/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.compression.Predictor;
import scala.Array$;
import scala.Function1;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a;Q!\u0001\u0002\t\u00025\taC\u00127pCRLgn\u001a)pS:$\bK]3eS\u000e$xN\u001d\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\bO\u0016|G/\u001b4g\u0015\t9\u0001\"\u0001\u0002j_*\u0011\u0011BC\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003-\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011aC\u00127pCRLgn\u001a)pS:$\bK]3eS\u000e$xN]\n\u0003\u001fI\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007\"B\r\u0010\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015ar\u0002\"\u0001\u001e\u0003\u0015\t\u0007\u000f\u001d7z)\tq\u0002\u000b\u0005\u0002\u000f?\u0019!\u0001C\u0001\u0001!'\ry\"#\t\t\u0003\u001d\tJ!a\t\u0002\u0003\u0013A\u0013X\rZ5di>\u0014\b\u0002C\u0013 \u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0015\r|Gn\u001d)feJ{w\u000f\u0005\u0002\u0014O%\u0011\u0001\u0006\u0006\u0002\u0004\u0013:$\b\u0002\u0003\u0016 \u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u001bI|wo]%o'\u0016<W.\u001a8u!\u0011\u0019BF\n\u0014\n\u00055\"\"!\u0003$v]\u000e$\u0018n\u001c82\u0011!ysD!A!\u0002\u0013\u0001\u0014\u0001\u00032b]\u0012$\u0016\u0010]3\u0011\u0005E\u0012T\"\u0001\u0003\n\u0005M\"!\u0001\u0003\"b]\u0012$\u0016\u0010]3\t\u0011Uz\"\u0011!Q\u0001\n\u0019\n\u0011BY1oI\u000e{WO\u001c;\t\u000beyB\u0011A\u001c\u0015\u000byA\u0014HO\u001e\t\u000b\u00152\u0004\u0019\u0001\u0014\t\u000b)2\u0004\u0019A\u0016\t\u000b=2\u0004\u0019\u0001\u0019\t\u000bU2\u0004\u0019\u0001\u0014\t\u000fuz\"\u0019!C\u0001}\u0005Y1\r[3dW\u0016sG-[1o+\u0005y\u0004CA\nA\u0013\t\tECA\u0004C_>dW-\u00198\t\r\r{\u0002\u0015!\u0003@\u00031\u0019\u0007.Z2l\u000b:$\u0017.\u00198!\u0011\u0015ar\u0004\"\u0001F)\r1EJ\u0014\t\u0004'\u001dK\u0015B\u0001%\u0015\u0005\u0015\t%O]1z!\t\u0019\"*\u0003\u0002L)\t!!)\u001f;f\u0011\u0015iE\t1\u0001G\u0003\u0015\u0011\u0017\u0010^3t\u0011\u0015yE\t1\u0001'\u00031\u0019XmZ7f]RLe\u000eZ3y\u0011\u0015\t6\u00041\u0001S\u0003!!\u0018N\u001a4UC\u001e\u001c\bCA*W\u001b\u0005!&BA+\u0005\u0003\u0011!\u0018mZ:\n\u0005]#&\u0001\u0003+jM\u001a$\u0016mZ:")
public class FloatingPointPredictor
implements Predictor {
    private final int colsPerRow;
    private final Function1<Object, Object> rowsInSegment;
    private final BandType bandType;
    private final int bandCount;
    private final boolean checkEndian;

    @Override
    public boolean checkEndian() {
        return this.checkEndian;
    }

    @Override
    public byte[] apply(byte[] bytes, int segmentIndex) {
        int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
        int bytesPerSample = this.bandType.bytesPerSample();
        int colValuesPerRow = this.colsPerRow * this.bandCount;
        int bytesPerRow = colValuesPerRow * bytesPerSample;
        for (int index$macro$386 = 0; index$macro$386 < rows; ++index$macro$386) {
            int rowByteIndex = index$macro$386 * bytesPerRow;
            int limit = (index$macro$386 + 1) * bytesPerRow;
            for (int index$macro$383 = rowByteIndex + this.bandCount; index$macro$383 < limit; ++index$macro$383) {
                bytes[index$macro$383] = (byte)(bytes[index$macro$383] + bytes[index$macro$383 - this.bandCount]);
            }
            byte[] tmp = (byte[])Array$.MODULE$.ofDim(bytesPerRow, ClassTag$.MODULE$.Byte());
            System.arraycopy(bytes, rowByteIndex, tmp, 0, bytesPerRow);
            for (int index$macro$385 = 0; index$macro$385 < this.colsPerRow * this.bandCount; ++index$macro$385) {
                for (int index$macro$384 = 0; index$macro$384 < bytesPerSample; ++index$macro$384) {
                    bytes[rowByteIndex + (bytesPerSample * index$macro$385 + index$macro$384)] = tmp[index$macro$384 * this.colsPerRow + index$macro$385];
                }
            }
        }
        return bytes;
    }

    public FloatingPointPredictor(int colsPerRow, Function1<Object, Object> rowsInSegment, BandType bandType, int bandCount) {
        this.colsPerRow = colsPerRow;
        this.rowsInSegment = rowsInSegment;
        this.bandType = bandType;
        this.bandCount = bandCount;
        this.checkEndian = false;
    }
}

