/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.DeflateCompression$;
import geotrellis.raster.io.geotiff.compression.LZWDecompressor$;
import geotrellis.raster.io.geotiff.compression.NoCompression$;
import geotrellis.raster.io.geotiff.compression.PackBitsDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.Predictor$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReaderLimitationException;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Decompressor$
implements Serializable {
    public static final Decompressor$ MODULE$;

    static {
        new Decompressor$();
    }

    public Decompressor apply(TiffTags tiffTags, ByteOrder byteOrder) {
        int n;
        block16: {
            Decompressor decompressor;
            block13: {
                int[] segmentSizes;
                block15: {
                    block14: {
                        block12: {
                            int segmentCount = tiffTags.segmentCount();
                            segmentSizes = (int[])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.Int());
                            int bandCount = tiffTags.bandCount();
                            if (tiffTags.hasPixelInterleave() && bandCount != 1) {
                                for (int index$macro$381 = 0; index$macro$381 < segmentCount; ++index$macro$381) {
                                    segmentSizes[index$macro$381] = (int)tiffTags.imageSegmentByteSize(index$macro$381) * tiffTags.bandCount();
                                }
                            } else {
                                for (int index$macro$380 = 0; index$macro$380 < segmentCount; ++index$macro$380) {
                                    segmentSizes[index$macro$380] = (int)tiffTags.imageSegmentByteSize(index$macro$380);
                                }
                            }
                            n = tiffTags.compression();
                            if (CompressionType$.MODULE$.Uncompressed() != n) break block12;
                            decompressor = this.checkEndian$1(NoCompression$.MODULE$, tiffTags, byteOrder);
                            break block13;
                        }
                        if (CompressionType$.MODULE$.LZWCoded() != n) break block14;
                        decompressor = this.checkPredictor$1(LZWDecompressor$.MODULE$.apply(segmentSizes), tiffTags, byteOrder);
                        break block13;
                    }
                    boolean bl = CompressionType$.MODULE$.ZLibCoded() == n ? true : CompressionType$.MODULE$.PkZipCoded() == n;
                    if (!bl) break block15;
                    decompressor = this.checkPredictor$1(DeflateCompression$.MODULE$.createDecompressor(segmentSizes), tiffTags, byteOrder);
                    break block13;
                }
                if (CompressionType$.MODULE$.PackBitsCoded() != n) break block16;
                decompressor = this.checkEndian$1(PackBitsDecompressor$.MODULE$.apply(segmentSizes), tiffTags, byteOrder);
            }
            return decompressor;
        }
        if (CompressionType$.MODULE$.JpegCoded() == n) {
            throw new GeoTiffReaderLimitationException("compression type JPEG is not supported by this reader.");
        }
        if (CompressionType$.MODULE$.HuffmanCoded() == n) {
            throw new GeoTiffReaderLimitationException("compression type CCITTRLE is not supported by this reader.");
        }
        if (CompressionType$.MODULE$.GroupThreeCoded() == n) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression type CCITTFAX3 is not supported by this reader."})).s((Seq)Nil$.MODULE$);
            throw new GeoTiffReaderLimitationException(msg);
        }
        if (CompressionType$.MODULE$.GroupFourCoded() == n) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression type CCITTFAX4 is not supported by this reader."})).s((Seq)Nil$.MODULE$);
            throw new GeoTiffReaderLimitationException(msg);
        }
        if (CompressionType$.MODULE$.JpegOldCoded() == n) {
            throw new MalformedGeoTiffException("old jpeg (compression = 6) is deprecated.");
        }
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression type ", " is not supported by this reader."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)}));
        throw new GeoTiffReaderLimitationException(msg);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Decompressor checkEndian$1(Decompressor d, TiffTags tiffTags$1, ByteOrder byteOrder$1) {
        ByteOrder byteOrder = byteOrder$1;
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        return (byteOrder == null ? byteOrder2 != null : !byteOrder.equals(byteOrder2)) && tiffTags$1.bitsPerPixel() > 8 ? d.flipEndian(tiffTags$1.bytesPerPixel() / tiffTags$1.bandCount()) : d;
    }

    private final Decompressor checkPredictor$1(Decompressor d, TiffTags tiffTags$1, ByteOrder byteOrder$1) {
        Predictor predictor = Predictor$.MODULE$.apply(tiffTags$1);
        return predictor.checkEndian() ? this.checkEndian$1(d, tiffTags$1, byteOrder$1).withPredictor(predictor) : d.withPredictor(predictor);
    }

    private Decompressor$() {
        MODULE$ = this;
    }
}

