/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.FloatArrayTile$;
import geotrellis.raster.FloatCells;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.UInt32BandType$;
import geotrellis.raster.io.geotiff.UInt32GeoTiffSegment;
import geotrellis.raster.io.geotiff.UInt32GeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.UInt32GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u0017\t\tR+\u00138ugI:Um\u001c+jM\u001a$\u0016\u000e\\3\u000b\u0005\r!\u0011aB4f_RLgM\u001a\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011A\u0002:bgR,'OC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111bR3p)&4g\rV5mKB\u0011Q\"E\u0005\u0003%\t\u0011a$V%oiN\u0012t)Z8US\u001a47+Z4nK:$8i\u001c7mK\u000e$\u0018n\u001c8\t\u0011Q\u0001!Q1A\u0005\u0002U\tAb]3h[\u0016tGOQ=uKN,\u0012A\u0006\t\u0003\u001b]I!\u0001\u0007\u0002\u0003\u0019M+w-\\3oi\nKH/Z:\t\u0011i\u0001!\u0011!Q\u0001\nY\tQb]3h[\u0016tGOQ=uKN\u0004\u0003\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002\u0019\u0011,7m\\7qe\u0016\u001c8o\u001c:\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0002\u0002\u0017\r|W\u000e\u001d:fgNLwN\\\u0005\u0003G\u0001\u0012A\u0002R3d_6\u0004(/Z:t_JD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000eI\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0011\t\u0013\u001d\u0002!\u0011!Q\u0001\n!Z\u0013!D:fO6,g\u000e\u001e'bs>,H\u000f\u0005\u0002\u000eS%\u0011!F\u0001\u0002\u0015\u000f\u0016|G+\u001b4g'\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;\n\u0005\u001dr\u0001\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0011\u0005}q\u0013BA\u0018!\u0005-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\t\u0011E\u0002!Q1A\u0005\u0002I\n\u0001bY3mYRK\b/Z\u000b\u0002gI\u0019AG\u000e\u001e\u0007\tU\u0002\u0001a\r\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003oaj\u0011AB\u0005\u0003s\u0019\u0011!B\u00127pCR\u001cU\r\u001c7t!\t94(\u0003\u0002=\r\tqaj\u001c#bi\u0006D\u0015M\u001c3mS:<\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u0013\r,G\u000e\u001c+za\u0016\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0004C\u0007\u0012+ei\u0012\t\u0003\u001b\u0001AQ\u0001F A\u0002YAQ\u0001H A\u0002yAQaJ A\u0002!BQ!I A\u00025BQ!M A\u0002!\u00132!\u0013\u001c;\r\u0011)\u0004\u0001\u0001%\t\u000b-\u0003A\u0011\u0001'\u0002\u000f5,H/\u00192mKV\tQ\n\u0005\u00028\u001d&\u0011qJ\u0002\u0002\u0011\u001bV$\u0018M\u00197f\u0003J\u0014\u0018-\u001f+jY\u0016DQ!\u0015\u0001\u0005\u0002I\u000bAa\u0019:paR\u0011Qj\u0015\u0005\u0006)B\u0003\r!V\u0001\u000bOJLGMQ8v]\u0012\u001c\bCA\u001cW\u0013\t9fA\u0001\u0006He&$'i\\;oINDQ!\u0017\u0001\u0005\u0002i\u000b!b^5uQ:{G)\u0019;b)\t\u00115\fC\u0003]1\u0002\u0007Q,A\u0006o_\u0012\u000bG/\u0019,bYV,\u0007c\u00010bG6\tqLC\u0001a\u0003\u0015\u00198-\u00197b\u0013\t\u0011wL\u0001\u0004PaRLwN\u001c\t\u0003=\u0012L!!Z0\u0003\r\u0011{WO\u00197f\u0011\u00159\u0007\u0001\"\u0001i\u0003-Ig\u000e^3saJ,G/Q:\u0015\u00051I\u0007\"\u00026g\u0001\u0004Y\u0017a\u00038fo\u000e+G\u000e\u001c+za\u0016\u0004\"\u0001\u001c<\u000f\u00055$hB\u00018t\u001d\ty'/D\u0001q\u0015\t\t(\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003k\u001a\tq\u0001]1dW\u0006<W-\u0003\u0002xq\nA1)\u001a7m)f\u0004XM\u0003\u0002v\r\u0001")
public class UInt32GeoTiffTile
extends GeoTiffTile
implements UInt32GeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final FloatCells cellType;
    private final UInt32BandType$ bandType;
    private final Function1<Object, UInt32GeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public UInt32BandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        UInt32GeoTiffTile uInt32GeoTiffTile = this;
        synchronized (uInt32GeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = UInt32GeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, UInt32GeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$UInt32GeoTiffSegmentCollection$_setter_$bandType_$eq(UInt32BandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public FloatCells cellType() {
        return this.cellType;
    }

    @Override
    public MutableArrayTile mutable() {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Float());
        for (int index$macro$376 = 0; index$macro$376 < this.segmentCount(); ++index$macro$376) {
            UInt32GeoTiffSegment segment = (UInt32GeoTiffSegment)this.getSegment(index$macro$376);
            GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$376);
            for (int index$macro$375 = 0; index$macro$375 < segment.size(); ++index$macro$375) {
                int col = segmentTransform.indexToCol(index$macro$375);
                int row = segmentTransform.indexToRow(index$macro$375);
                if (col >= this.cols() || row >= this.rows()) continue;
                arr[row * this.cols() + col] = segment.get(index$macro$375);
            }
        }
        return FloatArrayTile$.MODULE$.apply(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        float[] arr = (float[])Array$.MODULE$.ofDim(gridBounds.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$379 = 0; index$macro$379 < this.segmentCount(); ++index$macro$379) {
            GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$379, super.segmentLayout().getGridBounds$default$2());
            if (!gridBounds.intersects(segmentGridBounds)) continue;
            UInt32GeoTiffSegment segment = (UInt32GeoTiffSegment)this.getSegment(index$macro$379);
            GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$379);
            GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
            Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
            int iterator = super.segmentLayout().isStriped() ? intersection.cols() : intersection.tileWidth();
            for (int index$macro$378 = intersection.start(); index$macro$378 < intersection.end(); index$macro$378 += iterator) {
                for (int index$macro$377 = 0; index$macro$377 < result.width(); ++index$macro$377) {
                    int col = segmentTransform.indexToCol(index$macro$378 + index$macro$377);
                    int row = segmentTransform.indexToRow(index$macro$378 + index$macro$377);
                    arr[(row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin())] = segment.get(index$macro$378 + index$macro$377);
                }
            }
        }
        return FloatArrayTile$.MODULE$.apply(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public UInt32GeoTiffTile withNoData(Option<Object> noDataValue) {
        return new UInt32GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public GeoTiffTile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof FloatCells) {
            FloatCells floatCells = (FloatCells)((Object)newCellType);
            geoTiffTile = new UInt32GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, floatCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public UInt32GeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, FloatCells cellType) {
        this.segmentBytes = segmentBytes;
        this.decompressor = decompressor;
        this.compression = compression;
        this.cellType = cellType;
        super(segmentLayout, compression);
        GeoTiffSegmentCollection$class.$init$(this);
        UInt32GeoTiffSegmentCollection$class.$init$(this);
    }
}

