/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegment$class;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0017\t!R+\u00138ugI:Um\u001c+jM\u001a\u001cVmZ7f]RT!a\u0001\u0003\u0002\u000f\u001d,w\u000e^5gM*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\rI\f7\u000f^3s\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001d\u001d+w\u000eV5gMN+w-\\3oi\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$A\u0003csR,7/F\u0001\u001a!\ri!\u0004H\u0005\u000379\u0011Q!\u0011:sCf\u0004\"!D\u000f\n\u0005yq!\u0001\u0002\"zi\u0016D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!G\u0001\u0007Ef$Xm\u001d\u0011\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u0014\u0001!)q#\ta\u00013!9q\u0005\u0001b\u0001\n#A\u0013A\u00022vM\u001a,'/F\u0001*!\tQs&D\u0001,\u0015\taS&A\u0002oS>T\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\tI\u0011J\u001c;Ck\u001a4WM\u001d\u0005\u0007e\u0001\u0001\u000b\u0011B\u0015\u0002\u000f\t,hMZ3sA!9A\u0007\u0001b\u0001\n\u0003)\u0014\u0001B:ju\u0016,\u0012A\u000e\t\u0003\u001b]J!\u0001\u000f\b\u0003\u0007%sG\u000f\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u0006g&TX\r\t\u0005\u0006y\u0001!\t!P\u0001\u0004O\u0016$HC\u0001 B!\tiq(\u0003\u0002A\u001d\t)a\t\\8bi\")!i\u000fa\u0001m\u0005\t\u0011\u000eC\u0003E\u0001\u0011\u0005Q)\u0001\u0004hKRLe\u000e\u001e\u000b\u0003m\u0019CQAQ\"A\u0002YBQ\u0001\u0013\u0001\u0005\u0002%\u000b\u0011bZ3u\t>,(\r\\3\u0015\u0005)k\u0005CA\u0007L\u0013\taeB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0005\u001e\u0003\rA\u000e\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0004[\u0006\u0004HCA\rR\u0011\u0015\u0011f\n1\u0001T\u0003\u00051\u0007\u0003B\u0007UmYJ!!\u0016\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"B,\u0001\t\u0003A\u0016!C7ba\u0012{WO\u00197f)\tI\u0012\fC\u0003S-\u0002\u0007!\f\u0005\u0003\u000e)*S\u0005\"\u0002/\u0001\t\u0003i\u0016\u0001D7ba^KG\u000f[%oI\u0016DHCA\r_\u0011\u0015\u00116\f1\u0001`!\u0015i\u0001M\u000e\u001c7\u0013\t\tgBA\u0005Gk:\u001cG/[8oe!)1\r\u0001C\u0001I\u0006\u0011R.\u00199E_V\u0014G.Z,ji\"Le\u000eZ3y)\tIR\rC\u0003SE\u0002\u0007a\rE\u0003\u000eAZR%\n")
public class UInt32GeoTiffSegment
implements GeoTiffSegment {
    private final byte[] bytes;
    private final IntBuffer buffer;
    private final int size;

    @Override
    public byte[] convert(DataType cellType) {
        return GeoTiffSegment$class.convert(this, cellType);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    public IntBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    public float get(int i) {
        return (long)this.buffer().get(i) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int i) {
        float n = this.get(i);
        return Float.isNaN(n) ? Integer.MIN_VALUE : (int)n;
    }

    @Override
    public double getDouble(int i) {
        return this.get(i);
    }

    @Override
    public byte[] map(Function1<Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$371 = 0; index$macro$371 < this.size(); ++index$macro$371) {
            int n = f.apply$mcII$sp(this.getInt(index$macro$371));
            arr[index$macro$371] = n == Integer.MIN_VALUE ? Float.NaN : (float)n;
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDouble(Function1<Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$372 = 0; index$macro$372 < this.size(); ++index$macro$372) {
            arr[index$macro$372] = (float)f.apply$mcDD$sp(this.getDouble(index$macro$372));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapWithIndex(Function2<Object, Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$373 = 0; index$macro$373 < this.size(); ++index$macro$373) {
            int n = f.apply$mcIII$sp(index$macro$373, this.getInt(index$macro$373));
            arr[index$macro$373] = n == Integer.MIN_VALUE ? Float.NaN : (float)n;
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDoubleWithIndex(Function2<Object, Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$374 = 0; index$macro$374 < this.size(); ++index$macro$374) {
            arr[index$macro$374] = (float)f.apply$mcDID$sp(index$macro$374, this.getDouble(index$macro$374));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    public UInt32GeoTiffSegment(byte[] bytes) {
        this.bytes = bytes;
        GeoTiffSegment$class.$init$(this);
        this.buffer = ByteBuffer.wrap(bytes).asIntBuffer();
        this.size = Predef$.MODULE$.byteArrayOps(bytes).size() / 4;
    }
}

