/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.UShortArrayTile$;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.UInt16BandType$;
import geotrellis.raster.io.geotiff.UInt16GeoTiffSegment;
import geotrellis.raster.io.geotiff.UInt16GeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.UInt16GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011\u0011#V%oiF2t)Z8US\u001a4G+\u001b7f\u0015\t\u0019A!A\u0004hK>$\u0018N\u001a4\u000b\u0005\u00151\u0011AA5p\u0015\t9\u0001\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001\u0001\u0004\t\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!aC$f_RKgM\u001a+jY\u0016\u0004\"!D\t\n\u0005I\u0011!AH+J]R\fdgR3p)&4gmU3h[\u0016tGoQ8mY\u0016\u001cG/[8o\u0011!!\u0002A!b\u0001\n\u0003)\u0012\u0001D:fO6,g\u000e\u001e\"zi\u0016\u001cX#\u0001\f\u0011\u000559\u0012B\u0001\r\u0003\u00051\u0019VmZ7f]R\u0014\u0015\u0010^3t\u0011!Q\u0002A!A!\u0002\u00131\u0012!D:fO6,g\u000e\u001e\"zi\u0016\u001c\b\u0005\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001e\u00031!WmY8naJ,7o]8s+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u0003\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\n\u0005\r\u0002#\u0001\u0004#fG>l\u0007O]3tg>\u0014\b\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001b\u0011,7m\\7qe\u0016\u001c8o\u001c:!\u0011%9\u0003A!A!\u0002\u0013A3&A\u0007tK\u001elWM\u001c;MCf|W\u000f\u001e\t\u0003\u001b%J!A\u000b\u0002\u0003)\u001d+w\u000eV5gMN+w-\\3oi2\u000b\u0017p\\;u\u0013\t9c\u0002\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003.!\tyb&\u0003\u00020A\tY1i\\7qe\u0016\u001c8/[8o\u0011!\t\u0004A!b\u0001\n\u0003\u0011\u0014\u0001C2fY2$\u0016\u0010]3\u0016\u0003M\u00122\u0001\u000e\u001c;\r\u0011)\u0004\u0001A\u001a\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005]BT\"\u0001\u0004\n\u0005e2!aC+TQ>\u0014HoQ3mYN\u0004\"aN\u001e\n\u0005q2!A\u0004(p\t\u0006$\u0018\rS1oI2Lgn\u001a\u0005\t}\u0001\u0011\t\u0011)A\u0005g\u0005I1-\u001a7m)f\u0004X\r\t\u0005\u0006\u0001\u0002!\t!Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\t\u001bE)\u0012$H!\ti\u0001\u0001C\u0003\u0015\u007f\u0001\u0007a\u0003C\u0003\u001d\u007f\u0001\u0007a\u0004C\u0003(\u007f\u0001\u0007\u0001\u0006C\u0003\"\u007f\u0001\u0007Q\u0006C\u00032\u007f\u0001\u0007\u0001JE\u0002Jmi2A!\u000e\u0001\u0001\u0011\"91\n\u0001b\u0001\n\u0003a\u0015a\u00038p\t\u0006$\u0018MV1mk\u0016,\u0012!\u0014\t\u0004\u001dF\u001bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\r=\u0003H/[8o!\tqE+\u0003\u0002V\u001f\n\u0019\u0011J\u001c;\t\r]\u0003\u0001\u0015!\u0003N\u00031qw\u000eR1uCZ\u000bG.^3!\u0011\u0015I\u0006\u0001\"\u0001[\u0003\u001diW\u000f^1cY\u0016,\u0012a\u0017\t\u0003oqK!!\u0018\u0004\u0003!5+H/\u00192mK\u0006\u0013(/Y=US2,\u0007\"B0\u0001\t\u0003\u0001\u0017\u0001B2s_B$\"aW1\t\u000b\tt\u0006\u0019A2\u0002\u0015\u001d\u0014\u0018\u000e\u001a\"pk:$7\u000f\u0005\u00028I&\u0011QM\u0002\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\b\"B4\u0001\t\u0003A\u0017AC<ji\"tu\u000eR1uCR\u0011!)\u001b\u0005\u0006\u0017\u001a\u0004\rA\u001b\t\u0004\u001dF[\u0007C\u0001(m\u0013\tiwJ\u0001\u0004E_V\u0014G.\u001a\u0005\u0006_\u0002!\t\u0001]\u0001\fS:$XM\u001d9sKR\f5\u000f\u0006\u0002\rc\")!O\u001ca\u0001g\u0006Ya.Z<DK2dG+\u001f9f!\t!hP\u0004\u0002vy:\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003s*\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA?\u0007\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005!\u0019U\r\u001c7UsB,'BA?\u0007\u0001")
public class UInt16GeoTiffTile
extends GeoTiffTile
implements UInt16GeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final UShortCells cellType;
    private final Option<Object> noDataValue;
    private final UInt16BandType$ bandType;
    private final Function1<Object, UInt16GeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public UInt16BandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        UInt16GeoTiffTile uInt16GeoTiffTile = this;
        synchronized (uInt16GeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = UInt16GeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, UInt16GeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$UInt16GeoTiffSegmentCollection$_setter_$bandType_$eq(UInt16BandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public UShortCells cellType() {
        return this.cellType;
    }

    @Override
    public Option<Object> noDataValue() {
        return this.noDataValue;
    }

    @Override
    public MutableArrayTile mutable() {
        short[] arr = (short[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Short());
        for (int index$macro$366 = 0; index$macro$366 < this.segmentCount(); ++index$macro$366) {
            UInt16GeoTiffSegment segment = (UInt16GeoTiffSegment)this.getSegment(index$macro$366);
            GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$366);
            for (int index$macro$365 = 0; index$macro$365 < segment.size(); ++index$macro$365) {
                short data;
                int col = segmentTransform.indexToCol(index$macro$365);
                int row = segmentTransform.indexToRow(index$macro$365);
                if (col >= this.cols() || row >= this.rows()) continue;
                arr[row * this.cols() + col] = data = segment.getRaw(index$macro$365);
            }
        }
        return UShortArrayTile$.MODULE$.apply(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(gridBounds.size() * UShortConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        int counter = 0;
        if (super.segmentLayout().isStriped()) {
            for (int index$macro$368 = 0; index$macro$368 < this.segmentCount(); ++index$macro$368) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$368, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                UInt16GeoTiffSegment segment = (UInt16GeoTiffSegment)this.getSegment(index$macro$368);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * UShortConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * UShortConstantNoDataCellType$.MODULE$.bytes();
                int adjCols = this.cols() * UShortConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * UShortConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$367 = adjStart; index$macro$367 < adjEnd; index$macro$367 += adjCols) {
                    System.arraycopy(segment.bytes(), index$macro$367, arr, counter, adjWidth);
                    counter += adjWidth;
                }
            }
        } else {
            for (int index$macro$370 = 0; index$macro$370 < this.segmentCount(); ++index$macro$370) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$370, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                UInt16GeoTiffSegment segment = (UInt16GeoTiffSegment)this.getSegment(index$macro$370);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$370);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * UShortConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * UShortConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * UShortConstantNoDataCellType$.MODULE$.bytes();
                int adjCols = intersection.tileWidth() * UShortConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$369 = adjStart; index$macro$369 < adjEnd; index$macro$369 += adjCols) {
                    int col = segmentTransform.indexToCol(index$macro$369 / UShortConstantNoDataCellType$.MODULE$.bytes());
                    int row = segmentTransform.indexToRow(index$macro$369 / UShortConstantNoDataCellType$.MODULE$.bytes());
                    int j = (row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin());
                    System.arraycopy(segment.bytes(), index$macro$369, arr, j * UShortConstantNoDataCellType$.MODULE$.bytes(), adjWidth);
                }
            }
        }
        return UShortArrayTile$.MODULE$.fromBytes(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public UInt16GeoTiffTile withNoData(Option<Object> noDataValue) {
        return new UInt16GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public GeoTiffTile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof UShortCells) {
            UShortCells uShortCells = (UShortCells)((Object)newCellType);
            geoTiffTile = new UInt16GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, uShortCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public UInt16GeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, UShortCells cellType) {
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        this.segmentBytes = segmentBytes;
                        this.decompressor = decompressor;
                        this.compression = compression;
                        this.cellType = cellType;
                        super(segmentLayout, compression);
                        GeoTiffSegmentCollection$class.$init$(this);
                        UInt16GeoTiffSegmentCollection$class.$init$(this);
                        if (!UShortCellType$.MODULE$.equals(cellType)) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!UShortConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    none$ = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                    break block3;
                }
                if (!(cellType instanceof UShortUserDefinedNoDataCellType)) break block5;
                UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)uShortUserDefinedNoDataCellType.noDataValue()));
            }
            this.noDataValue = none$;
            return;
        }
        throw new MatchError((Object)cellType);
    }
}

