/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.UByteArrayTile$;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteUserDefinedNoDataCellType;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.UByteBandType$;
import geotrellis.raster.io.geotiff.UByteGeoTiffSegment;
import geotrellis.raster.io.geotiff.UByteGeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.UByteGeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011\u0001#\u0016\"zi\u0016<Um\u001c+jM\u001a$\u0016\u000e\\3\u000b\u0005\r!\u0011aB4f_RLgM\u001a\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011A\u0002:bgR,'OC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111bR3p)&4g\rV5mKB\u0011Q\"E\u0005\u0003%\t\u0011Q$\u0016\"zi\u0016<Um\u001c+jM\u001a\u001cVmZ7f]R\u001cu\u000e\u001c7fGRLwN\u001c\u0005\t)\u0001\u0011)\u0019!C\u0001+\u0005a1/Z4nK:$()\u001f;fgV\ta\u0003\u0005\u0002\u000e/%\u0011\u0001D\u0001\u0002\r'\u0016<W.\u001a8u\u0005f$Xm\u001d\u0005\t5\u0001\u0011\t\u0011)A\u0005-\u0005i1/Z4nK:$()\u001f;fg\u0002B\u0001\u0002\b\u0001\u0003\u0006\u0004%\t!H\u0001\rI\u0016\u001cw.\u001c9sKN\u001cxN]\u000b\u0002=A\u0011qDI\u0007\u0002A)\u0011\u0011EA\u0001\fG>l\u0007O]3tg&|g.\u0003\u0002$A\taA)Z2p[B\u0014Xm]:pe\"AQ\u0005\u0001B\u0001B\u0003%a$A\u0007eK\u000e|W\u000e\u001d:fgN|'\u000f\t\u0005\nO\u0001\u0011\t\u0011)A\u0005Q-\nQb]3h[\u0016tG\u000fT1z_V$\bCA\u0007*\u0013\tQ#A\u0001\u000bHK>$\u0016N\u001a4TK\u001elWM\u001c;MCf|W\u000f^\u0005\u0003O9A\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!\f\t\u0003?9J!a\f\u0011\u0003\u0017\r{W\u000e\u001d:fgNLwN\u001c\u0005\tc\u0001\u0011)\u0019!C\u0001e\u0005A1-\u001a7m)f\u0004X-F\u00014%\r!dG\u000f\u0004\u0005k\u0001\u00011G\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u00028q5\ta!\u0003\u0002:\r\tQQKQ=uK\u000e+G\u000e\\:\u0011\u0005]Z\u0014B\u0001\u001f\u0007\u00059qu\u000eR1uC\"\u000bg\u000e\u001a7j]\u001eD\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaM\u0001\nG\u0016dG\u000eV=qK\u0002BQ\u0001\u0011\u0001\u0005\u0002\u0005\u000ba\u0001P5oSRtDC\u0002\"D\t\u00163u\t\u0005\u0002\u000e\u0001!)Ac\u0010a\u0001-!)Ad\u0010a\u0001=!)qe\u0010a\u0001Q!)\u0011e\u0010a\u0001[!)\u0011g\u0010a\u0001\u0011J\u0019\u0011J\u000e\u001e\u0007\tU\u0002\u0001\u0001\u0013\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0003-qw\u000eR1uCZ\u000bG.^3\u0016\u00035\u00032AT)T\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%AB(qi&|g\u000e\u0005\u0002O)&\u0011Qk\u0014\u0002\u0004\u0013:$\bBB,\u0001A\u0003%Q*\u0001\u0007o_\u0012\u000bG/\u0019,bYV,\u0007\u0005C\u0003Z\u0001\u0011\u0005!,A\u0004nkR\f'\r\\3\u0016\u0003m\u0003\"a\u000e/\n\u0005u3!\u0001E'vi\u0006\u0014G.Z!se\u0006LH+\u001b7f\u0011\u0015y\u0006\u0001\"\u0001a\u0003\u0011\u0019'o\u001c9\u0015\u0005m\u000b\u0007\"\u00022_\u0001\u0004\u0019\u0017AC4sS\u0012\u0014u.\u001e8egB\u0011q\u0007Z\u0005\u0003K\u001a\u0011!b\u0012:jI\n{WO\u001c3t\u0011\u00159\u0007\u0001\"\u0001i\u0003)9\u0018\u000e\u001e5O_\u0012\u000bG/\u0019\u000b\u0003\u0005&DQa\u00134A\u0002)\u00042AT)l!\tqE.\u0003\u0002n\u001f\n1Ai\\;cY\u0016DQa\u001c\u0001\u0005\u0002A\f1\"\u001b8uKJ\u0004(/\u001a;BgR\u0011A\"\u001d\u0005\u0006e:\u0004\ra]\u0001\f]\u0016<8)\u001a7m)f\u0004X\r\u0005\u0002u}:\u0011Q\u000f \b\u0003mnt!a\u001e>\u000e\u0003aT!!\u001f\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\tih!A\u0004qC\u000e\\\u0017mZ3\n\u0007}\f\tA\u0001\u0005DK2dG+\u001f9f\u0015\tih\u0001")
public class UByteGeoTiffTile
extends GeoTiffTile
implements UByteGeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final UByteCells cellType;
    private final Option<Object> noDataValue;
    private final UByteBandType$ bandType;
    private final Function1<Object, UByteGeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public UByteBandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        UByteGeoTiffTile uByteGeoTiffTile = this;
        synchronized (uByteGeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = UByteGeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, UByteGeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$UByteGeoTiffSegmentCollection$_setter_$bandType_$eq(UByteBandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public UByteCells cellType() {
        return this.cellType;
    }

    @Override
    public Option<Object> noDataValue() {
        return this.noDataValue;
    }

    @Override
    public MutableArrayTile mutable() {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Byte());
        if (super.segmentLayout().isStriped()) {
            int i = 0;
            for (int index$macro$355 = 0; index$macro$355 < this.segmentCount(); ++index$macro$355) {
                UByteGeoTiffSegment segment = (UByteGeoTiffSegment)this.getSegment(index$macro$355);
                int size = Predef$.MODULE$.byteArrayOps(segment.bytes()).size();
                System.arraycopy(segment.bytes(), 0, arr, i, size);
                i += size;
            }
        } else {
            for (int index$macro$357 = 0; index$macro$357 < this.segmentCount(); ++index$macro$357) {
                UByteGeoTiffSegment segment = (UByteGeoTiffSegment)this.getSegment(index$macro$357);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$357);
                int width = segmentTransform.segmentCols();
                int tileWidth = super.segmentLayout().tileLayout().tileCols();
                for (int index$macro$356 = 0; index$macro$356 < tileWidth * segmentTransform.segmentRows(); index$macro$356 += tileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$356);
                    int row = segmentTransform.indexToRow(index$macro$356);
                    int j = row * this.cols() + col;
                    System.arraycopy(segment.bytes(), index$macro$356, arr, j, width);
                }
            }
        }
        return UByteArrayTile$.MODULE$.fromBytes(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(gridBounds.size(), ClassTag$.MODULE$.Byte());
        int counter = 0;
        if (super.segmentLayout().isStriped()) {
            for (int index$macro$359 = 0; index$macro$359 < this.segmentCount(); ++index$macro$359) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$359, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                UByteGeoTiffSegment segment = (UByteGeoTiffSegment)this.getSegment(index$macro$359);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                for (int index$macro$358 = intersection.start(); index$macro$358 < intersection.end(); index$macro$358 += this.cols()) {
                    System.arraycopy(segment.bytes(), index$macro$358, arr, counter, result.width());
                    counter += result.width();
                }
            }
        } else {
            for (int index$macro$361 = 0; index$macro$361 < this.segmentCount(); ++index$macro$361) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$361, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                UByteGeoTiffSegment segment = (UByteGeoTiffSegment)this.getSegment(index$macro$361);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$361);
                int tileWidth = super.segmentLayout().tileLayout().tileCols();
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                for (int index$macro$360 = intersection.start(); index$macro$360 < intersection.end(); index$macro$360 += tileWidth) {
                    int row;
                    int col = segmentTransform.indexToCol(index$macro$360);
                    if (!gridBounds.contains(col, row = segmentTransform.indexToRow(index$macro$360))) continue;
                    int j = (row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin());
                    System.arraycopy(segment.bytes(), index$macro$360, arr, j, result.width());
                }
            }
        }
        return UByteArrayTile$.MODULE$.fromBytes(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public UByteGeoTiffTile withNoData(Option<Object> noDataValue) {
        return new UByteGeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public GeoTiffTile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof UByteCells) {
            UByteCells uByteCells = (UByteCells)((Object)newCellType);
            geoTiffTile = new UByteGeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, uByteCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public UByteGeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, UByteCells cellType) {
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        this.segmentBytes = segmentBytes;
                        this.decompressor = decompressor;
                        this.compression = compression;
                        this.cellType = cellType;
                        super(segmentLayout, compression);
                        GeoTiffSegmentCollection$class.$init$(this);
                        UByteGeoTiffSegmentCollection$class.$init$(this);
                        if (!UByteCellType$.MODULE$.equals(cellType)) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!UByteConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    none$ = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                    break block3;
                }
                if (!(cellType instanceof UByteUserDefinedNoDataCellType)) break block5;
                UByteUserDefinedNoDataCellType uByteUserDefinedNoDataCellType = (UByteUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)uByteUserDefinedNoDataCellType.noDataValue()));
            }
            this.noDataValue = none$;
            return;
        }
        throw new MatchError((Object)cellType);
    }
}

