/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Int32BandType$;
import geotrellis.raster.io.geotiff.Int32GeoTiffSegment;
import geotrellis.raster.io.geotiff.Int32GeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.Int32GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011\u0001#\u00138ugI:Um\u001c+jM\u001a$\u0016\u000e\\3\u000b\u0005\r!\u0011aB4f_RLgM\u001a\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011A\u0002:bgR,'OC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111bR3p)&4g\rV5mKB\u0011Q\"E\u0005\u0003%\t\u0011Q$\u00138ugI:Um\u001c+jM\u001a\u001cVmZ7f]R\u001cu\u000e\u001c7fGRLwN\u001c\u0005\t)\u0001\u0011)\u0019!C\u0001+\u0005a1/Z4nK:$()\u001f;fgV\ta\u0003\u0005\u0002\u000e/%\u0011\u0001D\u0001\u0002\r'\u0016<W.\u001a8u\u0005f$Xm\u001d\u0005\t5\u0001\u0011\t\u0011)A\u0005-\u0005i1/Z4nK:$()\u001f;fg\u0002B\u0001\u0002\b\u0001\u0003\u0006\u0004%\t!H\u0001\rI\u0016\u001cw.\u001c9sKN\u001cxN]\u000b\u0002=A\u0011qDI\u0007\u0002A)\u0011\u0011EA\u0001\fG>l\u0007O]3tg&|g.\u0003\u0002$A\taA)Z2p[B\u0014Xm]:pe\"AQ\u0005\u0001B\u0001B\u0003%a$A\u0007eK\u000e|W\u000e\u001d:fgN|'\u000f\t\u0005\nO\u0001\u0011\t\u0011)A\u0005Q-\nQb]3h[\u0016tG\u000fT1z_V$\bCA\u0007*\u0013\tQ#A\u0001\u000bHK>$\u0016N\u001a4TK\u001elWM\u001c;MCf|W\u000f^\u0005\u0003O9A\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!\f\t\u0003?9J!a\f\u0011\u0003\u0017\r{W\u000e\u001d:fgNLwN\u001c\u0005\tc\u0001\u0011)\u0019!C\u0001e\u0005A1-\u001a7m)f\u0004X-F\u00014%\r!dG\u000f\u0004\u0005k\u0001\u00011G\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u00028q5\ta!\u0003\u0002:\r\tA\u0011J\u001c;DK2d7\u000f\u0005\u00028w%\u0011AH\u0002\u0002\u000f\u001d>$\u0015\r^1IC:$G.\u001b8h\u0011!q\u0004A!A!\u0002\u0013\u0019\u0014!C2fY2$\u0016\u0010]3!\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q1!i\u0011#F\r\u001e\u0003\"!\u0004\u0001\t\u000bQy\u0004\u0019\u0001\f\t\u000bqy\u0004\u0019\u0001\u0010\t\u000b\u001dz\u0004\u0019\u0001\u0015\t\u000b\u0005z\u0004\u0019A\u0017\t\u000bEz\u0004\u0019\u0001%\u0013\u0007%3$H\u0002\u00036\u0001\u0001A\u0005bB&\u0001\u0005\u0004%\t\u0001T\u0001\f]>$\u0015\r^1WC2,X-F\u0001N!\rq\u0015kU\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n1q\n\u001d;j_:\u0004\"A\u0014+\n\u0005U{%aA%oi\"1q\u000b\u0001Q\u0001\n5\u000bAB\\8ECR\fg+\u00197vK\u0002BQ!\u0017\u0001\u0005\u0002i\u000bq!\\;uC\ndW-F\u0001\\!\t9D,\u0003\u0002^\r\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u0005\u0006?\u0002!\t\u0001Y\u0001\u0005GJ|\u0007\u000f\u0006\u0002\\C\")!M\u0018a\u0001G\u0006QqM]5e\u0005>,h\u000eZ:\u0011\u0005]\"\u0017BA3\u0007\u0005)9%/\u001b3C_VtGm\u001d\u0005\u0006O\u0002!\t\u0001[\u0001\u000bo&$\bNT8ECR\fGC\u0001\"j\u0011\u0015Ye\r1\u0001k!\rq\u0015k\u001b\t\u0003\u001d2L!!\\(\u0003\r\u0011{WO\u00197f\u0011\u0015y\u0007\u0001\"\u0001q\u0003-Ig\u000e^3saJ,G/Q:\u0015\u00051\t\b\"\u0002:o\u0001\u0004\u0019\u0018a\u00038fo\u000e+G\u000e\u001c+za\u0016\u0004\"\u0001\u001e@\u000f\u0005UdhB\u0001<|\u001d\t9(0D\u0001y\u0015\tI(\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003{\u001a\tq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u0011\u0001bQ3mYRK\b/\u001a\u0006\u0003{\u001a\u0001")
public class Int32GeoTiffTile
extends GeoTiffTile
implements Int32GeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final IntCells cellType;
    private final Option<Object> noDataValue;
    private final Int32BandType$ bandType;
    private final Function1<Object, Int32GeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public Int32BandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        Int32GeoTiffTile int32GeoTiffTile = this;
        synchronized (int32GeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = Int32GeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, Int32GeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$Int32GeoTiffSegmentCollection$_setter_$bandType_$eq(Int32BandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public IntCells cellType() {
        return this.cellType;
    }

    @Override
    public Option<Object> noDataValue() {
        return this.noDataValue;
    }

    @Override
    public MutableArrayTile mutable() {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(this.cols() * this.rows() * IntConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        if (super.segmentLayout().isStriped()) {
            int i = 0;
            for (int index$macro$344 = 0; index$macro$344 < this.segmentCount(); ++index$macro$344) {
                Int32GeoTiffSegment segment = (Int32GeoTiffSegment)this.getSegment(index$macro$344);
                int size = Predef$.MODULE$.byteArrayOps(segment.bytes()).size();
                System.arraycopy(segment.bytes(), 0, arr, i, size);
                i += size;
            }
        } else {
            for (int index$macro$346 = 0; index$macro$346 < this.segmentCount(); ++index$macro$346) {
                Int32GeoTiffSegment segment = (Int32GeoTiffSegment)this.getSegment(index$macro$346);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$346);
                int width = segmentTransform.segmentCols() * IntConstantNoDataCellType$.MODULE$.bytes();
                int tileWidth = super.segmentLayout().tileLayout().tileCols() * IntConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$345 = 0; index$macro$345 < tileWidth * segmentTransform.segmentRows(); index$macro$345 += tileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$345 / IntConstantNoDataCellType$.MODULE$.bytes());
                    int row = segmentTransform.indexToRow(index$macro$345 / IntConstantNoDataCellType$.MODULE$.bytes());
                    int j = (row * this.cols() + col) * IntConstantNoDataCellType$.MODULE$.bytes();
                    System.arraycopy(segment.bytes(), index$macro$345, arr, j, width);
                }
            }
        }
        return IntArrayTile$.MODULE$.fromBytes(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(gridBounds.size() * IntConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        int counter = 0;
        if (super.segmentLayout().isStriped()) {
            for (int index$macro$348 = 0; index$macro$348 < this.segmentCount(); ++index$macro$348) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$348, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Int32GeoTiffSegment segment = (Int32GeoTiffSegment)this.getSegment(index$macro$348);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * IntConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * IntConstantNoDataCellType$.MODULE$.bytes();
                int adjCols = intersection.cols() * IntConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * IntConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$347 = adjStart; index$macro$347 < adjEnd; index$macro$347 += adjCols) {
                    System.arraycopy(segment.bytes(), index$macro$347, arr, counter, adjWidth);
                    counter += adjWidth;
                }
            }
        } else {
            for (int index$macro$350 = 0; index$macro$350 < this.segmentCount(); ++index$macro$350) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$350, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Int32GeoTiffSegment segment = (Int32GeoTiffSegment)this.getSegment(index$macro$350);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$350);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * IntConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * IntConstantNoDataCellType$.MODULE$.bytes();
                int adjTileWidth = intersection.tileWidth() * IntConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * IntConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$349 = adjStart; index$macro$349 < adjEnd; index$macro$349 += adjTileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$349 / IntConstantNoDataCellType$.MODULE$.bytes());
                    int row = segmentTransform.indexToRow(index$macro$349 / IntConstantNoDataCellType$.MODULE$.bytes());
                    int j = (row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin());
                    System.arraycopy(segment.bytes(), index$macro$349, arr, j * IntConstantNoDataCellType$.MODULE$.bytes(), adjWidth);
                }
            }
        }
        return IntArrayTile$.MODULE$.fromBytes(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public Int32GeoTiffTile withNoData(Option<Object> noDataValue) {
        return new Int32GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public GeoTiffTile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof IntCells) {
            IntCells intCells = (IntCells)((Object)newCellType);
            geoTiffTile = new Int32GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, intCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public Int32GeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, IntCells cellType) {
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        this.segmentBytes = segmentBytes;
                        this.decompressor = decompressor;
                        this.compression = compression;
                        this.cellType = cellType;
                        super(segmentLayout, compression);
                        GeoTiffSegmentCollection$class.$init$(this);
                        Int32GeoTiffSegmentCollection$class.$init$(this);
                        if (!IntCellType$.MODULE$.equals(cellType)) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!IntConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    none$ = new Some((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE));
                    break block3;
                }
                if (!(cellType instanceof IntUserDefinedNoDataCellType)) break block5;
                IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)intUserDefinedNoDataCellType.noDataValue()));
            }
            this.noDataValue = none$;
            return;
        }
        throw new MatchError((Object)cellType);
    }
}

