/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.ShortArrayTile$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortUserDefinedNoDataCellType;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Int16BandType$;
import geotrellis.raster.io.geotiff.Int16GeoTiffSegment;
import geotrellis.raster.io.geotiff.Int16GeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.Int16GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011\u0001#\u00138ucY:Um\u001c+jM\u001a$\u0016\u000e\\3\u000b\u0005\r!\u0011aB4f_RLgM\u001a\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011A\u0002:bgR,'OC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111bR3p)&4g\rV5mKB\u0011Q\"E\u0005\u0003%\t\u0011Q$\u00138ucY:Um\u001c+jM\u001a\u001cVmZ7f]R\u001cu\u000e\u001c7fGRLwN\u001c\u0005\t)\u0001\u0011)\u0019!C\u0001+\u0005a1/Z4nK:$()\u001f;fgV\ta\u0003\u0005\u0002\u000e/%\u0011\u0001D\u0001\u0002\r'\u0016<W.\u001a8u\u0005f$Xm\u001d\u0005\t5\u0001\u0011\t\u0011)A\u0005-\u0005i1/Z4nK:$()\u001f;fg\u0002B\u0001\u0002\b\u0001\u0003\u0006\u0004%\t!H\u0001\rI\u0016\u001cw.\u001c9sKN\u001cxN]\u000b\u0002=A\u0011qDI\u0007\u0002A)\u0011\u0011EA\u0001\fG>l\u0007O]3tg&|g.\u0003\u0002$A\taA)Z2p[B\u0014Xm]:pe\"AQ\u0005\u0001B\u0001B\u0003%a$A\u0007eK\u000e|W\u000e\u001d:fgN|'\u000f\t\u0005\nO\u0001\u0011\t\u0011)A\u0005Q-\nQb]3h[\u0016tG\u000fT1z_V$\bCA\u0007*\u0013\tQ#A\u0001\u000bHK>$\u0016N\u001a4TK\u001elWM\u001c;MCf|W\u000f^\u0005\u0003O9A\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!\f\t\u0003?9J!a\f\u0011\u0003\u0017\r{W\u000e\u001d:fgNLwN\u001c\u0005\tc\u0001\u0011)\u0019!C\u0001e\u0005A1-\u001a7m)f\u0004X-F\u00014%\r!dG\u000f\u0004\u0005k\u0001\u00011G\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u00028q5\ta!\u0003\u0002:\r\tQ1\u000b[8si\u000e+G\u000e\\:\u0011\u0005]Z\u0014B\u0001\u001f\u0007\u00059qu\u000eR1uC\"\u000bg\u000e\u001a7j]\u001eD\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaM\u0001\nG\u0016dG\u000eV=qK\u0002BQ\u0001\u0011\u0001\u0005\u0002\u0005\u000ba\u0001P5oSRtDC\u0002\"D\t\u00163u\t\u0005\u0002\u000e\u0001!)Ac\u0010a\u0001-!)Ad\u0010a\u0001=!)qe\u0010a\u0001Q!)\u0011e\u0010a\u0001[!)\u0011g\u0010a\u0001\u0011J\u0019\u0011J\u000e\u001e\u0007\tU\u0002\u0001\u0001\u0013\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0003-qw\u000eR1uCZ\u000bG.^3\u0016\u00035\u00032AT)T\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%AB(qi&|g\u000e\u0005\u0002O)&\u0011Qk\u0014\u0002\u0006'\"|'\u000f\u001e\u0005\u0007/\u0002\u0001\u000b\u0011B'\u0002\u00199|G)\u0019;b-\u0006dW/\u001a\u0011\t\u000be\u0003A\u0011\u0001.\u0002\u000f5,H/\u00192mKV\t1\f\u0005\u000289&\u0011QL\u0002\u0002\u0011\u001bV$\u0018M\u00197f\u0003J\u0014\u0018-\u001f+jY\u0016DQa\u0018\u0001\u0005\u0002\u0001\fAa\u0019:paR\u00111,\u0019\u0005\u0006Ez\u0003\raY\u0001\u000bOJLGMQ8v]\u0012\u001c\bCA\u001ce\u0013\t)gA\u0001\u0006He&$'i\\;oINDQa\u001a\u0001\u0005\u0002!\f!b^5uQ:{G)\u0019;b)\t\u0011\u0015\u000eC\u0003LM\u0002\u0007!\u000eE\u0002O#.\u0004\"A\u00147\n\u00055|%A\u0002#pk\ndW\rC\u0003p\u0001\u0011\u0005\u0001/A\u0006j]R,'\u000f\u001d:fi\u0006\u001bHC\u0001\u0007r\u0011\u0015\u0011h\u000e1\u0001t\u0003-qWm^\"fY2$\u0016\u0010]3\u0011\u0005QthBA;}\u001d\t18P\u0004\u0002xu6\t\u0001P\u0003\u0002z\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!! \u0004\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u0011\r+G\u000e\u001c+za\u0016T!! \u0004")
public class Int16GeoTiffTile
extends GeoTiffTile
implements Int16GeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final ShortCells cellType;
    private final Option<Object> noDataValue;
    private final Int16BandType$ bandType;
    private final Function1<Object, Int16GeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public Int16BandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        Int16GeoTiffTile int16GeoTiffTile = this;
        synchronized (int16GeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = Int16GeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, Int16GeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$Int16GeoTiffSegmentCollection$_setter_$bandType_$eq(Int16BandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    @TraitSetter
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public ShortCells cellType() {
        return this.cellType;
    }

    @Override
    public Option<Object> noDataValue() {
        return this.noDataValue;
    }

    @Override
    public MutableArrayTile mutable() {
        short[] arr = (short[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Short());
        for (int index$macro$335 = 0; index$macro$335 < this.segmentCount(); ++index$macro$335) {
            Int16GeoTiffSegment segment = (Int16GeoTiffSegment)this.getSegment(index$macro$335);
            GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$335);
            for (int index$macro$334 = 0; index$macro$334 < segment.size(); ++index$macro$334) {
                short data;
                int col = segmentTransform.indexToCol(index$macro$334);
                int row = segmentTransform.indexToRow(index$macro$334);
                if (col >= this.cols() || row >= this.rows()) continue;
                arr[row * this.cols() + col] = data = segment.get(index$macro$334);
            }
        }
        return ShortArrayTile$.MODULE$.apply(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(gridBounds.size() * ShortConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        int counter = 0;
        if (super.segmentLayout().isStriped()) {
            for (int index$macro$337 = 0; index$macro$337 < this.segmentCount(); ++index$macro$337) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$337, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Int16GeoTiffSegment segment = (Int16GeoTiffSegment)this.getSegment(index$macro$337);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * ShortConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * ShortConstantNoDataCellType$.MODULE$.bytes();
                int adjCols = this.cols() * ShortConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * ShortConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$336 = adjStart; index$macro$336 < adjEnd; index$macro$336 += adjCols) {
                    System.arraycopy(segment.bytes(), index$macro$336, arr, counter, adjWidth);
                    counter += adjWidth;
                }
            }
        } else {
            for (int index$macro$339 = 0; index$macro$339 < this.segmentCount(); ++index$macro$339) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$339, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Int16GeoTiffSegment segment = (Int16GeoTiffSegment)this.getSegment(index$macro$339);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$339);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * ShortConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * ShortConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * ShortConstantNoDataCellType$.MODULE$.bytes();
                int adjTileWidth = intersection.tileWidth() * ShortConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$338 = adjStart; index$macro$338 < adjEnd; index$macro$338 += adjTileWidth) {
                    int row;
                    int col = segmentTransform.indexToCol(index$macro$338 / ShortConstantNoDataCellType$.MODULE$.bytes());
                    if (!gridBounds.contains(col, row = segmentTransform.indexToRow(index$macro$338 / ShortConstantNoDataCellType$.MODULE$.bytes()))) continue;
                    int j = (row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin());
                    System.arraycopy(segment.bytes(), index$macro$338, arr, j * ShortConstantNoDataCellType$.MODULE$.bytes(), adjWidth);
                }
            }
        }
        return ShortArrayTile$.MODULE$.fromBytes(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public Int16GeoTiffTile withNoData(Option<Object> noDataValue) {
        return new Int16GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public GeoTiffTile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof ShortCells) {
            ShortCells shortCells = (ShortCells)((Object)newCellType);
            geoTiffTile = new Int16GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, shortCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public Int16GeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, ShortCells cellType) {
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        this.segmentBytes = segmentBytes;
                        this.decompressor = decompressor;
                        this.compression = compression;
                        this.cellType = cellType;
                        super(segmentLayout, compression);
                        GeoTiffSegmentCollection$class.$init$(this);
                        Int16GeoTiffSegmentCollection$class.$init$(this);
                        if (!ShortCellType$.MODULE$.equals(cellType)) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!ShortConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    none$ = new Some((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE));
                    break block3;
                }
                if (!(cellType instanceof ShortUserDefinedNoDataCellType)) break block5;
                ShortUserDefinedNoDataCellType shortUserDefinedNoDataCellType = (ShortUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)BoxesRunTime.boxToShort((short)shortUserDefinedNoDataCellType.noDataValue()));
            }
            this.noDataValue = none$;
            return;
        }
        throw new MatchError((Object)cellType);
    }
}

