/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.ArraySegmentBytes;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile$;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tes!B\u0001\u0003\u0011\u0003Y\u0011aC$f_RKgM\u001a+jY\u0016T!a\u0001\u0003\u0002\u000f\u001d,w\u000e^5gM*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\rI\f7\u000f^3s\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!aC$f_RKgM\u001a+jY\u0016\u001c2!\u0004\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011\u0011cF\u0005\u00031I\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAG\u0007\u0005\u0002m\ta\u0001P5oSRtD#A\u0006\t\u000buiA\u0011\u0001\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001b}\t9/!=\u0002|\u0006u\u0018q B\u0001!\ta\u0001EB\u0003\u000f\u0005\u0005\u0005\u0011e\u0005\u0003!!\t2\u0003CA\u0012%\u001b\u00051\u0011BA\u0013\u0007\u0005\u0011!\u0016\u000e\\3\u0011\u000519\u0013B\u0001\u0015\u0003\u0005A9Um\u001c+jM\u001aLU.Y4f\t\u0006$\u0018\r\u0003\u0005+A\t\u0015\r\u0011\"\u0001,\u00035\u0019XmZ7f]Rd\u0015-_8viV\tA\u0006\u0005\u0002\r[%\u0011aF\u0001\u0002\u0015\u000f\u0016|G+\u001b4g'\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;\t\u0011A\u0002#\u0011!Q\u0001\n1\nab]3h[\u0016tG\u000fT1z_V$\b\u0005\u0003\u00053A\t\u0005\t\u0015!\u00034\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u0011\u0005Q2T\"A\u001b\u000b\u0005I\u0012\u0011BA\u001c6\u0005-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\t\u000bi\u0001C\u0011A\u001d\u0015\u0007}Q4\bC\u0003+q\u0001\u0007A\u0006C\u00033q\u0001\u00071\u0007C\u0004>A\t\u0007i\u0011\u0001 \u0002\u0011\r,G\u000e\u001c+za\u0016,\u0012a\u0010\t\u0003\u0001*s!!\u0011%\u000f\u0005\t;eBA\"G\u001b\u0005!%BA#\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011\u0011JB\u0001\ba\u0006\u001c7.Y4f\u0013\tYEJ\u0001\u0005DK2dG+\u001f9f\u0015\tIe\u0001C\u0004OA\t\u0007I\u0011A(\u0002\u0013\t\fg\u000eZ\"pk:$X#\u0001)\u0011\u0005E\t\u0016B\u0001*\u0013\u0005\rIe\u000e\u001e\u0005\u0007)\u0002\u0002\u000b\u0011\u0002)\u0002\u0015\t\fg\u000eZ\"pk:$\b\u0005C\u0004WA\t\u0007I\u0011A(\u0002\t\r|Gn\u001d\u0005\u00071\u0002\u0002\u000b\u0011\u0002)\u0002\u000b\r|Gn\u001d\u0011\t\u000fi\u0003#\u0019!C\u0001\u001f\u0006!!o\\<t\u0011\u0019a\u0006\u0005)A\u0005!\u0006)!o\\<tA!9a\f\tb\u0001\n\u0013y\u0016aB5t)&dW\rZ\u000b\u0002AB\u0011\u0011#Y\u0005\u0003EJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004eA\u0001\u0006I\u0001Y\u0001\tSN$\u0016\u000e\\3eA!)a\r\tC\u0001O\u000691m\u001c8wKJ$HCA\u0010i\u0011\u0015IW\r1\u0001@\u0003-qWm^\"fY2$\u0016\u0010]3\t\u000f-\u0004#\u0019!C\u0001\u001f\u0006a1/Z4nK:$8i\\;oi\"1Q\u000e\tQ\u0001\nA\u000bQb]3h[\u0016tGoQ8v]R\u0004\u0003\"B8!\r\u0003\u0001\u0018AC4fiN+w-\\3oiR\u0011\u0011\u000f\u001e\t\u0003\u0019IL!a\u001d\u0002\u0003\u001d\u001d+w\u000eV5gMN+w-\\3oi\")QO\u001ca\u0001!\u0006\t\u0011\u000eC\u0003xA\u0011\u0005\u00010A\u0002hKR$2\u0001U=|\u0011\u0015Qh\u000f1\u0001Q\u0003\r\u0019w\u000e\u001c\u0005\u0006yZ\u0004\r\u0001U\u0001\u0004e><\b\"\u0002@!\t\u0003y\u0018!C4fi\u0012{WO\u00197f)\u0019\t\t!a\u0002\u0002\nA\u0019\u0011#a\u0001\n\u0007\u0005\u0015!C\u0001\u0004E_V\u0014G.\u001a\u0005\u0006uv\u0004\r\u0001\u0015\u0005\u0006yv\u0004\r\u0001\u0015\u0005\b\u0003\u001b\u0001C\u0011AA\b\u0003\u001d1wN]3bG\"$B!!\u0005\u0002\u0018A\u0019\u0011#a\u0005\n\u0007\u0005U!C\u0001\u0003V]&$\b\u0002CA\r\u0003\u0017\u0001\r!a\u0007\u0002\u0003\u0019\u0004b!EA\u000f!\u0006E\u0011bAA\u0010%\tIa)\u001e8di&|g.\r\u0005\b\u0003G\u0001C\u0011AA\u0013\u000351wN]3bG\"$u.\u001e2mKR!\u0011\u0011CA\u0014\u0011!\tI\"!\tA\u0002\u0005%\u0002cB\t\u0002\u001e\u0005\u0005\u0011\u0011\u0003\u0005\b\u0003[\u0001C\u0011AA\u0018\u0003\ri\u0017\r\u001d\u000b\u0004?\u0005E\u0002\u0002CA\r\u0003W\u0001\r!a\r\u0011\u000bE\ti\u0002\u0015)\t\u000f\u0005]\u0002\u0005\"\u0001\u0002:\u0005IQ.\u00199E_V\u0014G.\u001a\u000b\u0004?\u0005m\u0002\u0002CA\r\u0003k\u0001\r!!\u0010\u0011\u000fE\ti\"!\u0001\u0002\u0002!9\u0011\u0011\t\u0011\u0005\u0002\u0005\r\u0013!\u00054pe\u0016\f7\r[%oiZK7/\u001b;peR!\u0011\u0011CA#\u0011!\t9%a\u0010A\u0002\u0005%\u0013a\u0002<jg&$xN\u001d\t\u0004\u0001\u0006-\u0013bAA'\u0019\nq\u0011J\u001c;US2,g+[:ji>\u0014\bbBA)A\u0011\u0005\u00111K\u0001\u0015M>\u0014X-Y2i\t>,(\r\\3WSNLGo\u001c:\u0015\t\u0005E\u0011Q\u000b\u0005\t\u0003\u000f\ny\u00051\u0001\u0002XA\u0019\u0001)!\u0017\n\u0007\u0005mCJA\tE_V\u0014G.\u001a+jY\u00164\u0016n]5u_JDq!a\u0018!\t\u0003\t\t'\u0001\u0007nCBLe\u000e^'baB,'\u000fF\u0002#\u0003GB\u0001\"!\u001a\u0002^\u0001\u0007\u0011qM\u0001\u0007[\u0006\u0004\b/\u001a:\u0011\u0007\u0001\u000bI'C\u0002\u0002l1\u0013Q\"\u00138u)&dW-T1qa\u0016\u0014\bbBA8A\u0011\u0005\u0011\u0011O\u0001\u0010[\u0006\u0004Hi\\;cY\u0016l\u0015\r\u001d9feR\u0019!%a\u001d\t\u0011\u0005\u0015\u0014Q\u000ea\u0001\u0003k\u00022\u0001QA<\u0013\r\tI\b\u0014\u0002\u0011\t>,(\r\\3US2,W*\u00199qKJDq!! !\t\u0003\ty(A\u0004d_6\u0014\u0017N\\3\u0015\t\u0005\u0005\u00151\u0012\u000b\u0004E\u0005\r\u0005\u0002CA\r\u0003w\u0002\r!!\"\u0011\rE\t9\t\u0015)Q\u0013\r\tII\u0005\u0002\n\rVt7\r^5p]JBq!!$\u0002|\u0001\u0007!%A\u0003pi\",'\u000fC\u0004\u0002\u0012\u0002\"\t!a%\u0002\u001b\r|WNY5oK\u0012{WO\u00197f)\u0011\t)*a'\u0015\u0007\t\n9\n\u0003\u0005\u0002\u001a\u0005=\u0005\u0019AAM!%\t\u0012qQA\u0001\u0003\u0003\t\t\u0001C\u0004\u0002\u000e\u0006=\u0005\u0019\u0001\u0012\t\u000f\u0005}\u0005\u0005\"\u0001\u0002\"\u00069Ao\\!se\u0006LHCAAR!\u0011\t\u0012Q\u0015)\n\u0007\u0005\u001d&CA\u0003BeJ\f\u0017\u0010C\u0004\u0002,\u0002\"\t!!,\u0002\u001bQ|\u0017I\u001d:bs\u0012{WO\u00197f)\t\ty\u000bE\u0003\u0012\u0003K\u000b\t\u0001C\u0004\u00024\u0002\"\t!!.\u0002\u0017Q|\u0017I\u001d:bsRKG.\u001a\u000b\u0003\u0003o\u00032aIA]\u0013\r\tYL\u0002\u0002\n\u0003J\u0014\u0018-\u001f+jY\u0016Dq!a0!\r\u0003\t\t-A\u0004nkR\f'\r\\3\u0016\u0005\u0005\r\u0007cA\u0012\u0002F&\u0019\u0011q\u0019\u0004\u0003!5+H/\u00192mK\u0006\u0013(/Y=US2,\u0007bBAfA\u0019\u0005\u0011QZ\u0001\u0005GJ|\u0007\u000f\u0006\u0003\u0002D\u0006=\u0007\u0002CAi\u0003\u0013\u0004\r!a5\u0002\u0015\u001d\u0014\u0018\u000e\u001a\"pk:$7\u000fE\u0002$\u0003+L1!a6\u0007\u0005)9%/\u001b3C_VtGm\u001d\u0005\b\u00037\u0004C\u0011AAo\u0003\u001d!xNQ=uKN$\"!a8\u0011\u000bE\t)+!9\u0011\u0007E\t\u0019/C\u0002\u0002fJ\u0011AAQ=uK\"9\u0011\u0011\u001e\u000fA\u0002\u0005-\u0018\u0001D:fO6,g\u000e\u001e\"zi\u0016\u001c\bc\u0001\u0007\u0002n&\u0019\u0011q\u001e\u0002\u0003\u0019M+w-\\3oi\nKH/Z:\t\u000f\u0005MH\u00041\u0001\u0002v\u0006aA-Z2p[B\u0014Xm]:peB\u0019A'a>\n\u0007\u0005eXG\u0001\u0007EK\u000e|W\u000e\u001d:fgN|'\u000fC\u0003+9\u0001\u0007A\u0006C\u000339\u0001\u00071\u0007C\u0003>9\u0001\u0007q\bC\u0005\u0003\u0004q\u0001\n\u00111\u0001\u0003\u0006\u0005A!-\u00198e)f\u0004X\rE\u0003\u0012\u0005\u000f\u0011Y!C\u0002\u0003\nI\u0011aa\u00149uS>t\u0007c\u0001\u0007\u0003\u000e%\u0019!q\u0002\u0002\u0003\u0011\t\u000bg\u000e\u001a+za\u0016Da!H\u0007\u0005\u0002\tMAcA\u0010\u0003\u0016!9!q\u0003B\t\u0001\u0004\u0011\u0013\u0001\u0002;jY\u0016Da!H\u0007\u0005\u0002\tmA#B\u0010\u0003\u001e\t}\u0001b\u0002B\f\u00053\u0001\rA\t\u0005\t\u0005C\u0011I\u00021\u0001\u0003$\u00059q\u000e\u001d;j_:\u001c\bc\u0001\u0007\u0003&%\u0019!q\u0005\u0002\u0003\u001d\u001d+w\u000eV5gM>\u0003H/[8og\"I!1F\u0007\u0012\u0002\u0013\u0005!QF\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!q\u0006\u0016\u0005\u0005\u000b\u0011\td\u000b\u0002\u00034A!!Q\u0007B \u001b\t\u00119D\u0003\u0003\u0003:\tm\u0012!C;oG\",7m[3e\u0015\r\u0011iDE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B!\u0005o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011)%DA\u0001\n\u0013\u00119%A\u0006sK\u0006$'+Z:pYZ,GC\u0001B%!\u0011\u0011YE!\u0016\u000e\u0005\t5#\u0002\u0002B(\u0005#\nA\u0001\\1oO*\u0011!1K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003X\t5#AB(cU\u0016\u001cG\u000f")
public abstract class GeoTiffTile
implements Tile,
GeoTiffImageData {
    private final GeoTiffSegmentLayout segmentLayout;
    private final Compression compression;
    private final int bandCount;
    private final int cols;
    private final int rows;
    private final boolean isTiled;
    private final int segmentCount;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Option<BandType> apply$default$6() {
        return GeoTiffTile$.MODULE$.apply$default$6();
    }

    public static GeoTiffTile apply(Tile tile, GeoTiffOptions geoTiffOptions) {
        return GeoTiffTile$.MODULE$.apply(tile, geoTiffOptions);
    }

    public static GeoTiffTile apply(Tile tile) {
        return GeoTiffTile$.MODULE$.apply(tile);
    }

    public static GeoTiffTile apply(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout geoTiffSegmentLayout, Compression compression, DataType dataType, Option<BandType> option) {
        return GeoTiffTile$.MODULE$.apply(segmentBytes, decompressor, geoTiffSegmentLayout, compression, dataType, option);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDraw() {
        return Tile$class.asciiDraw(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    @Override
    public GeoTiffSegmentLayout segmentLayout() {
        return this.segmentLayout;
    }

    @Override
    public abstract DataType cellType();

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    private boolean isTiled() {
        return this.isTiled;
    }

    @Override
    public GeoTiffTile convert(DataType newCellType) {
        BoxedUnit boxedUnit;
        if (newCellType.isFloatingPoint() != this.cellType().isFloatingPoint()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion from ", " to ", " may lead to data loss."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cellType(), newCellType})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        for (int index$macro$314 = 0; index$macro$314 < this.segmentCount(); ++index$macro$314) {
            GeoTiffSegment segment = this.getSegment(index$macro$314);
            byte[] newBytes = segment.convert(newCellType);
            arr[index$macro$314] = compressor.compress(newBytes, index$macro$314);
        }
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression, newCellType, GeoTiffTile$.MODULE$.apply$default$6());
    }

    public int segmentCount() {
        return this.segmentCount;
    }

    public abstract GeoTiffSegment getSegment(int var1);

    @Override
    public int get(int col, int row) {
        int segmentIndex = this.segmentLayout().getSegmentIndex(col, row);
        int i = this.segmentLayout().getSegmentTransform(segmentIndex).gridToIndex(col, row);
        return this.getSegment(segmentIndex).getInt(i);
    }

    @Override
    public double getDouble(int col, int row) {
        int segmentIndex = this.segmentLayout().getSegmentIndex(col, row);
        int i = this.segmentLayout().getSegmentTransform(segmentIndex).gridToIndex(col, row);
        return this.getSegment(segmentIndex).getDouble(i);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        for (int index$macro$317 = 0; index$macro$317 < this.segmentCount(); ++index$macro$317) {
            GeoTiffSegment segment = this.getSegment(index$macro$317);
            int segmentSize = segment.size();
            if (this.isTiled()) {
                GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$317);
                for (int index$macro$315 = 0; index$macro$315 < segmentSize; ++index$macro$315) {
                    int col = segmentTransform.indexToCol(index$macro$315);
                    int row = segmentTransform.indexToRow(index$macro$315);
                    if (col >= this.cols() || row >= this.rows()) continue;
                    f.apply$mcVI$sp(segment.getInt(index$macro$315));
                }
                continue;
            }
            for (int index$macro$316 = 0; index$macro$316 < segmentSize; ++index$macro$316) {
                f.apply$mcVI$sp(segment.getInt(index$macro$316));
            }
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        for (int index$macro$320 = 0; index$macro$320 < this.segmentCount(); ++index$macro$320) {
            GeoTiffSegment segment = this.getSegment(index$macro$320);
            int segmentSize = segment.size();
            if (this.isTiled()) {
                GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$320);
                for (int index$macro$318 = 0; index$macro$318 < segmentSize; ++index$macro$318) {
                    int col = segmentTransform.indexToCol(index$macro$318);
                    int row = segmentTransform.indexToRow(index$macro$318);
                    if (col >= this.cols() || row >= this.rows()) continue;
                    f.apply$mcVD$sp(segment.getDouble(index$macro$318));
                }
                continue;
            }
            for (int index$macro$319 = 0; index$macro$319 < segmentSize; ++index$macro$319) {
                f.apply$mcVD$sp(segment.getDouble(index$macro$319));
            }
        }
    }

    @Override
    public GeoTiffTile map(Function1<Object, Object> f) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        for (int index$macro$321 = 0; index$macro$321 < this.segmentCount(); ++index$macro$321) {
            GeoTiffSegment segment = this.getSegment(index$macro$321);
            byte[] newBytes = segment.map((Function1<Object, Object>)new Serializable(this, f){
                public static final long serialVersionUID = 0L;
                public final Function1 f$1;

                public final int apply(int x$19) {
                    return this.f$1.apply$mcII$sp(x$19);
                }

                public int apply$mcII$sp(int x$19) {
                    return this.f$1.apply$mcII$sp(x$19);
                }
                {
                    this.f$1 = f$1;
                }
            });
            arr[index$macro$321] = compressor.compress(newBytes, index$macro$321);
        }
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression, this.cellType(), GeoTiffTile$.MODULE$.apply$default$6());
    }

    @Override
    public GeoTiffTile mapDouble(Function1<Object, Object> f) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        for (int index$macro$322 = 0; index$macro$322 < this.segmentCount(); ++index$macro$322) {
            GeoTiffSegment segment = this.getSegment(index$macro$322);
            byte[] newBytes = segment.mapDouble(f);
            arr[index$macro$322] = compressor.compress(newBytes, index$macro$322);
        }
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression, this.cellType(), GeoTiffTile$.MODULE$.apply$default$6());
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$324 = 0; index$macro$324 < this.segmentCount(); ++index$macro$324) {
            GeoTiffSegment segment = this.getSegment(index$macro$324);
            int segmentSize = segment.size();
            GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$324);
            for (int index$macro$323 = 0; index$macro$323 < segmentSize; ++index$macro$323) {
                int col = segmentTransform.indexToCol(index$macro$323);
                int row = segmentTransform.indexToRow(index$macro$323);
                if (col >= this.cols() || row >= this.rows()) continue;
                visitor.apply(col, row, segment.getInt(index$macro$323));
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$326 = 0; index$macro$326 < this.segmentCount(); ++index$macro$326) {
            GeoTiffSegment segment = this.getSegment(index$macro$326);
            int segmentSize = segment.size();
            GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$326);
            for (int index$macro$325 = 0; index$macro$325 < segmentSize; ++index$macro$325) {
                int col = segmentTransform.indexToCol(index$macro$325);
                int row = segmentTransform.indexToRow(index$macro$325);
                if (col >= this.cols() || row >= this.rows()) continue;
                visitor.apply(col, row, segment.getDouble(index$macro$325));
            }
        }
    }

    public Tile mapIntMapper(IntTileMapper mapper) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        for (int index$macro$327 = 0; index$macro$327 < this.segmentCount(); ++index$macro$327) {
            GeoTiffSegment segment = this.getSegment(index$macro$327);
            GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$327);
            byte[] newBytes = segment.mapWithIndex((Function2<Object, Object, Object>)new Serializable(this, mapper, segmentTransform){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoTiffTile $outer;
                private final IntTileMapper mapper$1;
                private final GridIndexTransform segmentTransform$1;

                public final int apply(int i, int z) {
                    return this.apply$mcIII$sp(i, z);
                }

                public int apply$mcIII$sp(int i, int z) {
                    int col = this.segmentTransform$1.indexToCol(i);
                    int row = this.segmentTransform$1.indexToRow(i);
                    return col < this.$outer.cols() && row < this.$outer.rows() ? this.mapper$1.apply(col, row, z) : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.mapper$1 = mapper$1;
                    this.segmentTransform$1 = segmentTransform$1;
                }
            });
            arr[index$macro$327] = compressor.compress(newBytes, index$macro$327);
        }
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression, this.cellType(), GeoTiffTile$.MODULE$.apply$default$6());
    }

    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        for (int index$macro$328 = 0; index$macro$328 < this.segmentCount(); ++index$macro$328) {
            GeoTiffSegment segment = this.getSegment(index$macro$328);
            GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$328);
            byte[] newBytes = segment.mapDoubleWithIndex((Function2<Object, Object, Object>)new Serializable(this, mapper, segmentTransform){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoTiffTile $outer;
                private final DoubleTileMapper mapper$2;
                private final GridIndexTransform segmentTransform$2;

                public final double apply(int i, double z) {
                    return this.apply$mcDID$sp(i, z);
                }

                public double apply$mcDID$sp(int i, double z) {
                    int col = this.segmentTransform$2.indexToCol(i);
                    int row = this.segmentTransform$2.indexToRow(i);
                    return col < this.$outer.cols() && row < this.$outer.rows() ? this.mapper$2.apply(col, row, z) : 0.0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.mapper$2 = mapper$2;
                    this.segmentTransform$2 = segmentTransform$2;
                }
            });
            arr[index$macro$328] = compressor.compress(newBytes, index$macro$328);
        }
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression, this.cellType(), GeoTiffTile$.MODULE$.apply$default$6());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        if (!(other instanceof GeoTiffTile)) return this.mapIntMapper(new IntTileMapper(this, other, f){
            private final Tile other$1;
            private final Function2 f$2;

            public int apply(int col, int row, int z) {
                return this.f$2.apply$mcIII$sp(z, this.other$1.get(col, row));
            }
            {
                this.other$1 = other$1;
                this.f$2 = f$2;
            }
        });
        GeoTiffTile geoTiffTile = (GeoTiffTile)other;
        TileLayout tileLayout = this.segmentLayout().tileLayout();
        TileLayout tileLayout2 = geoTiffTile.segmentLayout().tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return this.mapIntMapper(new /* invalid duplicate definition of identical inner class */);
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return this.mapIntMapper(new /* invalid duplicate definition of identical inner class */);
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        int index$macro$329 = 0;
        while (index$macro$329 < this.segmentCount()) {
            GeoTiffSegment segment = this.getSegment(index$macro$329);
            GeoTiffSegment otherSegment = geoTiffTile.getSegment(index$macro$329);
            byte[] newBytes = segment.mapWithIndex((Function2<Object, Object, Object>)new Serializable(this, f, otherSegment){
                public static final long serialVersionUID = 0L;
                public final Function2 f$2;
                public final GeoTiffSegment otherSegment$1;

                public final int apply(int i, int z) {
                    return this.f$2.apply$mcIII$sp(z, this.otherSegment$1.getInt(i));
                }

                public int apply$mcIII$sp(int i, int z) {
                    return this.f$2.apply$mcIII$sp(z, this.otherSegment$1.getInt(i));
                }
                {
                    this.f$2 = f$2;
                    this.otherSegment$1 = otherSegment$1;
                }
            });
            arr[index$macro$329] = compressor.compress(newBytes, index$macro$329);
            ++index$macro$329;
        }
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression, this.cellType(), GeoTiffTile$.MODULE$.apply$default$6());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        if (!(other instanceof GeoTiffTile)) return this.mapDoubleMapper(new DoubleTileMapper(this, other, f){
            private final Tile other$2;
            private final Function2 f$3;

            public double apply(int col, int row, double z) {
                return this.f$3.apply$mcDDD$sp(z, (double)this.other$2.get(col, row));
            }
            {
                this.other$2 = other$2;
                this.f$3 = f$3;
            }
        });
        GeoTiffTile geoTiffTile = (GeoTiffTile)other;
        TileLayout tileLayout = this.segmentLayout().tileLayout();
        TileLayout tileLayout2 = geoTiffTile.segmentLayout().tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return this.mapDoubleMapper(new /* invalid duplicate definition of identical inner class */);
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return this.mapDoubleMapper(new /* invalid duplicate definition of identical inner class */);
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        int index$macro$330 = 0;
        while (index$macro$330 < this.segmentCount()) {
            GeoTiffSegment segment = this.getSegment(index$macro$330);
            GeoTiffSegment otherSegment = geoTiffTile.getSegment(index$macro$330);
            byte[] newBytes = segment.mapDoubleWithIndex((Function2<Object, Object, Object>)new Serializable(this, f, otherSegment){
                public static final long serialVersionUID = 0L;
                public final Function2 f$3;
                public final GeoTiffSegment otherSegment$2;

                public final double apply(int i, double z) {
                    return this.f$3.apply$mcDDD$sp(z, this.otherSegment$2.getDouble(i));
                }

                public double apply$mcDID$sp(int i, double z) {
                    return this.f$3.apply$mcDDD$sp(z, this.otherSegment$2.getDouble(i));
                }
                {
                    this.f$3 = f$3;
                    this.otherSegment$2 = otherSegment$2;
                }
            });
            arr[index$macro$330] = compressor.compress(newBytes, index$macro$330);
            ++index$macro$330;
        }
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression, this.cellType(), GeoTiffTile$.MODULE$.apply$default$6());
    }

    @Override
    public int[] toArray() {
        return this.toArrayTile().toArray();
    }

    @Override
    public double[] toArrayDouble() {
        return this.toArrayTile().toArrayDouble();
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public abstract MutableArrayTile mutable();

    public abstract MutableArrayTile crop(GridBounds var1);

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    public GeoTiffTile(GeoTiffSegmentLayout segmentLayout, Compression compression) {
        this.segmentLayout = segmentLayout;
        this.compression = compression;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        this.bandCount = 1;
        this.cols = segmentLayout.totalCols();
        this.rows = segmentLayout.totalRows();
        this.isTiled = segmentLayout.isTiled();
        this.segmentCount = this.segmentBytes().size();
    }
}

