/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.IntCells;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import geotrellis.raster.io.geotiff.ArraySegmentBytes;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.BitGeoTiffTile;
import geotrellis.raster.io.geotiff.ByteGeoTiffTile;
import geotrellis.raster.io.geotiff.Float32GeoTiffTile;
import geotrellis.raster.io.geotiff.Float64GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffOptions$;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.Int16GeoTiffTile;
import geotrellis.raster.io.geotiff.Int32GeoTiffTile;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.UByteGeoTiffTile;
import geotrellis.raster.io.geotiff.UInt16GeoTiffTile;
import geotrellis.raster.io.geotiff.UInt32BandType$;
import geotrellis.raster.io.geotiff.UInt32GeoTiffTile;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.package$;
import geotrellis.raster.split.Split;
import geotrellis.raster.split.Split$Options$;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class GeoTiffTile$
implements Serializable {
    public static final GeoTiffTile$ MODULE$;

    static {
        new GeoTiffTile$();
    }

    public GeoTiffTile apply(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, DataType cellType, Option<BandType> bandType) {
        block13: {
            GeoTiffTile geoTiffTile;
            block4: {
                GeoTiffTile geoTiffTile2;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                block2: {
                                                    block3: {
                                                        Some some;
                                                        if (!(bandType instanceof Some) || !UInt32BandType$.MODULE$.equals((some = (Some)bandType).x())) break block2;
                                                        if (!(cellType instanceof FloatCells)) break block3;
                                                        NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                                        geoTiffTile = new UInt32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (FloatCells)((Object)noDataHandling));
                                                        break block4;
                                                    }
                                                    throw new IllegalArgumentException("UInt32BandType should always resolve to Float celltype");
                                                }
                                                if (!(cellType instanceof BitCells)) break block5;
                                                NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                                geoTiffTile2 = new BitGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (BitCells)((Object)noDataHandling));
                                                break block6;
                                            }
                                            if (!(cellType instanceof ByteCells)) break block7;
                                            NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                            geoTiffTile2 = new ByteGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (ByteCells)((Object)noDataHandling));
                                            break block6;
                                        }
                                        if (!(cellType instanceof UByteCells)) break block8;
                                        NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                        geoTiffTile2 = new UByteGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (UByteCells)((Object)noDataHandling));
                                        break block6;
                                    }
                                    if (!(cellType instanceof ShortCells)) break block9;
                                    NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                    geoTiffTile2 = new Int16GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (ShortCells)((Object)noDataHandling));
                                    break block6;
                                }
                                if (!(cellType instanceof UShortCells)) break block10;
                                NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                geoTiffTile2 = new UInt16GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (UShortCells)((Object)noDataHandling));
                                break block6;
                            }
                            if (!(cellType instanceof IntCells)) break block11;
                            NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                            geoTiffTile2 = new Int32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (IntCells)((Object)noDataHandling));
                            break block6;
                        }
                        if (!(cellType instanceof FloatCells)) break block12;
                        NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                        geoTiffTile2 = new Float32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (FloatCells)((Object)noDataHandling));
                        break block6;
                    }
                    if (!(cellType instanceof DoubleCells)) break block13;
                    NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                    geoTiffTile2 = new Float64GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (DoubleCells)((Object)noDataHandling));
                }
                geoTiffTile = geoTiffTile2;
            }
            return geoTiffTile;
        }
        throw new MatchError((Object)cellType);
    }

    public GeoTiffTile apply(Tile tile) {
        return this.apply(tile, GeoTiffOptions$.MODULE$.DEFAULT());
    }

    public GeoTiffTile apply(Tile tile, GeoTiffOptions options) {
        StorageMethod storageMethod;
        block5: {
            Tile[] tileArray;
            byte[][] segmentBytes;
            Compressor compressor;
            int segmentCount;
            GeoTiffSegmentLayout segmentLayout;
            block4: {
                block3: {
                    BandType bandType = BandType$.MODULE$.forCellType(tile.cellType());
                    segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(tile.cols(), tile.rows(), options.storageMethod(), bandType);
                    segmentCount = segmentLayout.tileLayout().layoutCols() * segmentLayout.tileLayout().layoutRows();
                    compressor = options.compression().createCompressor(segmentCount);
                    segmentBytes = (byte[][])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                    storageMethod = options.storageMethod();
                    if (!(storageMethod instanceof Tiled)) break block3;
                    tileArray = (Tile[])package$.MODULE$.withTileMethods(tile).split(segmentLayout.tileLayout());
                    break block4;
                }
                if (!(storageMethod instanceof Striped)) break block5;
                boolean x$39 = Split$Options$.MODULE$.apply$default$1();
                tileArray = package$.MODULE$.withTileMethods(tile).split(segmentLayout.tileLayout(), new Split.Options(x$39, false));
            }
            for (int index$macro$313 = 0; index$macro$313 < segmentCount; ++index$macro$313) {
                byte[] bytes = tileArray[index$macro$313].toBytes();
                segmentBytes[index$macro$313] = compressor.compress(bytes, index$macro$313);
            }
            return this.apply(new ArraySegmentBytes(segmentBytes), compressor.createDecompressor(), segmentLayout, options.compression(), tile.cellType(), this.apply$default$6());
        }
        throw new MatchError((Object)storageMethod);
    }

    public Option<BandType> apply$default$6() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeoTiffTile$() {
        MODULE$ = this;
    }
}

