/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.GridBounds;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped$;
import geotrellis.raster.io.geotiff.Tiled;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001.\u0011AcR3p)&4gmU3h[\u0016tG\u000fT1z_V$(BA\u0002\u0005\u0003\u001d9Wm\u001c;jM\u001aT!!\u0002\u0004\u0002\u0005%|'BA\u0004\t\u0003\u0019\u0011\u0018m\u001d;fe*\t\u0011\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001a\u0005\u0003\u0001\u0019I)\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\b!J|G-^2u!\tia#\u0003\u0002\u0018\u001d\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0004\u0001BK\u0002\u0013\u0005!$A\u0005u_R\fGnQ8mgV\t1\u0004\u0005\u0002\u000e9%\u0011QD\u0004\u0002\u0004\u0013:$\b\u0002C\u0010\u0001\u0005#\u0005\u000b\u0011B\u000e\u0002\u0015Q|G/\u00197D_2\u001c\b\u0005\u0003\u0005\"\u0001\tU\r\u0011\"\u0001\u001b\u0003%!x\u000e^1m%><8\u000f\u0003\u0005$\u0001\tE\t\u0015!\u0003\u001c\u0003)!x\u000e^1m%><8\u000f\t\u0005\tK\u0001\u0011)\u001a!C\u0001M\u0005QA/\u001b7f\u0019\u0006Lx.\u001e;\u0016\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003\u0019I!A\u000b\u0004\u0003\u0015QKG.\u001a'bs>,H\u000f\u0003\u0005-\u0001\tE\t\u0015!\u0003(\u0003-!\u0018\u000e\\3MCf|W\u000f\u001e\u0011\t\u00119\u0002!Q3A\u0005\u0002=\nq![:US2,G-F\u00011!\ti\u0011'\u0003\u00023\u001d\t9!i\\8mK\u0006t\u0007\u0002\u0003\u001b\u0001\u0005#\u0005\u000b\u0011\u0002\u0019\u0002\u0011%\u001cH+\u001b7fI\u0002BQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtD#\u0002\u001d;wqj\u0004CA\u001d\u0001\u001b\u0005\u0011\u0001\"B\r6\u0001\u0004Y\u0002\"B\u00116\u0001\u0004Y\u0002\"B\u00136\u0001\u00049\u0003\"\u0002\u00186\u0001\u0004\u0001\u0004\"B \u0001\t\u0003\u0001\u0015!D:u_J\fw-Z'fi\"|G-F\u0001B!\tI$)\u0003\u0002D\u0005\ti1\u000b^8sC\u001e,W*\u001a;i_\u0012DQ!\u0012\u0001\u0005\u0002=\n\u0011\"[:TiJL\u0007/\u001a3\t\u000b\u001d\u0003A\u0011\u0001%\u0002)\u001d,GoU3h[\u0016tG\u000fR5nK:\u001c\u0018n\u001c8t)\tIE\n\u0005\u0003\u000e\u0015nY\u0012BA&\u000f\u0005\u0019!V\u000f\u001d7fe!)QJ\u0012a\u00017\u0005a1/Z4nK:$\u0018J\u001c3fq\")q\n\u0001C\u0001!\u0006qq-\u001a;TK\u001elWM\u001c;TSj,GCA\u000eR\u0011\u0015ie\n1\u0001\u001c\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003=9W\r^*fO6,g\u000e^%oI\u0016DHcA\u000eV/\")aK\u0015a\u00017\u0005\u00191m\u001c7\t\u000ba\u0013\u0006\u0019A\u000e\u0002\u0007I|w\u000fC\u0003[\u0001\u0011\u00051,A\nhKR\u001cVmZ7f]R$&/\u00198tM>\u0014X\u000e\u0006\u0002]?B\u0011\u0011(X\u0005\u0003=\n\u0011!c\u0012:jI&sG-\u001a=Ue\u0006t7OZ8s[\")Q*\u0017a\u00017!)\u0011\r\u0001C\u0001E\u0006iq-\u001a;He&$'i\\;oIN$2a\u00194h!\tAC-\u0003\u0002f\r\tQqI]5e\u0005>,h\u000eZ:\t\u000b5\u0003\u0007\u0019A\u000e\t\u000f!\u0004\u0007\u0013!a\u0001a\u0005)\u0011n\u001d\"ji\"9!\u000eAA\u0001\n\u0003Y\u0017\u0001B2paf$R\u0001\u000f7n]>Dq!G5\u0011\u0002\u0003\u00071\u0004C\u0004\"SB\u0005\t\u0019A\u000e\t\u000f\u0015J\u0007\u0013!a\u0001O!9a&\u001bI\u0001\u0002\u0004\u0001\u0004bB9\u0001#\u0003%\tA]\u0001\u0018O\u0016$xI]5e\u0005>,h\u000eZ:%I\u00164\u0017-\u001e7uII*\u0012a\u001d\u0016\u0003aQ\\\u0013!\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005it\u0011AC1o]>$\u0018\r^5p]&\u0011Ap\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002@\u0001#\u0003%\ta`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tA\u000b\u0002\u001ci\"A\u0011Q\u0001\u0001\u0012\u0002\u0013\u0005q0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005%\u0001!%A\u0005\u0002\u0005-\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bQ#a\n;\t\u0011\u0005E\u0001!%A\u0005\u0002I\fabY8qs\u0012\"WMZ1vYR$C\u0007C\u0005\u0002\u0016\u0001\t\t\u0011\"\u0011\u0002\u0018\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011aa\u0015;sS:<\u0007\u0002CA\u0016\u0001\u0005\u0005I\u0011\u0001\u000e\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003g\tI\u0004E\u0002\u000e\u0003kI1!a\u000e\u000f\u0005\r\te.\u001f\u0005\n\u0003w\ti#!AA\u0002m\t1\u0001\u001f\u00132\u0011%\ty\u0004AA\u0001\n\u0003\n\t%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0005\u0005\u0004\u0002F\u0005-\u00131G\u0007\u0003\u0003\u000fR1!!\u0013\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019&\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0014Q\u000b\u0005\u000b\u0003w\ty%!AA\u0002\u0005M\u0002\"CA-\u0001\u0005\u0005I\u0011IA.\u0003!A\u0017m\u001d5D_\u0012,G#A\u000e\t\u0013\u0005}\u0003!!A\u0005B\u0005\u0005\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0001\"CA3\u0001\u0005\u0005I\u0011IA4\u0003\u0019)\u0017/^1mgR\u0019\u0001'!\u001b\t\u0015\u0005m\u00121MA\u0001\u0002\u0004\t\u0019dB\u0004\u0002n\tA\t!a\u001c\u0002)\u001d+w\u000eV5gMN+w-\\3oi2\u000b\u0017p\\;u!\rI\u0014\u0011\u000f\u0004\u0007\u0003\tA\t!a\u001d\u0014\t\u0005ED\"\u0006\u0005\bm\u0005ED\u0011AA<)\t\ty\u0007\u0003\u0005\u0002|\u0005ED\u0011AA?\u0003\u0015\t\u0007\u000f\u001d7z)%A\u0014qPAA\u0003\u0007\u000b)\t\u0003\u0004\u001a\u0003s\u0002\ra\u0007\u0005\u0007C\u0005e\u0004\u0019A\u000e\t\r}\nI\b1\u0001B\u0011!\t9)!\u001fA\u0002\u0005%\u0015\u0001\u00032b]\u0012$\u0016\u0010]3\u0011\u0007e\nY)C\u0002\u0002\u000e\n\u0011\u0001BQ1oIRK\b/\u001a\u0005\u000b\u0003w\n\t(!A\u0005\u0002\u0006EE#\u0003\u001d\u0002\u0014\u0006U\u0015qSAM\u0011\u0019I\u0012q\u0012a\u00017!1\u0011%a$A\u0002mAa!JAH\u0001\u00049\u0003B\u0002\u0018\u0002\u0010\u0002\u0007\u0001\u0007\u0003\u0006\u0002\u001e\u0006E\u0014\u0011!CA\u0003?\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\"\u00065\u0006#B\u0007\u0002$\u0006\u001d\u0016bAAS\u001d\t1q\n\u001d;j_:\u0004r!DAU7m9\u0003'C\u0002\u0002,:\u0011a\u0001V;qY\u0016$\u0004\"CAX\u00037\u000b\t\u00111\u00019\u0003\rAH\u0005\r\u0005\u000b\u0003g\u000b\t(!A\u0005\n\u0005U\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a.\u0011\t\u0005m\u0011\u0011X\u0005\u0005\u0003w\u000biB\u0001\u0004PE*,7\r\u001e")
public class GeoTiffSegmentLayout
implements Product,
Serializable {
    private final int totalCols;
    private final int totalRows;
    private final TileLayout tileLayout;
    private final boolean isTiled;

    public static Option<Tuple4<Object, Object, TileLayout, Object>> unapply(GeoTiffSegmentLayout geoTiffSegmentLayout) {
        return GeoTiffSegmentLayout$.MODULE$.unapply(geoTiffSegmentLayout);
    }

    public static GeoTiffSegmentLayout apply(int n, int n2, TileLayout tileLayout, boolean bl) {
        return GeoTiffSegmentLayout$.MODULE$.apply(n, n2, tileLayout, bl);
    }

    public static GeoTiffSegmentLayout apply(int n, int n2, StorageMethod storageMethod, BandType bandType) {
        return GeoTiffSegmentLayout$.MODULE$.apply(n, n2, storageMethod, bandType);
    }

    public int totalCols() {
        return this.totalCols;
    }

    public int totalRows() {
        return this.totalRows;
    }

    public TileLayout tileLayout() {
        return this.tileLayout;
    }

    public boolean isTiled() {
        return this.isTiled;
    }

    public StorageMethod storageMethod() {
        return this.isTiled() ? new Tiled(this.tileLayout().tileCols(), this.tileLayout().tileRows()) : Striped$.MODULE$.apply(this.tileLayout().tileRows());
    }

    public boolean isStriped() {
        return !this.isTiled();
    }

    public Tuple2<Object, Object> getSegmentDimensions(int segmentIndex) {
        int layoutCol = segmentIndex % this.tileLayout().layoutCols();
        int layoutRow = segmentIndex / this.tileLayout().layoutCols();
        int cols = layoutCol == this.tileLayout().layoutCols() - 1 ? this.totalCols() - (this.tileLayout().layoutCols() - 1) * this.tileLayout().tileCols() : this.tileLayout().tileCols();
        int rows = layoutRow == this.tileLayout().layoutRows() - 1 ? this.totalRows() - (this.tileLayout().layoutRows() - 1) * this.tileLayout().tileRows() : this.tileLayout().tileRows();
        return new Tuple2.mcII.sp(cols, rows);
    }

    public int getSegmentSize(int segmentIndex) {
        Tuple2<Object, Object> tuple2 = this.getSegmentDimensions(segmentIndex);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
            int cols = sp2._1$mcI$sp();
            int rows = sp2._2$mcI$sp();
            return cols * rows;
        }
        throw new MatchError(tuple2);
    }

    public int getSegmentIndex(int col, int row) {
        int layoutCol = col / this.tileLayout().tileCols();
        int layoutRow = row / this.tileLayout().tileRows();
        return layoutRow * this.tileLayout().layoutCols() + layoutCol;
    }

    public GridIndexTransform getSegmentTransform(int segmentIndex) {
        int layoutCol = segmentIndex % this.tileLayout().layoutCols();
        int layoutRow = segmentIndex / this.tileLayout().layoutCols();
        return new GridIndexTransform(this, layoutCol, layoutRow){
            private final int segmentCols;
            private final int segmentRows;
            private final /* synthetic */ GeoTiffSegmentLayout $outer;
            private final int layoutCol$1;
            private final int layoutRow$1;

            public int segmentCols() {
                return this.segmentCols;
            }

            public int segmentRows() {
                return this.segmentRows;
            }

            public int indexToCol(int i) {
                int tileCol = i % this.$outer.tileLayout().tileCols();
                return this.layoutCol$1 * this.$outer.tileLayout().tileCols() + tileCol;
            }

            public int indexToRow(int i) {
                int tileRow = i / this.$outer.tileLayout().tileCols();
                return this.layoutRow$1 * this.$outer.tileLayout().tileRows() + tileRow;
            }

            public int bitIndexToCol(int i) {
                int tileCol = i % this.segmentCols();
                return this.layoutCol$1 * this.$outer.tileLayout().tileCols() + tileCol;
            }

            public int bitIndexToRow(int i) {
                int tileRow = i / this.segmentCols();
                return this.layoutRow$1 * this.$outer.tileLayout().tileRows() + tileRow;
            }

            public int gridToIndex(int col, int row) {
                int tileCol = col - this.layoutCol$1 * this.$outer.tileLayout().tileCols();
                int tileRow = row - this.layoutRow$1 * this.$outer.tileLayout().tileRows();
                return this.$outer.isTiled() ? tileRow * this.$outer.tileLayout().tileCols() + tileCol : tileRow * this.segmentCols() + tileCol;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.layoutCol$1 = layoutCol$1;
                this.layoutRow$1 = layoutRow$1;
                this.segmentCols = layoutCol$1 == $outer.tileLayout().layoutCols() - 1 ? $outer.totalCols() - ($outer.tileLayout().layoutCols() - 1) * $outer.tileLayout().tileCols() : $outer.tileLayout().tileCols();
                this.segmentRows = layoutRow$1 == $outer.tileLayout().layoutRows() - 1 ? $outer.totalRows() - ($outer.tileLayout().layoutRows() - 1) * $outer.tileLayout().tileRows() : $outer.tileLayout().tileRows();
            }
        };
    }

    public GridBounds getGridBounds(int segmentIndex, boolean isBit) {
        GridIndexTransform segmentTransform = this.getSegmentTransform(segmentIndex);
        int segmentCols = segmentTransform.segmentCols();
        int segmentRows = segmentTransform.segmentRows();
        int startCol = isBit ? segmentTransform.bitIndexToCol(0) : segmentTransform.indexToCol(0);
        int startRow = isBit ? segmentTransform.bitIndexToRow(0) : segmentTransform.indexToRow(0);
        int endCol = this.isStriped() ? this.getSegmentDimensions(segmentIndex)._1$mcI$sp() : startCol + segmentCols - 1;
        int endRow = this.isStriped() ? segmentIndex * segmentRows + segmentRows : startRow + segmentRows - 1;
        return new GridBounds(startCol, startRow, endCol, endRow);
    }

    public boolean getGridBounds$default$2() {
        return false;
    }

    public GeoTiffSegmentLayout copy(int totalCols, int totalRows, TileLayout tileLayout, boolean isTiled) {
        return new GeoTiffSegmentLayout(totalCols, totalRows, tileLayout, isTiled);
    }

    public int copy$default$1() {
        return this.totalCols();
    }

    public int copy$default$2() {
        return this.totalRows();
    }

    public TileLayout copy$default$3() {
        return this.tileLayout();
    }

    public boolean copy$default$4() {
        return this.isTiled();
    }

    public String productPrefix() {
        return "GeoTiffSegmentLayout";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isTiled());
                break;
            }
            case 2: {
                object = this.tileLayout();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.totalRows());
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.totalCols());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GeoTiffSegmentLayout;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.totalCols()), (int)this.totalRows()), (int)Statics.anyHash((Object)this.tileLayout())), (int)(this.isTiled() ? 1231 : 1237)), (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof GeoTiffSegmentLayout)) return false;
        boolean bl = true;
        if (!bl) return false;
        GeoTiffSegmentLayout geoTiffSegmentLayout = (GeoTiffSegmentLayout)x$1;
        if (this.totalCols() != geoTiffSegmentLayout.totalCols()) return false;
        if (this.totalRows() != geoTiffSegmentLayout.totalRows()) return false;
        TileLayout tileLayout = this.tileLayout();
        TileLayout tileLayout2 = geoTiffSegmentLayout.tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return false;
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return false;
        if (this.isTiled() != geoTiffSegmentLayout.isTiled()) return false;
        if (!geoTiffSegmentLayout.canEqual(this)) return false;
        return true;
    }

    public GeoTiffSegmentLayout(int totalCols, int totalRows, TileLayout tileLayout, boolean isTiled) {
        this.totalCols = totalCols;
        this.totalRows = totalRows;
        this.tileLayout = tileLayout;
        this.isTiled = isTiled;
        Product.class.$init$((Product)this);
    }
}

