/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.macros.DoubleTileCombiner10;
import geotrellis.macros.DoubleTileCombiner3;
import geotrellis.macros.DoubleTileCombiner4;
import geotrellis.macros.DoubleTileCombiner5;
import geotrellis.macros.DoubleTileCombiner6;
import geotrellis.macros.DoubleTileCombiner7;
import geotrellis.macros.DoubleTileCombiner8;
import geotrellis.macros.DoubleTileCombiner9;
import geotrellis.macros.IntTileCombiner10;
import geotrellis.macros.IntTileCombiner3;
import geotrellis.macros.IntTileCombiner4;
import geotrellis.macros.IntTileCombiner5;
import geotrellis.macros.IntTileCombiner6;
import geotrellis.macros.IntTileCombiner7;
import geotrellis.macros.IntTileCombiner8;
import geotrellis.macros.IntTileCombiner9;
import geotrellis.macros.MacroCombineFunctions;
import geotrellis.raster.ArrayMultibandTile;
import geotrellis.raster.ArrayMultibandTile$;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MacroGeotiffMultibandCombiners;
import geotrellis.raster.MacroGeotiffMultibandCombiners$class;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.SegmentCombiner;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.ArraySegmentBytes;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.BitBandType$;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile$;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffTile$;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.util.package$;
import scala.Array$;
import scala.Function1;
import scala.Function11;
import scala.Function13;
import scala.Function15;
import scala.Function17;
import scala.Function19;
import scala.Function2;
import scala.Function21;
import scala.Function3;
import scala.Function5;
import scala.Function7;
import scala.Function9;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEs!B\u0001\u0003\u0011\u0003Y\u0011\u0001F$f_RKgMZ'vYRL'-\u00198e)&dWM\u0003\u0002\u0004\t\u00059q-Z8uS\u001a4'BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u00051!/Y:uKJT\u0011!C\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0015\u000f\u0016|G+\u001b4g\u001bVdG/\u001b2b]\u0012$\u0016\u000e\\3\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003#]I!\u0001\u0007\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000biiA\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0001\"B\u000f\u000e\t\u0003q\u0012!B1qa2LH#E\u0010\u0003l\n5(q\u001eBy\u0005g\u0014)Pa>\u0003zB\u0011A\u0002\t\u0004\u0006\u001d\t\t\t!I\n\u0006AA\u0011c%\u000b\t\u0003G\u0011j\u0011AB\u0005\u0003K\u0019\u0011Q\"T;mi&\u0014\u0017M\u001c3US2,\u0007C\u0001\u0007(\u0013\tA#A\u0001\tHK>$\u0016N\u001a4J[\u0006<W\rR1uCB\u00111EK\u0005\u0003W\u0019\u0011a$T1de><Um\u001c;jM\u001alU\u000f\u001c;jE\u0006tGmQ8nE&tWM]:\t\u00115\u0002#Q1A\u0005\u00029\nAb]3h[\u0016tGOQ=uKN,\u0012a\f\t\u0003\u0019AJ!!\r\u0002\u0003\u0019M+w-\\3oi\nKH/Z:\t\u0011M\u0002#\u0011!Q\u0001\n=\nQb]3h[\u0016tGOQ=uKN\u0004\u0003\u0002C\u001b!\u0005\u000b\u0007I\u0011\u0001\u001c\u0002\u0019\u0011,7m\\7qe\u0016\u001c8o\u001c:\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0002\u0002\u0017\r|W\u000e\u001d:fgNLwN\\\u0005\u0003ye\u0012A\u0002R3d_6\u0004(/Z:t_JD\u0001B\u0010\u0011\u0003\u0002\u0003\u0006IaN\u0001\u000eI\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0011\t\u0011\u0001\u0003#Q1A\u0005\u0002\u0005\u000bQb]3h[\u0016tG\u000fT1z_V$X#\u0001\"\u0011\u00051\u0019\u0015B\u0001#\u0003\u0005Q9Um\u001c+jM\u001a\u001cVmZ7f]Rd\u0015-_8vi\"Aa\t\tB\u0001B\u0003%!)\u0001\btK\u001elWM\u001c;MCf|W\u000f\u001e\u0011\t\u0011i\u0002#Q1A\u0005\u0002!+\u0012!\u0013\t\u0003q)K!aS\u001d\u0003\u0017\r{W\u000e\u001d:fgNLwN\u001c\u0005\t\u001b\u0002\u0012\t\u0011)A\u0005\u0013\u0006a1m\\7qe\u0016\u001c8/[8oA!Aq\n\tBC\u0002\u0013\u0005\u0001+A\u0005cC:$7i\\;oiV\t\u0011\u000b\u0005\u0002\u0012%&\u00111K\u0005\u0002\u0004\u0013:$\b\u0002C+!\u0005\u0003\u0005\u000b\u0011B)\u0002\u0015\t\fg\u000eZ\"pk:$\b\u0005\u0003\u0005XA\t\u0015\r\u0011\"\u0001Y\u0003IA\u0017m\u001d)jq\u0016d\u0017J\u001c;fe2,\u0017M^3\u0016\u0003e\u0003\"!\u0005.\n\u0005m\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\t;\u0002\u0012\t\u0011)A\u00053\u0006\u0019\u0002.Y:QSb,G.\u00138uKJdW-\u0019<fA!)!\u0004\tC\u0001?R9q\u0004Y1cG\u0012,\u0007\"B\u0017_\u0001\u0004y\u0003\"B\u001b_\u0001\u00049\u0004\"\u0002!_\u0001\u0004\u0011\u0005\"\u0002\u001e_\u0001\u0004I\u0005\"B(_\u0001\u0004\t\u0006\"B,_\u0001\u0004I\u0006bB4!\u0005\u00045\t\u0001[\u0001\tG\u0016dG\u000eV=qKV\t\u0011\u000e\u0005\u0002ki:\u00111N\u001d\b\u0003YFt!!\u001c9\u000e\u00039T!a\u001c\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t\u0019h!A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(\u0001C\"fY2$\u0016\u0010]3\u000b\u0005M4\u0001b\u0002=!\u0005\u0004%\t\u0001U\u0001\u0005G>d7\u000f\u0003\u0004{A\u0001\u0006I!U\u0001\u0006G>d7\u000f\t\u0005\by\u0002\u0012\r\u0011\"\u0001Q\u0003\u0011\u0011xn^:\t\ry\u0004\u0003\u0015!\u0003R\u0003\u0015\u0011xn^:!\u0011\u001d\t\t\u0001\tD\u0001\u0003\u0007\t!bZ3u'\u0016<W.\u001a8u)\u0011\t)!a\u0003\u0011\u00071\t9!C\u0002\u0002\n\t\u0011abR3p)&4gmU3h[\u0016tG\u000f\u0003\u0004\u0002\u000e}\u0004\r!U\u0001\u0002S\"A\u0011\u0011\u0003\u0011C\u0002\u0013\u0005\u0001+\u0001\u0007tK\u001elWM\u001c;D_VtG\u000fC\u0004\u0002\u0016\u0001\u0002\u000b\u0011B)\u0002\u001bM,w-\\3oi\u000e{WO\u001c;!\u0011!\tI\u0002\tb\u0001\n\u0013A\u0016aB5t)&dW\r\u001a\u0005\b\u0003;\u0001\u0003\u0015!\u0003Z\u0003!I7\u000fV5mK\u0012\u0004\u0003bBA\u0011A\u0011\u0005\u00111E\u0001\u0005E\u0006tG\r\u0006\u0003\u0002&\u0005-\u0002c\u0001\u0007\u0002(%\u0019\u0011\u0011\u0006\u0002\u0003\u0017\u001d+w\u000eV5gMRKG.\u001a\u0005\b\u0003[\ty\u00021\u0001R\u0003%\u0011\u0017M\u001c3J]\u0012,\u0007\u0010C\u0004\u00022\u0001\"\t!a\r\u0002\u000b\t\fg\u000eZ:\u0016\u0005\u0005U\u0002CBA\u001c\u0003\u007f\t)E\u0004\u0003\u0002:\u0005ubbA7\u0002<%\t1#\u0003\u0002t%%!\u0011\u0011IA\"\u0005\u00191Vm\u0019;pe*\u00111O\u0005\t\u0004G\u0005\u001d\u0013bAA%\r\t!A+\u001b7f\u0011\u001d\ti\u0005\tC\u0001\u0003\u001f\n1b];cg\u0016$()\u00198egR!\u0011\u0011KA,!\r\u0019\u00131K\u0005\u0004\u0003+2!AE!se\u0006LX*\u001e7uS\n\fg\u000e\u001a+jY\u0016D\u0001\"!\u0017\u0002L\u0001\u0007\u00111L\u0001\rE\u0006tGmU3rk\u0016t7-\u001a\t\u0006\u0003o\ti&U\u0005\u0005\u0003?\n\u0019EA\u0002TKFDq!a\u0019!\t\u0003\t)'A\u0006u_\u0006\u0013(/Y=US2,GCAA)\u0011\u001d\tI\u0007\tC\u0001\u0003W\nAa\u0019:paR!\u0011\u0011KA7\u0011!\ty'a\u001aA\u0002\u0005E\u0014AC4sS\u0012\u0014u.\u001e8egB\u00191%a\u001d\n\u0007\u0005UdA\u0001\u0006He&$'i\\;oINDq!!\u001f!\t\u0003\tY(A\u0004d_:4XM\u001d;\u0015\u0007}\ti\bC\u0004\u0002\u0000\u0005]\u0004\u0019A5\u0002\u00179,woQ3mYRK\b/\u001a\u0005\b\u0003\u0007\u0003C\u0011AAC\u0003-i\u0017\r]*fO6,g\u000e^:\u0015\u0007\t\n9\t\u0003\u0005\u0002\n\u0006\u0005\u0005\u0019AAF\u0003\u00051\u0007\u0003C\t\u0002\u000e\u0006\u0015\u0011+!%\n\u0007\u0005=%CA\u0005Gk:\u001cG/[8oeA)\u0011#a%\u0002\u0018&\u0019\u0011Q\u0013\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0007E\tI*C\u0002\u0002\u001cJ\u0011AAQ=uK\"9\u0011q\u0014\u0011\u0005\u0002\u0005\u0005\u0016aA7baR!\u00111UAU)\r\u0011\u0013Q\u0015\u0005\t\u0003\u0013\u000bi\n1\u0001\u0002(B1\u0011#!$R#FC\u0001\"a+\u0002\u001e\u0002\u0007\u00111L\u0001\u0007gV\u00147/\u001a;\t\u000f\u0005=\u0006\u0005\"\u0001\u00022\u0006IQ.\u00199E_V\u0014G.\u001a\u000b\u0005\u0003g\u000by\fF\u0002#\u0003kC\u0001\"!#\u0002.\u0002\u0007\u0011q\u0017\t\t#\u00055\u0015+!/\u0002:B\u0019\u0011#a/\n\u0007\u0005u&C\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0003W\u000bi\u000b1\u0001\u0002\\!9\u0011q\u0014\u0011\u0005\u0002\u0005\rG\u0003BAc\u0003\u001f$2AIAd\u0011!\tI)!1A\u0002\u0005%\u0007#B\t\u0002LF\u000b\u0016bAAg%\tIa)\u001e8di&|g.\r\u0005\b\u0003#\f\t\r1\u0001R\u0003\t\u0011\u0007\u0007C\u0004\u00020\u0002\"\t!!6\u0015\t\u0005]\u0017Q\u001c\u000b\u0004E\u0005e\u0007\u0002CAE\u0003'\u0004\r!a7\u0011\u000fE\tY-!/\u0002:\"9\u0011\u0011[Aj\u0001\u0004\t\u0006bBAPA\u0011\u0005\u0011\u0011\u001d\u000b\u0004E\u0005\r\b\u0002CAE\u0003?\u0004\r!a*\t\u000f\u0005\u001d\b\u0005\"\u0003\u0002j\u0006!q,\\1q)\u0011\tY/a=\u0015\u0007\t\ni\u000f\u0003\u0005\u0002p\u0006\u0015\b\u0019AAy\u0003)\u0011\u0017M\u001c3GS2$XM\u001d\t\u0006#\u0005-\u0017+\u0017\u0005\t\u0003\u0013\u000b)\u000f1\u0001\u0002(\"9\u0011q\u0016\u0011\u0005\u0002\u0005]Hc\u0001\u0012\u0002z\"A\u0011\u0011RA{\u0001\u0004\t9\fC\u0004\u0002~\u0002\"I!a@\u0002\u0015}k\u0017\r\u001d#pk\ndW\r\u0006\u0003\u0003\u0002\t\u0015Ac\u0001\u0012\u0003\u0004!A\u0011q^A~\u0001\u0004\t\t\u0010\u0003\u0005\u0002\n\u0006m\b\u0019AA\\\u0011\u001d\u0011I\u0001\tC\u0001\u0005\u0017\tqAZ8sK\u0006\u001c\u0007\u000e\u0006\u0003\u0003\u000e\teA\u0003\u0002B\b\u0005+\u00012!\u0005B\t\u0013\r\u0011\u0019B\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002\n\n\u001d\u0001\u0019\u0001B\f!\u0019\t\u00121Z)\u0003\u0010!9\u0011\u0011\u001bB\u0004\u0001\u0004\t\u0006b\u0002B\u000fA\u0011\u0005!qD\u0001\u000eM>\u0014X-Y2i\t>,(\r\\3\u0015\t\t\u0005\"q\u0005\u000b\u0005\u0005\u001f\u0011\u0019\u0003\u0003\u0005\u0002\n\nm\u0001\u0019\u0001B\u0013!\u001d\t\u00121ZA]\u0005\u001fAq!!5\u0003\u001c\u0001\u0007\u0011\u000bC\u0004\u0003,\u0001\"IA!\f\u0002\u0011}3wN]3bG\"$BAa\f\u00036Q!!q\u0002B\u0019\u0011!\tII!\u000bA\u0002\tM\u0002\u0003C\t\u0002\u000e\u0006\u0015\u0011Ka\u0004\t\u000f\u0005E'\u0011\u0006a\u0001#\"9!\u0011\u0002\u0011\u0005\u0002\teB\u0003\u0002B\b\u0005wA\u0001\"!#\u00038\u0001\u0007!Q\b\t\b#\u00055\u0015+\u0015B\b\u0011\u001d\u0011i\u0002\tC\u0001\u0005\u0003\"BAa\u0004\u0003D!A\u0011\u0011\u0012B \u0001\u0004\u0011)\u0005\u0005\u0005\u0012\u0003\u001b\u000b\u0016\u0011\u0018B\b\u0011\u001d\u0011Y\u0003\tC\u0005\u0005\u0013\"BAa\u0004\u0003L!A\u0011\u0011\u0012B$\u0001\u0004\u0011i\u0005E\u0005\u0012\u0005\u001f\n\u0016QA)\u0003\u0010%\u0019!\u0011\u000b\n\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004b\u0002B\u0005A\u0011\u0005!Q\u000b\u000b\u0005\u0005\u001f\u00119\u0006\u0003\u0005\u0002\n\nM\u0003\u0019\u0001B-!\u001d\t\u00121\u001aB.\u0005\u001f\u0001B!EAJ#\"9!Q\u0004\u0011\u0005\u0002\t}C\u0003\u0002B\b\u0005CB\u0001\"!#\u0003^\u0001\u0007!1\r\t\b#\u0005-'Q\rB\b!\u0015\t\u00121SA]\u0011\u001d\u0011I\u0007\tC\u0001\u0005W\nqaY8nE&tW\r\u0006\u0003\u0003n\tMD\u0003BA#\u0005_B\u0001\"!#\u0003h\u0001\u0007!\u0011\u000f\t\u0007#\u0005-\u00171L)\t\u0011\u0005-&q\ra\u0001\u00037BqAa\u001e!\t\u0003\u0011I(A\u0007d_6\u0014\u0017N\\3E_V\u0014G.\u001a\u000b\u0005\u0005w\u0012\u0019\t\u0006\u0003\u0002F\tu\u0004\u0002CAE\u0005k\u0002\rAa \u0011\u000fE\tYM!!\u0002:B1\u0011qGA/\u0003sC\u0001\"a+\u0003v\u0001\u0007\u00111\f\u0005\b\u0005S\u0002C\u0011\tBD)\u0011\t)E!#\t\u0011\u0005%%Q\u0011a\u0001\u0005\u0017\u0003b!EAf\u00057\n\u0006b\u0002B<A\u0011\u0005#q\u0012\u000b\u0005\u0003\u000b\u0012\t\n\u0003\u0005\u0002\n\n5\u0005\u0019\u0001BJ!\u001d\t\u00121\u001aB3\u0003sCqAa&!\t\u0013\u0011I*\u0001\u0005`G>l'-\u001b8f)\u0011\u0011YJa-\u0015\t\tu%1\u0016\u000b\u0005\u0003\u000b\u0012y\n\u0003\u0005\u0003\"\nU\u0005\u0019\u0001BR\u00035\u0019X\r\u001e$s_64\u0016\r\\;fgB9\u0011#a3\u0003&\n]\u0001cA\u0012\u0003(&\u0019!\u0011\u0016\u0004\u0003\u001fM+w-\\3oi\u000e{WNY5oKJD\u0001B!,\u0003\u0016\u0002\u0007!qV\u0001\u000ba2\f7-\u001a,bYV,\u0007cB\t\u0002L\n\u0015&\u0011\u0017\t\n#\t=\u0013QA)R\u0005\u001fA\u0001B!.\u0003\u0016\u0002\u0007!qW\u0001\u0010S:LGOV1mk\u0016Du\u000e\u001c3feB9\u0011#a3\u0003&\n=\u0001b\u0002B5A\u0011\u0005!1\u0018\u000b\u0007\u0005{\u0013\tMa1\u0015\t\u0005\u0015#q\u0018\u0005\t\u0003\u0013\u0013I\f1\u0001\u0002(\"9\u0011\u0011\u001bB]\u0001\u0004\t\u0006b\u0002Bc\u0005s\u0003\r!U\u0001\u0003EFBqAa\u001e!\t\u0003\u0011I\r\u0006\u0004\u0003L\nE'1\u001b\u000b\u0005\u0003\u000b\u0012i\r\u0003\u0005\u0002\n\n\u001d\u0007\u0019\u0001Bh!%\t\u0012QRA]\u0003s\u000bI\fC\u0004\u0002R\n\u001d\u0007\u0019A)\t\u000f\t\u0015'q\u0019a\u0001#\"9!q\u0013\u0011\u0005\n\t]GC\u0002Bm\u0005O\u0014I\u000f\u0006\u0003\u0002F\tm\u0007\u0002\u0003Bo\u0005+\u0004\rAa8\u0002\u0007M,G\u000fE\u0004\u0012\u0003\u0017\u0014)K!9\u0011\u0019E\u0011\u0019/UA\u0003#\u0006\u0015\u0011Ka\u0004\n\u0007\t\u0015(CA\u0005Gk:\u001cG/[8ok!9\u0011\u0011\u001bBk\u0001\u0004\t\u0006b\u0002Bc\u0005+\u0004\r!\u0015\u0005\u0006[q\u0001\ra\f\u0005\u0006kq\u0001\ra\u000e\u0005\u0006\u0001r\u0001\rA\u0011\u0005\u0006uq\u0001\r!\u0013\u0005\u0006\u001fr\u0001\r!\u0015\u0005\u0006/r\u0001\r!\u0017\u0005\u0006Or\u0001\r!\u001b\u0005\n\u0005wd\u0002\u0013!a\u0001\u0005{\f\u0001BY1oIRK\b/\u001a\t\u0006#\t}81A\u0005\u0004\u0007\u0003\u0011\"AB(qi&|g\u000eE\u0002\r\u0007\u000bI1aa\u0002\u0003\u0005!\u0011\u0015M\u001c3UsB,\u0007BB\u000f\u000e\t\u0003\u0019Y\u0001F\u0002 \u0007\u001bAqaa\u0004\u0004\n\u0001\u0007!%\u0001\u0003uS2,\u0007BB\u000f\u000e\t\u0003\u0019\u0019\u0002F\u0003 \u0007+\u00199\u0002C\u0004\u0004\u0010\rE\u0001\u0019\u0001\u0012\t\u0011\re1\u0011\u0003a\u0001\u00077\tqa\u001c9uS>t7\u000fE\u0002\r\u0007;I1aa\b\u0003\u000599Um\u001c+jM\u001a|\u0005\u000f^5p]ND\u0011ba\t\u000e#\u0003%\ta!\n\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIa*\"aa\n+\t\tu8\u0011F\u0016\u0003\u0007W\u0001Ba!\f\u000485\u00111q\u0006\u0006\u0005\u0007c\u0019\u0019$A\u0005v]\u000eDWmY6fI*\u00191Q\u0007\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004:\r=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1QH\u0007\u0002\u0002\u0013%1qH\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004BA!11IB'\u001b\t\u0019)E\u0003\u0003\u0004H\r%\u0013\u0001\u00027b]\u001eT!aa\u0013\u0002\t)\fg/Y\u0005\u0005\u0007\u001f\u001a)E\u0001\u0004PE*,7\r\u001e")
public abstract class GeoTiffMultibandTile
implements MultibandTile,
GeoTiffImageData,
MacroGeotiffMultibandCombiners {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final GeoTiffSegmentLayout segmentLayout;
    private final Compression compression;
    private final int bandCount;
    private final boolean hasPixelInterleave;
    private final int cols;
    private final int rows;
    private final int segmentCount;
    private final boolean isTiled;

    public static Option<BandType> apply$default$8() {
        return GeoTiffMultibandTile$.MODULE$.apply$default$8();
    }

    public static GeoTiffMultibandTile apply(MultibandTile multibandTile, GeoTiffOptions geoTiffOptions) {
        return GeoTiffMultibandTile$.MODULE$.apply(multibandTile, geoTiffOptions);
    }

    public static GeoTiffMultibandTile apply(MultibandTile multibandTile) {
        return GeoTiffMultibandTile$.MODULE$.apply(multibandTile);
    }

    public static GeoTiffMultibandTile apply(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout geoTiffSegmentLayout, Compression compression, int n, boolean bl, DataType dataType, Option<BandType> option) {
        return GeoTiffMultibandTile$.MODULE$.apply(segmentBytes, decompressor, geoTiffSegmentLayout, compression, n, bl, dataType, option);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner3 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner3 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, Function1<SegmentCombiner, Function7<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, set2);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner4 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner4 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, int b3, Function1<SegmentCombiner, Function9<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, b3, set2);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner5 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner5 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, int b3, int b4, Function1<SegmentCombiner, Function11<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, b3, b4, set2);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner6 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner6 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, int b3, int b4, int b5, Function1<SegmentCombiner, Function13<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, b3, b4, b5, set2);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner7 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner7 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, int b3, int b4, int b5, int b6, Function1<SegmentCombiner, Function15<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, b3, b4, b5, b6, set2);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner8 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner8 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, Function1<SegmentCombiner, Function17<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, b3, b4, b5, b6, b7, set2);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner9 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner9 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, Function1<SegmentCombiner, Function19<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, b3, b4, b5, b6, b7, b8, set2);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner10 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineDoubleTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner10 combiner) {
        return MacroGeotiffMultibandCombiners$class.combineIntTileCombiner((MacroGeotiffMultibandCombiners)this, combiner);
    }

    @Override
    public Tile _combine(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, Function1<SegmentCombiner, Function21<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        return MacroGeotiffMultibandCombiners$class._combine(this, b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, set2);
    }

    @Override
    public DataType targetCellType() {
        return MultibandTile$class.targetCellType(this);
    }

    @Override
    public MultibandTile subsetBands(Seq<Object> bandSequence, Predef.DummyImplicit d) {
        return MultibandTile$class.subsetBands(this, bandSequence, d);
    }

    @Override
    public MultibandTile mapBands(Function2<Object, Tile, Tile> f) {
        return MultibandTile$class.mapBands(this, f);
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    @Override
    public GeoTiffSegmentLayout segmentLayout() {
        return this.segmentLayout;
    }

    @Override
    public Compression compression() {
        return this.compression;
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public boolean hasPixelInterleave() {
        return this.hasPixelInterleave;
    }

    @Override
    public abstract DataType cellType();

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public abstract GeoTiffSegment getSegment(int var1);

    @Override
    public int segmentCount() {
        return this.segmentCount;
    }

    private boolean isTiled() {
        return this.isTiled;
    }

    @Override
    public GeoTiffTile band(int bandIndex) {
        GeoTiffTile geoTiffTile;
        if (bandIndex >= this.bandCount()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Band ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bandIndex)})));
        }
        if (this.hasPixelInterleave()) {
            GeoTiffTile geoTiffTile2;
            BandType bandType = this.bandType();
            if (BitBandType$.MODULE$.equals(bandType)) {
                byte[][] compressedBandBytes = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                Compressor compressor = this.compression().createCompressor(this.segmentCount());
                for (int index$macro$255 = 0; index$macro$255 < this.segmentCount(); ++index$macro$255) {
                    Tuple2.mcII.sp sp2;
                    this.segmentLayout().getSegmentSize(index$macro$255);
                    Tuple2.mcII.sp sp3 = sp2 = this.segmentLayout().isTiled() ? new Tuple2.mcII.sp(this.segmentLayout().tileLayout().tileCols(), this.segmentLayout().tileLayout().tileRows()) : this.segmentLayout().getSegmentDimensions(index$macro$255);
                    if (sp2 != null) {
                        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(sp2._1$mcI$sp(), sp2._2$mcI$sp());
                        int cols = sp4._1$mcI$sp();
                        int rows = sp4._2$mcI$sp();
                        int bytesWidth = (cols + 7) / 8;
                        int paddedCols = bytesWidth * 8;
                        int resultByteCount = paddedCols / 8 * rows;
                        byte[] bandSegment = (byte[])Array$.MODULE$.ofDim(resultByteCount, ClassTag$.MODULE$.Byte());
                        GeoTiffSegment segment = this.getSegment(index$macro$255);
                        for (int index$macro$253 = bandIndex; index$macro$253 < segment.size(); index$macro$253 += this.bandCount()) {
                            int j = index$macro$253 / this.bandCount();
                            int col = j % cols;
                            int row = j / cols;
                            int i2 = row * paddedCols + col;
                            BitArrayTile$.MODULE$.update(bandSegment, i2, segment.getInt(index$macro$253));
                        }
                        for (int index$macro$254 = 0; index$macro$254 < Predef$.MODULE$.byteArrayOps(bandSegment).size(); ++index$macro$254) {
                            bandSegment[index$macro$254] = package$.MODULE$.invertByte(bandSegment[index$macro$254]);
                        }
                        compressedBandBytes[index$macro$255] = compressor.compress(bandSegment, index$macro$255);
                        continue;
                    }
                    throw new MatchError((Object)sp2);
                }
                geoTiffTile2 = GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(compressedBandBytes), compressor.createDecompressor(), this.segmentLayout(), this.compression(), this.cellType(), (Option<BandType>)new Some((Object)this.bandType()));
            } else {
                byte[][] compressedBandBytes = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                Compressor compressor = this.compression().createCompressor(this.segmentCount());
                int bytesPerSample = this.bandType().bytesPerSample();
                int bytesPerCell = bytesPerSample * this.bandCount();
                for (int index$macro$257 = 0; index$macro$257 < this.segmentCount(); ++index$macro$257) {
                    byte[] segment = this.getSegment(index$macro$257).bytes();
                    int segmentSize = Predef$.MODULE$.byteArrayOps(segment).size();
                    int bandSegmentCount = segmentSize / this.bandCount();
                    byte[] bandSegment = (byte[])Array$.MODULE$.ofDim(bandSegmentCount, ClassTag$.MODULE$.Byte());
                    int j = 0;
                    for (int index$macro$256 = bandIndex * bytesPerSample; index$macro$256 < segmentSize; index$macro$256 += bytesPerCell) {
                        for (int b = 0; b < bytesPerSample; ++b) {
                            bandSegment[j + b] = segment[index$macro$256 + b];
                        }
                        j += bytesPerSample;
                    }
                    compressedBandBytes[index$macro$257] = compressor.compress(bandSegment, index$macro$257);
                }
                geoTiffTile2 = GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(compressedBandBytes), compressor.createDecompressor(), this.segmentLayout(), this.compression(), this.cellType(), (Option<BandType>)new Some((Object)this.bandType()));
            }
            geoTiffTile = geoTiffTile2;
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            byte[][] compressedBandBytes = (byte[][])Array$.MODULE$.ofDim(bandSegmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            int start = bandSegmentCount * bandIndex;
            for (int index$macro$258 = 0; index$macro$258 < bandSegmentCount; ++index$macro$258) {
                compressedBandBytes[index$macro$258] = (byte[])this.segmentBytes().getSegment(index$macro$258 + start).clone();
            }
            geoTiffTile = GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(compressedBandBytes), this.decompressor(), this.segmentLayout(), this.compression(), this.cellType(), (Option<BandType>)new Some((Object)this.bandType()));
        }
        return geoTiffTile;
    }

    @Override
    public Vector<Tile> bands() {
        Predef$ predef$ = Predef$.MODULE$;
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(0, this.bandCount()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoTiffMultibandTile $outer;

            public final GeoTiffTile apply(int x$28) {
                return this.$outer.band(x$28);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toVector();
    }

    @Override
    public ArrayMultibandTile subsetBands(Seq<Object> bandSequence) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(bandSequence.size(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef i = IntRef.create((int)0);
        Predef$.MODULE$.require(bandSequence.size() <= this.bandCount());
        bandSequence.foreach((Function1)new Serializable(this, newBands, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoTiffMultibandTile $outer;
            private final Tile[] newBands$1;
            private final IntRef i$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                this.newBands$1[this.i$1.elem] = this.$outer.band(j);
                ++this.i$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newBands$1 = newBands$1;
                this.i$1 = i$1;
            }
        });
        return new ArrayMultibandTile(newBands);
    }

    public ArrayMultibandTile toArrayTile() {
        Predef$ predef$ = Predef$.MODULE$;
        return ArrayMultibandTile$.MODULE$.apply((Seq<Tile>)((Seq)RichInt$.MODULE$.until$extension0(0, this.bandCount()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoTiffMultibandTile $outer;

            public final ArrayTile apply(int x$29) {
                return this.$outer.band(x$29).toArrayTile();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
    }

    public ArrayMultibandTile crop(GridBounds gridBounds) {
        Predef$ predef$ = Predef$.MODULE$;
        return ArrayMultibandTile$.MODULE$.apply((Seq<Tile>)((Seq)RichInt$.MODULE$.until$extension0(0, this.bandCount()).map((Function1)new Serializable(this, gridBounds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoTiffMultibandTile $outer;
            private final GridBounds gridBounds$1;

            public final MutableArrayTile apply(int x$30) {
                return this.$outer.band(x$30).crop(this.gridBounds$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gridBounds$1 = gridBounds$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
    }

    @Override
    public GeoTiffMultibandTile convert(DataType newCellType) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression().createCompressor(this.segmentCount());
        for (int index$macro$259 = 0; index$macro$259 < this.segmentCount(); ++index$macro$259) {
            GeoTiffSegment segment = this.getSegment(index$macro$259);
            byte[] newBytes = segment.convert(newCellType);
            arr[index$macro$259] = compressor.compress(newBytes, index$macro$259);
        }
        return GeoTiffMultibandTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression(), this.bandCount(), this.hasPixelInterleave(), this.cellType(), (Option<BandType>)new Some((Object)this.bandType()));
    }

    public MultibandTile mapSegments(Function2<GeoTiffSegment, Object, byte[]> f) {
        Compressor compressor = this.compression().createCompressor(this.segmentCount());
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        for (int index$macro$260 = 0; index$macro$260 < this.segmentCount(); ++index$macro$260) {
            arr[index$macro$260] = compressor.compress((byte[])f.apply((Object)this.getSegment(index$macro$260), (Object)BoxesRunTime.boxToInteger((int)index$macro$260)), index$macro$260);
        }
        return GeoTiffMultibandTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression(), this.bandCount(), this.hasPixelInterleave(), this.cellType(), (Option<BandType>)new Some((Object)this.bandType()));
    }

    @Override
    public MultibandTile map(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Set set2 = subset.toSet();
        Serializable fn = new Serializable(this, f, set2){
            public static final long serialVersionUID = 0L;
            private final Function2 f$1;
            private final Set set$1;

            public final int apply(int bandIndex, int z) {
                return this.apply$mcIII$sp(bandIndex, z);
            }

            public int apply$mcIII$sp(int bandIndex, int z) {
                return this.set$1.contains((Object)BoxesRunTime.boxToInteger((int)bandIndex)) ? this.f$1.apply$mcIII$sp(bandIndex, z) : z;
            }
            {
                this.f$1 = f$1;
                this.set$1 = set$1;
            }
        };
        return this._map((Function2<Object, Object, Object>)fn, (Function1<Object, Object>)new Serializable(this, set2){
            public static final long serialVersionUID = 0L;
            public final Set set$1;

            public final boolean apply(int b) {
                return this.set$1.contains((Object)BoxesRunTime.boxToInteger((int)b));
            }

            public boolean apply$mcZI$sp(int b) {
                return this.set$1.contains((Object)BoxesRunTime.boxToInteger((int)b));
            }
            {
                this.set$1 = set$1;
            }
        });
    }

    @Override
    public MultibandTile mapDouble(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Set set2 = subset.toSet();
        Serializable fn = new Serializable(this, f, set2){
            public static final long serialVersionUID = 0L;
            private final Function2 f$3;
            private final Set set$2;

            public final double apply(int bandIndex, double z) {
                return this.apply$mcDID$sp(bandIndex, z);
            }

            public double apply$mcDID$sp(int bandIndex, double z) {
                return this.set$2.contains((Object)BoxesRunTime.boxToInteger((int)bandIndex)) ? this.f$3.apply$mcDID$sp(bandIndex, z) : z;
            }
            {
                this.f$3 = f$3;
                this.set$2 = set$2;
            }
        };
        return this._mapDouble((Function2<Object, Object, Object>)fn, (Function1<Object, Object>)new Serializable(this, set2){
            public static final long serialVersionUID = 0L;
            public final Set set$2;

            public final boolean apply(int b) {
                return this.set$2.contains((Object)BoxesRunTime.boxToInteger((int)b));
            }

            public boolean apply$mcZI$sp(int b) {
                return this.set$2.contains((Object)BoxesRunTime.boxToInteger((int)b));
            }
            {
                this.set$2 = set$2;
            }
        });
    }

    @Override
    public MultibandTile map(int b0, Function1<Object, Object> f) {
        MultibandTile multibandTile;
        if (this.hasPixelInterleave()) {
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, b0, f){
                public static final long serialVersionUID = 0L;
                public final /* synthetic */ GeoTiffMultibandTile $outer;
                public final int b0$1;
                public final Function1 f$5;

                public final byte[] apply(GeoTiffSegment segment, int x$35) {
                    return segment.mapWithIndex((Function2<Object, Object, Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$map$3 $outer;

                        public final int apply(int i, int z) {
                            return this.apply$mcIII$sp(i, z);
                        }

                        public int apply$mcIII$sp(int i, int z) {
                            return i % this.$outer.$outer.bandCount() == this.$outer.b0$1 ? this.$outer.f$5.apply$mcII$sp(z) : z;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ GeoTiffMultibandTile geotrellis$raster$io$geotiff$GeoTiffMultibandTile$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.b0$1 = b0$1;
                    this.f$5 = f$5;
                }
            });
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            int start = bandSegmentCount * b0;
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, f, bandSegmentCount, start){
                public static final long serialVersionUID = 0L;
                private final Function1 f$5;
                private final int bandSegmentCount$1;
                private final int start$1;

                public final byte[] apply(GeoTiffSegment segment, int segmentIndex) {
                    return this.start$1 <= segmentIndex && segmentIndex < this.start$1 + this.bandSegmentCount$1 ? segment.map((Function1<Object, Object>)this.f$5) : segment.bytes();
                }
                {
                    this.f$5 = f$5;
                    this.bandSegmentCount$1 = bandSegmentCount$1;
                    this.start$1 = start$1;
                }
            });
        }
        return multibandTile;
    }

    @Override
    public MultibandTile mapDouble(int b0, Function1<Object, Object> f) {
        MultibandTile multibandTile;
        if (this.hasPixelInterleave()) {
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, b0, f){
                public static final long serialVersionUID = 0L;
                public final /* synthetic */ GeoTiffMultibandTile $outer;
                public final int b0$2;
                public final Function1 f$6;

                public final byte[] apply(GeoTiffSegment segment, int x$36) {
                    return segment.mapDoubleWithIndex((Function2<Object, Object, Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$mapDouble$3 $outer;

                        public final double apply(int i, double z) {
                            return this.apply$mcDID$sp(i, z);
                        }

                        public double apply$mcDID$sp(int i, double z) {
                            return i % this.$outer.$outer.bandCount() == this.$outer.b0$2 ? this.$outer.f$6.apply$mcDD$sp(z) : z;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ GeoTiffMultibandTile geotrellis$raster$io$geotiff$GeoTiffMultibandTile$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.b0$2 = b0$2;
                    this.f$6 = f$6;
                }
            });
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            int start = bandSegmentCount * b0;
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, f, bandSegmentCount, start){
                public static final long serialVersionUID = 0L;
                private final Function1 f$6;
                private final int bandSegmentCount$2;
                private final int start$2;

                public final byte[] apply(GeoTiffSegment segment, int segmentIndex) {
                    return this.start$2 <= segmentIndex && segmentIndex < this.start$2 + this.bandSegmentCount$2 ? segment.mapDouble((Function1<Object, Object>)this.f$6) : segment.bytes();
                }
                {
                    this.f$6 = f$6;
                    this.bandSegmentCount$2 = bandSegmentCount$2;
                    this.start$2 = start$2;
                }
            });
        }
        return multibandTile;
    }

    @Override
    public MultibandTile map(Function2<Object, Object, Object> f) {
        return this._map(f, (Function1<Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$37) {
                return true;
            }

            public boolean apply$mcZI$sp(int x$37) {
                return true;
            }
        });
    }

    private MultibandTile _map(Function2<Object, Object, Object> f, Function1<Object, Object> bandFilter) {
        MultibandTile multibandTile;
        if (this.hasPixelInterleave()) {
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, f){
                public static final long serialVersionUID = 0L;
                public final /* synthetic */ GeoTiffMultibandTile $outer;
                public final Function2 f$2;

                public final byte[] apply(GeoTiffSegment segment, int semgentIndex) {
                    return segment.mapWithIndex((Function2<Object, Object, Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$_map$1 $outer;

                        public final int apply(int i, int z) {
                            return this.apply$mcIII$sp(i, z);
                        }

                        public int apply$mcIII$sp(int i, int z) {
                            return this.$outer.f$2.apply$mcIII$sp(i % this.$outer.$outer.bandCount(), z);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ GeoTiffMultibandTile geotrellis$raster$io$geotiff$GeoTiffMultibandTile$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.f$2 = f$2;
                }
            });
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, f, bandFilter, bandSegmentCount){
                public static final long serialVersionUID = 0L;
                public final Function2 f$2;
                private final Function1 bandFilter$1;
                private final int bandSegmentCount$3;

                public final byte[] apply(GeoTiffSegment segment, int segmentIndex) {
                    int bandIndex = segmentIndex / this.bandSegmentCount$3;
                    return this.bandFilter$1.apply$mcZI$sp(bandIndex) ? segment.map((Function1<Object, Object>)new Serializable(this, bandIndex){
                        public static final long serialVersionUID = 0L;
                        public final /* synthetic */ $anonfun$_map$2 $outer;
                        public final int bandIndex$1;

                        public final int apply(int z) {
                            return this.$outer.f$2.apply$mcIII$sp(this.bandIndex$1, z);
                        }

                        public int apply$mcII$sp(int z) {
                            return this.$outer.f$2.apply$mcIII$sp(this.bandIndex$1, z);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.bandIndex$1 = bandIndex$1;
                        }
                    }) : segment.bytes();
                }
                {
                    this.f$2 = f$2;
                    this.bandFilter$1 = bandFilter$1;
                    this.bandSegmentCount$3 = bandSegmentCount$3;
                }
            });
        }
        return multibandTile;
    }

    @Override
    public MultibandTile mapDouble(Function2<Object, Object, Object> f) {
        return this._mapDouble(f, (Function1<Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$38) {
                return true;
            }

            public boolean apply$mcZI$sp(int x$38) {
                return true;
            }
        });
    }

    private MultibandTile _mapDouble(Function2<Object, Object, Object> f, Function1<Object, Object> bandFilter) {
        MultibandTile multibandTile;
        if (this.hasPixelInterleave()) {
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, f){
                public static final long serialVersionUID = 0L;
                public final /* synthetic */ GeoTiffMultibandTile $outer;
                public final Function2 f$4;

                public final byte[] apply(GeoTiffSegment segment, int semgentIndex) {
                    return segment.mapDoubleWithIndex((Function2<Object, Object, Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$_mapDouble$1 $outer;

                        public final double apply(int i, double z) {
                            return this.apply$mcDID$sp(i, z);
                        }

                        public double apply$mcDID$sp(int i, double z) {
                            return this.$outer.f$4.apply$mcDID$sp(i % this.$outer.$outer.bandCount(), z);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ GeoTiffMultibandTile geotrellis$raster$io$geotiff$GeoTiffMultibandTile$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.f$4 = f$4;
                }
            });
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            multibandTile = this.mapSegments((Function2<GeoTiffSegment, Object, byte[]>)new Serializable(this, f, bandFilter, bandSegmentCount){
                public static final long serialVersionUID = 0L;
                public final Function2 f$4;
                private final Function1 bandFilter$2;
                private final int bandSegmentCount$4;

                public final byte[] apply(GeoTiffSegment segment, int segmentIndex) {
                    int bandIndex = segmentIndex / this.bandSegmentCount$4;
                    return this.bandFilter$2.apply$mcZI$sp(bandIndex) ? segment.mapDouble((Function1<Object, Object>)new Serializable(this, bandIndex){
                        public static final long serialVersionUID = 0L;
                        public final /* synthetic */ $anonfun$_mapDouble$2 $outer;
                        public final int bandIndex$2;

                        public final double apply(double z) {
                            return this.$outer.f$4.apply$mcDID$sp(this.bandIndex$2, z);
                        }

                        public double apply$mcDD$sp(double z) {
                            return this.$outer.f$4.apply$mcDID$sp(this.bandIndex$2, z);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.bandIndex$2 = bandIndex$2;
                        }
                    }) : segment.bytes();
                }
                {
                    this.f$4 = f$4;
                    this.bandFilter$2 = bandFilter$2;
                    this.bandSegmentCount$4 = bandSegmentCount$4;
                }
            });
        }
        return multibandTile;
    }

    @Override
    public void foreach(int b0, Function1<Object, BoxedUnit> f) {
        this._foreach(b0, (Function2<GeoTiffSegment, Object, BoxedUnit>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$7;

            public final void apply(GeoTiffSegment segment, int i) {
                this.f$7.apply$mcVI$sp(segment.getInt(i));
            }
            {
                this.f$7 = f$7;
            }
        });
    }

    @Override
    public void foreachDouble(int b0, Function1<Object, BoxedUnit> f) {
        this._foreach(b0, (Function2<GeoTiffSegment, Object, BoxedUnit>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$8;

            public final void apply(GeoTiffSegment segment, int i) {
                this.f$8.apply$mcVD$sp(segment.getDouble(i));
            }
            {
                this.f$8 = f$8;
            }
        });
    }

    private void _foreach(int b0, Function2<GeoTiffSegment, Object, BoxedUnit> f) {
        if (this.hasPixelInterleave()) {
            if (this.isTiled()) {
                for (int index$macro$262 = 0; index$macro$262 < this.segmentCount(); ++index$macro$262) {
                    GeoTiffSegment segment = this.getSegment(index$macro$262);
                    int segmentSize = segment.size();
                    GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$262);
                    for (int index$macro$261 = 0; index$macro$261 < segmentSize; ++index$macro$261) {
                        Object object;
                        if (index$macro$261 % this.bandCount() == b0) {
                            int col = segmentTransform.indexToCol(index$macro$261 / this.bandCount());
                            int row = segmentTransform.indexToRow(index$macro$261 / this.bandCount());
                            if (col < this.cols() && row < this.rows()) {
                                object = f.apply((Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$261));
                                continue;
                            }
                            object = BoxedUnit.UNIT;
                            continue;
                        }
                        object = BoxedUnit.UNIT;
                    }
                }
            } else {
                for (int index$macro$264 = 0; index$macro$264 < this.segmentCount(); ++index$macro$264) {
                    GeoTiffSegment segment = this.getSegment(index$macro$264);
                    int segmentSize = segment.size();
                    for (int index$macro$263 = 0; index$macro$263 < segmentSize; ++index$macro$263) {
                        Object object = index$macro$263 % this.bandCount() == b0 ? f.apply((Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$263)) : BoxedUnit.UNIT;
                    }
                }
            }
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            int start = bandSegmentCount * b0;
            if (this.isTiled()) {
                for (int index$macro$266 = start; index$macro$266 < start + bandSegmentCount; ++index$macro$266) {
                    GeoTiffSegment segment = this.getSegment(index$macro$266);
                    int segmentSize = segment.size();
                    GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$266 % bandSegmentCount);
                    for (int index$macro$265 = 0; index$macro$265 < segmentSize; ++index$macro$265) {
                        int col = segmentTransform.indexToCol(index$macro$265);
                        int row = segmentTransform.indexToRow(index$macro$265);
                        Object object = col < this.cols() && row < this.rows() ? f.apply((Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$265)) : BoxedUnit.UNIT;
                    }
                }
            } else {
                for (int index$macro$268 = start; index$macro$268 < start + bandSegmentCount; ++index$macro$268) {
                    GeoTiffSegment segment = this.getSegment(index$macro$268);
                    int segmentSize = segment.size();
                    for (int index$macro$267 = 0; index$macro$267 < segmentSize; ++index$macro$267) {
                        f.apply((Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$267));
                    }
                }
            }
        }
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        this._foreach((Function3<Object, GeoTiffSegment, Object, BoxedUnit>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final Function2 f$9;

            public final void apply(int segmentIndex, GeoTiffSegment segment, int i) {
                this.f$9.apply$mcVII$sp(segmentIndex, segment.getInt(i));
            }
            {
                this.f$9 = f$9;
            }
        });
    }

    @Override
    public void foreachDouble(Function2<Object, Object, BoxedUnit> f) {
        this._foreach((Function3<Object, GeoTiffSegment, Object, BoxedUnit>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final Function2 f$10;

            public final void apply(int segmentIndex, GeoTiffSegment segment, int i) {
                this.f$10.apply$mcVID$sp(segmentIndex, segment.getDouble(i));
            }
            {
                this.f$10 = f$10;
            }
        });
    }

    private void _foreach(Function3<Object, GeoTiffSegment, Object, BoxedUnit> f) {
        if (this.hasPixelInterleave()) {
            if (this.isTiled()) {
                for (int index$macro$270 = 0; index$macro$270 < this.segmentCount(); ++index$macro$270) {
                    GeoTiffSegment segment = this.getSegment(index$macro$270);
                    int segmentSize = segment.size();
                    GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$270);
                    for (int index$macro$269 = 0; index$macro$269 < segmentSize; ++index$macro$269) {
                        int col = segmentTransform.indexToCol(index$macro$269 / this.bandCount());
                        int row = segmentTransform.indexToRow(index$macro$269 / this.bandCount());
                        Object object = col < this.cols() && row < this.rows() ? f.apply((Object)BoxesRunTime.boxToInteger((int)(index$macro$269 % this.bandCount())), (Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$269)) : BoxedUnit.UNIT;
                    }
                }
            } else {
                for (int index$macro$272 = 0; index$macro$272 < this.segmentCount(); ++index$macro$272) {
                    GeoTiffSegment segment = this.getSegment(index$macro$272);
                    int segmentSize = segment.size();
                    for (int index$macro$271 = 0; index$macro$271 < segmentSize; ++index$macro$271) {
                        f.apply((Object)BoxesRunTime.boxToInteger((int)(index$macro$271 % this.bandCount())), (Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$271));
                    }
                }
            }
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            if (this.isTiled()) {
                for (int index$macro$274 = 0; index$macro$274 < this.segmentCount(); ++index$macro$274) {
                    GeoTiffSegment segment = this.getSegment(index$macro$274);
                    int segmentSize = segment.size();
                    GridIndexTransform segmentTransform = this.segmentLayout().getSegmentTransform(index$macro$274 % bandSegmentCount);
                    int bandIndex = index$macro$274 / bandSegmentCount;
                    for (int index$macro$273 = 0; index$macro$273 < segmentSize; ++index$macro$273) {
                        int col = segmentTransform.indexToCol(index$macro$273);
                        int row = segmentTransform.indexToRow(index$macro$273);
                        Object object = col < this.cols() && row < this.rows() ? f.apply((Object)BoxesRunTime.boxToInteger((int)bandIndex), (Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$273)) : BoxedUnit.UNIT;
                    }
                }
            } else {
                for (int index$macro$276 = 0; index$macro$276 < this.segmentCount(); ++index$macro$276) {
                    GeoTiffSegment segment = this.getSegment(index$macro$276);
                    int segmentSize = segment.size();
                    int bandIndex = index$macro$276 / bandSegmentCount;
                    for (int index$macro$275 = 0; index$macro$275 < segmentSize; ++index$macro$275) {
                        f.apply((Object)BoxesRunTime.boxToInteger((int)bandIndex), (Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$275));
                    }
                }
            }
        }
    }

    @Override
    public void foreach(Function1<int[], BoxedUnit> f) {
        for (int index$macro$279 = 0; index$macro$279 < this.cols(); ++index$macro$279) {
            for (int index$macro$278 = 0; index$macro$278 < this.rows(); ++index$macro$278) {
                int[] bandValues = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
                for (int index$macro$277 = 0; index$macro$277 < this.bandCount(); ++index$macro$277) {
                    bandValues[index$macro$277] = ((Tile)this.bands().apply(index$macro$277)).get(index$macro$279, index$macro$278);
                }
                f.apply((Object)bandValues);
            }
        }
    }

    @Override
    public void foreachDouble(Function1<double[], BoxedUnit> f) {
        for (int index$macro$282 = 0; index$macro$282 < this.cols(); ++index$macro$282) {
            for (int index$macro$281 = 0; index$macro$281 < this.rows(); ++index$macro$281) {
                double[] bandValues = (double[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Double());
                for (int index$macro$280 = 0; index$macro$280 < this.bandCount(); ++index$macro$280) {
                    bandValues[index$macro$280] = ((Tile)this.bands().apply(index$macro$280)).getDouble(index$macro$282, index$macro$281);
                }
                f.apply((Object)bandValues);
            }
        }
    }

    @Override
    public Tile combine(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoTiffMultibandTile $outer;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                boolean bl = 0 <= b && b < this.$outer.bandCount();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"All elements of subset must be present").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Serializable fn = new Serializable(this, subset, f){
            public static final long serialVersionUID = 0L;
            private final Seq subset$1;
            private final Function1 f$11;

            public final int apply(int[] array) {
                Seq data = (Seq)this.subset$1.map((Function1)new Serializable(this, array){
                    public static final long serialVersionUID = 0L;
                    public final int[] array$1;

                    public final int apply(int i) {
                        return this.array$1[i];
                    }

                    public int apply$mcII$sp(int i) {
                        return this.array$1[i];
                    }
                    {
                        this.array$1 = array$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return BoxesRunTime.unboxToInt((Object)this.f$11.apply((Object)data));
            }
            {
                this.subset$1 = subset$1;
                this.f$11 = f$11;
            }
        };
        return this.combine((Function1<int[], Object>)fn);
    }

    @Override
    public Tile combineDouble(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoTiffMultibandTile $outer;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                boolean bl = 0 <= b && b < this.$outer.bandCount();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"All elements of subset must be present").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Serializable fn = new Serializable(this, subset, f){
            public static final long serialVersionUID = 0L;
            private final Seq subset$2;
            private final Function1 f$14;

            public final double apply(double[] array) {
                Seq data = (Seq)this.subset$2.map((Function1)new Serializable(this, array){
                    public static final long serialVersionUID = 0L;
                    public final double[] array$2;

                    public final double apply(int i) {
                        return this.array$2[i];
                    }

                    public double apply$mcDI$sp(int i) {
                        return this.array$2[i];
                    }
                    {
                        this.array$2 = array$2;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return BoxesRunTime.unboxToDouble((Object)this.f$14.apply((Object)data));
            }
            {
                this.subset$2 = subset$2;
                this.f$14 = f$14;
            }
        };
        return this.combineDouble((Function1<double[], Object>)fn);
    }

    @Override
    public Tile combine(Function1<int[], Object> f) {
        return this._combine((Function1<SegmentCombiner, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SegmentCombiner x$83) {
                x$83.initValueHolder();
            }
        }, (Function1<SegmentCombiner, Function3<GeoTiffSegment, Object, Object, BoxedUnit>>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Function3<GeoTiffSegment, Object, Object, BoxedUnit> apply(SegmentCombiner segmentCombiner) {
                return new Serializable(this, segmentCombiner){
                    public static final long serialVersionUID = 0L;
                    private final SegmentCombiner segmentCombiner$1;

                    public final void apply(GeoTiffSegment segment, int i, int bandIndex) {
                        this.segmentCombiner$1.placeValue(segment, i, bandIndex);
                    }
                    {
                        this.segmentCombiner$1 = segmentCombiner$1;
                    }
                };
            }
        }, (Function1<SegmentCombiner, Function1<Object, BoxedUnit>>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            public final Function1 f$13;

            public final Function1<Object, BoxedUnit> apply(SegmentCombiner segmentCombiner) {
                return new Serializable(this, segmentCombiner){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$combine$4 $outer;
                    public final SegmentCombiner segmentCombiner$2;

                    public final void apply(int i) {
                        this.segmentCombiner$2.setFromValues(i, (Function1<int[], Object>)this.$outer.f$13);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.segmentCombiner$2.setFromValues(i, (Function1<int[], Object>)this.$outer.f$13);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.segmentCombiner$2 = segmentCombiner$2;
                    }
                };
            }
            {
                this.f$13 = f$13;
            }
        });
    }

    @Override
    public Tile combineDouble(Function1<double[], Object> f) {
        return this._combine((Function1<SegmentCombiner, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SegmentCombiner x$84) {
                x$84.initValueHolderDouble();
            }
        }, (Function1<SegmentCombiner, Function3<GeoTiffSegment, Object, Object, BoxedUnit>>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Function3<GeoTiffSegment, Object, Object, BoxedUnit> apply(SegmentCombiner segmentCombiner) {
                return new Serializable(this, segmentCombiner){
                    public static final long serialVersionUID = 0L;
                    private final SegmentCombiner segmentCombiner$3;

                    public final void apply(GeoTiffSegment segment, int i, int bandIndex) {
                        this.segmentCombiner$3.placeValueDouble(segment, i, bandIndex);
                    }
                    {
                        this.segmentCombiner$3 = segmentCombiner$3;
                    }
                };
            }
        }, (Function1<SegmentCombiner, Function1<Object, BoxedUnit>>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            public final Function1 f$16;

            public final Function1<Object, BoxedUnit> apply(SegmentCombiner segmentCombiner) {
                return new Serializable(this, segmentCombiner){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$combineDouble$4 $outer;
                    public final SegmentCombiner segmentCombiner$4;

                    public final void apply(int i) {
                        this.segmentCombiner$4.setFromValuesDouble(i, (Function1<double[], Object>)this.$outer.f$16);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.segmentCombiner$4.setFromValuesDouble(i, (Function1<double[], Object>)this.$outer.f$16);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.segmentCombiner$4 = segmentCombiner$4;
                    }
                };
            }
            {
                this.f$16 = f$16;
            }
        });
    }

    private Tile _combine(Function1<SegmentCombiner, BoxedUnit> initValueHolder, Function1<SegmentCombiner, Function3<GeoTiffSegment, Object, Object, BoxedUnit>> placeValue, Function1<SegmentCombiner, Function1<Object, BoxedUnit>> setFromValues) {
        Tuple2 tuple2;
        if (this.hasPixelInterleave()) {
            Compressor compressor = this.compression().createCompressor(this.segmentCount());
            byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            for (int index$macro$285 = 0; index$macro$285 < this.segmentCount(); ++index$macro$285) {
                GeoTiffSegment segment = this.getSegment(index$macro$285);
                int segmentSize = segment.size();
                SegmentCombiner segmentCombiner = this.createSegmentCombiner(segmentSize / this.bandCount());
                initValueHolder.apply((Object)segmentCombiner);
                int j = 0;
                for (int index$macro$284 = 0; index$macro$284 < segmentSize; index$macro$284 += this.bandCount()) {
                    for (int index$macro$283 = 0; index$macro$283 < this.bandCount(); ++index$macro$283) {
                        ((Function3)placeValue.apply((Object)segmentCombiner)).apply((Object)segment, (Object)BoxesRunTime.boxToInteger((int)(index$macro$284 + index$macro$283)), (Object)BoxesRunTime.boxToInteger((int)index$macro$283));
                    }
                    ((Function1)setFromValues.apply((Object)segmentCombiner)).apply$mcVI$sp(j);
                    ++j;
                }
                arr[index$macro$285] = compressor.compress(segmentCombiner.getBytes(), index$macro$285);
            }
            tuple2 = new Tuple2((Object)arr, (Object)compressor);
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            Compressor compressor = this.compression().createCompressor(bandSegmentCount);
            byte[][] arr = (byte[][])Array$.MODULE$.ofDim(bandSegmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            for (int index$macro$288 = 0; index$macro$288 < bandSegmentCount; ++index$macro$288) {
                int segmentSize = this.getSegment(index$macro$288).size();
                SegmentCombiner segmentCombiner = this.createSegmentCombiner(segmentSize);
                initValueHolder.apply((Object)segmentCombiner);
                for (int index$macro$287 = 0; index$macro$287 < segmentSize; ++index$macro$287) {
                    for (int index$macro$286 = 0; index$macro$286 < this.bandCount(); ++index$macro$286) {
                        GeoTiffSegment segment = this.getSegment(index$macro$286 * bandSegmentCount + index$macro$288);
                        ((Function3)placeValue.apply((Object)segmentCombiner)).apply((Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$287), (Object)BoxesRunTime.boxToInteger((int)index$macro$286));
                    }
                    ((Function1)setFromValues.apply((Object)segmentCombiner)).apply$mcVI$sp(index$macro$287);
                }
                arr[index$macro$288] = compressor.compress(segmentCombiner.getBytes(), index$macro$288);
            }
            tuple2 = new Tuple2((Object)arr, (Object)compressor);
        }
        Tuple2 tuple22 = tuple2;
        Tuple2 tuple23 = new Tuple2(tuple22._1(), tuple22._2());
        byte[][] arr = (byte[][])tuple23._1();
        Compressor compressor = (Compressor)tuple23._2();
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression(), this.cellType(), (Option<BandType>)new Some((Object)this.bandType()));
    }

    @Override
    public Tile combine(int b0, int b1, Function2<Object, Object, Object> f) {
        return this._combine(b0, b1, (Function1<SegmentCombiner, Function5<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            public final Function2 f$12;

            public final Function5<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit> apply(SegmentCombiner segmentCombiner) {
                return new Serializable(this, segmentCombiner){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$combine$5 $outer;
                    private final SegmentCombiner segmentCombiner$5;

                    public final void apply(int targetIndex, GeoTiffSegment s1, int i1, GeoTiffSegment s2, int i2) {
                        this.segmentCombiner$5.set(targetIndex, s1, i1, s2, i2, (Function2<Object, Object, Object>)this.$outer.f$12);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.segmentCombiner$5 = segmentCombiner$5;
                    }
                };
            }
            {
                this.f$12 = f$12;
            }
        });
    }

    @Override
    public Tile combineDouble(int b0, int b1, Function2<Object, Object, Object> f) {
        return this._combine(b0, b1, (Function1<SegmentCombiner, Function5<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            public final Function2 f$15;

            public final Function5<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit> apply(SegmentCombiner segmentCombiner) {
                return new Serializable(this, segmentCombiner){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$combineDouble$5 $outer;
                    private final SegmentCombiner segmentCombiner$6;

                    public final void apply(int targetIndex, GeoTiffSegment s1, int i1, GeoTiffSegment s2, int i2) {
                        this.segmentCombiner$6.setDouble(targetIndex, s1, i1, s2, i2, (Function2<Object, Object, Object>)this.$outer.f$15);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.segmentCombiner$6 = segmentCombiner$6;
                    }
                };
            }
            {
                this.f$15 = f$15;
            }
        });
    }

    private Tile _combine(int b0, int b1, Function1<SegmentCombiner, Function5<Object, GeoTiffSegment, Object, GeoTiffSegment, Object, BoxedUnit>> set2) {
        Tuple2 tuple2;
        boolean bl = b0 < this.bandCount();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal band index: ", " is out of range (", " bands)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)b0), BoxesRunTime.boxToInteger((int)this.bandCount())}))).toString());
        }
        boolean bl2 = b1 < this.bandCount();
        Predef$ predef$2 = Predef$.MODULE$;
        if (!bl2) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal band index: ", " is out of range (", " bands)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)b1), BoxesRunTime.boxToInteger((int)this.bandCount())}))).toString());
        }
        if (this.hasPixelInterleave()) {
            int diff = b1 - b0;
            Compressor compressor = this.compression().createCompressor(this.segmentCount());
            byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            for (int index$macro$290 = 0; index$macro$290 < this.segmentCount(); ++index$macro$290) {
                GeoTiffSegment segment = this.getSegment(index$macro$290);
                int segmentSize = segment.size();
                SegmentCombiner segmentCombiner = this.createSegmentCombiner(segmentSize / this.bandCount());
                int j = 0;
                for (int index$macro$289 = b0; index$macro$289 < segmentSize; index$macro$289 += this.bandCount()) {
                    ((Function5)set2.apply((Object)segmentCombiner)).apply((Object)BoxesRunTime.boxToInteger((int)j), (Object)segment, (Object)BoxesRunTime.boxToInteger((int)index$macro$289), (Object)segment, (Object)BoxesRunTime.boxToInteger((int)(index$macro$289 + diff)));
                    ++j;
                }
                arr[index$macro$290] = compressor.compress(segmentCombiner.getBytes(), index$macro$290);
            }
            tuple2 = new Tuple2((Object)arr, (Object)compressor);
        } else {
            int bandSegmentCount = this.segmentCount() / this.bandCount();
            Compressor compressor = this.compression().createCompressor(bandSegmentCount);
            byte[][] arr = (byte[][])Array$.MODULE$.ofDim(bandSegmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            int start0 = bandSegmentCount * b0;
            int start1 = bandSegmentCount * b1;
            for (int index$macro$292 = 0; index$macro$292 < bandSegmentCount; ++index$macro$292) {
                int segmentSize1;
                GeoTiffSegment segment0 = this.getSegment(start0 + index$macro$292);
                GeoTiffSegment segment1 = this.getSegment(start1 + index$macro$292);
                int segmentSize0 = segment0.size();
                boolean bl3 = segmentSize0 == (segmentSize1 = segment1.size());
                Predef$ predef$3 = Predef$.MODULE$;
                if (!bl3) {
                    throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"GeoTiff band segments do not match in size!").toString());
                }
                SegmentCombiner segmentCombiner = this.createSegmentCombiner(segmentSize0);
                for (int index$macro$291 = 0; index$macro$291 < segmentSize0; ++index$macro$291) {
                    ((Function5)set2.apply((Object)segmentCombiner)).apply((Object)BoxesRunTime.boxToInteger((int)index$macro$291), (Object)segment0, (Object)BoxesRunTime.boxToInteger((int)index$macro$291), (Object)segment1, (Object)BoxesRunTime.boxToInteger((int)index$macro$291));
                }
                arr[index$macro$292] = compressor.compress(segmentCombiner.getBytes(), index$macro$292);
            }
            tuple2 = new Tuple2((Object)arr, (Object)compressor);
        }
        Tuple2 tuple22 = tuple2;
        Tuple2 tuple23 = new Tuple2(tuple22._1(), tuple22._2());
        byte[][] arr = (byte[][])tuple23._1();
        Compressor compressor = (Compressor)tuple23._2();
        return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(arr), compressor.createDecompressor(), this.segmentLayout(), this.compression(), this.cellType(), (Option<BandType>)new Some((Object)this.bandType()));
    }

    public GeoTiffMultibandTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, int bandCount, boolean hasPixelInterleave) {
        this.segmentBytes = segmentBytes;
        this.decompressor = decompressor;
        this.segmentLayout = segmentLayout;
        this.compression = compression;
        this.bandCount = bandCount;
        this.hasPixelInterleave = hasPixelInterleave;
        Grid$class.$init$(this);
        MacroCombineFunctions.class.$init$((MacroCombineFunctions)this);
        MultibandTile$class.$init$(this);
        MacroGeotiffMultibandCombiners$class.$init$(this);
        this.cols = segmentLayout.totalCols();
        this.rows = segmentLayout.totalRows();
        this.segmentCount = segmentBytes.size();
        this.isTiled = segmentLayout.isTiled();
    }
}

