/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.IntCells;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import geotrellis.raster.io.geotiff.ArraySegmentBytes;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.BitGeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.ByteGeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.Float32GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.Float64GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffOptions$;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.Int16GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.Int32GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.UByteGeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.UInt16GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.UInt32BandType$;
import geotrellis.raster.io.geotiff.UInt32GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.package$;
import geotrellis.raster.split.Split;
import geotrellis.raster.split.Split$Options$;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class GeoTiffMultibandTile$
implements Serializable {
    public static final GeoTiffMultibandTile$ MODULE$;

    static {
        new GeoTiffMultibandTile$();
    }

    public GeoTiffMultibandTile apply(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, int bandCount, boolean hasPixelInterleave, DataType cellType, Option<BandType> bandType) {
        block13: {
            GeoTiffMultibandTile geoTiffMultibandTile;
            block4: {
                GeoTiffMultibandTile geoTiffMultibandTile2;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                block2: {
                                                    block3: {
                                                        Some some;
                                                        if (!(bandType instanceof Some) || !UInt32BandType$.MODULE$.equals((some = (Some)bandType).x())) break block2;
                                                        if (!(cellType instanceof FloatCells)) break block3;
                                                        NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                                        geoTiffMultibandTile = new UInt32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (FloatCells)((Object)noDataHandling));
                                                        break block4;
                                                    }
                                                    throw new IllegalArgumentException("UInt32BandType should always resolve to Float celltype");
                                                }
                                                if (!(cellType instanceof BitCells)) break block5;
                                                NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                                geoTiffMultibandTile2 = new BitGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (BitCells)((Object)noDataHandling));
                                                break block6;
                                            }
                                            if (!(cellType instanceof ByteCells)) break block7;
                                            NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                            geoTiffMultibandTile2 = new ByteGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (ByteCells)((Object)noDataHandling));
                                            break block6;
                                        }
                                        if (!(cellType instanceof UByteCells)) break block8;
                                        NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                        geoTiffMultibandTile2 = new UByteGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (UByteCells)((Object)noDataHandling));
                                        break block6;
                                    }
                                    if (!(cellType instanceof ShortCells)) break block9;
                                    NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                    geoTiffMultibandTile2 = new Int16GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (ShortCells)((Object)noDataHandling));
                                    break block6;
                                }
                                if (!(cellType instanceof UShortCells)) break block10;
                                NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                                geoTiffMultibandTile2 = new UInt16GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (UShortCells)((Object)noDataHandling));
                                break block6;
                            }
                            if (!(cellType instanceof IntCells)) break block11;
                            NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                            geoTiffMultibandTile2 = new Int32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (IntCells)((Object)noDataHandling));
                            break block6;
                        }
                        if (!(cellType instanceof FloatCells)) break block12;
                        NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                        geoTiffMultibandTile2 = new Float32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (FloatCells)((Object)noDataHandling));
                        break block6;
                    }
                    if (!(cellType instanceof DoubleCells)) break block13;
                    NoDataHandling noDataHandling = (NoDataHandling)((Object)cellType);
                    geoTiffMultibandTile2 = new Float64GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, hasPixelInterleave, (DoubleCells)((Object)noDataHandling));
                }
                geoTiffMultibandTile = geoTiffMultibandTile2;
            }
            return geoTiffMultibandTile;
        }
        throw new MatchError((Object)cellType);
    }

    public GeoTiffMultibandTile apply(MultibandTile tile) {
        return this.apply(tile, GeoTiffOptions$.MODULE$.DEFAULT());
    }

    public GeoTiffMultibandTile apply(MultibandTile tile, GeoTiffOptions options) {
        BandType bandType = BandType$.MODULE$.forCellType(tile.cellType());
        int bandCount = tile.bandCount();
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(tile.cols(), tile.rows(), options.storageMethod(), bandType);
        int segmentCount = segmentLayout.tileLayout().layoutCols() * segmentLayout.tileLayout().layoutRows();
        Compressor compressor = options.compression().createCompressor(segmentCount);
        byte[][] segmentBytes = (byte[][])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Tile[][] segmentTiles = (Tile[][])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tile.class)));
        for (int index$macro$247 = 0; index$macro$247 < bandCount; ++index$macro$247) {
            StorageMethod storageMethod;
            block13: {
                Tile[] tileArray;
                block12: {
                    block11: {
                        storageMethod = options.storageMethod();
                        if (!(storageMethod instanceof Tiled)) break block11;
                        tileArray = (Tile[])package$.MODULE$.withTileMethods(tile.band(index$macro$247)).split(segmentLayout.tileLayout());
                        break block12;
                    }
                    if (!(storageMethod instanceof Striped)) break block13;
                    boolean x$108 = Split$Options$.MODULE$.apply$default$1();
                    tileArray = package$.MODULE$.withTileMethods(tile.band(index$macro$247)).split(segmentLayout.tileLayout(), new Split.Options(x$108, false));
                }
                for (int index$macro$246 = 0; index$macro$246 < segmentCount; ++index$macro$246) {
                    Tile bandTile = tileArray[index$macro$246];
                    if (index$macro$247 == 0) {
                        segmentTiles[index$macro$246] = (Tile[])Array$.MODULE$.ofDim(bandCount, ClassTag$.MODULE$.apply(Tile.class));
                    }
                    segmentTiles[index$macro$246][index$macro$247] = bandTile;
                }
                continue;
            }
            throw new MatchError((Object)storageMethod);
        }
        int byteCount = tile.cellType().bytes();
        for (int index$macro$252 = 0; index$macro$252 < segmentCount; ++index$macro$252) {
            Tile[] tiles = segmentTiles[index$macro$252];
            int cols = tiles[0].cols();
            int rows = tiles[0].rows();
            byte[] segBytes = (byte[])Array$.MODULE$.ofDim(cols * rows * bandCount * byteCount, ClassTag$.MODULE$.Byte());
            byte[][] tileBytes = (byte[][])Array$.MODULE$.ofDim(bandCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            for (int index$macro$248 = 0; index$macro$248 < bandCount; ++index$macro$248) {
                tileBytes[index$macro$248] = tiles[index$macro$248].toBytes();
            }
            int segmentIndex = 0;
            for (int index$macro$251 = 0; index$macro$251 < cols * rows; ++index$macro$251) {
                for (int index$macro$250 = 0; index$macro$250 < bandCount; ++index$macro$250) {
                    for (int index$macro$249 = 0; index$macro$249 < byteCount; ++index$macro$249) {
                        byte[] bytes = tileBytes[index$macro$250];
                        segBytes[segmentIndex] = bytes[index$macro$251 * byteCount + index$macro$249];
                        ++segmentIndex;
                    }
                }
            }
            segmentBytes[index$macro$252] = compressor.compress(segBytes, index$macro$252);
        }
        return this.apply(new ArraySegmentBytes(segmentBytes), compressor.createDecompressor(), segmentLayout, options.compression(), bandCount, true, tile.cellType(), this.apply$default$8());
    }

    public Option<BandType> apply$default$8() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeoTiffMultibandTile$() {
        MODULE$ = this;
    }
}

