/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.io.geotiff.Float64BandType$;
import geotrellis.raster.io.geotiff.Float64GeoTiffSegment;
import geotrellis.raster.io.geotiff.Float64GeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.Float64GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u0017\t\u0011b\t\\8biZ\"t)Z8US\u001a4G+\u001b7f\u0015\t\u0019A!A\u0004hK>$\u0018N\u001a4\u000b\u0005\u00151\u0011AA5p\u0015\t9\u0001\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001\u0001\u0004\t\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!aC$f_RKgM\u001a+jY\u0016\u0004\"!D\t\n\u0005I\u0011!a\b$m_\u0006$h\u0007N$f_RKgMZ*fO6,g\u000e^\"pY2,7\r^5p]\"AA\u0003\u0001BC\u0002\u0013\u0005Q#\u0001\u0007tK\u001elWM\u001c;CsR,7/F\u0001\u0017!\tiq#\u0003\u0002\u0019\u0005\ta1+Z4nK:$()\u001f;fg\"A!\u0004\u0001B\u0001B\u0003%a#A\u0007tK\u001elWM\u001c;CsR,7\u000f\t\u0005\t9\u0001\u0011)\u0019!C\u0001;\u0005aA-Z2p[B\u0014Xm]:peV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0005\u0005Y1m\\7qe\u0016\u001c8/[8o\u0013\t\u0019\u0003E\u0001\u0007EK\u000e|W\u000e\u001d:fgN|'\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\u001f\u00035!WmY8naJ,7o]8sA!Iq\u0005\u0001B\u0001B\u0003%\u0001fK\u0001\u000eg\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;\u0011\u00055I\u0013B\u0001\u0016\u0003\u0005Q9Um\u001c+jM\u001a\u001cVmZ7f]Rd\u0015-_8vi&\u0011qE\u0004\u0005\tC\u0001\u0011\t\u0011)A\u0005[A\u0011qDL\u0005\u0003_\u0001\u00121bQ8naJ,7o]5p]\"A\u0011\u0007\u0001BC\u0002\u0013\u0005!'\u0001\u0005dK2dG+\u001f9f+\u0005\u0019$c\u0001\u001b7u\u0019!Q\u0007\u0001\u00014\u00051a$/\u001a4j]\u0016lWM\u001c;?!\t9\u0004(D\u0001\u0007\u0013\tIdAA\u0006E_V\u0014G.Z\"fY2\u001c\bCA\u001c<\u0013\tadA\u0001\bO_\u0012\u000bG/\u0019%b]\u0012d\u0017N\\4\t\u0011y\u0002!\u0011!Q\u0001\nM\n\u0011bY3mYRK\b/\u001a\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0019\u00115\tR#G\u000fB\u0011Q\u0002\u0001\u0005\u0006)}\u0002\rA\u0006\u0005\u00069}\u0002\rA\b\u0005\u0006O}\u0002\r\u0001\u000b\u0005\u0006C}\u0002\r!\f\u0005\u0006c}\u0002\r\u0001\u0013\n\u0004\u0013ZRd\u0001B\u001b\u0001\u0001!Cqa\u0013\u0001C\u0002\u0013\u0005A*A\u0006o_\u0012\u000bG/\u0019,bYV,W#A'\u0011\u00079\u000b6+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019y\u0005\u000f^5p]B\u0011a\nV\u0005\u0003+>\u0013a\u0001R8vE2,\u0007BB,\u0001A\u0003%Q*\u0001\u0007o_\u0012\u000bG/\u0019,bYV,\u0007\u0005C\u0003Z\u0001\u0011\u0005!,A\u0004nkR\f'\r\\3\u0016\u0003m\u0003\"a\u000e/\n\u0005u3!\u0001E'vi\u0006\u0014G.Z!se\u0006LH+\u001b7f\u0011\u0015y\u0006\u0001\"\u0001a\u0003\u0011\u0019'o\u001c9\u0015\u0005m\u000b\u0007\"\u00022_\u0001\u0004\u0019\u0017AC4sS\u0012\u0014u.\u001e8egB\u0011q\u0007Z\u0005\u0003K\u001a\u0011!b\u0012:jI\n{WO\u001c3t\u0011\u00159\u0007\u0001\"\u0001i\u0003)9\u0018\u000e\u001e5O_\u0012\u000bG/\u0019\u000b\u0003\u0005&DQa\u00134A\u00025CQa\u001b\u0001\u0005\u00021\f1\"\u001b8uKJ\u0004(/\u001a;BgR\u0011A\"\u001c\u0005\u0006]*\u0004\ra\\\u0001\f]\u0016<8)\u001a7m)f\u0004X\r\u0005\u0002qu:\u0011\u0011\u000f\u001f\b\u0003e^t!a\u001d<\u000e\u0003QT!!\u001e\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\tIh!A\u0004qC\u000e\\\u0017mZ3\n\u0005md(\u0001C\"fY2$\u0016\u0010]3\u000b\u0005e4\u0001")
public class Float64GeoTiffTile
extends GeoTiffTile
implements Float64GeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final DoubleCells cellType;
    private final Option<Object> noDataValue;
    private final Float64BandType$ bandType;
    private final Function1<Object, Float64GeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public Float64BandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        Float64GeoTiffTile float64GeoTiffTile = this;
        synchronized (float64GeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = Float64GeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, Float64GeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$Float64GeoTiffSegmentCollection$_setter_$bandType_$eq(Float64BandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public DoubleCells cellType() {
        return this.cellType;
    }

    @Override
    public Option<Object> noDataValue() {
        return this.noDataValue;
    }

    @Override
    public MutableArrayTile mutable() {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(this.cols() * this.rows() * DoubleConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        if (super.segmentLayout().isStriped()) {
            int i = 0;
            for (int index$macro$239 = 0; index$macro$239 < this.segmentCount(); ++index$macro$239) {
                Float64GeoTiffSegment segment = (Float64GeoTiffSegment)this.getSegment(index$macro$239);
                int size = Predef$.MODULE$.byteArrayOps(segment.bytes()).size();
                System.arraycopy(segment.bytes(), 0, arr, i, size);
                i += size;
            }
        } else {
            for (int index$macro$241 = 0; index$macro$241 < this.segmentCount(); ++index$macro$241) {
                Float64GeoTiffSegment segment = (Float64GeoTiffSegment)this.getSegment(index$macro$241);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$241);
                int width = segmentTransform.segmentCols() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                int tileWidth = super.segmentLayout().tileLayout().tileCols() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$240 = 0; index$macro$240 < tileWidth * segmentTransform.segmentRows(); index$macro$240 += tileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$240 / DoubleConstantNoDataCellType$.MODULE$.bytes());
                    int row = segmentTransform.indexToRow(index$macro$240 / DoubleConstantNoDataCellType$.MODULE$.bytes());
                    int j = (row * this.cols() + col) * DoubleConstantNoDataCellType$.MODULE$.bytes();
                    System.arraycopy(segment.bytes(), index$macro$240, arr, j, width);
                }
            }
        }
        return DoubleArrayTile$.MODULE$.fromBytes(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(gridBounds.size() * DoubleConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        int counter = 0;
        if (super.segmentLayout().isStriped()) {
            for (int index$macro$243 = 0; index$macro$243 < this.segmentCount(); ++index$macro$243) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$243, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Float64GeoTiffSegment segment = (Float64GeoTiffSegment)this.getSegment(index$macro$243);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                int adjCols = intersection.cols() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$242 = adjStart; index$macro$242 < adjEnd; index$macro$242 += adjCols) {
                    System.arraycopy(segment.bytes(), index$macro$242, arr, counter, adjWidth);
                    counter += adjWidth;
                }
            }
        } else {
            for (int index$macro$245 = 0; index$macro$245 < this.segmentCount(); ++index$macro$245) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$245, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Float64GeoTiffSegment segment = (Float64GeoTiffSegment)this.getSegment(index$macro$245);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$245);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                int adjTileWidth = intersection.tileWidth() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * DoubleConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$244 = adjStart; index$macro$244 < adjEnd; index$macro$244 += adjTileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$244 / DoubleConstantNoDataCellType$.MODULE$.bytes());
                    int row = segmentTransform.indexToRow(index$macro$244 / DoubleConstantNoDataCellType$.MODULE$.bytes());
                    int j = (row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin());
                    System.arraycopy(segment.bytes(), index$macro$244, arr, j * DoubleConstantNoDataCellType$.MODULE$.bytes(), adjWidth);
                }
            }
        }
        return DoubleArrayTile$.MODULE$.fromBytes(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public Float64GeoTiffTile withNoData(Option<Object> noDataValue) {
        return new Float64GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public GeoTiffTile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof DoubleCells) {
            DoubleCells doubleCells = (DoubleCells)((Object)newCellType);
            geoTiffTile = new Float64GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, doubleCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public Float64GeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, DoubleCells cellType) {
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        this.segmentBytes = segmentBytes;
                        this.decompressor = decompressor;
                        this.compression = compression;
                        this.cellType = cellType;
                        super(segmentLayout, compression);
                        GeoTiffSegmentCollection$class.$init$(this);
                        Float64GeoTiffSegmentCollection$class.$init$(this);
                        if (!DoubleCellType$.MODULE$.equals(cellType)) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!DoubleConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    none$ = new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
                    break block3;
                }
                if (!(cellType instanceof DoubleUserDefinedNoDataCellType)) break block5;
                DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)BoxesRunTime.boxToDouble((double)doubleUserDefinedNoDataCellType.noDataValue()));
            }
            this.noDataValue = none$;
            return;
        }
        throw new MatchError((Object)cellType);
    }
}

