/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.FloatArrayTile$;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.FloatCells;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatUserDefinedNoDataCellType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.Float32BandType$;
import geotrellis.raster.io.geotiff.Float32GeoTiffSegment;
import geotrellis.raster.io.geotiff.Float32GeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.Float32GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001-\u0011!C\u00127pCR\u001c$gR3p)&4g\rV5mK*\u00111\u0001B\u0001\bO\u0016|G/\u001b4g\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001\u0001\u0007\u0011!\tia\"D\u0001\u0003\u0013\ty!AA\u0006HK>$\u0016N\u001a4US2,\u0007CA\u0007\u0012\u0013\t\u0011\"AA\u0010GY>\fGo\r\u001aHK>$\u0016N\u001a4TK\u001elWM\u001c;D_2dWm\u0019;j_:D\u0001\u0002\u0006\u0001\u0003\u0006\u0004%\t!F\u0001\rg\u0016<W.\u001a8u\u0005f$Xm]\u000b\u0002-A\u0011QbF\u0005\u00031\t\u0011AbU3h[\u0016tGOQ=uKND\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IAF\u0001\u000eg\u0016<W.\u001a8u\u0005f$Xm\u001d\u0011\t\u0011q\u0001!Q1A\u0005\u0002u\tA\u0002Z3d_6\u0004(/Z:t_J,\u0012A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0003C\t\t1bY8naJ,7o]5p]&\u00111\u0005\t\u0002\r\t\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0005\tK\u0001\u0011\t\u0011)A\u0005=\u0005iA-Z2p[B\u0014Xm]:pe\u0002B\u0011b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0016\u0002\u001bM,w-\\3oi2\u000b\u0017p\\;u!\ti\u0011&\u0003\u0002+\u0005\t!r)Z8US\u001a47+Z4nK:$H*Y=pkRL!a\n\b\t\u0011\u0005\u0002!\u0011!Q\u0001\n5\u0002\"a\b\u0018\n\u0005=\u0002#aC\"p[B\u0014Xm]:j_:D\u0001\"\r\u0001\u0003\u0006\u0004%\tAM\u0001\tG\u0016dG\u000eV=qKV\t1GE\u00025mi2A!\u000e\u0001\u0001g\taAH]3gS:,W.\u001a8u}A\u0011q\u0007O\u0007\u0002\r%\u0011\u0011H\u0002\u0002\u000b\r2|\u0017\r^\"fY2\u001c\bCA\u001c<\u0013\tadA\u0001\bO_\u0012\u000bG/\u0019%b]\u0012d\u0017N\\4\t\u0011y\u0002!\u0011!Q\u0001\nM\n\u0011bY3mYRK\b/\u001a\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0019\u00115\tR#G\u000fB\u0011Q\u0002\u0001\u0005\u0006)}\u0002\rA\u0006\u0005\u00069}\u0002\rA\b\u0005\u0006O}\u0002\r\u0001\u000b\u0005\u0006C}\u0002\r!\f\u0005\u0006c}\u0002\r\u0001\u0013\n\u0004\u0013ZRd\u0001B\u001b\u0001\u0001!Cqa\u0013\u0001C\u0002\u0013\u0005A*A\u0006o_\u0012\u000bG/\u0019,bYV,W#A'\u0011\u00079\u000b6+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019y\u0005\u000f^5p]B\u0011a\nV\u0005\u0003+>\u0013QA\u00127pCRDaa\u0016\u0001!\u0002\u0013i\u0015\u0001\u00048p\t\u0006$\u0018MV1mk\u0016\u0004\u0003\"B-\u0001\t\u0003Q\u0016aB7vi\u0006\u0014G.Z\u000b\u00027B\u0011q\u0007X\u0005\u0003;\u001a\u0011\u0001#T;uC\ndW-\u0011:sCf$\u0016\u000e\\3\t\u000b}\u0003A\u0011\u00011\u0002\t\r\u0014x\u000e\u001d\u000b\u00037\u0006DQA\u00190A\u0002\r\f!b\u001a:jI\n{WO\u001c3t!\t9D-\u0003\u0002f\r\tQqI]5e\u0005>,h\u000eZ:\t\u000b\u001d\u0004A\u0011\u00015\u0002\u0015]LG\u000f\u001b(p\t\u0006$\u0018\r\u0006\u0002CS\")1J\u001aa\u0001UB\u0019a*U6\u0011\u00059c\u0017BA7P\u0005\u0019!u.\u001e2mK\")q\u000e\u0001C\u0001a\u0006Y\u0011N\u001c;feB\u0014X\r^!t)\t\tH\u000f\u0005\u00028e&\u00111O\u0002\u0002\u0005)&dW\rC\u0003v]\u0002\u0007a/A\u0006oK^\u001cU\r\u001c7UsB,\u0007cA<\u0002\u00049\u0011\u0001p \b\u0003szt!A_?\u000e\u0003mT!\u0001 \u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\r\t\tAB\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)!a\u0002\u0003\u0011\r+G\u000e\u001c+za\u0016T1!!\u0001\u0007\u0001")
public class Float32GeoTiffTile
extends GeoTiffTile
implements Float32GeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final FloatCells cellType;
    private final Option<Object> noDataValue;
    private final Float32BandType$ bandType;
    private final Function1<Object, Float32GeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public Float32BandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        Float32GeoTiffTile float32GeoTiffTile = this;
        synchronized (float32GeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = Float32GeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, Float32GeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$Float32GeoTiffSegmentCollection$_setter_$bandType_$eq(Float32BandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public FloatCells cellType() {
        return this.cellType;
    }

    @Override
    public Option<Object> noDataValue() {
        return this.noDataValue;
    }

    @Override
    public MutableArrayTile mutable() {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(this.cols() * this.rows() * FloatConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        if (super.segmentLayout().isStriped()) {
            int i = 0;
            for (int index$macro$228 = 0; index$macro$228 < this.segmentCount(); ++index$macro$228) {
                Float32GeoTiffSegment segment = (Float32GeoTiffSegment)this.getSegment(index$macro$228);
                int size = Predef$.MODULE$.byteArrayOps(segment.bytes()).size();
                System.arraycopy(segment.bytes(), 0, arr, i, size);
                i += size;
            }
        } else {
            for (int index$macro$230 = 0; index$macro$230 < this.segmentCount(); ++index$macro$230) {
                Float32GeoTiffSegment segment = (Float32GeoTiffSegment)this.getSegment(index$macro$230);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$230);
                int width = segmentTransform.segmentCols() * FloatConstantNoDataCellType$.MODULE$.bytes();
                int tileWidth = super.segmentLayout().tileLayout().tileCols() * FloatConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$229 = 0; index$macro$229 < tileWidth * segmentTransform.segmentRows(); index$macro$229 += tileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$229 / FloatConstantNoDataCellType$.MODULE$.bytes());
                    int row = segmentTransform.indexToRow(index$macro$229 / FloatConstantNoDataCellType$.MODULE$.bytes());
                    int j = (row * this.cols() + col) * FloatConstantNoDataCellType$.MODULE$.bytes();
                    System.arraycopy(segment.bytes(), index$macro$229, arr, j, width);
                }
            }
        }
        return FloatArrayTile$.MODULE$.fromBytes(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(gridBounds.size() * FloatConstantNoDataCellType$.MODULE$.bytes(), ClassTag$.MODULE$.Byte());
        int counter = 0;
        if (super.segmentLayout().isStriped()) {
            for (int index$macro$232 = 0; index$macro$232 < this.segmentCount(); ++index$macro$232) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$232, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Float32GeoTiffSegment segment = (Float32GeoTiffSegment)this.getSegment(index$macro$232);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * FloatConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * FloatConstantNoDataCellType$.MODULE$.bytes();
                int adjCols = intersection.cols() * FloatConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * FloatConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$231 = adjStart; index$macro$231 < adjEnd; index$macro$231 += adjCols) {
                    System.arraycopy(segment.bytes(), index$macro$231, arr, counter, adjWidth);
                    counter += adjWidth;
                }
            }
        } else {
            for (int index$macro$234 = 0; index$macro$234 < this.segmentCount(); ++index$macro$234) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$234, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                Float32GeoTiffSegment segment = (Float32GeoTiffSegment)this.getSegment(index$macro$234);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$234);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                int adjStart = intersection.start() * FloatConstantNoDataCellType$.MODULE$.bytes();
                int adjEnd = intersection.end() * FloatConstantNoDataCellType$.MODULE$.bytes();
                int adjTileWidth = intersection.tileWidth() * FloatConstantNoDataCellType$.MODULE$.bytes();
                int adjWidth = result.width() * FloatConstantNoDataCellType$.MODULE$.bytes();
                for (int index$macro$233 = adjStart; index$macro$233 < adjEnd; index$macro$233 += adjTileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$233 / FloatConstantNoDataCellType$.MODULE$.bytes());
                    int row = segmentTransform.indexToRow(index$macro$233 / FloatConstantNoDataCellType$.MODULE$.bytes());
                    int j = (row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin());
                    System.arraycopy(segment.bytes(), index$macro$233, arr, j * FloatConstantNoDataCellType$.MODULE$.bytes(), adjWidth);
                }
            }
        }
        return FloatArrayTile$.MODULE$.fromBytes(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public Float32GeoTiffTile withNoData(Option<Object> noDataValue) {
        return new Float32GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof FloatCells) {
            FloatCells floatCells = (FloatCells)((Object)newCellType);
            geoTiffTile = new Float32GeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, floatCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public Float32GeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, FloatCells cellType) {
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        this.segmentBytes = segmentBytes;
                        this.decompressor = decompressor;
                        this.compression = compression;
                        this.cellType = cellType;
                        super(segmentLayout, compression);
                        GeoTiffSegmentCollection$class.$init$(this);
                        Float32GeoTiffSegmentCollection$class.$init$(this);
                        if (!FloatCellType$.MODULE$.equals(cellType)) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!FloatConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    none$ = new Some((Object)BoxesRunTime.boxToFloat((float)Float.NaN));
                    break block3;
                }
                if (!(cellType instanceof FloatUserDefinedNoDataCellType)) break block5;
                FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)BoxesRunTime.boxToFloat((float)floatUserDefinedNoDataCellType.noDataValue()));
            }
            this.noDataValue = none$;
            return;
        }
        throw new MatchError((Object)cellType);
    }
}

