/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteCells;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteUserDefinedNoDataCellType;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.ByteBandType$;
import geotrellis.raster.io.geotiff.ByteGeoTiffSegment;
import geotrellis.raster.io.geotiff.ByteGeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.ByteGeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.Intersection;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001-\u0011qBQ=uK\u001e+w\u000eV5gMRKG.\u001a\u0006\u0003\u0007\u0011\tqaZ3pi&4gM\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0003\u000f!\taA]1ti\u0016\u0014(\"A\u0005\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0007\u0001a\u0001\u0003\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\tYq)Z8US\u001a4G+\u001b7f!\ti\u0011#\u0003\u0002\u0013\u0005\ta\")\u001f;f\u000f\u0016|G+\u001b4g'\u0016<W.\u001a8u\u0007>dG.Z2uS>t\u0007\u0002\u0003\u000b\u0001\u0005\u000b\u0007I\u0011A\u000b\u0002\u0019M,w-\\3oi\nKH/Z:\u0016\u0003Y\u0001\"!D\f\n\u0005a\u0011!\u0001D*fO6,g\u000e\u001e\"zi\u0016\u001c\b\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u001bM,w-\\3oi\nKH/Z:!\u0011!a\u0002A!b\u0001\n\u0003i\u0012\u0001\u00043fG>l\u0007O]3tg>\u0014X#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0011aC2p[B\u0014Xm]:j_:L!a\t\u0011\u0003\u0019\u0011+7m\\7qe\u0016\u001c8o\u001c:\t\u0011\u0015\u0002!\u0011!Q\u0001\ny\tQ\u0002Z3d_6\u0004(/Z:t_J\u0004\u0003\"C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015,\u00035\u0019XmZ7f]Rd\u0015-_8viB\u0011Q\"K\u0005\u0003U\t\u0011AcR3p)&4gmU3h[\u0016tG\u000fT1z_V$\u0018BA\u0014\u000f\u0011!\t\u0003A!A!\u0002\u0013i\u0003CA\u0010/\u0013\ty\u0003EA\u0006D_6\u0004(/Z:tS>t\u0007\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\u0002\u0011\r,G\u000e\u001c+za\u0016,\u0012a\r\n\u0004iYRd\u0001B\u001b\u0001\u0001M\u0012A\u0002\u0010:fM&tW-\\3oiz\u0002\"a\u000e\u001d\u000e\u0003\u0019I!!\u000f\u0004\u0003\u0013\tKH/Z\"fY2\u001c\bCA\u001c<\u0013\tadA\u0001\bO_\u0012\u000bG/\u0019%b]\u0012d\u0017N\\4\t\u0011y\u0002!\u0011!Q\u0001\nM\n\u0011bY3mYRK\b/\u001a\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0019\u00115\tR#G\u000fB\u0011Q\u0002\u0001\u0005\u0006)}\u0002\rA\u0006\u0005\u00069}\u0002\rA\b\u0005\u0006O}\u0002\r\u0001\u000b\u0005\u0006C}\u0002\r!\f\u0005\u0006c}\u0002\r\u0001\u0013\n\u0004\u0013ZRd\u0001B\u001b\u0001\u0001!Cqa\u0013\u0001C\u0002\u0013\u0005A*A\u0006o_\u0012\u000bG/\u0019,bYV,W#A'\u0011\u00079\u000b6+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019y\u0005\u000f^5p]B\u0011a\nV\u0005\u0003+>\u0013AAQ=uK\"1q\u000b\u0001Q\u0001\n5\u000bAB\\8ECR\fg+\u00197vK\u0002BQ!\u0017\u0001\u0005\u0002i\u000bq!\\;uC\ndW-F\u0001\\!\t9D,\u0003\u0002^\r\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u0005\u0006?\u0002!\t\u0001Y\u0001\u0005GJ|\u0007\u000f\u0006\u0002\\C\")!M\u0018a\u0001G\u0006QqM]5e\u0005>,h\u000eZ:\u0011\u0005]\"\u0017BA3\u0007\u0005)9%/\u001b3C_VtGm\u001d\u0005\u0006O\u0002!\t\u0001[\u0001\u000bo&$\bNT8ECR\fGC\u0001\"j\u0011\u0015Ye\r1\u0001k!\rq\u0015k\u001b\t\u0003\u001d2L!!\\(\u0003\r\u0011{WO\u00197f\u0011\u0015y\u0007\u0001\"\u0001q\u0003-Ig\u000e^3saJ,G/Q:\u0015\u0005E$\bCA\u001cs\u0013\t\u0019hA\u0001\u0003US2,\u0007\"B;o\u0001\u00041\u0018a\u00038fo\u000e+G\u000e\u001c+za\u0016\u00042a^A\u0002\u001d\tAxP\u0004\u0002z}:\u0011!0`\u0007\u0002w*\u0011APC\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0002\u0005\n\u0007\u0005\u0005a!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0011q\u0001\u0002\t\u0007\u0016dG\u000eV=qK*\u0019\u0011\u0011\u0001\u0004")
public class ByteGeoTiffTile
extends GeoTiffTile
implements ByteGeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final ByteCells cellType;
    private final Option<Object> noDataValue;
    private final ByteBandType$ bandType;
    private final Function1<Object, ByteGeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    private volatile boolean bitmap$0;

    @Override
    public ByteBandType$ bandType() {
        return this.bandType;
    }

    private Function1 createSegment$lzycompute() {
        ByteGeoTiffTile byteGeoTiffTile = this;
        synchronized (byteGeoTiffTile) {
            if (!this.bitmap$0) {
                this.createSegment = ByteGeoTiffSegmentCollection$class.createSegment(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.createSegment;
        }
    }

    @Override
    public Function1<Object, ByteGeoTiffSegment> createSegment() {
        return this.bitmap$0 ? this.createSegment : this.createSegment$lzycompute();
    }

    @Override
    public void geotrellis$raster$io$geotiff$ByteGeoTiffSegmentCollection$_setter_$bandType_$eq(ByteBandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public ByteCells cellType() {
        return this.cellType;
    }

    @Override
    public Option<Object> noDataValue() {
        return this.noDataValue;
    }

    @Override
    public MutableArrayTile mutable() {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Byte());
        if (super.segmentLayout().isStriped()) {
            int i = 0;
            for (int index$macro$217 = 0; index$macro$217 < this.segmentCount(); ++index$macro$217) {
                ByteGeoTiffSegment segment = (ByteGeoTiffSegment)this.getSegment(index$macro$217);
                int size = Predef$.MODULE$.byteArrayOps(segment.bytes()).size();
                System.arraycopy(segment.bytes(), 0, arr, i, size);
                i += size;
            }
        } else {
            for (int index$macro$219 = 0; index$macro$219 < this.segmentCount(); ++index$macro$219) {
                ByteGeoTiffSegment segment = (ByteGeoTiffSegment)this.getSegment(index$macro$219);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$219);
                int width = segmentTransform.segmentCols();
                int tileWidth = super.segmentLayout().tileLayout().tileCols();
                for (int index$macro$218 = 0; index$macro$218 < tileWidth * segmentTransform.segmentRows(); index$macro$218 += tileWidth) {
                    int col = segmentTransform.indexToCol(index$macro$218);
                    int row = segmentTransform.indexToRow(index$macro$218);
                    int j = row * this.cols() + col;
                    System.arraycopy(segment.bytes(), index$macro$218, arr, j, width);
                }
            }
        }
        return ByteArrayTile$.MODULE$.fromBytes(arr, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        byte[] arr = (byte[])Array$.MODULE$.ofDim(gridBounds.size(), ClassTag$.MODULE$.Byte());
        int counter = 0;
        if (super.segmentLayout().isStriped()) {
            for (int index$macro$221 = 0; index$macro$221 < this.segmentCount(); ++index$macro$221) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$221, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                ByteGeoTiffSegment segment = (ByteGeoTiffSegment)this.getSegment(index$macro$221);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                for (int index$macro$220 = intersection.start(); index$macro$220 < intersection.end(); index$macro$220 += this.cols()) {
                    System.arraycopy(segment.bytes(), index$macro$220, arr, counter, result.width());
                    counter += result.width();
                }
            }
        } else {
            for (int index$macro$223 = 0; index$macro$223 < this.segmentCount(); ++index$macro$223) {
                GridBounds segmentGridBounds = super.segmentLayout().getGridBounds(index$macro$223, super.segmentLayout().getGridBounds$default$2());
                if (!gridBounds.intersects(segmentGridBounds)) continue;
                ByteGeoTiffSegment segment = (ByteGeoTiffSegment)this.getSegment(index$macro$223);
                GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$223);
                GridBounds result = (GridBounds)gridBounds.intersection(segmentGridBounds).get();
                Intersection intersection = new Intersection(segmentGridBounds, result, super.segmentLayout());
                for (int index$macro$222 = intersection.start(); index$macro$222 < intersection.end(); index$macro$222 += intersection.tileWidth()) {
                    int col = segmentTransform.indexToCol(index$macro$222);
                    int row = segmentTransform.indexToRow(index$macro$222);
                    int j = (row - gridBounds.rowMin()) * gridBounds.width() + (col - gridBounds.colMin());
                    System.arraycopy(segment.bytes(), index$macro$222, arr, j, result.width());
                }
            }
        }
        return ByteArrayTile$.MODULE$.fromBytes(arr, gridBounds.width(), gridBounds.height(), this.cellType());
    }

    @Override
    public ByteGeoTiffTile withNoData(Option<Object> noDataValue) {
        return new ByteGeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof ByteCells) {
            ByteCells byteCells = (ByteCells)((Object)newCellType);
            geoTiffTile = new ByteGeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, byteCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public ByteGeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, ByteCells cellType) {
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        this.segmentBytes = segmentBytes;
                        this.decompressor = decompressor;
                        this.compression = compression;
                        this.cellType = cellType;
                        super(segmentLayout, compression);
                        GeoTiffSegmentCollection$class.$init$(this);
                        ByteGeoTiffSegmentCollection$class.$init$(this);
                        if (!ByteCellType$.MODULE$.equals(cellType)) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!ByteConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    none$ = new Some((Object)BoxesRunTime.boxToByte((byte)-128));
                    break block3;
                }
                if (!(cellType instanceof ByteUserDefinedNoDataCellType)) break block5;
                ByteUserDefinedNoDataCellType byteUserDefinedNoDataCellType = (ByteUserDefinedNoDataCellType)cellType;
                none$ = new Some((Object)BoxesRunTime.boxToByte((byte)byteUserDefinedNoDataCellType.noDataValue()));
            }
            this.noDataValue = none$;
            return;
        }
        throw new MatchError((Object)cellType);
    }
}

