/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitArrayTile;
import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.BitCells;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.BitBandType$;
import geotrellis.raster.io.geotiff.BitGeoTiffSegment;
import geotrellis.raster.io.geotiff.BitGeoTiffSegmentCollection;
import geotrellis.raster.io.geotiff.BitGeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentCollection$class;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GridIndexTransform;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001-\u0011aBQ5u\u000f\u0016|G+\u001b4g)&dWM\u0003\u0002\u0004\t\u00059q-Z8uS\u001a4'BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u00051!/Y:uKJT\u0011!C\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u00011\u0001\u0002CA\u0007\u000f\u001b\u0005\u0011\u0011BA\b\u0003\u0005-9Um\u001c+jM\u001a$\u0016\u000e\\3\u0011\u00055\t\u0012B\u0001\n\u0003\u0005m\u0011\u0015\u000e^$f_RKgMZ*fO6,g\u000e^\"pY2,7\r^5p]\"AA\u0003\u0001BC\u0002\u0013\u0005Q#\u0001\u0007tK\u001elWM\u001c;CsR,7/F\u0001\u0017!\tiq#\u0003\u0002\u0019\u0005\ta1+Z4nK:$()\u001f;fg\"A!\u0004\u0001B\u0001B\u0003%a#A\u0007tK\u001elWM\u001c;CsR,7\u000f\t\u0005\t9\u0001\u0011)\u0019!C\u0001;\u0005aA-Z2p[B\u0014Xm]:peV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0005\u0005Y1m\\7qe\u0016\u001c8/[8o\u0013\t\u0019\u0003E\u0001\u0007EK\u000e|W\u000e\u001d:fgN|'\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\u001f\u00035!WmY8naJ,7o]8sA!Iq\u0005\u0001B\u0001B\u0003%\u0001fK\u0001\u000eg\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;\u0011\u00055I\u0013B\u0001\u0016\u0003\u0005Q9Um\u001c+jM\u001a\u001cVmZ7f]Rd\u0015-_8vi&\u0011qE\u0004\u0005\tC\u0001\u0011\t\u0011)A\u0005[A\u0011qDL\u0005\u0003_\u0001\u00121bQ8naJ,7o]5p]\"A\u0011\u0007\u0001BC\u0002\u0013\u0005!'\u0001\u0005dK2dG+\u001f9f+\u0005\u0019$c\u0001\u001b7u\u0019!Q\u0007\u0001\u00014\u00051a$/\u001a4j]\u0016lWM\u001c;?!\t9\u0004(D\u0001\u0007\u0013\tIdA\u0001\u0005CSR\u001cU\r\u001c7t!\t94(\u0003\u0002=\r\tqaj\u001c#bi\u0006D\u0015M\u001c3mS:<\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u0013\r,G\u000e\u001c+za\u0016\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0004C\u0007\u0012+ei\u0012\t\u0003\u001b\u0001AQ\u0001F A\u0002YAQ\u0001H A\u0002yAQaJ A\u0002!BQ!I A\u00025BQ!M A\u0002!\u00132!\u0013\u001c;\r\u0011)\u0004\u0001\u0001%\t\u000f-\u0003!\u0019!C\u0001\u0019\u0006\u0011\u0002.Y:QSb,G.\u00138uKJdW-\u0019<f+\u0005i\u0005C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%a\u0002\"p_2,\u0017M\u001c\u0005\u0007)\u0002\u0001\u000b\u0011B'\u0002'!\f7\u000fU5yK2Le\u000e^3sY\u0016\fg/\u001a\u0011\t\u000bY\u0003A\u0011A,\u0002\u000f5,H/\u00192mKV\t\u0001\f\u0005\u000283&\u0011!L\u0002\u0002\u0011\u001bV$\u0018M\u00197f\u0003J\u0014\u0018-\u001f+jY\u0016DQ\u0001\u0018\u0001\u0005\u0002u\u000bAa\u0019:paR\u0011\u0001L\u0018\u0005\u0006?n\u0003\r\u0001Y\u0001\u000bOJLGMQ8v]\u0012\u001c\bCA\u001cb\u0013\t\u0011gA\u0001\u0006He&$'i\\;oINDQ\u0001\u001a\u0001\u0005\u0002\u0015\f!b^5uQ:{G)\u0019;b)\t\u0011e\rC\u0003hG\u0002\u0007\u0001.A\u0006o_\u0012\u000bG/\u0019,bYV,\u0007c\u0001(jW&\u0011!n\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059c\u0017BA7P\u0005\u0019!u.\u001e2mK\")q\u000e\u0001C\u0001a\u0006Y\u0011N\u001c;feB\u0014X\r^!t)\t\tH\u000f\u0005\u00028e&\u00111O\u0002\u0002\u0005)&dW\rC\u0003v]\u0002\u0007a/A\u0006oK^\u001cU\r\u001c7UsB,\u0007cA<\u0002\u00049\u0011\u0001p \b\u0003szt!A_?\u000e\u0003mT!\u0001 \u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\r\t\tAB\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)!a\u0002\u0003\u0011\r+G\u000e\u001c+za\u0016T1!!\u0001\u0007\u0001")
public class BitGeoTiffTile
extends GeoTiffTile
implements BitGeoTiffSegmentCollection {
    private final SegmentBytes segmentBytes;
    private final Decompressor decompressor;
    private final Compression compression;
    private final BitCells cellType;
    private final boolean hasPixelInterleave;
    private final BitBandType$ bandType;
    private final Function1<Object, BitGeoTiffSegment> createSegment;
    private GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;

    @Override
    public BitBandType$ bandType() {
        return this.bandType;
    }

    @Override
    public Function1<Object, BitGeoTiffSegment> createSegment() {
        return this.createSegment;
    }

    @Override
    public void geotrellis$raster$io$geotiff$BitGeoTiffSegmentCollection$_setter_$bandType_$eq(BitBandType$ x$1) {
        this.bandType = x$1;
    }

    @Override
    public void geotrellis$raster$io$geotiff$BitGeoTiffSegmentCollection$_setter_$createSegment_$eq(Function1 x$1) {
        this.createSegment = x$1;
    }

    @Override
    public GeoTiffSegment geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment_$eq(GeoTiffSegment x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegment = x$1;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex;
    }

    @Override
    public void geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex_$eq(int x$1) {
        this.geotrellis$raster$io$geotiff$GeoTiffSegmentCollection$$_lastSegmentIndex = x$1;
    }

    @Override
    public byte[] getDecompressedBytes(int i) {
        return GeoTiffSegmentCollection$class.getDecompressedBytes(this, i);
    }

    @Override
    public GeoTiffSegment getSegment(int i) {
        return GeoTiffSegmentCollection$class.getSegment(this, i);
    }

    @Override
    public SegmentBytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public Decompressor decompressor() {
        return this.decompressor;
    }

    public BitCells cellType() {
        return this.cellType;
    }

    @Override
    public boolean hasPixelInterleave() {
        return this.hasPixelInterleave;
    }

    @Override
    public MutableArrayTile mutable() {
        BitArrayTile result = BitArrayTile$.MODULE$.empty(this.cols(), this.rows());
        int layoutCols = super.segmentLayout().tileLayout().layoutCols();
        int tileCols = super.segmentLayout().tileLayout().tileCols();
        int layoutRows = super.segmentLayout().tileLayout().layoutRows();
        int tileRows = super.segmentLayout().tileLayout().tileRows();
        for (int index$macro$210 = 0; index$macro$210 < layoutCols; ++index$macro$210) {
            int colStart = index$macro$210 * tileCols;
            int n = colStart + tileCols;
            Predef$ predef$ = Predef$.MODULE$;
            int colEnd = RichInt$.MODULE$.min$extension(n, this.cols());
            for (int index$macro$209 = 0; index$macro$209 < layoutRows; ++index$macro$209) {
                int rowStart = index$macro$209 * tileRows;
                int n2 = rowStart + tileRows;
                Predef$ predef$2 = Predef$.MODULE$;
                int rowEnd = RichInt$.MODULE$.min$extension(n2, this.rows());
                for (int index$macro$208 = colStart; index$macro$208 < colEnd; ++index$macro$208) {
                    for (int index$macro$207 = rowStart; index$macro$207 < rowEnd; ++index$macro$207) {
                        result.set(index$macro$208, index$macro$207, this.get(index$macro$208, index$macro$207));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public MutableArrayTile crop(GridBounds gridBounds) {
        BitArrayTile result = BitArrayTile$.MODULE$.empty(gridBounds.width(), gridBounds.height());
        int colMin = gridBounds.colMin();
        int rowMin = gridBounds.rowMin();
        int tileCols = super.segmentLayout().tileLayout().tileCols();
        int tileRows = super.segmentLayout().tileLayout().tileRows();
        for (int index$macro$213 = 0; index$macro$213 < this.segmentCount(); ++index$macro$213) {
            GridIndexTransform segmentTransform = super.segmentLayout().getSegmentTransform(index$macro$213);
            int colStart = segmentTransform.bitIndexToCol(0);
            int rowStart = segmentTransform.bitIndexToRow(0);
            int n = colStart + tileCols;
            Predef$ predef$ = Predef$.MODULE$;
            int colEnd = RichInt$.MODULE$.min$extension(n, this.cols());
            int n2 = rowStart + tileRows;
            Predef$ predef$2 = Predef$.MODULE$;
            int rowEnd = RichInt$.MODULE$.min$extension(n2, this.rows());
            if (!gridBounds.intersects(new GridBounds(colStart, rowStart, colEnd, rowEnd))) continue;
            for (int index$macro$212 = colStart; index$macro$212 < colEnd; ++index$macro$212) {
                for (int index$macro$211 = rowStart; index$macro$211 < rowEnd; ++index$macro$211) {
                    if (!gridBounds.contains(index$macro$212, index$macro$211)) continue;
                    result.set(index$macro$212 - colMin, index$macro$211 - rowMin, this.get(index$macro$212, index$macro$211));
                }
            }
        }
        return result;
    }

    @Override
    public BitGeoTiffTile withNoData(Option<Object> noDataValue) {
        return new BitGeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        GeoTiffTile geoTiffTile;
        if (newCellType instanceof BitCells) {
            BitCells bitCells = (BitCells)((Object)newCellType);
            geoTiffTile = new BitGeoTiffTile(this.segmentBytes(), this.decompressor(), super.segmentLayout(), this.compression, bitCells);
        } else {
            geoTiffTile = ((GeoTiffTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return geoTiffTile;
    }

    public BitGeoTiffTile(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, BitCells cellType) {
        this.segmentBytes = segmentBytes;
        this.decompressor = decompressor;
        this.compression = compression;
        this.cellType = cellType;
        super(segmentLayout, compression);
        GeoTiffSegmentCollection$class.$init$(this);
        BitGeoTiffSegmentCollection$class.$init$(this);
        this.hasPixelInterleave = false;
    }
}

