/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.ascii;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.io.ascii.ReadState;

public abstract class ReadState$class {
    public static MutableArrayTile createTile(ReadState $this, int cols, int rows) {
        return ArrayTile$.MODULE$.empty($this.getType(), cols, rows);
    }

    public static void destroy(ReadState $this) {
    }

    public static void translate(ReadState $this, MutableArrayTile data) {
    }

    public static Tile loadRaster(ReadState $this) {
        RasterExtent re = $this.rasterExtent();
        double src_cellwidth = re.cellwidth();
        double src_cellheight = re.cellheight();
        int src_cols = re.cols();
        int src_rows = re.rows();
        double src_xmin = re.extent().xmin();
        double src_ymin = re.extent().ymin();
        re.extent().xmax();
        re.extent().ymax();
        int dst_cols = $this.target().cols();
        int dst_rows = $this.target().rows();
        double dst_cellwidth = ($this.target().extent().xmax() - $this.target().extent().xmin()) / (double)dst_cols;
        double dst_cellheight = ($this.target().extent().ymax() - $this.target().extent().ymin()) / (double)dst_rows;
        double xbase = $this.target().extent().xmin() - src_xmin + dst_cellwidth / (double)2;
        double ybase = $this.target().extent().ymax() - src_ymin - dst_cellheight / (double)2;
        int src_size = src_rows * src_cols;
        $this.initSource(0, src_size);
        MutableArrayTile resampled = $this.createTile(dst_cols, dst_rows);
        int min_col = (int)(xbase / src_cellwidth);
        int max_col = (int)((xbase + (double)dst_cols * dst_cellwidth) / src_cellwidth);
        double y = ybase;
        for (int index$macro$191 = 0; index$macro$191 < dst_rows; ++index$macro$191) {
            int src_row = src_rows - (int)(y / src_cellheight) - 1;
            int src_span = src_row * src_cols;
            int dst_span = index$macro$191 * dst_cols;
            if (src_span + min_col < src_size && src_span + max_col >= 0) {
                double x = xbase;
                for (int index$macro$190 = 0; index$macro$190 < dst_cols; ++index$macro$190) {
                    int src_col = (int)(x / src_cellwidth);
                    int src_i = src_span + src_col;
                    if (src_col >= 0 && src_col < src_cols && src_i < src_size && src_i >= 0) {
                        int dst_i = dst_span + index$macro$190;
                        $this.assignFromSource(src_i, resampled, dst_i);
                    }
                    x += dst_cellwidth;
                }
            }
            y -= dst_cellheight;
        }
        $this.translate(resampled);
        return resampled;
    }

    public static void $init$(ReadState $this) {
    }
}

