/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.arg;

import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.io.arg.ArgWriter$;
import geotrellis.raster.io.arg.CellWriter$;
import geotrellis.vector.Extent;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001.\u0011\u0011\"\u0011:h/JLG/\u001a:\u000b\u0005\r!\u0011aA1sO*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\rI\f7\u000f^3s\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011\u0003\u0002\u0001\r%U\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\u0007\u0014\u0013\t!bBA\u0004Qe>$Wo\u0019;\u0011\u000551\u0012BA\f\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!I\u0002A!f\u0001\n\u0003Q\u0012\u0001C2fY2$\u0016\u0010]3\u0016\u0003m\u0001\"\u0001\b\u0014\u000f\u0005u!cB\u0001\u0010$\u001d\ty\"%D\u0001!\u0015\t\t#\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003K\u0019\tq\u0001]1dW\u0006<W-\u0003\u0002(Q\tA1)\u001a7m)f\u0004XM\u0003\u0002&\r!A!\u0006\u0001B\tB\u0003%1$A\u0005dK2dG+\u001f9fA!)A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"\"A\f\u0019\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000beY\u0003\u0019A\u000e\t\u000bI\u0002A\u0011A\u001a\u0002\u000b]LG\r\u001e5\u0016\u0003Q\u0002\"!D\u001b\n\u0005Yr!aA%oi\")\u0001\b\u0001C\u0001s\u0005a1-\u001a7m)f\u0004XMT1nKV\t!\b\u0005\u0002<}9\u0011Q\u0002P\u0005\u0003{9\ta\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011QH\u0004\u0005\u0006\u0005\u0002!\taQ\u0001\tI\u0006$\u0018\rV=qKV\tA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0010$\t\u000b1\u0003A\u0011A'\u0002#]\u0014\u0018\u000e^3NKR\fG-\u0019;b\u0015N{e\n\u0006\u0003O#N+\u0006CA\u0007P\u0013\t\u0001fB\u0001\u0003V]&$\b\"\u0002*L\u0001\u0004Q\u0014\u0001\u00029bi\"DQ\u0001V&A\u0002i\nAA\\1nK\")ak\u0013a\u0001/\u0006\u0011!/\u001a\t\u00031fk\u0011AB\u0005\u00035\u001a\u0011ABU1ti\u0016\u0014X\t\u001f;f]RDQ\u0001\u0018\u0001\u0005\u0002u\u000bQa\u001e:ji\u0016$RA\u00140aK6DQaX.A\u0002i\nab\\;uaV$h)\u001b7f!\u0006$\b\u000eC\u0003b7\u0002\u0007!-\u0001\u0003uS2,\u0007C\u0001-d\u0013\t!gA\u0001\u0003US2,\u0007\"\u00024\\\u0001\u00049\u0017AB3yi\u0016tG\u000f\u0005\u0002iW6\t\u0011N\u0003\u0002k\u0011\u00051a/Z2u_JL!\u0001\\5\u0003\r\u0015CH/\u001a8u\u0011\u0015q7\f1\u0001;\u00031iW\r^1eCR\fg*Y7f\u0011\u0015\u0001\b\u0001\"\u0001r\u0003%9(/\u001b;f\t\u0006$\u0018\rF\u0002OeNDQAU8A\u0002iBQ!Y8A\u0002\tDQ!\u001e\u0001\u0005\u0002Y\f\u0011c\u001e:ji\u0016\u001cuN\\:uC:$H+\u001b7f)\u0015qu\u000f_?\u007f\u0011\u0015\u0011F\u000f1\u0001;\u0011\u0015IH\u000f1\u0001{\u0003\t\u0019G\u000f\u0005\u0002Yw&\u0011AP\u0002\u0002\r\u0007>t7\u000f^1oiRKG.\u001a\u0005\u0006)R\u0004\rA\u000f\u0005\u0006-R\u0004\ra\u0016\u0005\n\u0003\u0003\u0001\u0011\u0011!C\u0001\u0003\u0007\tAaY8qsR\u0019a&!\u0002\t\u000fey\b\u0013!a\u00017!I\u0011\u0011\u0002\u0001\u0012\u0002\u0013\u0005\u00111B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiAK\u0002\u001c\u0003\u001fY#!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037q\u0011AC1o]>$\u0018\r^5p]&!\u0011qDA\u000b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\t\u0003G\u0001\u0011\u0011!C!\u0007\u0006i\u0001O]8ek\u000e$\bK]3gSbD\u0001\"a\n\u0001\u0003\u0003%\taM\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00020\u0005U\u0002cA\u0007\u00022%\u0019\u00111\u0007\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u00028\u0005%\u0012\u0011!a\u0001i\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002CBA!\u0003\u000f\ny#\u0004\u0002\u0002D)\u0019\u0011Q\t\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0005\r#\u0001C%uKJ\fGo\u001c:\t\u0013\u00055\u0003!!A\u0005\u0002\u0005=\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0013q\u000b\t\u0004\u001b\u0005M\u0013bAA+\u001d\t9!i\\8mK\u0006t\u0007BCA\u001c\u0003\u0017\n\t\u00111\u0001\u00020!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0013QL\u0001\tQ\u0006\u001c\bnQ8eKR\tA\u0007C\u0005\u0002b\u0001\t\t\u0011\"\u0011\u0002d\u0005AAo\\*ue&tw\rF\u0001E\u0011%\t9\u0007AA\u0001\n\u0003\nI'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\nY\u0007\u0003\u0006\u00028\u0005\u0015\u0014\u0011!a\u0001\u0003_9\u0011\"a\u001c\u0003\u0003\u0003E\t!!\u001d\u0002\u0013\u0005\u0013xm\u0016:ji\u0016\u0014\bcA\u0018\u0002t\u0019A\u0011AAA\u0001\u0012\u0003\t)hE\u0003\u0002t\u0005]T\u0003\u0005\u0004\u0002z\u0005}4DL\u0007\u0003\u0003wR1!! \u000f\u0003\u001d\u0011XO\u001c;j[\u0016LA!!!\u0002|\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000f1\n\u0019\b\"\u0001\u0002\u0006R\u0011\u0011\u0011\u000f\u0005\u000b\u0003C\n\u0019(!A\u0005F\u0005\r\u0004BCAF\u0003g\n\t\u0011\"!\u0002\u000e\u0006)\u0011\r\u001d9msR\u0019a&a$\t\re\tI\t1\u0001\u001c\u0011)\t\u0019*a\u001d\u0002\u0002\u0013\u0005\u0015QS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9*!(\u0011\t5\tIjG\u0005\u0004\u00037s!AB(qi&|g\u000eC\u0005\u0002 \u0006E\u0015\u0011!a\u0001]\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005\r\u00161OA\u0001\n\u0013\t)+A\u0006sK\u0006$'+Z:pYZ,GCAAT!\r)\u0015\u0011V\u0005\u0004\u0003W3%AB(cU\u0016\u001cG\u000f")
public class ArgWriter
implements Product,
Serializable {
    private final DataType cellType;

    public static Option<DataType> unapply(ArgWriter argWriter) {
        return ArgWriter$.MODULE$.unapply(argWriter);
    }

    public static ArgWriter apply(DataType dataType) {
        return ArgWriter$.MODULE$.apply(dataType);
    }

    public static <A> Function1<DataType, A> andThen(Function1<ArgWriter, A> function1) {
        return ArgWriter$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ArgWriter> compose(Function1<A, DataType> function1) {
        return ArgWriter$.MODULE$.compose(function1);
    }

    public DataType cellType() {
        return this.cellType;
    }

    public int width() {
        return this.cellType().bits() / 8;
    }

    public String cellTypeName() {
        return this.cellType().name();
    }

    public String dataType() {
        return "arg";
    }

    public void writeMetadataJSON(String path, String name, RasterExtent re) {
        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\n        |  \"layer\": \"", "\",\n        |  \"datatype\": \"", "\",\n        |  \"type\": \"", "\",\n        |  \"xmin\": ", ",\n        |  \"xmax\": ", ",\n        |  \"ymin\": ", ",\n        |  \"ymax\": ", ",\n        |  \"cols\": ", ",\n        |  \"rows\": ", ",\n        |  \"cellwidth\": ", ",\n        |  \"cellheight\": ", ",\n        |  \"epsg\": 3785,\n        |  \"yskew\": 0.0,\n        |  \"xskew\": 0.0\n        |}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.cellTypeName(), this.dataType(), BoxesRunTime.boxToDouble((double)re.extent().xmin()), BoxesRunTime.boxToDouble((double)re.extent().xmax()), BoxesRunTime.boxToDouble((double)re.extent().ymin()), BoxesRunTime.boxToDouble((double)re.extent().ymax()), BoxesRunTime.boxToInteger((int)re.cols()), BoxesRunTime.boxToInteger((int)re.rows()), BoxesRunTime.boxToDouble((double)re.cellwidth()), BoxesRunTime.boxToDouble((double)re.cellheight())}));
        Predef$ predef$ = Predef$.MODULE$;
        String metadata = new StringOps(string).stripMargin();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(metadata.getBytes());
        bos.close();
    }

    public void write(String outputFilePath, Tile tile, Extent extent2, String metadataName) {
        String base;
        String string = base = outputFilePath.endsWith(".arg") || outputFilePath.endsWith(".json") || outputFilePath.endsWith(".") ? outputFilePath.substring(0, outputFilePath.lastIndexOf(".")) : outputFilePath;
        if (tile instanceof ConstantTile) {
            ConstantTile constantTile = (ConstantTile)tile;
            this.writeConstantTile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base})), constantTile, metadataName, RasterExtent$.MODULE$.apply(extent2, tile.cols(), tile.rows()));
        } else {
            this.writeMetadataJSON(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base})), metadataName, RasterExtent$.MODULE$.apply(extent2, tile.cols(), tile.rows()));
            this.writeData(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".arg"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base})), tile);
        }
    }

    public void writeData(String path, Tile tile) {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
        CellWriter$.MODULE$.byType(this.cellType()).writeCells(tile, dos);
        dos.close();
    }

    public void writeConstantTile(String path, ConstantTile ct, String name, RasterExtent re) {
        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\n        |  \"layer\": \"", "\",\n        |  \"datatype\": \"", "\",\n        |  \"type\": \"constant\",\n        |  \"xmin\": ", ",\n        |  \"xmax\": ", ",\n        |  \"ymin\": ", ",\n        |  \"ymax\": ", ",\n        |  \"cols\": ", ",\n        |  \"rows\": ", ",\n        |  \"cellwidth\": ", ",\n        |  \"cellheight\": ", ",\n        |  \"epsg\": 3785,\n        |  \"yskew\": 0.0,\n        |  \"xskew\": 0.0,\n        |  \"constant\": {ct.getDouble(0,0)}\n        |}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.cellTypeName(), BoxesRunTime.boxToDouble((double)re.extent().xmin()), BoxesRunTime.boxToDouble((double)re.extent().xmax()), BoxesRunTime.boxToDouble((double)re.extent().ymin()), BoxesRunTime.boxToDouble((double)re.extent().ymax()), BoxesRunTime.boxToInteger((int)re.cols()), BoxesRunTime.boxToInteger((int)re.rows()), BoxesRunTime.boxToDouble((double)re.cellwidth()), BoxesRunTime.boxToDouble((double)re.cellheight())}));
        Predef$ predef$ = Predef$.MODULE$;
        String metadata = new StringOps(string).stripMargin();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(metadata.getBytes());
        bos.close();
    }

    public ArgWriter copy(DataType cellType) {
        return new ArgWriter(cellType);
    }

    public DataType copy$default$1() {
        return this.cellType();
    }

    public String productPrefix() {
        return "ArgWriter";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.cellType();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArgWriter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof ArgWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArgWriter argWriter = (ArgWriter)x$1;
        DataType dataType = this.cellType();
        DataType dataType2 = argWriter.cellType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!argWriter.canEqual(this)) return false;
        return true;
    }

    public ArgWriter(DataType cellType) {
        this.cellType = cellType;
        Product.class.$init$((Product)this);
    }
}

