/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.arg;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitArrayTile;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile$;
import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteConstantTile;
import geotrellis.raster.ByteConstantTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleConstantTile;
import geotrellis.raster.DoubleConstantTile$;
import geotrellis.raster.FloatArrayTile$;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatConstantTile;
import geotrellis.raster.FloatConstantTile$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntConstantTile;
import geotrellis.raster.IntConstantTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortArrayTile$;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortConstantTile;
import geotrellis.raster.ShortConstantTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteArrayTile$;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteConstantTile;
import geotrellis.raster.UByteConstantTile$;
import geotrellis.raster.UShortArrayTile$;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortConstantTile;
import geotrellis.raster.UShortConstantTile$;
import geotrellis.raster.package$;
import geotrellis.raster.package$ByteArrayFiller$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.package$FloatArrayFiller$;
import geotrellis.raster.package$IntArrayFiller$;
import geotrellis.raster.package$ShortArrayFiller$;
import geotrellis.raster.resample.BitResampleAssign;
import geotrellis.raster.resample.ByteBufferResampleAssign;
import geotrellis.raster.resample.DoubleBufferResampleAssign;
import geotrellis.raster.resample.FloatBufferResampleAssign;
import geotrellis.raster.resample.IntBufferResampleAssign;
import geotrellis.raster.resample.ResampleAssign$;
import geotrellis.raster.resample.ShortBufferResampleAssign;
import geotrellis.util.Filesystem$;
import geotrellis.vector.Extent;
import java.io.File;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ArgReader$ {
    public static final ArgReader$ MODULE$;

    static {
        new ArgReader$();
    }

    public final Raster<Tile> read(String path) {
        return this.read(path, (Option<RasterExtent>)None$.MODULE$);
    }

    public final Raster<Tile> read(String path, RasterExtent targetRasterExtent) {
        return this.read(path, (Option<RasterExtent>)new Some((Object)targetRasterExtent));
    }

    private final Raster<Tile> read(String path, Option<RasterExtent> targetRasterExtent) {
        String string;
        block13: {
            String layerType;
            block25: {
                block28: {
                    Raster<Tile> raster;
                    block24: {
                        Raster<Tile> raster2;
                        block27: {
                            String argPath;
                            int rows;
                            int cols;
                            Extent extent2;
                            DataType dataType;
                            block26: {
                                File file;
                                Config json;
                                block14: {
                                    block23: {
                                        Raster<Tile> raster3;
                                        block16: {
                                            double v;
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block17: {
                                                                    block15: {
                                                                        block6: {
                                                                            block12: {
                                                                                block11: {
                                                                                    block10: {
                                                                                        block9: {
                                                                                            block8: {
                                                                                                block7: {
                                                                                                    block5: {
                                                                                                        json = ConfigFactory.parseString((String)Filesystem$.MODULE$.readText(path));
                                                                                                        string = json.getString("datatype");
                                                                                                        if (!"bool".equals(string)) break block5;
                                                                                                        dataType = BitCellType$.MODULE$;
                                                                                                        break block6;
                                                                                                    }
                                                                                                    if (!"int8".equals(string)) break block7;
                                                                                                    dataType = ByteConstantNoDataCellType$.MODULE$;
                                                                                                    break block6;
                                                                                                }
                                                                                                if (!"uint8".equals(string)) break block8;
                                                                                                dataType = UByteConstantNoDataCellType$.MODULE$;
                                                                                                break block6;
                                                                                            }
                                                                                            if (!"int16".equals(string)) break block9;
                                                                                            dataType = ShortConstantNoDataCellType$.MODULE$;
                                                                                            break block6;
                                                                                        }
                                                                                        if (!"uint16".equals(string)) break block10;
                                                                                        dataType = UShortConstantNoDataCellType$.MODULE$;
                                                                                        break block6;
                                                                                    }
                                                                                    if (!"int32".equals(string)) break block11;
                                                                                    dataType = IntConstantNoDataCellType$.MODULE$;
                                                                                    break block6;
                                                                                }
                                                                                if (!"float32".equals(string)) break block12;
                                                                                dataType = FloatConstantNoDataCellType$.MODULE$;
                                                                                break block6;
                                                                            }
                                                                            if (!"float64".equals(string)) break block13;
                                                                            dataType = DoubleConstantNoDataCellType$.MODULE$;
                                                                        }
                                                                        double xmin = json.getDouble("xmin");
                                                                        double ymin = json.getDouble("ymin");
                                                                        double xmax = json.getDouble("xmax");
                                                                        double ymax = json.getDouble("ymax");
                                                                        extent2 = new Extent(xmin, ymin, xmax, ymax);
                                                                        cols = json.getInt("cols");
                                                                        rows = json.getInt("rows");
                                                                        String string2 = layerType = json.getString("type").toLowerCase();
                                                                        if (string2 == null || !string2.equals("constant")) break block14;
                                                                        v = json.getDouble("constant");
                                                                        if (!BitCellType$.MODULE$.equals(dataType)) break block15;
                                                                        raster3 = new Raster<Tile>(BitConstantTile$.MODULE$.apply(Double.isNaN(v) ? Integer.MIN_VALUE : (int)v, cols, rows), extent2);
                                                                        break block16;
                                                                    }
                                                                    if (!ByteConstantNoDataCellType$.MODULE$.equals(dataType)) break block17;
                                                                    raster3 = new Raster<ByteConstantTile>(new ByteConstantTile((byte)(Double.isNaN(v) ? -128 : (byte)v), cols, rows, ByteConstantTile$.MODULE$.apply$default$4()), extent2);
                                                                    break block16;
                                                                }
                                                                if (!UByteConstantNoDataCellType$.MODULE$.equals(dataType)) break block18;
                                                                raster3 = new Raster<UByteConstantTile>(new UByteConstantTile((byte)(Double.isNaN(v) ? -128 : (byte)v), cols, rows, UByteConstantTile$.MODULE$.apply$default$4()), extent2);
                                                                break block16;
                                                            }
                                                            if (!ShortConstantNoDataCellType$.MODULE$.equals(dataType)) break block19;
                                                            raster3 = new Raster<ShortConstantTile>(new ShortConstantTile((short)(Double.isNaN(v) ? Short.MIN_VALUE : (short)v), cols, rows, ShortConstantTile$.MODULE$.apply$default$4()), extent2);
                                                            break block16;
                                                        }
                                                        if (!UShortConstantNoDataCellType$.MODULE$.equals(dataType)) break block20;
                                                        raster3 = new Raster<UShortConstantTile>(new UShortConstantTile((short)(Double.isNaN(v) ? Short.MIN_VALUE : (short)v), cols, rows, UShortConstantTile$.MODULE$.apply$default$4()), extent2);
                                                        break block16;
                                                    }
                                                    if (!IntConstantNoDataCellType$.MODULE$.equals(dataType)) break block21;
                                                    raster3 = new Raster<IntConstantTile>(new IntConstantTile(Double.isNaN(v) ? Integer.MIN_VALUE : (int)v, cols, rows, IntConstantTile$.MODULE$.apply$default$4()), extent2);
                                                    break block16;
                                                }
                                                if (!FloatConstantNoDataCellType$.MODULE$.equals(dataType)) break block22;
                                                raster3 = new Raster<FloatConstantTile>(new FloatConstantTile((float)v, cols, rows, FloatConstantTile$.MODULE$.apply$default$4()), extent2);
                                                break block16;
                                            }
                                            if (!DoubleConstantNoDataCellType$.MODULE$.equals(dataType)) break block23;
                                            raster3 = new Raster<DoubleConstantTile>(new DoubleConstantTile(v, cols, rows, DoubleConstantTile$.MODULE$.apply$default$4()), extent2);
                                        }
                                        raster = raster3;
                                        break block24;
                                    }
                                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
                                }
                                String string3 = layerType;
                                if (string3 == null || !string3.equals("arg")) break block25;
                                if (json.hasPath("path")) {
                                    File f = new File(json.getString("path"));
                                    file = f.isAbsolute() ? f : new File(new File(path).getParent(), f.getPath());
                                } else {
                                    String layerName = json.getString("layer");
                                    file = new File(new File(path).getParent(), new StringBuilder().append((Object)layerName).append((Object)".arg").toString());
                                }
                                argPath = file.getAbsolutePath();
                                if (!(targetRasterExtent instanceof Some)) break block26;
                                Some some = (Some)targetRasterExtent;
                                raster2 = new Raster<Tile>(this.read(argPath, dataType, RasterExtent$.MODULE$.apply(extent2, cols, rows), (RasterExtent)some.x()), ((RasterExtent)some.x()).extent());
                                break block27;
                            }
                            if (!None$.MODULE$.equals(targetRasterExtent)) break block28;
                            raster2 = new Raster<Tile>(this.read(argPath, dataType, cols, rows), extent2);
                        }
                        raster = raster2;
                    }
                    return raster;
                }
                throw new MatchError(targetRasterExtent);
            }
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot read raster layer type ", ", must be arg"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{layerType})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public final Tile read(String path, DataType cellType, int cols, int rows) {
        return ArrayTile$.MODULE$.fromBytes(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()), cellType, cols, rows);
    }

    public final Tile read(String path, DataType cellType, RasterExtent rasterExtent, RasterExtent targetExtent) {
        int size = cellType.numBytes(rasterExtent.size());
        int cols = rasterExtent.cols();
        GridBounds gridBounds = rasterExtent.gridBoundsFor(targetExtent.extent(), rasterExtent.gridBoundsFor$default$2());
        if (gridBounds != null) {
            Tile tile;
            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)gridBounds.colMin()), (Object)BoxesRunTime.boxToInteger((int)gridBounds.rowMin()), (Object)BoxesRunTime.boxToInteger((int)gridBounds.colMax()), (Object)BoxesRunTime.boxToInteger((int)gridBounds.rowMax()));
            int colMin = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int rowMin = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int colMax = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int rowMax = BoxesRunTime.unboxToInt((Object)tuple4._4());
            int startIndex = scala.math.package$.MODULE$.max(cellType.numBytes((rowMin - 1) * cols + colMin - 1), 0);
            int length = scala.math.package$.MODULE$.min(size - startIndex, cellType.numBytes((rowMax + 1) * cols + colMax + 1) - startIndex);
            if (length > 0) {
                byte[] bytes = (byte[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Byte());
                Filesystem$.MODULE$.mapToByteArray(path, bytes, startIndex, length);
                tile = this.resampleBytes(bytes, cellType, rasterExtent, targetExtent);
            } else {
                tile = ArrayTile$.MODULE$.empty(cellType, targetExtent.cols(), targetExtent.rows());
            }
            return tile;
        }
        throw new MatchError((Object)gridBounds);
    }

    public final Tile resampleBytes(byte[] bytes, DataType cellType, RasterExtent re, RasterExtent targetRe) {
        block10: {
            MutableArrayTile mutableArrayTile;
            block3: {
                int rows;
                int cols;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            cols = targetRe.cols();
                                            rows = targetRe.rows();
                                            if (!BitCellType$.MODULE$.equals(cellType)) break block2;
                                            byte[] resampled = (byte[])Array$.MODULE$.ofDim((cols * rows + 7) / 8, ClassTag$.MODULE$.Byte());
                                            ResampleAssign$.MODULE$.apply(re, targetRe, new BitResampleAssign(bytes, resampled));
                                            mutableArrayTile = new BitArrayTile(resampled, cols, rows);
                                            break block3;
                                        }
                                        if (!ByteConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                                        ByteBuffer buffer = ByteBuffer.wrap(bytes);
                                        byte[] resampled = package$ByteArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ByteArrayFiller((byte[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Byte())), (byte)-128);
                                        ResampleAssign$.MODULE$.apply(re, targetRe, new ByteBufferResampleAssign(buffer, resampled));
                                        mutableArrayTile = ByteArrayTile$.MODULE$.apply(resampled, cols, rows);
                                        break block3;
                                    }
                                    if (!UByteConstantNoDataCellType$.MODULE$.equals(cellType)) break block5;
                                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                                    byte[] resampled = package$ByteArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ByteArrayFiller((byte[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Byte())), (byte)-128);
                                    ResampleAssign$.MODULE$.apply(re, targetRe, new ByteBufferResampleAssign(buffer, resampled));
                                    mutableArrayTile = UByteArrayTile$.MODULE$.apply(resampled, cols, rows);
                                    break block3;
                                }
                                if (!ShortConstantNoDataCellType$.MODULE$.equals(cellType)) break block6;
                                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                                short[] resampled = package$ShortArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ShortArrayFiller((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short())), (short)Short.MIN_VALUE);
                                ResampleAssign$.MODULE$.apply(re, targetRe, new ShortBufferResampleAssign(buffer, resampled));
                                mutableArrayTile = ShortArrayTile$.MODULE$.apply(resampled, cols, rows);
                                break block3;
                            }
                            if (!UShortConstantNoDataCellType$.MODULE$.equals(cellType)) break block7;
                            ByteBuffer buffer = ByteBuffer.wrap(bytes);
                            short[] resampled = package$ShortArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ShortArrayFiller((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short())), (short)Short.MIN_VALUE);
                            ResampleAssign$.MODULE$.apply(re, targetRe, new ShortBufferResampleAssign(buffer, resampled));
                            mutableArrayTile = UShortArrayTile$.MODULE$.apply(resampled, cols, rows);
                            break block3;
                        }
                        if (!IntConstantNoDataCellType$.MODULE$.equals(cellType)) break block8;
                        ByteBuffer buffer = ByteBuffer.wrap(bytes);
                        int[] resampled = package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int())), Integer.MIN_VALUE);
                        ResampleAssign$.MODULE$.apply(re, targetRe, new IntBufferResampleAssign(buffer, resampled));
                        mutableArrayTile = IntArrayTile$.MODULE$.apply(resampled, cols, rows);
                        break block3;
                    }
                    if (!FloatConstantNoDataCellType$.MODULE$.equals(cellType)) break block9;
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    float[] resampled = package$FloatArrayFiller$.MODULE$.fill$extension(package$.MODULE$.FloatArrayFiller((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float())), Float.NaN);
                    ResampleAssign$.MODULE$.apply(re, targetRe, new FloatBufferResampleAssign(buffer, resampled));
                    mutableArrayTile = FloatArrayTile$.MODULE$.apply(resampled, cols, rows);
                    break block3;
                }
                if (!DoubleConstantNoDataCellType$.MODULE$.equals(cellType)) break block10;
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                double[] resampled = package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double())), Double.NaN);
                ResampleAssign$.MODULE$.apply(re, targetRe, new DoubleBufferResampleAssign(buffer, resampled));
                mutableArrayTile = DoubleArrayTile$.MODULE$.apply(resampled, cols, rows);
            }
            return mutableArrayTile;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cellType})));
    }

    private ArgReader$() {
        MODULE$ = this;
    }
}

