/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io;

import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.vector.Extent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Locale;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class AsciiWriter$ {
    public static final AsciiWriter$ MODULE$;

    static {
        new AsciiWriter$();
    }

    public String cellType() {
        return "ascii";
    }

    public String dataType() {
        return "";
    }

    public void write(String path, Tile raster, Extent extent2, String name) {
        this.write(path, raster, extent2, name, Integer.MIN_VALUE);
    }

    public void write(String path, Tile raster, Extent extent2, String name, int noData) {
        RasterExtent g = RasterExtent$.MODULE$.apply(extent2, raster.cols(), raster.rows());
        if (g.cellwidth() != g.cellheight()) {
            throw new Exception("raster cannot be written as ASCII");
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(path)));
        pw.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nrows ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)g.rows())})));
        pw.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ncols ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)g.cols())})));
        Predef$ predef$ = Predef$.MODULE$;
        pw.write(new StringOps("xllcorner %.12f\n").formatLocal(Locale.ENGLISH, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)extent2.xmin())})));
        Predef$ predef$2 = Predef$.MODULE$;
        pw.write(new StringOps("yllcorner %.12f\n").formatLocal(Locale.ENGLISH, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)extent2.ymin())})));
        Predef$ predef$3 = Predef$.MODULE$;
        pw.write(new StringOps("cellsize %.12f\n").formatLocal(Locale.ENGLISH, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)g.cellwidth())})));
        pw.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nodata_value ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)noData)})));
        int[] data = raster.toArray();
        for (int y = 0; y < g.rows(); ++y) {
            int span = y * g.cols();
            for (int x = 0; x < g.cols(); ++x) {
                pw.print(" ");
                pw.print(data[span + x]);
            }
            pw.print("\n");
        }
        pw.close();
    }

    private AsciiWriter$() {
        MODULE$ = this;
    }
}

