/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.interpolation;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.interpolation.InverseDistanceWeighted;
import geotrellis.raster.interpolation.InverseDistanceWeighted$Options$;
import geotrellis.vector.Extent;
import geotrellis.vector.Feature;
import geotrellis.vector.Point;
import geotrellis.vector.SpatialIndex;
import geotrellis.vector.SpatialIndex$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Traversable;
import scala.collection.immutable.Vector;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class InverseDistanceWeighted$ {
    public static final InverseDistanceWeighted$ MODULE$;

    static {
        new InverseDistanceWeighted$();
    }

    public <D> Raster<Tile> apply(Traversable<Feature<Point, D>> points, RasterExtent rasterExtent, InverseDistanceWeighted.Options options, Function1<D, Object> ev) {
        if (options != null) {
            Tuple8 tuple8 = new Tuple8((Object)BoxesRunTime.boxToDouble((double)options.radiusX()), (Object)BoxesRunTime.boxToDouble((double)options.radiusY()), (Object)BoxesRunTime.boxToDouble((double)options.rotation()), (Object)BoxesRunTime.boxToDouble((double)options.weightingPower()), (Object)BoxesRunTime.boxToDouble((double)options.smoothingFactor()), (Object)BoxesRunTime.boxToDouble((double)options.equalWeightRadius()), (Object)options.cellType(), options.onSet());
            double radiusX = BoxesRunTime.unboxToDouble((Object)tuple8._1());
            double radiusY = BoxesRunTime.unboxToDouble((Object)tuple8._2());
            double rotation = BoxesRunTime.unboxToDouble((Object)tuple8._3());
            double weightingPower = BoxesRunTime.unboxToDouble((Object)tuple8._4());
            double smoothingFactor = BoxesRunTime.unboxToDouble((Object)tuple8._5());
            double equalWeightRadius = BoxesRunTime.unboxToDouble((Object)tuple8._6());
            DataType cellType = (DataType)tuple8._7();
            Function1 onSet = (Function1)tuple8._8();
            int cols = rasterExtent.cols();
            int rows = rasterExtent.rows();
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, cols, rows);
            if (!points.isEmpty()) {
                double ewr2 = equalWeightRadius * equalWeightRadius;
                double radiusXY = radiusX * radiusY;
                double d = radiusX * radiusY;
                if (Predef$.MODULE$.double2Double(d).isInfinite()) {
                    for (int index$macro$187 = 0; index$macro$187 < rows; ++index$macro$187) {
                        for (int index$macro$186 = 0; index$macro$186 < cols; ++index$macro$186) {
                            double x = rasterExtent.gridColToMap(index$macro$186);
                            double y = rasterExtent.gridRowToMap(index$macro$187);
                            double value = this.idw$1(points, x, y, false, ev, radiusX, radiusY, rotation, weightingPower, smoothingFactor, onSet, ewr2, radiusXY);
                            tile.setDouble(index$macro$186, index$macro$187, value);
                        }
                    }
                } else {
                    SpatialIndex index = SpatialIndex$.MODULE$.apply(points, (Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Feature<Point, D> p) {
                            return new Tuple2.mcDD.sp(((Point)p.geom()).x(), ((Point)p.geom()).y());
                        }
                    });
                    for (int index$macro$189 = 0; index$macro$189 < rows; ++index$macro$189) {
                        for (int index$macro$188 = 0; index$macro$188 < cols; ++index$macro$188) {
                            double y;
                            double x = rasterExtent.gridColToMap(index$macro$188);
                            Vector rPoints = index.pointsInExtent(new Extent(x - radiusX, (y = rasterExtent.gridRowToMap(index$macro$189)) - radiusY, x + radiusX, y + radiusY));
                            double value = rPoints.isEmpty() ? Double.NaN : this.idw$1((Traversable)rPoints, x, y, true, ev, radiusX, radiusY, rotation, weightingPower, smoothingFactor, onSet, ewr2, radiusXY);
                            tile.setDouble(index$macro$188, index$macro$189, value);
                        }
                    }
                }
            }
            return new Raster<Tile>(tile, rasterExtent.extent());
        }
        throw new MatchError((Object)options);
    }

    public <D> InverseDistanceWeighted.Options apply$default$3() {
        return InverseDistanceWeighted$Options$.MODULE$.DEFAULT();
    }

    private final double idw$1(Traversable points, double x, double y, boolean hasRadius, Function1 ev$1, double radiusX$1, double radiusY$1, double rotation$1, double weightingPower$1, double smoothingFactor$1, Function1 onSet$1, double ewr2$1, double radiusXY$1) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        IntRef count = IntRef.create((int)0);
        DoubleRef weightSum = DoubleRef.create((double)0.0);
        DoubleRef sampleSum = DoubleRef.create((double)0.0);
        IntRef sampleCount = IntRef.create((int)0);
        double halfPow = weightingPower$1 / 2.0;
        points.foreach((Function1)new Serializable(ev$1, radiusX$1, radiusY$1, rotation$1, smoothingFactor$1, ewr2$1, radiusXY$1, x, y, hasRadius, sum, count, weightSum, sampleSum, sampleCount, halfPow){
            public static final long serialVersionUID = 0L;
            private final Function1 ev$1;
            private final double radiusX$1;
            private final double radiusY$1;
            private final double rotation$1;
            private final double smoothingFactor$1;
            private final double ewr2$1;
            private final double radiusXY$1;
            private final double x$11;
            private final double y$1;
            private final boolean hasRadius$1;
            private final DoubleRef sum$1;
            private final IntRef count$1;
            private final DoubleRef weightSum$1;
            private final DoubleRef sampleSum$1;
            private final IntRef sampleCount$1;
            private final double halfPow$1;

            public final void apply(Feature<Point, D> point) {
                Tuple2.mcDD.sp sp2;
                double dX = this.x$11 - ((Point)point.geom()).x();
                double dY = this.y$1 - ((Point)point.geom()).y();
                double d2 = dX * dX + dY * dY + this.smoothingFactor$1 * this.smoothingFactor$1;
                if (this.rotation$1 != 0.0) {
                    double rotRads = package$.MODULE$.toRadians(this.rotation$1);
                    double coeff1 = package$.MODULE$.cos(rotRads);
                    double coeff2 = package$.MODULE$.sin(rotRads);
                    double dXRotated = dX * coeff1 + dY * coeff2;
                    double dYRotated = dY * coeff1 - dX * coeff2;
                    sp2 = new Tuple2.mcDD.sp(dXRotated, dYRotated);
                } else {
                    sp2 = new Tuple2.mcDD.sp(dX, dY);
                }
                Tuple2.mcDD.sp sp3 = sp2;
                Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(sp3._1$mcD$sp(), sp3._2$mcD$sp());
                double dX2 = sp4._1$mcD$sp();
                double dY2 = sp4._2$mcD$sp();
                if (!this.hasRadius$1 || this.radiusY$1 * dX2 * dX2 + this.radiusX$1 * dY2 * dY2 <= this.radiusXY$1) {
                    double data = BoxesRunTime.unboxToDouble((Object)this.ev$1.apply(point.data()));
                    if (d2 <= this.ewr2$1) {
                        this.sampleSum$1.elem += data;
                        ++this.sampleCount$1.elem;
                    } else {
                        double powerWeight = package$.MODULE$.pow(d2, this.halfPow$1);
                        double w = 1.0 / powerWeight;
                        this.sum$1.elem += data * w;
                        this.weightSum$1.elem += w;
                        ++this.count$1.elem;
                    }
                }
            }
            {
                this.ev$1 = ev$1;
                this.radiusX$1 = radiusX$1;
                this.radiusY$1 = radiusY$1;
                this.rotation$1 = rotation$1;
                this.smoothingFactor$1 = smoothingFactor$1;
                this.ewr2$1 = ewr2$1;
                this.radiusXY$1 = radiusXY$1;
                this.x$11 = x$11;
                this.y$1 = y$1;
                this.hasRadius$1 = hasRadius$1;
                this.sum$1 = sum$1;
                this.count$1 = count$1;
                this.weightSum$1 = weightSum$1;
                this.sampleSum$1 = sampleSum$1;
                this.sampleCount$1 = sampleCount$1;
                this.halfPow$1 = halfPow$1;
            }
        });
        return sampleCount.elem == 0 ? (count.elem == 0 ? Double.NaN : onSet$1.apply$mcDD$sp(sum.elem / weightSum.elem)) : onSet$1.apply$mcDD$sp(sampleSum.elem / (double)sampleCount.elem);
    }

    private InverseDistanceWeighted$() {
        MODULE$ = this;
    }
}

