/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.hydrology;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FlowDirection$ {
    public static final FlowDirection$ MODULE$;

    static {
        new FlowDirection$();
    }

    public int flow(int c, int r, Tile raster) {
        Map<Object, Object> neighbors = this.getNeighbors(c, r, raster);
        double max = BoxesRunTime.unboxToDouble((Object)neighbors.values().max((Ordering)Ordering.Double$.MODULE$));
        return BoxesRunTime.unboxToInt((Object)((MapLike)neighbors.filter((Function1)new Serializable(max){
            public static final long serialVersionUID = 0L;
            private final double max$1;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                if (x0$1 != null) {
                    return x0$1._2$mcD$sp() == this.max$1;
                }
                throw new MatchError(x0$1);
            }
            {
                this.max$1 = max$1;
            }
        })).keys().reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, int x$2) {
                return x$1 + x$2;
            }

            public int apply$mcIII$sp(int x$1, int x$2) {
                return x$1 + x$2;
            }
        }));
    }

    public Map<Object, Object> getNeighbors(int c, int r, Tile raster) {
        int center = raster.get(c, r);
        int ncols = raster.cols();
        int nrows = raster.rows();
        Map distances = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, package$.MODULE$.sqrt(2.0)), new Tuple2.mcID.sp(4, 1.0), new Tuple2.mcID.sp(8, package$.MODULE$.sqrt(2.0)), new Tuple2.mcID.sp(16, 1.0), new Tuple2.mcID.sp(32, package$.MODULE$.sqrt(2.0)), new Tuple2.mcID.sp(64, 1.0), new Tuple2.mcID.sp(128, package$.MODULE$.sqrt(2.0))}));
        Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Tuple2.mcII.sp(c + 1, r)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new Tuple2.mcII.sp(c + 1, r + 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)new Tuple2.mcII.sp(c, r + 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Object)new Tuple2.mcII.sp(c - 1, r + 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)16), (Object)new Tuple2.mcII.sp(c - 1, r)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)32), (Object)new Tuple2.mcII.sp(c - 1, r - 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)64), (Object)new Tuple2.mcII.sp(c, r - 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)128), (Object)new Tuple2.mcII.sp(c + 1, r - 1))}));
        return (Map)((TraversableLike)map2.filter((Function1)new Serializable(raster, ncols, nrows){
            public static final long serialVersionUID = 0L;
            private final Tile raster$1;
            private final int ncols$1;
            private final int nrows$1;

            public final boolean apply(Tuple2<Object, Tuple2<Object, Object>> x0$2) {
                if (x0$2 != null && x0$2._2() != null) {
                    return 0 <= ((Tuple2)x0$2._2())._1$mcI$sp() && ((Tuple2)x0$2._2())._1$mcI$sp() < this.ncols$1 && 0 <= ((Tuple2)x0$2._2())._2$mcI$sp() && ((Tuple2)x0$2._2())._2$mcI$sp() < this.nrows$1 && this.raster$1.get(((Tuple2)x0$2._2())._1$mcI$sp(), ((Tuple2)x0$2._2())._2$mcI$sp()) != Integer.MIN_VALUE;
                }
                throw new MatchError(x0$2);
            }
            {
                this.raster$1 = raster$1;
                this.ncols$1 = ncols$1;
                this.nrows$1 = nrows$1;
            }
        })).map((Function1)new Serializable(raster, center, distances){
            public static final long serialVersionUID = 0L;
            private final Tile raster$1;
            private final int center$1;
            private final Map distances$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Tuple2<Object, Object>> x0$3) {
                if (x0$3 != null) {
                    Double d = BoxesRunTime.boxToDouble((double)((double)(this.center$1 - this.raster$1.get(((Tuple2)x0$3._2())._1$mcI$sp(), ((Tuple2)x0$3._2())._2$mcI$sp())) / BoxesRunTime.unboxToDouble((Object)this.distances$1.apply((Object)BoxesRunTime.boxToInteger((int)x0$3._1$mcI$sp())))));
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x0$3._1$mcI$sp()));
                    Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                    return new Tuple2(object, (Object)d);
                }
                throw new MatchError(x0$3);
            }
            {
                this.raster$1 = raster$1;
                this.center$1 = center$1;
                this.distances$1 = distances$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public boolean isSink(int c, int r, Tile raster) {
        return BoxesRunTime.unboxToBoolean((Object)this.getNeighbors(c, r, raster).values().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$3, double x$4) {
                return x$3 && x$4 < 0.0;
            }
        }));
    }

    public Tile apply(Tile raster) {
        Tuple2<Object, Object> tuple2 = raster.dimensions();
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
            int cols = sp2._1$mcI$sp();
            int rows = sp2._2$mcI$sp();
            IntArrayTile tile = IntArrayTile$.MODULE$.apply((int[])Array$.MODULE$.ofDim(rows * cols, ClassTag$.MODULE$.Int()), cols, rows);
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    if (raster.get(c, r) == Integer.MIN_VALUE || this.isSink(c, r, raster)) {
                        tile.set(c, r, Integer.MIN_VALUE);
                        continue;
                    }
                    tile.set(c, r, this.flow(c, r, raster));
                }
            }
            return tile;
        }
        throw new MatchError(tuple2);
    }

    private FlowDirection$() {
        MODULE$ = this;
    }
}

