/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.hydrology;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import geotrellis.raster.package$IntArrayFiller$;
import scala.Array$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayStack;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Accumulation$ {
    public static final Accumulation$ MODULE$;

    static {
        new Accumulation$();
    }

    public boolean doesFlow(int value, int dir) {
        return value < dir ? false : (value >> (int)scala.math.package$.MODULE$.floor(scala.math.package$.MODULE$.log((double)dir) / scala.math.package$.MODULE$.log(2.0))) % 2 == 1;
    }

    public void calcAcc(int column, int row, IntArrayTile data, Tile flowDirrection) {
        int c = column;
        int r = row;
        int sum = data.get(column, row);
        int cols = data.cols();
        int rows = data.rows();
        Tuple2[] tuple2Array = new Tuple2[8];
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(column + 1, row);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)16));
        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[0] = new Tuple2(object, (Object)sp2);
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(column + 1, row + 1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)32));
        Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[1] = new Tuple2(object2, (Object)sp3);
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(column, row + 1);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)64));
        Predef.ArrowAssoc$ arrowAssoc$3 = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[2] = new Tuple2(object3, (Object)sp4);
        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(column - 1, row + 1);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)128));
        Predef.ArrowAssoc$ arrowAssoc$4 = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[3] = new Tuple2(object4, (Object)sp5);
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(column - 1, row);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        Predef.ArrowAssoc$ arrowAssoc$5 = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[4] = new Tuple2(object5, (Object)sp6);
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(column - 1, row - 1);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        Predef.ArrowAssoc$ arrowAssoc$6 = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[5] = new Tuple2(object6, (Object)sp7);
        Tuple2.mcII.sp sp8 = new Tuple2.mcII.sp(column, row - 1);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        Predef.ArrowAssoc$ arrowAssoc$7 = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[6] = new Tuple2(object7, (Object)sp8);
        Tuple2.mcII.sp sp9 = new Tuple2.mcII.sp(column + 1, row - 1);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8));
        Predef.ArrowAssoc$ arrowAssoc$8 = Predef.ArrowAssoc$.MODULE$;
        tuple2Array[7] = new Tuple2(object8, (Object)sp9);
        Map map2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        if (sum == -1) {
            ArrayStack stack = new ArrayStack();
            stack.push((Object)new Tuple2.mcII.sp(column, row));
            stack.push((Object)new Tuple2.mcII.sp(column, row));
            while (!stack.isEmpty() || data.get(c, r) == -1) {
                sum = 0;
                boolean flag = false;
                Tuple2 n = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)16));
                if (c + 1 < cols && this.doesFlow(flowDirrection.get(n._1$mcI$sp(), n._2$mcI$sp()), 16)) {
                    if (data.get(n._1$mcI$sp(), n._2$mcI$sp()) == -1) {
                        stack.push((Object)n);
                        flag = true;
                    } else {
                        sum = 0 + data.get(n._1$mcI$sp(), n._2$mcI$sp());
                    }
                }
                n = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)32));
                if (c + 1 < cols && r + 1 < rows && this.doesFlow(flowDirrection.get(n._1$mcI$sp(), n._2$mcI$sp()), 32)) {
                    if (data.get(n._1$mcI$sp(), n._2$mcI$sp()) == -1) {
                        stack.push((Object)n);
                        flag = true;
                    } else {
                        sum += data.get(n._1$mcI$sp(), n._2$mcI$sp()) + 1;
                    }
                }
                n = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)64));
                if (r + 1 < rows && this.doesFlow(flowDirrection.get(c, r + 1), 64)) {
                    if (data.get(n._1$mcI$sp(), n._2$mcI$sp()) == -1) {
                        stack.push((Object)n);
                        flag = true;
                    } else {
                        sum += data.get(n._1$mcI$sp(), n._2$mcI$sp()) + 1;
                    }
                }
                Tuple2 cfr_ignored_0 = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)128));
                n = null;
                if (c - 1 >= 0 && r + 1 < rows && this.doesFlow(flowDirrection.get(c - 1, r + 1), 128)) {
                    if (data.get(c - 1, r + 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c - 1, r + 1));
                        flag = true;
                    } else {
                        sum += data.get(c - 1, r + 1) + 1;
                    }
                }
                Tuple2 cfr_ignored_1 = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)1));
                if (c - 1 >= 0 && this.doesFlow(flowDirrection.get(c - 1, r), 1)) {
                    if (data.get(c - 1, r) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c - 1, r));
                        flag = true;
                    } else {
                        sum += data.get(c - 1, r) + 1;
                    }
                }
                Tuple2 cfr_ignored_2 = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)2));
                if (c - 1 >= 0 && r - 1 >= 0 && this.doesFlow(flowDirrection.get(c - 1, r - 1), 2)) {
                    if (data.get(c - 1, r - 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c - 1, r - 1));
                        flag = true;
                    } else {
                        sum += data.get(c - 1, r - 1) + 1;
                    }
                }
                Tuple2 cfr_ignored_3 = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)4));
                if (r - 1 >= 0 && this.doesFlow(flowDirrection.get(c, r - 1), 4)) {
                    if (data.get(c, r - 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c, r - 1));
                        flag = true;
                    } else {
                        sum += data.get(c, r - 1) + 1;
                    }
                }
                Tuple2 cfr_ignored_4 = (Tuple2)map2.apply((Object)BoxesRunTime.boxToInteger((int)8));
                if (c + 1 < cols && r - 1 >= 0 && this.doesFlow(flowDirrection.get(c + 1, r - 1), 8)) {
                    if (data.get(c + 1, r - 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c + 1, r - 1));
                        flag = true;
                    } else {
                        sum += data.get(c + 1, r - 1) + 1;
                    }
                }
                if (!flag) {
                    data.set(c, r, sum);
                }
                if (stack.isEmpty()) continue;
                Tuple2 t = (Tuple2)stack.pop();
                c = t._1$mcI$sp();
                r = t._2$mcI$sp();
            }
        }
    }

    public Tile apply(Tile flowDirrection) {
        int cols = flowDirrection.cols();
        int rows = flowDirrection.rows();
        IntArrayTile tile = IntArrayTile$.MODULE$.apply(package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int())), -1), cols, rows);
        for (int index$macro$183 = 0; index$macro$183 < rows; ++index$macro$183) {
            for (int index$macro$182 = 0; index$macro$182 < cols; ++index$macro$182) {
                this.calcAcc(index$macro$182, index$macro$183, tile, flowDirrection);
            }
        }
        return tile;
    }

    private Accumulation$() {
        MODULE$ = this;
    }
}

