/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.histogram;

import geotrellis.raster.histogram.IntHistogram;
import geotrellis.raster.summary.Statistics$mcI$sp;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class IntHistogram$class {
    public static void foreach(IntHistogram $this, Function2 f) {
        $this.foreach$mcI$sp((Function2<Object, Object, BoxedUnit>)f);
    }

    public static Option mode(IntHistogram $this) {
        if ($this.totalCount() == 0L) {
            return None$.MODULE$;
        }
        int[] localValues = $this.values$mcI$sp();
        int mode2 = localValues[0];
        long count = $this.itemCount$mcI$sp(mode2);
        int len = localValues.length;
        for (int index$macro$178 = 1; index$macro$178 < len; ++index$macro$178) {
            int z = localValues[index$macro$178];
            long c = $this.itemCount$mcI$sp(z);
            if (c <= count) continue;
            count = c;
            mode2 = z;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)mode2));
    }

    public static Option median(IntHistogram $this) {
        None$ none$;
        if ($this.totalCount() == 0L) {
            none$ = None$.MODULE$;
        } else {
            int[] localValues = $this.values$mcI$sp();
            long middle = $this.totalCount() / 2L;
            long total = 0L;
            int i = 0;
            while (total <= middle) {
                total += $this.itemCount$mcI$sp(localValues[i]);
                ++i;
            }
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)localValues[i - 1]));
        }
        return none$;
    }

    public static Option mean(IntHistogram $this) {
        if ($this.totalCount() == 0L) {
            return None$.MODULE$;
        }
        int[] localValues = $this.rawValues$mcI$sp();
        double mean = 0.0;
        double total = 0.0;
        for (int value : localValues) {
            long count = $this.itemCount$mcI$sp(value);
            double delta = (double)value - mean;
            mean += (double)count * delta / (total += (double)count);
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)mean));
    }

    public static Option statistics(IntHistogram $this) {
        None$ none$;
        int[] localValues = $this.values$mcI$sp();
        if (localValues.length == 0) {
            none$ = None$.MODULE$;
        } else {
            long dataCount = 0L;
            int mode2 = 0;
            long modeCount = 0L;
            double mean = 0.0;
            long total = 0L;
            int median = 0;
            boolean needMedian = true;
            long limit = $this.totalCount() / 2L;
            int len = localValues.length;
            for (int index$macro$180 = 0; index$macro$180 < len; ++index$macro$180) {
                int value = localValues[index$macro$180];
                long count = $this.itemCount$mcI$sp(value);
                dataCount += count;
                if (count == 0L) continue;
                if (count > modeCount) {
                    mode2 = value;
                    modeCount = count;
                }
                double delta = (double)value - mean;
                mean += (double)count * delta / (double)(total += count);
                if (!needMedian || total <= limit) continue;
                median = localValues[index$macro$180];
                needMedian = false;
            }
            int zmin = localValues[0];
            int zmax = localValues[len - 1];
            total = 0L;
            double mean2 = 0.0;
            for (int index$macro$181 = 0; index$macro$181 < len; ++index$macro$181) {
                int value = localValues[index$macro$181];
                long count = $this.itemCount$mcI$sp(value);
                if (count <= 0L) continue;
                double x = (double)value - mean;
                double y = x * x;
                double delta = y - mean2;
                mean2 += (double)count * delta / (double)(total += count);
            }
            double stddev = package$.MODULE$.sqrt(mean2);
            none$ = new Some((Object)new Statistics$mcI$sp(dataCount, mean, median, mode2, stddev, zmin, zmax));
        }
        return none$;
    }

    public static void foreach$mcI$sp(IntHistogram $this, Function2 f) {
        Predef$.MODULE$.intArrayOps($this.values$mcI$sp()).foreach((Function1)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ IntHistogram $outer;
            public final Function2 f$1;

            public final void apply(int z) {
                this.f$1.apply$mcVIJ$sp(z, this.$outer.itemCount$mcI$sp(z));
            }

            public void apply$mcVI$sp(int z) {
                this.f$1.apply$mcVIJ$sp(z, this.$outer.itemCount$mcI$sp(z));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        });
    }

    public static void $init$(IntHistogram $this) {
    }
}

