/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.equalization;

import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.IntCells;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import geotrellis.raster.equalization.HistogramEqualization;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.histogram.StreamingHistogram;
import geotrellis.raster.histogram.StreamingHistogram$;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.package$;

public final class HistogramEqualization$ {
    public static final HistogramEqualization$ MODULE$;
    private final HistogramEqualization.BucketComparator geotrellis$raster$equalization$HistogramEqualization$$cmp;

    static {
        new HistogramEqualization$();
    }

    public HistogramEqualization.BucketComparator geotrellis$raster$equalization$HistogramEqualization$$cmp() {
        return this.geotrellis$raster$equalization$HistogramEqualization$$cmp;
    }

    public double intensityToCdf(DataType cellType, Tuple2<Object, Object>[] cdf2, double x) {
        double d;
        int i = Arrays.binarySearch((Object[])cdf2, new Tuple2.mcDD.sp(x, 0.0), this.geotrellis$raster$equalization$HistogramEqualization$$cmp());
        double smallestCdf = cdf2[0]._2$mcD$sp();
        if (x < cdf2[0]._1$mcD$sp()) {
            d = smallestCdf;
        } else if (-1 * i > cdf2.length) {
            d = 1.0;
        } else if (i >= 0) {
            d = cdf2[i]._2$mcD$sp();
        } else {
            int j = -1 * i - 2;
            double label0 = cdf2[j + 0]._1$mcD$sp();
            double label1 = cdf2[j + 1]._1$mcD$sp();
            double t = (x - label0) / (label1 - label0);
            double cdf0 = cdf2[j + 0]._2$mcD$sp();
            double cdf1 = cdf2[j + 1]._2$mcD$sp();
            d = (1.0 - t) * cdf0 + t * cdf1;
        }
        double rawCdf = d;
        return package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, (rawCdf - smallestCdf) / (1.0 - smallestCdf)));
    }

    public double toIntensity(DataType cellType, double x) {
        block6: {
            double d;
            block3: {
                int bits;
                block5: {
                    block4: {
                        block2: {
                            bits = cellType.bits();
                            if (!(cellType instanceof FloatCells)) break block2;
                            d = 3.4028234663852886E38 * ((double)2 * x - 1.0);
                            break block3;
                        }
                        if (!(cellType instanceof DoubleCells)) break block4;
                        d = Double.MAX_VALUE * ((double)2 * x - 1.0);
                        break block3;
                    }
                    boolean bl = cellType instanceof BitCells ? true : (cellType instanceof UByteCells ? true : cellType instanceof UShortCells);
                    if (!bl) break block5;
                    d = (double)((1 << bits) - 1) * x;
                    break block3;
                }
                boolean bl = cellType instanceof ByteCells ? true : (cellType instanceof ShortCells ? true : cellType instanceof IntCells);
                if (!bl) break block6;
                d = (double)((1 << bits) - 1) * x - (double)(1 << bits - 1);
            }
            return d;
        }
        throw new MatchError((Object)cellType);
    }

    public double geotrellis$raster$equalization$HistogramEqualization$$transform(DataType cellType, Function1<Object, Object> fn, double x) {
        return this.toIntensity(cellType, fn.apply$mcDD$sp(x));
    }

    public Tile apply(Tile tile) {
        StreamingHistogram histogram2 = StreamingHistogram$.MODULE$.fromTile(tile, 131072);
        return this.apply(tile, histogram2);
    }

    public <T> Tile apply(Tile tile, Histogram<T> histogram2) {
        DataType dataType = tile.cellType();
        Tuple2<Object, Object>[] tuple2Array = histogram2.cdf();
        Serializable localIntensityToCdf = new Serializable(dataType, tuple2Array){
            public static final long serialVersionUID = 0L;
            public final DataType eta$0$1$1;
            public final Tuple2[] eta$1$1$1;

            public final double apply(double x) {
                double d;
                Tuple2[] tuple2Array = this.eta$1$1$1;
                HistogramEqualization$ histogramEqualization$ = HistogramEqualization$.MODULE$;
                int i1 = Arrays.binarySearch((Object[])tuple2Array, new Tuple2.mcDD.sp(x, 0.0), histogramEqualization$.geotrellis$raster$equalization$HistogramEqualization$$cmp());
                double smallestCdf1 = tuple2Array[0]._2$mcD$sp();
                if (x < tuple2Array[0]._1$mcD$sp()) {
                    d = smallestCdf1;
                } else if (-1 * i1 > tuple2Array.length) {
                    d = 1.0;
                } else if (i1 >= 0) {
                    d = tuple2Array[i1]._2$mcD$sp();
                } else {
                    int j1 = -1 * i1 - 2;
                    double label01 = tuple2Array[j1 + 0]._1$mcD$sp();
                    double label11 = tuple2Array[j1 + 1]._1$mcD$sp();
                    double t1 = (x - label01) / (label11 - label01);
                    double cdf01 = tuple2Array[j1 + 0]._2$mcD$sp();
                    double cdf11 = tuple2Array[j1 + 1]._2$mcD$sp();
                    d = (1.0 - t1) * cdf01 + t1 * cdf11;
                }
                double rawCdf1 = d;
                return package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, (rawCdf1 - smallestCdf1) / (1.0 - smallestCdf1)));
            }

            public double apply$mcDD$sp(double x) {
                double d;
                Tuple2[] tuple2Array = this.eta$1$1$1;
                HistogramEqualization$ histogramEqualization$ = HistogramEqualization$.MODULE$;
                int i1 = Arrays.binarySearch((Object[])tuple2Array, new Tuple2.mcDD.sp(x, 0.0), histogramEqualization$.geotrellis$raster$equalization$HistogramEqualization$$cmp());
                double smallestCdf1 = tuple2Array[0]._2$mcD$sp();
                if (x < tuple2Array[0]._1$mcD$sp()) {
                    d = smallestCdf1;
                } else if (-1 * i1 > tuple2Array.length) {
                    d = 1.0;
                } else if (i1 >= 0) {
                    d = tuple2Array[i1]._2$mcD$sp();
                } else {
                    int j1 = -1 * i1 - 2;
                    double label01 = tuple2Array[j1 + 0]._1$mcD$sp();
                    double label11 = tuple2Array[j1 + 1]._1$mcD$sp();
                    double t1 = (x - label01) / (label11 - label01);
                    double cdf01 = tuple2Array[j1 + 0]._2$mcD$sp();
                    double cdf11 = tuple2Array[j1 + 1]._2$mcD$sp();
                    d = (1.0 - t1) * cdf01 + t1 * cdf11;
                }
                double rawCdf1 = d;
                return package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, (rawCdf1 - smallestCdf1) / (1.0 - smallestCdf1)));
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
                this.eta$1$1$1 = eta$1$1$1;
            }
        };
        DataType dataType2 = tile.cellType();
        Serializable localTransform = new Serializable((Function1)localIntensityToCdf, dataType2){
            public static final long serialVersionUID = 0L;
            public final Function1 localIntensityToCdf$1;
            public final DataType eta$0$2$1;

            public final double apply(double x) {
                DataType dataType;
                block6: {
                    double d;
                    block3: {
                        int bits1;
                        double d2;
                        block5: {
                            block4: {
                                block2: {
                                    Function1 function1 = this.localIntensityToCdf$1;
                                    dataType = this.eta$0$2$1;
                                    d2 = function1.apply$mcDD$sp(x);
                                    HistogramEqualization$ histogramEqualization$ = HistogramEqualization$.MODULE$;
                                    bits1 = dataType.bits();
                                    if (!(dataType instanceof FloatCells)) break block2;
                                    d = 3.4028234663852886E38 * ((double)2 * d2 - 1.0);
                                    break block3;
                                }
                                if (!(dataType instanceof DoubleCells)) break block4;
                                d = Double.MAX_VALUE * ((double)2 * d2 - 1.0);
                                break block3;
                            }
                            boolean bl = dataType instanceof BitCells ? true : (dataType instanceof UByteCells ? true : dataType instanceof UShortCells);
                            if (!bl) break block5;
                            d = (double)((1 << bits1) - 1) * d2;
                            break block3;
                        }
                        boolean bl = dataType instanceof ByteCells ? true : (dataType instanceof ShortCells ? true : dataType instanceof IntCells);
                        if (!bl) break block6;
                        d = (double)((1 << bits1) - 1) * d2 - (double)(1 << bits1 - 1);
                    }
                    return d;
                }
                throw new MatchError((Object)dataType);
            }

            public double apply$mcDD$sp(double x) {
                DataType dataType;
                block6: {
                    double d;
                    block3: {
                        int bits1;
                        double d2;
                        block5: {
                            block4: {
                                block2: {
                                    Function1 function1 = this.localIntensityToCdf$1;
                                    dataType = this.eta$0$2$1;
                                    d2 = function1.apply$mcDD$sp(x);
                                    HistogramEqualization$ histogramEqualization$ = HistogramEqualization$.MODULE$;
                                    bits1 = dataType.bits();
                                    if (!(dataType instanceof FloatCells)) break block2;
                                    d = 3.4028234663852886E38 * ((double)2 * d2 - 1.0);
                                    break block3;
                                }
                                if (!(dataType instanceof DoubleCells)) break block4;
                                d = Double.MAX_VALUE * ((double)2 * d2 - 1.0);
                                break block3;
                            }
                            boolean bl = dataType instanceof BitCells ? true : (dataType instanceof UByteCells ? true : dataType instanceof UShortCells);
                            if (!bl) break block5;
                            d = (double)((1 << bits1) - 1) * d2;
                            break block3;
                        }
                        boolean bl = dataType instanceof ByteCells ? true : (dataType instanceof ShortCells ? true : dataType instanceof IntCells);
                        if (!bl) break block6;
                        d = (double)((1 << bits1) - 1) * d2 - (double)(1 << bits1 - 1);
                    }
                    return d;
                }
                throw new MatchError((Object)dataType);
            }
            {
                this.localIntensityToCdf$1 = localIntensityToCdf$1;
                this.eta$0$2$1 = eta$0$2$1;
            }
        };
        return tile.mapDouble((Function1<Object, Object>)localTransform);
    }

    public MultibandTile apply(MultibandTile tile) {
        Vector histograms = (Vector)tile.bands().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StreamingHistogram apply(Tile tile) {
                return StreamingHistogram$.MODULE$.fromTile(tile, 131072);
            }
        }, Vector$.MODULE$.canBuildFrom());
        return this.apply(tile, (Seq)histograms);
    }

    public <T> MultibandTile apply(MultibandTile tile, Seq<Histogram<T>> histograms) {
        return MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)((TraversableLike)tile.bands().zip(histograms, Vector$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tile apply(Tuple2<Tile, Histogram<T>> x0$1) {
                if (x0$1 != null) {
                    return HistogramEqualization$.MODULE$.apply((Tile)x0$1._1(), (Histogram)x0$1._2());
                }
                throw new MatchError(x0$1);
            }
        }, Vector$.MODULE$.canBuildFrom())));
    }

    private HistogramEqualization$() {
        MODULE$ = this;
        this.geotrellis$raster$equalization$HistogramEqualization$$cmp = new HistogramEqualization.BucketComparator();
    }
}

