/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.crop;

import geotrellis.raster.CellGrid;
import geotrellis.raster.CroppedTile;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Raster;
import geotrellis.raster.Tile;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.Implicits$class;
import geotrellis.raster.crop.SinglebandTileCropMethods;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.package;
import geotrellis.raster.package$;
import geotrellis.vector.Extent;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;

public abstract class SinglebandTileCropMethods$class {
    /*
     * Enabled aggressive block sorting
     */
    public static Tile crop(SinglebandTileCropMethods $this, GridBounds gb, Crop.Options options) {
        Tile tile;
        Tile tile2;
        GridBounds gridBounds;
        if (options.clamp()) {
            Option<GridBounds> option = gb.intersection((CellGrid)$this.self());
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                throw new GeoAttrsError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Grid bounds do not intersect: ", " crop ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.self(), gb})));
            }
            Some some = (Some)option;
            gridBounds = (GridBounds)some.x();
        } else {
            gridBounds = gb;
        }
        GridBounds cropBounds = gridBounds;
        Tile tile3 = (Tile)$this.self();
        if (tile3 instanceof GeoTiffTile) {
            GeoTiffTile geoTiffTile = (GeoTiffTile)tile3;
            tile2 = geoTiffTile.crop(gb);
        } else {
            tile2 = new CroppedTile((Tile)$this.self(), cropBounds);
        }
        if (options.force()) {
            tile = tile2.toArrayTile();
            return tile;
        }
        tile = tile2;
        return tile;
    }

    public static Tile crop(SinglebandTileCropMethods $this, Extent srcExtent, Extent extent2, Crop.Options options) {
        return (Tile)Implicits$class.withExtentCropMethods(package$.MODULE$, new Raster<CellGrid>((CellGrid)$this.self(), srcExtent), (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final package.withTileMethods apply(Tile self) {
                return package$.MODULE$.withTileMethods(self);
            }
        }).crop(extent2, options).tile();
    }

    public static void $init$(SinglebandTileCropMethods $this) {
    }
}

