/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.costdistance;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.costdistance.CostDistance;
import geotrellis.raster.costdistance.DOption$;
import geotrellis.raster.costdistance.IOption$;
import java.util.Comparator;
import java.util.PriorityQueue;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CostDistance$ {
    public static final CostDistance$ MODULE$;
    private final CostDistance.Dir[] dirs;

    static {
        new CostDistance$();
    }

    /*
     * WARNING - void declaration
     */
    public Tile apply(Tile cost, Seq<Tuple2<Object, Object>> points) {
        Tuple2<Object, Object> tuple2 = cost.dimensions();
        if (tuple2 != null) {
            Tuple3 tuple3;
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tuple2._1$mcI$sp(), tuple2._2$mcI$sp());
            int cols = sp2._1$mcI$sp();
            int rows = sp2._2$mcI$sp();
            DoubleArrayTile output = DoubleArrayTile$.MODULE$.empty(cols, rows);
            points.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    boolean bl = check$ifrefutable$1 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(output){
                public static final long serialVersionUID = 0L;
                private final DoubleArrayTile output$1;

                public final void apply(Tuple2<Object, Object> x$2) {
                    if (x$2 != null) {
                        this.output$1.setDouble(x$2._1$mcI$sp(), x$2._2$mcI$sp(), 0.0);
                        return;
                    }
                    throw new MatchError(x$2);
                }
                {
                    this.output$1 = output$1;
                }
            });
            PriorityQueue<Tuple3<Object, Object, Object>> pqueue = new PriorityQueue<Tuple3<Object, Object, Object>>(1000, new Comparator<Tuple3<Object, Object, Object>>(){

                public boolean equals(Object a) {
                    return a.equals(this);
                }

                public int compare(Tuple3<Object, Object, Object> a, Tuple3<Object, Object, Object> b) {
                    return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)a._3())).compareTo(Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)b._3())));
                }
            });
            points.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                    boolean bl = check$ifrefutable$2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(cost, output, pqueue){
                public static final long serialVersionUID = 0L;
                private final Tile cost$1;
                private final DoubleArrayTile output$1;
                private final PriorityQueue pqueue$1;

                public final void apply(Tuple2<Object, Object> x$3) {
                    if (x$3 != null) {
                        CostDistance$.MODULE$.geotrellis$raster$costdistance$CostDistance$$calcNeighbors(x$3._1$mcI$sp(), x$3._2$mcI$sp(), this.cost$1, this.output$1, this.pqueue$1);
                        return;
                    }
                    throw new MatchError(x$3);
                }
                {
                    this.cost$1 = cost$1;
                    this.output$1 = output$1;
                    this.pqueue$1 = pqueue$1;
                }
            });
            while (true) {
                void var11_7;
                void var12_8;
                if (pqueue.isEmpty()) {
                    return output;
                }
                tuple3 = (Tuple3)var12_8.poll();
                if (tuple3 == null) break;
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                int c = BoxesRunTime.unboxToInt((Object)tuple32._1());
                int r = BoxesRunTime.unboxToInt((Object)tuple32._2());
                double v = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                if (v != var11_7.getDouble(c, r)) continue;
                this.geotrellis$raster$costdistance$CostDistance$$calcNeighbors(c, r, cost, (DoubleArrayTile)var11_7, (PriorityQueue<Tuple3<Object, Object, Object>>)var12_8);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError(tuple2);
    }

    private boolean isValid(int c, int r, Tile cost) {
        return c >= 0 && r >= 0 && c < cost.cols() && r < cost.rows();
    }

    public CostDistance.Dir[] dirs() {
        return this.dirs;
    }

    private Option<Tuple3<Object, Object, Object>> calcCostCell(int c, int r, CostDistance.Dir dir, Tile cost, DoubleArrayTile d) {
        None$ none$;
        Tuple2<Object, Object> cr = dir.apply(c, r);
        if (this.isValid(cr._1$mcI$sp(), cr._2$mcI$sp(), cost)) {
            double prev = d.getDouble(cr._1$mcI$sp(), cr._2$mcI$sp());
            if (prev == 0.0) {
                none$ = None$.MODULE$;
            } else {
                double source = d.getDouble(c, r);
                double prevCost = Double.isNaN(prev) ? Double.MAX_VALUE : prev;
                double curMinCost = Double.MAX_VALUE;
                double baseCostOpt = this.calcCost(c, r, dir, cost);
                if (DOption$.MODULE$.isDefined$extension(baseCostOpt)) {
                    curMinCost = source + DOption$.MODULE$.get$extension(baseCostOpt);
                }
                for (Tuple2<Object, Object> p : dir.cornerOffsets()) {
                    double cost2;
                    int r1;
                    int c1 = p._1$mcI$sp() + c;
                    double cost1 = this.calcCost(c, r, c1, r1 = p._2$mcI$sp() + r, cost);
                    if (!DOption$.MODULE$.isDefined$extension(cost1) || !DOption$.MODULE$.isDefined$extension(cost2 = this.calcCost(c1, r1, dir.apply(c, r), cost))) continue;
                    curMinCost = package$.MODULE$.min(curMinCost, source + DOption$.MODULE$.get$extension(cost1) + DOption$.MODULE$.get$extension(cost2));
                }
                if (curMinCost == Double.MAX_VALUE) {
                    none$ = None$.MODULE$;
                } else if (curMinCost < prevCost) {
                    d.setDouble(cr._1$mcI$sp(), cr._2$mcI$sp(), curMinCost);
                    none$ = new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)cr._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)cr._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)curMinCost)));
                } else {
                    none$ = None$.MODULE$;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void geotrellis$raster$costdistance$CostDistance$$calcNeighbors(int c, int r, Tile cost, DoubleArrayTile d, PriorityQueue<Tuple3<Object, Object, Object>> p) {
        int l = this.dirs().length;
        for (int z = 0; z < l; ++z) {
            Option<Tuple3<Object, Object, Object>> opt = this.calcCostCell(c, r, this.dirs()[z], cost, d);
            Object object = opt.isDefined() ? BoxesRunTime.boxToBoolean((boolean)p.add((Tuple3<Object, Object, Object>)opt.get())) : BoxedUnit.UNIT;
        }
    }

    private double factor(int c, int r, int c1, int r1) {
        return c == c1 || r == r1 ? 1.0 : 1.41421356237;
    }

    private int safeGet(int c, int r, Tile cost) {
        return IOption$.MODULE$.apply(cost.get(c, r));
    }

    private double calcCost(int c, int r, int c2, int r2, Tile cost) {
        int cost1 = this.safeGet(c, r, cost);
        int cost2 = this.safeGet(c2, r2, cost);
        return IOption$.MODULE$.isDefined$extension(cost1) && IOption$.MODULE$.isDefined$extension(cost2) ? DOption$.MODULE$.apply(this.factor(c, r, c2, r2) * (double)(IOption$.MODULE$.get$extension(cost1) + IOption$.MODULE$.get$extension(cost2)) / 2.0) : DOption$.MODULE$.None();
    }

    private double calcCost(int c, int r, Tuple2<Object, Object> cr2, Tile cost) {
        return this.calcCost(c, r, cr2._1$mcI$sp(), cr2._2$mcI$sp(), cost);
    }

    private double calcCost(int c, int r, CostDistance.Dir dir, Tile cost) {
        return this.calcCost(c, r, dir.apply(c, r), cost);
    }

    private CostDistance$() {
        MODULE$ = this;
        this.dirs = (CostDistance.Dir[])Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2.mcII.sp(-1, -1), new Tuple2.mcII.sp(0, -1), new Tuple2.mcII.sp(1, -1), new Tuple2.mcII.sp(-1, 0), new Tuple2.mcII.sp(1, 0), new Tuple2.mcII.sp(-1, 1), new Tuple2.mcII.sp(0, 1), new Tuple2.mcII.sp(1, 1)}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CostDistance.Dir apply(Tuple2<Object, Object> x0$1) {
                if (x0$1 != null) {
                    return new CostDistance.Dir(x0$1._1$mcI$sp(), x0$1._2$mcI$sp());
                }
                throw new MatchError(x0$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CostDistance.Dir.class)));
    }
}

