/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$class;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.MutableArrayTile$class;
import geotrellis.raster.ShortArrayTile$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import geotrellis.raster.UShortArrayTile$;
import geotrellis.raster.UShortCells;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055e!B\u0001\u0003\u0003\u00039!aD+TQ>\u0014H/\u0011:sCf$\u0016\u000e\\3\u000b\u0005\r!\u0011A\u0002:bgR,'OC\u0001\u0006\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!\u0001E'vi\u0006\u0014G.Z!se\u0006LH+\u001b7f\u0011!\u0019\u0002A!b\u0001\n\u0003!\u0012!B1se\u0006LX#A\u000b\u0011\u0007%1\u0002$\u0003\u0002\u0018\u0015\t)\u0011I\u001d:bsB\u0011\u0011\"G\u0005\u00035)\u0011Qa\u00155peRD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0007CJ\u0014\u0018-\u001f\u0011\t\u0011y\u0001!\u0011!Q\u0001\n}\tAaY8mgB\u0011\u0011\u0002I\u0005\u0003C)\u00111!\u00138u\u0011!\u0019\u0003A!A!\u0002\u0013y\u0012\u0001\u0002:poNDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtD\u0003B\u0014)S)\u0002\"a\u0004\u0001\t\u000bM!\u0003\u0019A\u000b\t\u000by!\u0003\u0019A\u0010\t\u000b\r\"\u0003\u0019A\u0010\t\u000f1\u0002!\u0019!D\u0001[\u0005A1-\u001a7m)f\u0004X-F\u0001/%\ry\u0013\u0007\u000e\u0004\u0005a\u0001\u0001aF\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002\u0010e%\u00111G\u0001\u0002\f+NCwN\u001d;DK2d7\u000f\u0005\u0002\u0010k%\u0011aG\u0001\u0002\u000f\u001d>$\u0015\r^1IC:$G.\u001b8h\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u001d!xNQ=uKN$\u0012A\u000f\t\u0004\u0013YY\u0004CA\u0005=\u0013\ti$B\u0001\u0003CsR,\u0007\"B \u0001\t\u0003\u0001\u0015\u0001B2paf,\u0012a\n\u0005\u0006\u0005\u0002!\taQ\u0001\u000bo&$\bNT8ECR\fGC\u0001#H!\tyQ)\u0003\u0002G\u0005\t!A+\u001b7f\u0011\u0015A\u0015\t1\u0001J\u0003-qw\u000eR1uCZ\u000bG.^3\u0011\u0007%QE*\u0003\u0002L\u0015\t1q\n\u001d;j_:\u0004\"!C'\n\u00059S!A\u0002#pk\ndW\rC\u0003Q\u0001\u0011\u0005\u0011+A\u0006j]R,'\u000f\u001d:fi\u0006\u001bHC\u0001#S\u0011\u0015\u0019v\n1\u0001U\u0003-qWm^\"fY2$\u0016\u0010]3\u0011\u0005UCfBA\bW\u0013\t9&!A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&\u0001C\"fY2$\u0016\u0010]3\u000b\u0005]\u0013q!\u0002/\u0003\u0011\u0003i\u0016aD+TQ>\u0014H/\u0011:sCf$\u0016\u000e\\3\u0011\u0005=qf!B\u0001\u0003\u0011\u0003y6c\u00010\tAB\u0011\u0011\"Y\u0005\u0003E*\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ!\n0\u0005\u0002\u0011$\u0012!\u0018\u0005\u0006Mz#\taZ\u0001\u0006CB\u0004H.\u001f\u000b\u0005O!T7\u000eC\u0003jK\u0002\u0007Q#A\u0002beJDQAH3A\u0002}AQaI3A\u0002}AQA\u001a0\u0005\u00025$Ra\n8paFDQ!\u001b7A\u0002UAQA\b7A\u0002}AQa\t7A\u0002}AQ\u0001\f7A\u0002I\u00142a]\u00195\r\u0011\u0001d\f\u0001:\t\u000b\u0019tF\u0011A;\u0015\u000b\u001d2x\u000f_=\t\u000b%$\b\u0019A\u000b\t\u000by!\b\u0019A\u0010\t\u000b\r\"\b\u0019A\u0010\t\u000b!#\b\u0019\u0001>\u0011\u0007%Q\u0005\u0004C\u0003g=\u0012\u0005A\u0010\u0006\u0004({z|\u0018\u0011\u0001\u0005\u0006Sn\u0004\r!\u0006\u0005\u0006=m\u0004\ra\b\u0005\u0006Gm\u0004\ra\b\u0005\u0006\u0011n\u0004\r\u0001\u0007\u0005\b\u0003\u000bqF\u0011AA\u0004\u0003\u0015yg\rR5n)\u00159\u0013\u0011BA\u0006\u0011\u0019q\u00121\u0001a\u0001?!11%a\u0001A\u0002}Aq!!\u0002_\t\u0003\ty\u0001F\u0004(\u0003#\t\u0019\"!\u0006\t\ry\ti\u00011\u0001 \u0011\u0019\u0019\u0013Q\u0002a\u0001?!9A&!\u0004A\u0002\u0005]!\u0003BA\rcQ2Q\u0001\r0\u0001\u0003/Aq!!\b_\t\u0003\ty\"A\u0003f[B$\u0018\u0010F\u0003(\u0003C\t\u0019\u0003\u0003\u0004\u001f\u00037\u0001\ra\b\u0005\u0007G\u0005m\u0001\u0019A\u0010\t\u000f\u0005ua\f\"\u0001\u0002(Q9q%!\u000b\u0002,\u00055\u0002B\u0002\u0010\u0002&\u0001\u0007q\u0004\u0003\u0004$\u0003K\u0001\ra\b\u0005\bY\u0005\u0015\u0002\u0019AA\u0018%\u0011\t\t$\r\u001b\u0007\u000bAr\u0006!a\f\t\u000f\u0005Ub\f\"\u0001\u00028\u0005!a-\u001b7m)\u001d9\u0013\u0011HA\u001f\u0003\u007fAq!a\u000f\u00024\u0001\u0007\u0001$A\u0001w\u0011\u0019q\u00121\u0007a\u0001?!11%a\rA\u0002}Aq!!\u000e_\t\u0003\t\u0019\u0005F\u0005(\u0003\u000b\n9%!\u0013\u0002L!9\u00111HA!\u0001\u0004A\u0002B\u0002\u0010\u0002B\u0001\u0007q\u0004\u0003\u0004$\u0003\u0003\u0002\ra\b\u0005\bY\u0005\u0005\u0003\u0019AA'%\u0011\ty%\r\u001b\u0007\u000bAr\u0006!!\u0014\t\u000f\u0005Mc\f\"\u0003\u0002V\u0005\u00192m\u001c8tiJ,8\r^*i_J$\u0018I\u001d:bsR\u0019Q#a\u0016\t\u000f\u0005e\u0013\u0011\u000ba\u0001u\u0005)!-\u001f;fg\"9\u0011Q\f0\u0005\u0002\u0005}\u0013!\u00034s_6\u0014\u0015\u0010^3t)\u001d9\u0013\u0011MA2\u0003KBq!!\u0017\u0002\\\u0001\u0007!\b\u0003\u0004\u001f\u00037\u0002\ra\b\u0005\u0007G\u0005m\u0003\u0019A\u0010\t\u000f\u0005uc\f\"\u0001\u0002jQIq%a\u001b\u0002n\u0005=\u0014\u0011\u000f\u0005\b\u00033\n9\u00071\u0001;\u0011\u0019q\u0012q\ra\u0001?!11%a\u001aA\u0002}Aq\u0001LA4\u0001\u0004\t\u0019H\u0005\u0003\u0002vE\"d!\u0002\u0019_\u0001\u0005M\u0004\"CA==\u0006\u0005I\u0011BA>\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0005Y\u0006twM\u0003\u0002\u0002\b\u0006!!.\u0019<b\u0013\u0011\tY)!!\u0003\r=\u0013'.Z2u\u0001")
public abstract class UShortArrayTile
implements MutableArrayTile {
    private final short[] array;
    private final int cols;
    private final int rows;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static UShortArrayTile fromBytes(byte[] byArray, int n, int n2, UShortCells uShortCells) {
        return UShortArrayTile$.MODULE$.fromBytes(byArray, n, n2, uShortCells);
    }

    public static UShortArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return UShortArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static UShortArrayTile fill(short s, int n, int n2, UShortCells uShortCells) {
        return UShortArrayTile$.MODULE$.fill(s, n, n2, uShortCells);
    }

    public static UShortArrayTile fill(short s, int n, int n2) {
        return UShortArrayTile$.MODULE$.fill(s, n, n2);
    }

    public static UShortArrayTile empty(int n, int n2, UShortCells uShortCells) {
        return UShortArrayTile$.MODULE$.empty(n, n2, uShortCells);
    }

    public static UShortArrayTile empty(int n, int n2) {
        return UShortArrayTile$.MODULE$.empty(n, n2);
    }

    public static UShortArrayTile ofDim(int n, int n2, UShortCells uShortCells) {
        return UShortArrayTile$.MODULE$.ofDim(n, n2, uShortCells);
    }

    public static UShortArrayTile ofDim(int n, int n2) {
        return UShortArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile$class.mutable(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile$class.set(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile$class.setDouble(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update2) {
        MutableArrayTile$class.update(this, colOffset, rowOffset, update2);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile$class.toArrayTile(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile$class.convert(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreach(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreachDouble(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile$class.foreachIntVisitor(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile$class.foreachDoubleVisitor(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile$class.map(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile$class.mapDouble(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile$class.mapIntMapper(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile$class.mapDoubleMapper(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile$class.equals(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile$class.get(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile$class.getDouble(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile$class.toList(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile$class.toListDouble(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile$class.toArray(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile$class.toArrayDouble(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDraw() {
        return Tile$class.asciiDraw(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        UShortArrayTile uShortArrayTile = this;
        synchronized (uShortArrayTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    public short[] array() {
        return this.array;
    }

    public abstract UShortCells cellType();

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] pixels = new byte[this.array().length * ((DataType)((Object)this.cellType())).bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(pixels);
        bytebuff.asShortBuffer().put(this.array());
        return var1_1;
    }

    @Override
    public UShortArrayTile copy() {
        return UShortArrayTile$.MODULE$.apply((short[])this.array().clone(), this.cols, this.rows);
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return UShortArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        if (newCellType instanceof ShortCells) {
            ShortCells shortCells = (ShortCells)((Object)newCellType);
            tile = ShortArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, shortCells);
        } else if (newCellType instanceof UShortCells) {
            UShortCells uShortCells = (UShortCells)((Object)newCellType);
            tile = UShortArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, uShortCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public UShortArrayTile(short[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        ArrayTile$class.$init$(this);
        MutableArrayTile$class.$init$(this);
    }
}

