/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.ArrayTile$class;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.MutableArrayTile$class;
import geotrellis.raster.ShortArrayTile$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import geotrellis.raster.UShortArrayTile$;
import geotrellis.raster.UShortCells;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0003\u00039!AD*i_J$\u0018I\u001d:bsRKG.\u001a\u0006\u0003\u0007\u0011\taA]1ti\u0016\u0014(\"A\u0003\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0001#T;uC\ndW-\u0011:sCf$\u0016\u000e\\3\t\u0011M\u0001!Q1A\u0005\u0002Q\tQ!\u0019:sCf,\u0012!\u0006\t\u0004\u0013YA\u0012BA\f\u000b\u0005\u0015\t%O]1z!\tI\u0011$\u0003\u0002\u001b\u0015\t)1\u000b[8si\"AA\u0004\u0001B\u0001B\u0003%Q#\u0001\u0004beJ\f\u0017\u0010\t\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005!1m\u001c7t!\tI\u0001%\u0003\u0002\"\u0015\t\u0019\u0011J\u001c;\t\u0011\r\u0002!\u0011!Q\u0001\n}\tAA]8xg\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"Ba\n\u0015*UA\u0011q\u0002\u0001\u0005\u0006'\u0011\u0002\r!\u0006\u0005\u0006=\u0011\u0002\ra\b\u0005\u0006G\u0011\u0002\ra\b\u0005\bY\u0001\u0011\rQ\"\u0001.\u0003!\u0019W\r\u001c7UsB,W#\u0001\u0018\u0013\u0007=\nDG\u0002\u00031\u0001\u0001q#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA\b3\u0013\t\u0019$A\u0001\u0006TQ>\u0014HoQ3mYN\u0004\"aD\u001b\n\u0005Y\u0012!A\u0004(p\t\u0006$\u0018\rS1oI2Lgn\u001a\u0005\u0006q\u0001!\t!O\u0001\bi>\u0014\u0015\u0010^3t)\u0005Q\u0004cA\u0005\u0017wA\u0011\u0011\u0002P\u0005\u0003{)\u0011AAQ=uK\")q\b\u0001C\u0001\u0001\u0006!1m\u001c9z+\u0005\t\u0005CA\bC\u0013\t\u0019%AA\u0005BeJ\f\u0017\u0010V5mK\")Q\t\u0001C\u0001\r\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005\u001dS\u0005CA\bI\u0013\tI%A\u0001\u0003US2,\u0007\"B&E\u0001\u0004a\u0015a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!C'P\u0013\tq%B\u0001\u0004PaRLwN\u001c\t\u0003\u0013AK!!\u0015\u0006\u0003\r\u0011{WO\u00197f\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003-Ig\u000e^3saJ,G/Q:\u0015\u0005\u001d+\u0006\"\u0002,S\u0001\u00049\u0016a\u00038fo\u000e+G\u000e\u001c+za\u0016\u0004\"\u0001W.\u000f\u0005=I\u0016B\u0001.\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0011\r+G\u000e\u001c+za\u0016T!A\u0017\u0002\b\u000b}\u0013\u0001\u0012\u00011\u0002\u001dMCwN\u001d;BeJ\f\u0017\u0010V5mKB\u0011q\"\u0019\u0004\u0006\u0003\tA\tAY\n\u0004C\"\u0019\u0007CA\u0005e\u0013\t)'B\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003&C\u0012\u0005q\rF\u0001a\u0011\u0015I\u0017\r\"\u0001k\u0003\u0015\t\u0007\u000f\u001d7z)\u001193.\u001c8\t\u000b1D\u0007\u0019A\u000b\u0002\u0007\u0005\u0014(\u000fC\u0003\u001fQ\u0002\u0007q\u0004C\u0003$Q\u0002\u0007q\u0004C\u0003jC\u0012\u0005\u0001\u000fF\u0003(cJ\u001cH\u000fC\u0003m_\u0002\u0007Q\u0003C\u0003\u001f_\u0002\u0007q\u0004C\u0003$_\u0002\u0007q\u0004C\u0003-_\u0002\u0007QOE\u0002wcQ2A\u0001M1\u0001k\")\u0011.\u0019C\u0001qR)q%\u001f>|y\")An\u001ea\u0001+!)ad\u001ea\u0001?!)1e\u001ea\u0001?!)1j\u001ea\u0001{B\u0019\u0011\"\u0014\r\t\u000b%\fG\u0011A@\u0015\u0013\u001d\n\t!a\u0001\u0002\u0006\u0005\u001d\u0001\"\u00027\u007f\u0001\u0004)\u0002\"\u0002\u0010\u007f\u0001\u0004y\u0002\"B\u0012\u007f\u0001\u0004y\u0002\"B&\u007f\u0001\u0004A\u0002bBA\u0006C\u0012\u0005\u0011QB\u0001\u0006_\u001a$\u0015.\u001c\u000b\u0006O\u0005=\u0011\u0011\u0003\u0005\u0007=\u0005%\u0001\u0019A\u0010\t\r\r\nI\u00011\u0001 \u0011\u001d\tY!\u0019C\u0001\u0003+!raJA\f\u00033\tY\u0002\u0003\u0004\u001f\u0003'\u0001\ra\b\u0005\u0007G\u0005M\u0001\u0019A\u0010\t\u000f1\n\u0019\u00021\u0001\u0002\u001eI!\u0011qD\u00195\r\u0015\u0001\u0014\rAA\u000f\u0011\u001d\t\u0019#\u0019C\u0001\u0003K\tQ!Z7qif$RaJA\u0014\u0003SAaAHA\u0011\u0001\u0004y\u0002BB\u0012\u0002\"\u0001\u0007q\u0004C\u0004\u0002$\u0005$\t!!\f\u0015\u000f\u001d\ny#!\r\u00024!1a$a\u000bA\u0002}AaaIA\u0016\u0001\u0004y\u0002b\u0002\u0017\u0002,\u0001\u0007\u0011Q\u0007\n\u0005\u0003o\tDGB\u00031C\u0002\t)\u0004C\u0004\u0002<\u0005$\t!!\u0010\u0002\t\u0019LG\u000e\u001c\u000b\bO\u0005}\u00121IA#\u0011\u001d\t\t%!\u000fA\u0002a\t\u0011A\u001e\u0005\u0007=\u0005e\u0002\u0019A\u0010\t\r\r\nI\u00041\u0001 \u0011\u001d\tY$\u0019C\u0001\u0003\u0013\"\u0012bJA&\u0003\u001b\ny%!\u0015\t\u000f\u0005\u0005\u0013q\ta\u00011!1a$a\u0012A\u0002}AaaIA$\u0001\u0004y\u0002b\u0002\u0017\u0002H\u0001\u0007\u00111\u000b\n\u0005\u0003+\nDGB\u00031C\u0002\t\u0019\u0006C\u0004\u0002Z\u0005$I!a\u0017\u0002'\r|gn\u001d;sk\u000e$8\u000b[8si\u0006\u0013(/Y=\u0015\u0007U\ti\u0006C\u0004\u0002`\u0005]\u0003\u0019\u0001\u001e\u0002\u000b\tLH/Z:\t\u000f\u0005\r\u0014\r\"\u0001\u0002f\u0005IaM]8n\u0005f$Xm\u001d\u000b\bO\u0005\u001d\u0014\u0011NA6\u0011\u001d\ty&!\u0019A\u0002iBaAHA1\u0001\u0004y\u0002BB\u0012\u0002b\u0001\u0007q\u0004C\u0004\u0002d\u0005$\t!a\u001c\u0015\u0013\u001d\n\t(a\u001d\u0002v\u0005]\u0004bBA0\u0003[\u0002\rA\u000f\u0005\u0007=\u00055\u0004\u0019A\u0010\t\r\r\ni\u00071\u0001 \u0011\u001da\u0013Q\u000ea\u0001\u0003s\u0012B!a\u001f2i\u0019)\u0001'\u0019\u0001\u0002z!I\u0011qP1\u0002\u0002\u0013%\u0011\u0011Q\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0004B!\u0011QQAH\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015\u0001\u00027b]\u001eT!!!$\u0002\t)\fg/Y\u0005\u0005\u0003#\u000b9I\u0001\u0004PE*,7\r\u001e")
public abstract class ShortArrayTile
implements MutableArrayTile {
    private final short[] array;
    private final int cols;
    private final int rows;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static ShortArrayTile fromBytes(byte[] byArray, int n, int n2, ShortCells shortCells) {
        return ShortArrayTile$.MODULE$.fromBytes(byArray, n, n2, shortCells);
    }

    public static ShortArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return ShortArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static ShortArrayTile fill(short s, int n, int n2, ShortCells shortCells) {
        return ShortArrayTile$.MODULE$.fill(s, n, n2, shortCells);
    }

    public static ShortArrayTile fill(short s, int n, int n2) {
        return ShortArrayTile$.MODULE$.fill(s, n, n2);
    }

    public static ShortArrayTile empty(int n, int n2, ShortCells shortCells) {
        return ShortArrayTile$.MODULE$.empty(n, n2, shortCells);
    }

    public static ShortArrayTile empty(int n, int n2) {
        return ShortArrayTile$.MODULE$.empty(n, n2);
    }

    public static ShortArrayTile ofDim(int n, int n2, ShortCells shortCells) {
        return ShortArrayTile$.MODULE$.ofDim(n, n2, shortCells);
    }

    public static ShortArrayTile ofDim(int n, int n2) {
        return ShortArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile$class.mutable(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile$class.set(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile$class.setDouble(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update2) {
        MutableArrayTile$class.update(this, colOffset, rowOffset, update2);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile$class.toArrayTile(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile$class.convert(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreach(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreachDouble(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile$class.foreachIntVisitor(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile$class.foreachDoubleVisitor(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile$class.map(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile$class.mapDouble(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile$class.mapIntMapper(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile$class.mapDoubleMapper(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile$class.equals(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile$class.get(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile$class.getDouble(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile$class.toList(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile$class.toListDouble(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile$class.toArray(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile$class.toArrayDouble(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDraw() {
        return Tile$class.asciiDraw(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        ShortArrayTile shortArrayTile = this;
        synchronized (shortArrayTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    public short[] array() {
        return this.array;
    }

    public abstract ShortCells cellType();

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] pixels = new byte[this.array().length * ((DataType)((Object)this.cellType())).bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(pixels);
        bytebuff.asShortBuffer().put(this.array());
        return var1_1;
    }

    @Override
    public ArrayTile copy() {
        return ArrayTile$.MODULE$.apply((short[])this.array().clone(), this.cols, this.rows);
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return ShortArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        if (newCellType instanceof ShortCells) {
            ShortCells shortCells = (ShortCells)((Object)newCellType);
            tile = ShortArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, shortCells);
        } else if (newCellType instanceof UShortCells) {
            UShortCells uShortCells = (UShortCells)((Object)newCellType);
            tile = UShortArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, uShortCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public ShortArrayTile(short[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        ArrayTile$class.$init$(this);
        MutableArrayTile$class.$init$(this);
    }
}

