/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.ArrayTile$class;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntCells;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.MutableArrayTile$class;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0003\u00039!\u0001D%oi\u0006\u0013(/Y=US2,'BA\u0002\u0005\u0003\u0019\u0011\u0018m\u001d;fe*\tQ!\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005AiU\u000f^1cY\u0016\f%O]1z)&dW\r\u0003\u0005\u0014\u0001\t\u0015\r\u0011\"\u0001\u0015\u0003\u0015\t'O]1z+\u0005)\u0002cA\u0005\u00171%\u0011qC\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0013eI!A\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0019\t'O]1zA!Aa\u0004\u0001B\u0001B\u0003%\u0001$\u0001\u0003d_2\u001c\b\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\tI|wo\u001d\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0011*ce\n\t\u0003\u001f\u0001AQaE\u0011A\u0002UAQAH\u0011A\u0002aAQ\u0001I\u0011A\u0002aAq!\u000b\u0001C\u0002\u001b\u0005!&\u0001\u0005dK2dG+\u001f9f+\u0005Y#c\u0001\u0017/c\u0019!Q\u0006\u0001\u0001,\u00051a$/\u001a4j]\u0016lWM\u001c;?!\tyq&\u0003\u00021\u0005\tA\u0011J\u001c;DK2d7\u000f\u0005\u0002\u0010e%\u00111G\u0001\u0002\u000f\u001d>$\u0015\r^1IC:$G.\u001b8h\u0011\u0015)\u0004\u0001\"\u00117\u0003\u001d!x.\u0011:sCf$\u0012!\u0006\u0005\u0006q\u0001!\t!O\u0001\bi>\u0014\u0015\u0010^3t)\u0005Q\u0004cA\u0005\u0017wA\u0011\u0011\u0002P\u0005\u0003{)\u0011AAQ=uK\")q\b\u0001C\u0001\u0001\u0006!1m\u001c9z+\u0005\t\u0005CA\bC\u0013\t\u0019%AA\u0005BeJ\f\u0017\u0010V5mK\")Q\t\u0001C\u0001\r\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005\u001dS\u0005CA\bI\u0013\tI%A\u0001\u0003US2,\u0007\"B&E\u0001\u0004a\u0015a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!C'P\u0013\tq%B\u0001\u0004PaRLwN\u001c\t\u0003\u0013AK!!\u0015\u0006\u0003\r\u0011{WO\u00197f\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003-Ig\u000e^3saJ,G/Q:\u0015\u0005\u001d+\u0006\"\u0002,S\u0001\u00049\u0016a\u00038fo\u000e+G\u000e\u001c+za\u0016\u0004\"\u0001W.\u000f\u0005=I\u0016B\u0001.\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0011\r+G\u000e\u001c+za\u0016T!A\u0017\u0002\b\u000b}\u0013\u0001\u0012\u00011\u0002\u0019%sG/\u0011:sCf$\u0016\u000e\\3\u0011\u0005=\tg!B\u0001\u0003\u0011\u0003\u00117cA1\tGB\u0011\u0011\u0002Z\u0005\u0003K*\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAI1\u0005\u0002\u001d$\u0012\u0001\u0019\u0005\u0006S\u0006$\tA[\u0001\u0006CB\u0004H.\u001f\u000b\u0005I-lg\u000eC\u0003mQ\u0002\u0007Q#A\u0002beJDQA\b5A\u0002aAQ\u0001\t5A\u0002aAQ![1\u0005\u0002A$R\u0001J9sgRDQ\u0001\\8A\u0002UAQAH8A\u0002aAQ\u0001I8A\u0002aAQ!K8A\u0002U\u00142A\u001e\u00182\r\u0011i\u0013\rA;\t\u000b%\fG\u0011\u0001=\u0015\u000b\u0011J(p\u001f?\t\u000b1<\b\u0019A\u000b\t\u000by9\b\u0019\u0001\r\t\u000b\u0001:\b\u0019\u0001\r\t\u000b-;\b\u0019A?\u0011\u0007%i\u0005\u0004C\u0003jC\u0012\u0005q\u0010F\u0005%\u0003\u0003\t\u0019!!\u0002\u0002\b!)AN a\u0001+!)aD a\u00011!)\u0001E a\u00011!)1J a\u00011!9\u00111B1\u0005\u0002\u00055\u0011!B8g\t&lG#\u0002\u0013\u0002\u0010\u0005E\u0001B\u0002\u0010\u0002\n\u0001\u0007\u0001\u0004\u0003\u0004!\u0003\u0013\u0001\r\u0001\u0007\u0005\b\u0003\u0017\tG\u0011AA\u000b)\u001d!\u0013qCA\r\u00037AaAHA\n\u0001\u0004A\u0002B\u0002\u0011\u0002\u0014\u0001\u0007\u0001\u0004C\u0004*\u0003'\u0001\r!!\b\u0013\t\u0005}a&\r\u0004\u0006[\u0005\u0004\u0011Q\u0004\u0005\b\u0003G\tG\u0011AA\u0013\u0003\u0015)W\u000e\u001d;z)\u0015!\u0013qEA\u0015\u0011\u0019q\u0012\u0011\u0005a\u00011!1\u0001%!\tA\u0002aAq!a\tb\t\u0003\ti\u0003F\u0004%\u0003_\t\t$a\r\t\ry\tY\u00031\u0001\u0019\u0011\u0019\u0001\u00131\u0006a\u00011!9\u0011&a\u000bA\u0002\u0005U\"\u0003BA\u001c]E2Q!L1\u0001\u0003kAq!a\u000fb\t\u0003\ti$\u0001\u0003gS2dGc\u0002\u0013\u0002@\u0005\r\u0013Q\t\u0005\b\u0003\u0003\nI\u00041\u0001\u0019\u0003\u00051\bB\u0002\u0010\u0002:\u0001\u0007\u0001\u0004\u0003\u0004!\u0003s\u0001\r\u0001\u0007\u0005\b\u0003w\tG\u0011AA%)%!\u00131JA'\u0003\u001f\n\t\u0006C\u0004\u0002B\u0005\u001d\u0003\u0019\u0001\r\t\ry\t9\u00051\u0001\u0019\u0011\u0019\u0001\u0013q\ta\u00011!9\u0011&a\u0012A\u0002\u0005M#\u0003BA+]E2Q!L1\u0001\u0003'Bq!!\u0017b\t\u0013\tY&A\td_:\u001cHO];di&sG/\u0011:sCf$2!FA/\u0011\u001d\ty&a\u0016A\u0002i\nQAY=uKNDq!a\u0019b\t\u0003\t)'A\u0005ge>l')\u001f;fgR9A%a\u001a\u0002j\u0005-\u0004bBA0\u0003C\u0002\rA\u000f\u0005\u0007=\u0005\u0005\u0004\u0019\u0001\r\t\r\u0001\n\t\u00071\u0001\u0019\u0011\u001d\t\u0019'\u0019C\u0001\u0003_\"\u0012\u0002JA9\u0003g\n)(a\u001e\t\u000f\u0005}\u0013Q\u000ea\u0001u!1a$!\u001cA\u0002aAa\u0001IA7\u0001\u0004A\u0002bB\u0015\u0002n\u0001\u0007\u0011\u0011\u0010\n\u0005\u0003wr\u0013GB\u0003.C\u0002\tI\bC\u0005\u0002\u0000\u0005\f\t\u0011\"\u0003\u0002\u0002\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\u000bAA[1wC&!\u0011\u0011SAD\u0005\u0019y%M[3di\u0002")
public abstract class IntArrayTile
implements MutableArrayTile {
    private final int[] array;
    private final int cols;
    private final int rows;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static IntArrayTile fromBytes(byte[] byArray, int n, int n2, IntCells intCells) {
        return IntArrayTile$.MODULE$.fromBytes(byArray, n, n2, intCells);
    }

    public static IntArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return IntArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static IntArrayTile fill(int n, int n2, int n3, IntCells intCells) {
        return IntArrayTile$.MODULE$.fill(n, n2, n3, intCells);
    }

    public static IntArrayTile fill(int n, int n2, int n3) {
        return IntArrayTile$.MODULE$.fill(n, n2, n3);
    }

    public static IntArrayTile empty(int n, int n2, IntCells intCells) {
        return IntArrayTile$.MODULE$.empty(n, n2, intCells);
    }

    public static IntArrayTile empty(int n, int n2) {
        return IntArrayTile$.MODULE$.empty(n, n2);
    }

    public static IntArrayTile ofDim(int n, int n2, IntCells intCells) {
        return IntArrayTile$.MODULE$.ofDim(n, n2, intCells);
    }

    public static IntArrayTile ofDim(int n, int n2) {
        return IntArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile$class.mutable(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile$class.set(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile$class.setDouble(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update2) {
        MutableArrayTile$class.update(this, colOffset, rowOffset, update2);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile$class.toArrayTile(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile$class.convert(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreach(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreachDouble(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile$class.foreachIntVisitor(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile$class.foreachDoubleVisitor(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile$class.map(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile$class.mapDouble(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile$class.mapIntMapper(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile$class.mapDoubleMapper(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile$class.equals(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile$class.get(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile$class.getDouble(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile$class.toList(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile$class.toListDouble(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile$class.toArrayDouble(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDraw() {
        return Tile$class.asciiDraw(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        IntArrayTile intArrayTile = this;
        synchronized (intArrayTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    public int[] array() {
        return this.array;
    }

    public abstract IntCells cellType();

    @Override
    public int[] toArray() {
        return (int[])this.array().clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] pixels = new byte[Predef$.MODULE$.intArrayOps(this.array()).size() * ((DataType)((Object)this.cellType())).bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(pixels);
        bytebuff.asIntBuffer().put(this.array());
        return var1_1;
    }

    @Override
    public ArrayTile copy() {
        return ArrayTile$.MODULE$.apply((int[])this.array().clone(), this.cols, this.rows);
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return IntArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        if (newCellType instanceof IntCells) {
            IntCells intCells = (IntCells)((Object)newCellType);
            tile = IntArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, intCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public IntArrayTile(int[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        ArrayTile$class.$init$(this);
        MutableArrayTile$class.$init$(this);
    }
}

