/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CellSize;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.RasterExtent;
import geotrellis.vector.Extent;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u0011!b\u0012:jI\u0016CH/\u001a8u\u0015\t\u0019A!\u0001\u0004sCN$XM\u001d\u0006\u0002\u000b\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\tIq\"\u0003\u0002\u0011\u0015\ta1+\u001a:jC2L'0\u00192mK\"A!\u0003\u0001BC\u0002\u0013\u00051#\u0001\u0004fqR,g\u000e^\u000b\u0002)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\u0007m\u0016\u001cGo\u001c:\n\u0005e1\"AB#yi\u0016tG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u001d)\u0007\u0010^3oi\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\nG\u0016dGn^5ei\",\u0012a\b\t\u0003\u0013\u0001J!!\t\u0006\u0003\r\u0011{WO\u00197f\u0011!\u0019\u0003A!A!\u0002\u0013y\u0012AC2fY2<\u0018\u000e\u001a;iA!AQ\u0005\u0001BC\u0002\u0013\u0005a$\u0001\u0006dK2d\u0007.Z5hQRD\u0001b\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\fG\u0016dG\u000e[3jO\"$\b\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0005W5rs\u0006\u0005\u0002-\u00015\t!\u0001C\u0003\u0013Q\u0001\u0007A\u0003C\u0003\u001eQ\u0001\u0007q\u0004C\u0003&Q\u0001\u0007q\u0004C\u0003*\u0001\u0011\u0005\u0011\u0007F\u0002,eMBQA\u0005\u0019A\u0002QAQ\u0001\u000e\u0019A\u0002U\n\u0001bY3mYNK'0\u001a\t\u0003YYJ!a\u000e\u0002\u0003\u0011\r+G\u000e\\*ju\u0016DQ\u0001\u000e\u0001\u0005\u0002e*\u0012!\u000e\u0005\u0006w\u0001!\t\u0001P\u0001\u000fi>\u0014\u0016m\u001d;fe\u0016CH/\u001a8u)\u0005i\u0004C\u0001\u0017?\u0013\ty$A\u0001\u0007SCN$XM]#yi\u0016tG\u000fC\u0003B\u0001\u0011\u0005!)A\fde\u0016\fG/Z!mS\u001etW\rZ$sS\u0012,\u0005\u0010^3oiR\u00111f\u0011\u0005\u0006\t\u0002\u0003\r\u0001F\u0001\ri\u0006\u0014x-\u001a;FqR,g\u000e\u001e\u0005\u0006\r\u0002!\taR\u0001\u0015SN<%/\u001b3FqR,g\u000e^!mY&<g.\u001a3\u0015\u0003!\u0003\"!C%\n\u0005)S!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0019\u0002!\t!T\u0001\u001aGJ,\u0017\r^3BY&<g.\u001a3SCN$XM]#yi\u0016tG\u000f\u0006\u0002>\u001d\")Ai\u0013a\u0001)!)\u0001\u000b\u0001C\u0001#\u0006IQ\r\u001f;f]R4uN\u001d\u000b\u0004)I;\u0006\"B*P\u0001\u0004!\u0016AC4sS\u0012\u0014u.\u001e8egB\u0011A&V\u0005\u0003-\n\u0011!b\u0012:jI\n{WO\u001c3t\u0011\u001dAv\n%AA\u0002!\u000bQa\u00197b[BDQA\u0017\u0001\u0005Bm\u000ba!Z9vC2\u001cHC\u0001%]\u0011\u0015i\u0016\f1\u0001_\u0003\u0005y\u0007CA\u0005`\u0013\t\u0001'BA\u0002B]fDQA\u0019\u0001\u0005B\r\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002IB\u0011\u0011\"Z\u0005\u0003M*\u00111!\u00138u\u0011\u0015A\u0007\u0001\"\u0011j\u0003!!xn\u0015;sS:<G#\u00016\u0011\u0005-tgBA\u0005m\u0013\ti'\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7\u000b\u0011\u001d\u0011\b!%A\u0005\u0002M\f1#\u001a=uK:$hi\u001c:%I\u00164\u0017-\u001e7uII*\u0012\u0001\u001e\u0016\u0003\u0011V\\\u0013A\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005mT\u0011AC1o]>$\u0018\r^5p]&\u0011Q\u0010\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,wAB@\u0003\u0011\u0003\t\t!\u0001\u0006He&$W\t\u001f;f]R\u00042\u0001LA\u0002\r\u0019\t!\u0001#\u0001\u0002\u0006M!\u00111\u0001\u0005\u000f\u0011\u001dI\u00131\u0001C\u0001\u0003\u0013!\"!!\u0001\t\u0011\u00055\u00111\u0001C\u0001\u0003\u001f\tQ!\u00199qYf$RaKA\t\u0003'AaAEA\u0006\u0001\u0004!\u0002B\u0002\u001b\u0002\f\u0001\u0007Q\u0007\u0003\u0005\u0002\u000e\u0005\rA\u0011AA\f)\u001dY\u0013\u0011DA\u000e\u0003;AaAEA\u000b\u0001\u0004!\u0002BB\u000f\u0002\u0016\u0001\u0007q\u0004\u0003\u0004&\u0003+\u0001\ra\b\u0005\t\u0003C\t\u0019\u0001\"\u0001\u0002$\u00059QO\\1qa2LH\u0003BA\u0013\u0003c\u0001R!CA\u0014\u0003WI1!!\u000b\u000b\u0005\u0019y\u0005\u000f^5p]B1\u0011\"!\f\u0015?}I1!a\f\u000b\u0005\u0019!V\u000f\u001d7fg!9\u00111GA\u0010\u0001\u0004Y\u0013AA4f\u0011)\t9$a\u0001\u0002\u0002\u0013%\u0011\u0011H\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00027b]\u001eT!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyD\u0001\u0004PE*,7\r\u001e")
public class GridExtent
implements Serializable {
    private final Extent extent;
    private final double cellwidth;
    private final double cellheight;

    public static Option<Tuple3<Extent, Object, Object>> unapply(GridExtent gridExtent) {
        return GridExtent$.MODULE$.unapply(gridExtent);
    }

    public static GridExtent apply(Extent extent2, double d, double d2) {
        return GridExtent$.MODULE$.apply(extent2, d, d2);
    }

    public static GridExtent apply(Extent extent2, CellSize cellSize) {
        return GridExtent$.MODULE$.apply(extent2, cellSize);
    }

    public Extent extent() {
        return this.extent;
    }

    public double cellwidth() {
        return this.cellwidth;
    }

    public double cellheight() {
        return this.cellheight;
    }

    public CellSize cellSize() {
        return new CellSize(this.cellwidth(), this.cellheight());
    }

    public RasterExtent toRasterExtent() {
        long targetCols = package$.MODULE$.round(this.extent().width() / this.cellwidth());
        long targetRows = package$.MODULE$.round(this.extent().height() / this.cellheight());
        if (targetCols > Integer.MAX_VALUE) {
            throw new GeoAttrsError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot convert GridExtent into a RasterExtent: number of columns exceeds maximum integer value (", " > ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetCols), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)})));
        }
        if (targetRows > Integer.MAX_VALUE) {
            throw new GeoAttrsError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot convert GridExtent into a RasterExtent: number of rows exceeds maximum integer value (", " > ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetRows), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)})));
        }
        return new RasterExtent(this.extent(), this.cellwidth(), this.cellheight(), (int)targetCols, (int)targetRows);
    }

    public GridExtent createAlignedGridExtent(Extent targetExtent) {
        double xmin = this.extent().xmin() + package$.MODULE$.floor((targetExtent.xmin() - this.extent().xmin()) / this.cellwidth()) * this.cellwidth();
        double xmax = this.extent().xmax() - package$.MODULE$.floor((this.extent().xmax() - targetExtent.xmax()) / this.cellwidth()) * this.cellwidth();
        double ymin = this.extent().ymin() + package$.MODULE$.floor((targetExtent.ymin() - this.extent().ymin()) / this.cellheight()) * this.cellheight();
        double ymax = this.extent().ymax() - package$.MODULE$.floor((this.extent().ymax() - targetExtent.ymax()) / this.cellheight()) * this.cellheight();
        return GridExtent$.MODULE$.apply(new Extent(xmin, ymin, xmax, ymax), this.cellwidth(), this.cellheight());
    }

    public boolean isGridExtentAlligned() {
        return this.isWhole$1((this.extent().xmax() - this.extent().xmin()) / this.cellwidth()) && this.isWhole$1((this.extent().ymax() - this.extent().ymin()) / this.cellheight());
    }

    public RasterExtent createAlignedRasterExtent(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent).toRasterExtent();
    }

    public Extent extentFor(GridBounds gridBounds, boolean clamp) {
        double xmin = (double)gridBounds.colMin() * this.cellwidth() + this.extent().xmin();
        double ymax = this.extent().ymax() - (double)gridBounds.rowMin() * this.cellheight();
        double xmax = xmin + (double)gridBounds.width() * this.cellwidth();
        double ymin = ymax - (double)gridBounds.height() * this.cellheight();
        return clamp ? new Extent(package$.MODULE$.max(package$.MODULE$.min(xmin, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymin, this.extent().ymax()), this.extent().ymin()), package$.MODULE$.max(package$.MODULE$.min(xmax, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymax, this.extent().ymax()), this.extent().ymin())) : new Extent(xmin, ymin, xmax, ymax);
    }

    public boolean extentFor$default$2() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof GridExtent)) return false;
        GridExtent gridExtent = (GridExtent)o;
        Extent extent2 = gridExtent.extent();
        Extent extent3 = this.extent();
        if (extent2 == null) {
            if (extent3 != null) {
                return false;
            }
        } else if (!extent2.equals(extent3)) return false;
        if (gridExtent.cellheight() != this.cellheight()) return false;
        if (gridExtent.cellwidth() != this.cellwidth()) return false;
        return true;
    }

    public int hashCode() {
        return ((31 + (this.extent() == null ? 0 : this.extent().hashCode())) * 31 + (int)this.cellheight()) * 31 + (int)this.cellwidth();
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GridExtent(", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.extent(), BoxesRunTime.boxToDouble((double)this.cellwidth()), BoxesRunTime.boxToDouble((double)this.cellheight())}));
    }

    private final boolean isWhole$1(double x) {
        return package$.MODULE$.floor(x) == x;
    }

    public GridExtent(Extent extent2, double cellwidth, double cellheight) {
        this.extent = extent2;
        this.cellwidth = cellwidth;
        this.cellheight = cellheight;
    }

    public GridExtent(Extent extent2, CellSize cellSize) {
        this(extent2, cellSize.width(), cellSize.height());
    }
}

