/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.FloatArrayTile;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.FloatCells;
import geotrellis.raster.FloatCells$;
import geotrellis.raster.FloatConstantNoDataArrayTile;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatRawArrayTile;
import geotrellis.raster.FloatUserDefinedNoDataArrayTile;
import geotrellis.raster.FloatUserDefinedNoDataCellType;
import geotrellis.raster.package$;
import geotrellis.raster.package$FloatArrayFiller$;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FloatArrayTile$
implements Serializable {
    public static final FloatArrayTile$ MODULE$;

    static {
        new FloatArrayTile$();
    }

    public FloatArrayTile apply(float[] arr, int cols, int rows) {
        return this.apply(arr, cols, rows, FloatConstantNoDataCellType$.MODULE$);
    }

    public FloatArrayTile apply(float[] arr, int cols, int rows, FloatCells cellType) {
        block5: {
            FloatArrayTile floatArrayTile;
            block3: {
                block4: {
                    block2: {
                        if (!FloatCellType$.MODULE$.equals(cellType)) break block2;
                        floatArrayTile = new FloatRawArrayTile(arr, cols, rows);
                        break block3;
                    }
                    if (!FloatConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    floatArrayTile = new FloatConstantNoDataArrayTile(arr, cols, rows);
                    break block3;
                }
                if (!(cellType instanceof FloatUserDefinedNoDataCellType)) break block5;
                FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)cellType;
                floatArrayTile = new FloatUserDefinedNoDataArrayTile(arr, cols, rows, floatUserDefinedNoDataCellType);
            }
            return floatArrayTile;
        }
        throw new MatchError((Object)cellType);
    }

    public FloatArrayTile apply(float[] arr, int cols, int rows, Option<Object> noDataValue) {
        return this.apply(arr, cols, rows, FloatCells$.MODULE$.withNoData(noDataValue));
    }

    public FloatArrayTile apply(float[] arr, int cols, int rows, float noDataValue) {
        return this.apply(arr, cols, rows, (Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)noDataValue)));
    }

    public FloatArrayTile ofDim(int cols, int rows) {
        return this.ofDim(cols, rows, FloatConstantNoDataCellType$.MODULE$);
    }

    public FloatArrayTile ofDim(int cols, int rows, FloatCells cellType) {
        block5: {
            FloatArrayTile floatArrayTile;
            block3: {
                block4: {
                    block2: {
                        if (!FloatCellType$.MODULE$.equals(cellType)) break block2;
                        floatArrayTile = new FloatRawArrayTile((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float()), cols, rows);
                        break block3;
                    }
                    if (!FloatConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    floatArrayTile = new FloatConstantNoDataArrayTile((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float()), cols, rows);
                    break block3;
                }
                if (!(cellType instanceof FloatUserDefinedNoDataCellType)) break block5;
                FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)cellType;
                floatArrayTile = new FloatUserDefinedNoDataArrayTile((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float()), cols, rows, floatUserDefinedNoDataCellType);
            }
            return floatArrayTile;
        }
        throw new MatchError((Object)cellType);
    }

    public FloatArrayTile empty(int cols, int rows) {
        return this.empty(cols, rows, FloatConstantNoDataCellType$.MODULE$);
    }

    public FloatArrayTile empty(int cols, int rows, FloatCells cellType) {
        block5: {
            FloatArrayTile floatArrayTile;
            block3: {
                block4: {
                    block2: {
                        if (!FloatCellType$.MODULE$.equals(cellType)) break block2;
                        floatArrayTile = this.ofDim(cols, rows, cellType);
                        break block3;
                    }
                    if (!FloatConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    floatArrayTile = this.fill(Float.NaN, cols, rows, cellType);
                    break block3;
                }
                if (!(cellType instanceof FloatUserDefinedNoDataCellType)) break block5;
                FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)cellType;
                floatArrayTile = this.fill(floatUserDefinedNoDataCellType.noDataValue(), cols, rows, cellType);
            }
            return floatArrayTile;
        }
        throw new MatchError((Object)cellType);
    }

    public FloatArrayTile fill(float v, int cols, int rows) {
        return this.fill(v, cols, rows, FloatConstantNoDataCellType$.MODULE$);
    }

    public FloatArrayTile fill(float v, int cols, int rows, FloatCells cellType) {
        block5: {
            FloatArrayTile floatArrayTile;
            block3: {
                block4: {
                    block2: {
                        if (!FloatCellType$.MODULE$.equals(cellType)) break block2;
                        floatArrayTile = new FloatRawArrayTile(package$FloatArrayFiller$.MODULE$.fill$extension(package$.MODULE$.FloatArrayFiller((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float())), v), cols, rows);
                        break block3;
                    }
                    if (!FloatConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    floatArrayTile = new FloatConstantNoDataArrayTile(package$FloatArrayFiller$.MODULE$.fill$extension(package$.MODULE$.FloatArrayFiller((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float())), v), cols, rows);
                    break block3;
                }
                if (!(cellType instanceof FloatUserDefinedNoDataCellType)) break block5;
                FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)cellType;
                floatArrayTile = new FloatUserDefinedNoDataArrayTile(package$FloatArrayFiller$.MODULE$.fill$extension(package$.MODULE$.FloatArrayFiller((float[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Float())), v), cols, rows, floatUserDefinedNoDataCellType);
            }
            return floatArrayTile;
        }
        throw new MatchError((Object)cellType);
    }

    private float[] constructFloatArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, Predef$.MODULE$.byteArrayOps(bytes).size());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        float[] floatArray = new float[Predef$.MODULE$.byteArrayOps(bytes).size() / FloatConstantNoDataCellType$.MODULE$.bytes()];
        floatBuffer.get(floatArray);
        return floatArray;
    }

    public FloatArrayTile fromBytes(byte[] bytes, int cols, int rows) {
        return this.fromBytes(bytes, cols, rows, FloatConstantNoDataCellType$.MODULE$);
    }

    public FloatArrayTile fromBytes(byte[] bytes, int cols, int rows, FloatCells cellType) {
        block5: {
            FloatArrayTile floatArrayTile;
            block3: {
                block4: {
                    block2: {
                        if (!FloatCellType$.MODULE$.equals(cellType)) break block2;
                        floatArrayTile = new FloatRawArrayTile(this.constructFloatArray(bytes), cols, rows);
                        break block3;
                    }
                    if (!FloatConstantNoDataCellType$.MODULE$.equals(cellType)) break block4;
                    floatArrayTile = new FloatConstantNoDataArrayTile(this.constructFloatArray(bytes), cols, rows);
                    break block3;
                }
                if (!(cellType instanceof FloatUserDefinedNoDataCellType)) break block5;
                FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)cellType;
                floatArrayTile = new FloatUserDefinedNoDataArrayTile(this.constructFloatArray(bytes), cols, rows, floatUserDefinedNoDataCellType);
            }
            return floatArrayTile;
        }
        throw new MatchError((Object)cellType);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FloatArrayTile$() {
        MODULE$ = this;
    }
}

