/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.ArrayTile$class;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.MutableArrayTile$class;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee!B\u0001\u0003\u0003\u00039!a\u0004#pk\ndW-\u0011:sCf$\u0016\u000e\\3\u000b\u0005\r!\u0011A\u0002:bgR,'OC\u0001\u0006\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!\u0001E'vi\u0006\u0014G.Z!se\u0006LH+\u001b7f\u0011!\u0019\u0002A!b\u0001\n\u0003!\u0012!B1se\u0006LX#A\u000b\u0011\u0007%1\u0002$\u0003\u0002\u0018\u0015\t)\u0011I\u001d:bsB\u0011\u0011\"G\u0005\u00035)\u0011a\u0001R8vE2,\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\r\u0005\u0014(/Y=!\u0011!q\u0002A!A!\u0002\u0013y\u0012\u0001B2pYN\u0004\"!\u0003\u0011\n\u0005\u0005R!aA%oi\"A1\u0005\u0001B\u0001B\u0003%q$\u0001\u0003s_^\u001c\b\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\b\u0006\u0003(Q%R\u0003CA\b\u0001\u0011\u0015\u0019B\u00051\u0001\u0016\u0011\u0015qB\u00051\u0001 \u0011\u0015\u0019C\u00051\u0001 \u0011\u001da\u0003A1A\u0007\u00025\n\u0001bY3mYRK\b/Z\u000b\u0002]I\u0019q&\r\u001b\u0007\tA\u0002\u0001A\f\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003\u001fIJ!a\r\u0002\u0003\u0017\u0011{WO\u00197f\u0007\u0016dGn\u001d\t\u0003\u001fUJ!A\u000e\u0002\u0003\u001d9{G)\u0019;b\u0011\u0006tG\r\\5oO\")\u0001\b\u0001C!s\u0005iAo\\!se\u0006LHi\\;cY\u0016$\u0012!\u0006\u0005\u0006w\u0001!\t\u0001P\u0001\bi>\u0014\u0015\u0010^3t)\u0005i\u0004cA\u0005\u0017}A\u0011\u0011bP\u0005\u0003\u0001*\u0011AAQ=uK\")!\t\u0001C\u0001\u0007\u0006!1m\u001c9z+\u0005!\u0005CA\bF\u0013\t1%AA\u0005BeJ\f\u0017\u0010V5mK\")\u0001\n\u0001C\u0001\u0013\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005)k\u0005CA\bL\u0013\ta%A\u0001\u0003US2,\u0007\"\u0002(H\u0001\u0004y\u0015a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!\u0003)\u0019\u0013\t\t&B\u0001\u0004PaRLwN\u001c\u0005\u0006'\u0002!\t\u0001V\u0001\fS:$XM\u001d9sKR\f5\u000f\u0006\u0002K+\")aK\u0015a\u0001/\u0006Ya.Z<DK2dG+\u001f9f!\tA6L\u0004\u0002\u00103&\u0011!LA\u0001\ba\u0006\u001c7.Y4f\u0013\taVL\u0001\u0005DK2dG+\u001f9f\u0015\tQ&aB\u0003`\u0005!\u0005\u0001-A\bE_V\u0014G.Z!se\u0006LH+\u001b7f!\ty\u0011MB\u0003\u0002\u0005!\u0005!mE\u0002b\u0011\r\u0004\"!\u00033\n\u0005\u0015T!\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0013b\t\u00039G#\u00011\t\u000b%\fG\u0011\u00016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u001dZWN\u001c\u0005\u0006Y\"\u0004\r!F\u0001\u0004CJ\u0014\b\"\u0002\u0010i\u0001\u0004y\u0002\"B\u0012i\u0001\u0004y\u0002\"B5b\t\u0003\u0001H#B\u0014reN$\b\"\u00027p\u0001\u0004)\u0002\"\u0002\u0010p\u0001\u0004y\u0002\"B\u0012p\u0001\u0004y\u0002\"\u0002\u0017p\u0001\u0004)(c\u0001<2i\u0019!\u0001'\u0019\u0001v\u0011\u0015I\u0017\r\"\u0001y)\u00159\u0013P_>}\u0011\u0015aw\u000f1\u0001\u0016\u0011\u0015qr\u000f1\u0001 \u0011\u0015\u0019s\u000f1\u0001 \u0011\u0015qu\u000f1\u0001P\u0011\u0015I\u0017\r\"\u0001\u007f)!9s0!\u0001\u0002\u0004\u0005\u0015\u0001\"\u00027~\u0001\u0004)\u0002\"\u0002\u0010~\u0001\u0004y\u0002\"B\u0012~\u0001\u0004y\u0002\"\u0002(~\u0001\u0004A\u0002bBA\u0005C\u0012\u0005\u00111B\u0001\u0006_\u001a$\u0015.\u001c\u000b\u0006O\u00055\u0011q\u0002\u0005\u0007=\u0005\u001d\u0001\u0019A\u0010\t\r\r\n9\u00011\u0001 \u0011\u001d\tI!\u0019C\u0001\u0003'!raJA\u000b\u0003/\tI\u0002\u0003\u0004\u001f\u0003#\u0001\ra\b\u0005\u0007G\u0005E\u0001\u0019A\u0010\t\u000f1\n\t\u00021\u0001\u0002\u001cI!\u0011QD\u00195\r\u0015\u0001\u0014\rAA\u000e\u0011\u001d\t\t#\u0019C\u0001\u0003G\tQ!Z7qif$RaJA\u0013\u0003OAaAHA\u0010\u0001\u0004y\u0002BB\u0012\u0002 \u0001\u0007q\u0004C\u0004\u0002\"\u0005$\t!a\u000b\u0015\u000f\u001d\ni#a\f\u00022!1a$!\u000bA\u0002}AaaIA\u0015\u0001\u0004y\u0002b\u0002\u0017\u0002*\u0001\u0007\u00111\u0007\n\u0005\u0003k\tDGB\u00031C\u0002\t\u0019\u0004C\u0004\u0002:\u0005$\t!a\u000f\u0002\t\u0019LG\u000e\u001c\u000b\bO\u0005u\u0012\u0011IA\"\u0011\u001d\ty$a\u000eA\u0002a\t\u0011A\u001e\u0005\u0007=\u0005]\u0002\u0019A\u0010\t\r\r\n9\u00041\u0001 \u0011\u001d\tI$\u0019C\u0001\u0003\u000f\"\u0012bJA%\u0003\u0017\ni%a\u0014\t\u000f\u0005}\u0012Q\ta\u00011!1a$!\u0012A\u0002}AaaIA#\u0001\u0004y\u0002b\u0002\u0017\u0002F\u0001\u0007\u0011\u0011\u000b\n\u0005\u0003'\nDGB\u00031C\u0002\t\t\u0006C\u0004\u0002X\u0005$I!!\u0017\u0002)\r|gn\u001d;sk\u000e$Hi\\;cY\u0016\f%O]1z)\r)\u00121\f\u0005\b\u0003;\n)\u00061\u0001>\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\t\t'\u0019C\u0001\u0003G\n\u0011B\u001a:p[\nKH/Z:\u0015\u000f\u001d\n)'a\u001a\u0002j!9\u0011QLA0\u0001\u0004i\u0004B\u0002\u0010\u0002`\u0001\u0007q\u0004\u0003\u0004$\u0003?\u0002\ra\b\u0005\b\u0003C\nG\u0011AA7)%9\u0013qNA9\u0003g\n)\bC\u0004\u0002^\u0005-\u0004\u0019A\u001f\t\ry\tY\u00071\u0001 \u0011\u0019\u0019\u00131\u000ea\u0001?!9A&a\u001bA\u0002\u0005]$\u0003BA=cQ2Q\u0001M1\u0001\u0003oB\u0011\"! b\u0003\u0003%I!a \u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)\u0001\u0003mC:<'BAAF\u0003\u0011Q\u0017M^1\n\t\u0005=\u0015Q\u0011\u0002\u0007\u001f\nTWm\u0019;")
public abstract class DoubleArrayTile
implements MutableArrayTile {
    private final double[] array;
    private final int cols;
    private final int rows;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static DoubleArrayTile fromBytes(byte[] byArray, int n, int n2, DoubleCells doubleCells) {
        return DoubleArrayTile$.MODULE$.fromBytes(byArray, n, n2, doubleCells);
    }

    public static DoubleArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return DoubleArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static DoubleArrayTile fill(double d, int n, int n2, DoubleCells doubleCells) {
        return DoubleArrayTile$.MODULE$.fill(d, n, n2, doubleCells);
    }

    public static DoubleArrayTile fill(double d, int n, int n2) {
        return DoubleArrayTile$.MODULE$.fill(d, n, n2);
    }

    public static DoubleArrayTile empty(int n, int n2, DoubleCells doubleCells) {
        return DoubleArrayTile$.MODULE$.empty(n, n2, doubleCells);
    }

    public static DoubleArrayTile empty(int n, int n2) {
        return DoubleArrayTile$.MODULE$.empty(n, n2);
    }

    public static DoubleArrayTile ofDim(int n, int n2, DoubleCells doubleCells) {
        return DoubleArrayTile$.MODULE$.ofDim(n, n2, doubleCells);
    }

    public static DoubleArrayTile ofDim(int n, int n2) {
        return DoubleArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile$class.mutable(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile$class.set(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile$class.setDouble(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update2) {
        MutableArrayTile$class.update(this, colOffset, rowOffset, update2);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile$class.toArrayTile(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile$class.convert(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreach(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreachDouble(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile$class.foreachIntVisitor(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile$class.foreachDoubleVisitor(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile$class.map(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile$class.mapDouble(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile$class.mapIntMapper(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile$class.mapDoubleMapper(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile$class.equals(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile$class.get(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile$class.getDouble(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile$class.toList(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile$class.toListDouble(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile$class.toArray(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDraw() {
        return Tile$class.asciiDraw(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        DoubleArrayTile doubleArrayTile = this;
        synchronized (doubleArrayTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    public double[] array() {
        return this.array;
    }

    public abstract DoubleCells cellType();

    @Override
    public double[] toArrayDouble() {
        return (double[])this.array().clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] pixels = new byte[Predef$.MODULE$.doubleArrayOps(this.array()).size() * ((DataType)((Object)this.cellType())).bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(pixels);
        bytebuff.asDoubleBuffer().put(this.array());
        return var1_1;
    }

    @Override
    public ArrayTile copy() {
        return ArrayTile$.MODULE$.apply((double[])this.array().clone(), this.cols, this.rows);
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return DoubleArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        if (newCellType instanceof DoubleCells) {
            DoubleCells doubleCells = (DoubleCells)((Object)newCellType);
            tile = DoubleArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, doubleCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public DoubleArrayTile(double[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        ArrayTile$class.$init$(this);
        MutableArrayTile$class.$init$(this);
    }
}

