/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile;
import geotrellis.raster.ByteCells;
import geotrellis.raster.ByteConstantTile;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleConstantTile;
import geotrellis.raster.DoubleConstantTile$;
import geotrellis.raster.FloatCells;
import geotrellis.raster.FloatConstantTile;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntConstantTile;
import geotrellis.raster.IntConstantTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.ShortConstantTile;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UByteConstantTile;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortConstantTile;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.package$IntArrayFiller$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public abstract class ConstantTile$class {
    public static int get(ConstantTile $this, int col, int row) {
        return $this.iVal();
    }

    public static double getDouble(ConstantTile $this, int col, int row) {
        return $this.dVal();
    }

    public static int[] toArray(ConstantTile $this) {
        return package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim($this.cols() * $this.rows(), ClassTag$.MODULE$.Int())), $this.iVal());
    }

    public static double[] toArrayDouble(ConstantTile $this) {
        return package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim($this.cols() * $this.rows(), ClassTag$.MODULE$.Double())), $this.dVal());
    }

    public static Tile convert(ConstantTile $this, DataType newType) {
        block15: {
            ConstantTile constantTile;
            block8: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            BoxedUnit boxedUnit;
                                            if (newType.isFloatingPoint() != $this.cellType().isFloatingPoint()) {
                                                if ($this.logger().underlying().isWarnEnabled()) {
                                                    $this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion from ", " to ", " may lead to data loss."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.cellType(), newType})));
                                                    boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    boxedUnit = BoxedUnit.UNIT;
                                                }
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            if (!BitCellType$.MODULE$.equals(newType)) break block7;
                                            constantTile = new BitConstantTile($this.iVal() != 0, $this.cols(), $this.rows());
                                            break block8;
                                        }
                                        if (!(newType instanceof ByteCells)) break block9;
                                        NoDataHandling noDataHandling = (NoDataHandling)((Object)newType);
                                        constantTile = new ByteConstantTile((byte)$this.iVal(), $this.cols(), $this.rows(), (ByteCells)((Object)noDataHandling));
                                        break block8;
                                    }
                                    if (!(newType instanceof UByteCells)) break block10;
                                    NoDataHandling noDataHandling = (NoDataHandling)((Object)newType);
                                    constantTile = new UByteConstantTile((byte)$this.iVal(), $this.cols(), $this.rows(), (UByteCells)((Object)noDataHandling));
                                    break block8;
                                }
                                if (!(newType instanceof ShortCells)) break block11;
                                NoDataHandling noDataHandling = (NoDataHandling)((Object)newType);
                                constantTile = new ShortConstantTile((short)$this.iVal(), $this.cols(), $this.rows(), (ShortCells)((Object)noDataHandling));
                                break block8;
                            }
                            if (!(newType instanceof UShortCells)) break block12;
                            NoDataHandling noDataHandling = (NoDataHandling)((Object)newType);
                            constantTile = new UShortConstantTile((short)$this.iVal(), $this.cols(), $this.rows(), (UShortCells)((Object)noDataHandling));
                            break block8;
                        }
                        if (!(newType instanceof IntCells)) break block13;
                        NoDataHandling noDataHandling = (NoDataHandling)((Object)newType);
                        constantTile = new IntConstantTile($this.iVal(), $this.cols(), $this.rows(), (IntCells)((Object)noDataHandling));
                        break block8;
                    }
                    if (!(newType instanceof FloatCells)) break block14;
                    NoDataHandling noDataHandling = (NoDataHandling)((Object)newType);
                    constantTile = new FloatConstantTile((float)$this.dVal(), $this.cols(), $this.rows(), (FloatCells)((Object)noDataHandling));
                    break block8;
                }
                if (!(newType instanceof DoubleCells)) break block15;
                NoDataHandling noDataHandling = (NoDataHandling)((Object)newType);
                constantTile = new DoubleConstantTile($this.dVal(), $this.cols(), $this.rows(), (DoubleCells)((Object)noDataHandling));
            }
            return constantTile;
        }
        throw new MatchError((Object)newType);
    }

    public static Tile interpretAs(ConstantTile $this, DataType newCellType) {
        return $this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
    }

    public static void foreach(ConstantTile $this, Function1 f) {
        int len = $this.size();
        for (int i = 0; i < len; ++i) {
            f.apply$mcVI$sp($this.iVal());
        }
    }

    public static void foreachDouble(ConstantTile $this, Function1 f) {
        int len = $this.size();
        for (int i = 0; i < len; ++i) {
            f.apply$mcVD$sp($this.dVal());
        }
    }

    public static void foreachIntVisitor(ConstantTile $this, IntTileVisitor visitor) {
        for (int index$macro$99 = 0; index$macro$99 < $this.rows(); ++index$macro$99) {
            for (int index$macro$98 = 0; index$macro$98 < $this.cols(); ++index$macro$98) {
                visitor.apply(index$macro$98, index$macro$99, $this.iVal());
            }
        }
    }

    public static void foreachDoubleVisitor(ConstantTile $this, DoubleTileVisitor visitor) {
        for (int index$macro$101 = 0; index$macro$101 < $this.rows(); ++index$macro$101) {
            for (int index$macro$100 = 0; index$macro$100 < $this.cols(); ++index$macro$100) {
                visitor.apply(index$macro$100, index$macro$101, $this.dVal());
            }
        }
    }

    public static Tile map(ConstantTile $this, Function1 f) {
        return new IntConstantTile(f.apply$mcII$sp($this.iVal()), $this.cols(), $this.rows(), IntConstantTile$.MODULE$.apply$default$4());
    }

    public static Tile combine(ConstantTile $this, Tile other, Function2 f) {
        return other.map((Function1<Object, Object>)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ConstantTile $outer;
            public final Function2 f$1;

            public final int apply(int z) {
                return this.f$1.apply$mcIII$sp(this.$outer.iVal(), z);
            }

            public int apply$mcII$sp(int z) {
                return this.f$1.apply$mcIII$sp(this.$outer.iVal(), z);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        });
    }

    public static Tile mapDouble(ConstantTile $this, Function1 f) {
        return new DoubleConstantTile(f.apply$mcDD$sp($this.dVal()), $this.cols(), $this.rows(), DoubleConstantTile$.MODULE$.apply$default$4());
    }

    public static Tile combineDouble(ConstantTile $this, Tile other, Function2 f) {
        return other.mapDouble((Function1<Object, Object>)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ConstantTile $outer;
            public final Function2 f$2;

            public final double apply(double z) {
                return this.f$2.apply$mcDDD$sp(this.$outer.dVal(), z);
            }

            public double apply$mcDD$sp(double z) {
                return this.f$2.apply$mcDDD$sp(this.$outer.dVal(), z);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$2 = f$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Tile mapIntMapper(ConstantTile $this, IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc($this.cellType(), $this.cols(), $this.rows());
        for (int index$macro$103 = 0; index$macro$103 < $this.rows(); ++index$macro$103) {
            for (int index$macro$102 = 0; index$macro$102 < $this.cols(); ++index$macro$102) {
                tile.set(index$macro$102, index$macro$103, mapper.apply(index$macro$102, index$macro$103, $this.get(index$macro$102, index$macro$103)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Tile mapDoubleMapper(ConstantTile $this, DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc($this.cellType(), $this.cols(), $this.rows());
        for (int index$macro$105 = 0; index$macro$105 < $this.rows(); ++index$macro$105) {
            for (int index$macro$104 = 0; index$macro$104 < $this.cols(); ++index$macro$104) {
                tile.setDouble(index$macro$104, index$macro$105, mapper.apply(index$macro$104, index$macro$105, $this.getDouble(index$macro$104, index$macro$105)));
            }
        }
        return var2_2;
    }

    public static void $init$(ConstantTile $this) {
    }
}

