/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSet;
import geotrellis.raster.CompositeTile$;
import geotrellis.raster.CompositeTile$$anonfun$asciiDraw$1$;
import geotrellis.raster.CompositeTile$$anonfun$asciiDraw$1$$anonfun$apply$1$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import geotrellis.raster.TileLayout;
import geotrellis.raster.package$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005x!B\u0001\u0003\u0011\u00039\u0011!D\"p[B|7/\u001b;f)&dWM\u0003\u0002\u0004\t\u00051!/Y:uKJT\u0011!B\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u000e\u0007>l\u0007o\\:ji\u0016$\u0016\u000e\\3\u0014\u0007%a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bYIA\u0011A\f\u0002\rqJg.\u001b;?)\u00059\u0001\"B\r\n\t\u0003Q\u0012!B1qa2LH#B\u000e\u0003\b\n-\u0005C\u0001\u0005\u001d\r\u0011Q!\u0001Q\u000f\u0014\u000bqaa$\t\n\u0011\u0005!y\u0012B\u0001\u0011\u0003\u0005\u0011!\u0016\u000e\\3\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\u001d\u0001&o\u001c3vGRD\u0001\"\n\u000f\u0003\u0016\u0004%\tAJ\u0001\u0006i&dWm]\u000b\u0002OA\u0019\u0001\u0006\r\u0010\u000f\u0005%rcB\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u00020\u001d\u00059\u0001/Y2lC\u001e,\u0017BA\u00193\u0005\r\u0019V-\u001d\u0006\u0003_9A\u0001\u0002\u000e\u000f\u0003\u0012\u0003\u0006IaJ\u0001\u0007i&dWm\u001d\u0011\t\u0011Yb\"Q3A\u0005\u0002]\n!\u0002^5mK2\u000b\u0017p\\;u+\u0005A\u0004C\u0001\u0005:\u0013\tQ$A\u0001\u0006US2,G*Y=pkRD\u0001\u0002\u0010\u000f\u0003\u0012\u0003\u0006I\u0001O\u0001\fi&dW\rT1z_V$\b\u0005C\u0003\u00179\u0011\u0005a\bF\u0002\u001c\u007f\u0001CQ!J\u001fA\u0002\u001dBQAN\u001fA\u0002aBqA\u0011\u000fC\u0002\u0013\u00051)\u0001\u0003d_2\u001cX#\u0001#\u0011\u00055)\u0015B\u0001$\u000f\u0005\rIe\u000e\u001e\u0005\u0007\u0011r\u0001\u000b\u0011\u0002#\u0002\u000b\r|Gn\u001d\u0011\t\u000f)c\"\u0019!C\u0001\u0007\u0006!!o\\<t\u0011\u0019aE\u0004)A\u0005\t\u0006)!o\\<tA!9a\n\bb\u0001\n\u0013y\u0015\u0001\u0003;jY\u0016d\u0015n\u001d;\u0016\u0003A\u00032!\u0015*\u001f\u001d\tia&\u0003\u0002Te\t!A*[:u\u0011\u0019)F\u0004)A\u0005!\u0006IA/\u001b7f\u0019&\u001cH\u000f\t\u0005\b/r\u0011\r\u0011\"\u0003D\u0003!!\u0018\u000e\\3D_2\u001c\bBB-\u001dA\u0003%A)A\u0005uS2,7i\u001c7tA!)1\f\bC\u00059\u00069q-\u001a;US2,Gc\u0001\u0010^?\")aL\u0017a\u0001\t\u0006!AoY8m\u0011\u0015\u0001'\f1\u0001E\u0003\u0011!(o\\<\t\u000f\td\"\u0019!C\u0001G\u0006A1-\u001a7m)f\u0004X-F\u0001e!\t)wM\u0004\u0002\tM&\u0011qFA\u0005\u0003Q&\u0014\u0001bQ3mYRK\b/\u001a\u0006\u0003_\tAaa\u001b\u000f!\u0002\u0013!\u0017!C2fY2$\u0016\u0010]3!\u0011\u0015iG\u0004\"\u0001o\u0003\u001d\u0019wN\u001c<feR$\"AH8\t\u000bAd\u0007\u0019\u00013\u0002\u001dQ\f'oZ3u\u0007\u0016dG\u000eV=qK\")!\u000f\bC\u0001g\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005m!\b\"B;r\u0001\u00041\u0018a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!D<z\u0013\tAhB\u0001\u0004PaRLwN\u001c\t\u0003\u001biL!a\u001f\b\u0003\r\u0011{WO\u00197f\u0011\u0015iH\u0004\"\u0001\u007f\u0003-Ig\u000e^3saJ,G/Q:\u0015\u0005my\b\"\u00029}\u0001\u0004!\u0007bBA\u00029\u0011\u0005\u0011QA\u0001\fi>\f%O]1z)&dW\r\u0006\u0002\u0002\bA\u0019\u0001\"!\u0003\n\u0007\u0005-!AA\u0005BeJ\f\u0017\u0010V5mK\"9\u0011q\u0002\u000f\u0005\u0002\u0005E\u0011aB7vi\u0006\u0014G.\u001a\u000b\u0003\u0003'\u00012\u0001CA\u000b\u0013\r\t9B\u0001\u0002\u0011\u001bV$\u0018M\u00197f\u0003J\u0014\u0018-\u001f+jY\u0016Dq!a\u0004\u001d\t\u0003\tY\u0002\u0006\u0003\u0002\u0014\u0005u\u0001B\u00029\u0002\u001a\u0001\u0007A\rC\u0004\u0002\"q!\t!a\t\u0002\u000fQ|\u0017I\u001d:bsR\u0011\u0011Q\u0005\t\u0005\u001b\u0005\u001dB)C\u0002\u0002*9\u0011Q!\u0011:sCfDq!!\f\u001d\t\u0003\ty#A\u0007u_\u0006\u0013(/Y=E_V\u0014G.\u001a\u000b\u0003\u0003c\u0001B!DA\u0014s\"9\u0011Q\u0007\u000f\u0005\u0002\u0005]\u0012a\u0002;p\u0005f$Xm\u001d\u000b\u0003\u0003s\u0001R!DA\u0014\u0003w\u00012!DA\u001f\u0013\r\tyD\u0004\u0002\u0005\u0005f$X\rC\u0004\u0002Dq!\t!!\u0012\u0002\u0007\u001d,G\u000fF\u0003E\u0003\u000f\nY\u0005C\u0004\u0002J\u0005\u0005\u0003\u0019\u0001#\u0002\u0007\r|G\u000eC\u0004\u0002N\u0005\u0005\u0003\u0019\u0001#\u0002\u0007I|w\u000fC\u0004\u0002Rq!\t!a\u0015\u0002\u0013\u001d,G\u000fR8vE2,G#B=\u0002V\u0005]\u0003bBA%\u0003\u001f\u0002\r\u0001\u0012\u0005\b\u0003\u001b\ny\u00051\u0001E\u0011\u001d\tY\u0006\bC\u0001\u0003;\nqAZ8sK\u0006\u001c\u0007\u000e\u0006\u0003\u0002`\u0005\u0015\u0004cA\u0007\u0002b%\u0019\u00111\r\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003O\nI\u00061\u0001\u0002j\u0005\ta\r\u0005\u0004\u000e\u0003W\"\u0015qL\u0005\u0004\u0003[r!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\t\t\b\bC\u0001\u0003g\nQBZ8sK\u0006\u001c\u0007\u000eR8vE2,G\u0003BA0\u0003kB\u0001\"a\u001a\u0002p\u0001\u0007\u0011q\u000f\t\u0007\u001b\u0005-\u00140a\u0018\t\u000f\u0005mD\u0004\"\u0001\u0002~\u0005\tbm\u001c:fC\u000eD\u0017J\u001c;WSNLGo\u001c:\u0015\t\u0005}\u0013q\u0010\u0005\t\u0003\u0003\u000bI\b1\u0001\u0002\u0004\u00069a/[:ji>\u0014\bcA3\u0002\u0006&\u0019\u0011qQ5\u0003\u001d%sG\u000fV5mKZK7/\u001b;pe\"9\u00111\u0012\u000f\u0005\u0002\u00055\u0015\u0001\u00064pe\u0016\f7\r\u001b#pk\ndWMV5tSR|'\u000f\u0006\u0003\u0002`\u0005=\u0005\u0002CAA\u0003\u0013\u0003\r!!%\u0011\u0007\u0015\f\u0019*C\u0002\u0002\u0016&\u0014\u0011\u0003R8vE2,G+\u001b7f-&\u001c\u0018\u000e^8s\u0011\u001d\tI\n\bC\u0001\u00037\u000b1!\\1q)\rq\u0012Q\u0014\u0005\t\u0003O\n9\n1\u0001\u0002 B)Q\"a\u001bE\t\"9\u00111\u0015\u000f\u0005\u0002\u0005\u0015\u0016!C7ba\u0012{WO\u00197f)\rq\u0012q\u0015\u0005\t\u0003O\n\t\u000b1\u0001\u0002*B)Q\"a\u001bzs\"9\u0011Q\u0016\u000f\u0005\u0002\u0005=\u0016\u0001D7ba&sG/T1qa\u0016\u0014Hc\u0001\u0010\u00022\"A\u00111WAV\u0001\u0004\t),\u0001\u0004nCB\u0004XM\u001d\t\u0004K\u0006]\u0016bAA]S\ni\u0011J\u001c;US2,W*\u00199qKJDq!!0\u001d\t\u0003\ty,A\bnCB$u.\u001e2mK6\u000b\u0007\u000f]3s)\rq\u0012\u0011\u0019\u0005\t\u0003g\u000bY\f1\u0001\u0002DB\u0019Q-!2\n\u0007\u0005\u001d\u0017N\u0001\tE_V\u0014G.\u001a+jY\u0016l\u0015\r\u001d9fe\"9\u00111\u001a\u000f\u0005\u0002\u00055\u0017aB2p[\nLg.\u001a\u000b\u0005\u0003\u001f\fI\u000eF\u0002\u001f\u0003#D\u0001\"a\u001a\u0002J\u0002\u0007\u00111\u001b\t\u0007\u001b\u0005UG\t\u0012#\n\u0007\u0005]gBA\u0005Gk:\u001cG/[8oe!9\u00111\\Ae\u0001\u0004q\u0012!B8uQ\u0016\u0014\bbBAp9\u0011\u0005\u0011\u0011]\u0001\u000eG>l'-\u001b8f\t>,(\r\\3\u0015\t\u0005\r\u0018\u0011\u001e\u000b\u0004=\u0005\u0015\b\u0002CA4\u0003;\u0004\r!a:\u0011\r5\t)._=z\u0011\u001d\tY.!8A\u0002yAq!!<\u001d\t\u0003\ny/A\u0005bg\u000eL\u0017\u000e\u0012:boR\u0011\u0011\u0011\u001f\t\u0005\u0003g\fIPD\u0002\u000e\u0003kL1!a>\u000f\u0003\u0019\u0001&/\u001a3fM&!\u00111`A\u007f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u001f\b\t\u0013\t\u0005A$!A\u0005\u0002\t\r\u0011\u0001B2paf$Ra\u0007B\u0003\u0005\u000fA\u0001\"JA\u0000!\u0003\u0005\ra\n\u0005\tm\u0005}\b\u0013!a\u0001q!I!1\u0002\u000f\u0012\u0002\u0013\u0005!QB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yAK\u0002(\u0005#Y#Aa\u0005\u0011\t\tU!qD\u0007\u0003\u0005/QAA!\u0007\u0003\u001c\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005;q\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u0005B\f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005Ka\u0012\u0013!C\u0001\u0005O\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003*)\u001a\u0001H!\u0005\t\u0013\t5B$!A\u0005B\t=\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00032A!!1\u0007B\u001f\u001b\t\u0011)D\u0003\u0003\u00038\te\u0012\u0001\u00027b]\u001eT!Aa\u000f\u0002\t)\fg/Y\u0005\u0005\u0003w\u0014)\u0004\u0003\u0005\u0003Bq\t\t\u0011\"\u0001D\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\u0011)\u0005HA\u0001\n\u0003\u00119%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t%#q\n\t\u0004\u001b\t-\u0013b\u0001B'\u001d\t\u0019\u0011I\\=\t\u0013\tE#1IA\u0001\u0002\u0004!\u0015a\u0001=%c!I!Q\u000b\u000f\u0002\u0002\u0013\u0005#qK\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\f\t\u0007\u00057\u0012\tG!\u0013\u000e\u0005\tu#b\u0001B0\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r$Q\f\u0002\t\u0013R,'/\u0019;pe\"I!q\r\u000f\u0002\u0002\u0013\u0005!\u0011N\u0001\tG\u0006tW)];bYR!!1\u000eB9!\ri!QN\u0005\u0004\u0005_r!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005#\u0012)'!AA\u0002\t%\u0003\"\u0003B;9\u0005\u0005I\u0011\tB<\u0003!A\u0017m\u001d5D_\u0012,G#\u0001#\t\u0013\tmD$!A\u0005B\tu\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tE\u0002\"\u0003BA9\u0005\u0005I\u0011\tBB\u0003\u0019)\u0017/^1mgR!!1\u000eBC\u0011)\u0011\tFa \u0002\u0002\u0003\u0007!\u0011\n\u0005\u0007\u0005\u0013C\u0002\u0019\u0001\u0010\u0002\tQLG.\u001a\u0005\u0006ma\u0001\r\u0001\u000f\u0005\b\u0005\u001fKA\u0011\u0001BI\u0003\u00119(/\u00199\u0015\u000fm\u0011\u0019J!&\u0003\u0018\"9!\u0011\u0012BG\u0001\u0004q\u0002BB,\u0003\u000e\u0002\u0007A\tC\u0004\u0003\u001a\n5\u0005\u0019\u0001#\u0002\u0011QLG.\u001a*poNDqAa$\n\t\u0003\u0011i\nF\u0005\u001c\u0005?\u0013\tKa)\u0003&\"9!\u0011\u0012BN\u0001\u0004q\u0002BB,\u0003\u001c\u0002\u0007A\tC\u0004\u0003\u001a\nm\u0005\u0019\u0001#\t\u0011\t\u001d&1\u0014a\u0001\u0005W\nqa\u0019:paB,G\rC\u0004\u0003\u0010&!\tAa+\u0015\u000bm\u0011iKa,\t\u000f\t%%\u0011\u0016a\u0001=!1aG!+A\u0002aBqAa$\n\t\u0003\u0011\u0019\fF\u0004\u001c\u0005k\u00139L!/\t\u000f\t%%\u0011\u0017a\u0001=!1aG!-A\u0002aB\u0001Ba*\u00032\u0002\u0007!1\u000e\u0005\t3%\t\t\u0011\"!\u0003>R)1Da0\u0003B\"1QEa/A\u0002\u001dBaA\u000eB^\u0001\u0004A\u0004\"\u0003Bc\u0013\u0005\u0005I\u0011\u0011Bd\u0003\u001d)h.\u00199qYf$BA!3\u0003RB!Qb\u001eBf!\u0015i!QZ\u00149\u0013\r\u0011yM\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\tM'1YA\u0001\u0002\u0004Y\u0012a\u0001=%a!I!q[\u0005\u0002\u0002\u0013%!\u0011\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\\B!!1\u0007Bo\u0013\u0011\u0011yN!\u000e\u0003\r=\u0013'.Z2u\u0001")
public class CompositeTile
implements Tile,
Product {
    private final Seq<Tile> tiles;
    private final TileLayout tileLayout;
    private final int cols;
    private final int rows;
    private final List<Tile> tileList;
    private final int tileCols;
    private final DataType cellType;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Seq<Tile>, TileLayout>> unapply(CompositeTile compositeTile) {
        return CompositeTile$.MODULE$.unapply(compositeTile);
    }

    public static CompositeTile apply(Seq<Tile> seq, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.apply(seq, tileLayout);
    }

    public static CompositeTile wrap(Tile tile, TileLayout tileLayout, boolean bl) {
        return CompositeTile$.MODULE$.wrap(tile, tileLayout, bl);
    }

    public static CompositeTile wrap(Tile tile, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.wrap(tile, tileLayout);
    }

    public static CompositeTile wrap(Tile tile, int n, int n2, boolean bl) {
        return CompositeTile$.MODULE$.wrap(tile, n, n2, bl);
    }

    public static CompositeTile wrap(Tile tile, int n, int n2) {
        return CompositeTile$.MODULE$.wrap(tile, n, n2);
    }

    public static CompositeTile apply(Tile tile, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.apply(tile, tileLayout);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        CompositeTile compositeTile = this;
        synchronized (compositeTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    public Seq<Tile> tiles() {
        return this.tiles;
    }

    public TileLayout tileLayout() {
        return this.tileLayout;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    private List<Tile> tileList() {
        return this.tileList;
    }

    private int tileCols() {
        return this.tileCols;
    }

    public Tile geotrellis$raster$CompositeTile$$getTile(int tcol, int trow) {
        return (Tile)this.tileList().apply(trow * this.tileCols() + tcol);
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    @Override
    public Tile convert(DataType targetCellType) {
        return this.mutable(targetCellType);
    }

    @Override
    public CompositeTile withNoData(Option<Object> noDataValue) {
        return new CompositeTile((Seq<Tile>)((Seq)this.tiles().map((Function1)new Serializable(this, noDataValue){
            public static final long serialVersionUID = 0L;
            private final Option noDataValue$1;

            public final Tile apply(Tile x$1) {
                return x$1.withNoData((Option<Object>)this.noDataValue$1);
            }
            {
                this.noDataValue$1 = noDataValue$1;
            }
        }, Seq$.MODULE$.canBuildFrom())), this.tileLayout());
    }

    @Override
    public CompositeTile interpretAs(DataType targetCellType) {
        return new CompositeTile((Seq<Tile>)((Seq)this.tiles().map((Function1)new Serializable(this, targetCellType){
            public static final long serialVersionUID = 0L;
            private final DataType targetCellType$1;

            public final Tile apply(Tile x$2) {
                return x$2.interpretAs(this.targetCellType$1);
            }
            {
                this.targetCellType$1 = targetCellType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())), this.tileLayout());
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return this.mutable(this.cellType());
    }

    public MutableArrayTile mutable(DataType targetCellType) {
        BoxedUnit boxedUnit;
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        if (targetCellType.isFloatingPoint() != this.cellType().isFloatingPoint()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion from ", " to ", " may lead to data loss."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cellType(), targetCellType})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, this.cols(), this.rows());
        this.cols();
        this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        if (this.cellType().isFloatingPoint()) {
            for (int index$macro$49 = 0; index$macro$49 < layoutRows; ++index$macro$49) {
                for (int index$macro$48 = 0; index$macro$48 < layoutCols; ++index$macro$48) {
                    Tile sourceTile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$48, index$macro$49);
                    for (int index$macro$47 = 0; index$macro$47 < tileRows; ++index$macro$47) {
                        for (int index$macro$46 = 0; index$macro$46 < tileCols; ++index$macro$46) {
                            int acol = tileCols * index$macro$48 + index$macro$46;
                            int arow = tileRows * index$macro$49 + index$macro$47;
                            tile.setDouble(acol, arow, sourceTile.getDouble(index$macro$46, index$macro$47));
                        }
                    }
                }
            }
        } else {
            for (int index$macro$45 = 0; index$macro$45 < layoutRows; ++index$macro$45) {
                for (int index$macro$44 = 0; index$macro$44 < layoutCols; ++index$macro$44) {
                    Tile sourceTile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$44, index$macro$45);
                    for (int index$macro$43 = 0; index$macro$43 < tileRows; ++index$macro$43) {
                        for (int index$macro$42 = 0; index$macro$42 < tileCols; ++index$macro$42) {
                            int acol = tileCols * index$macro$44 + index$macro$42;
                            int arow = tileRows * index$macro$45 + index$macro$43;
                            tile.set(acol, arow, sourceTile.get(index$macro$42, index$macro$43));
                        }
                    }
                }
            }
        }
        return tile;
    }

    @Override
    public int[] toArray() {
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        int[] arr = (int[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Int());
        this.cols();
        this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        int totalCols = layoutCols * tileCols;
        for (int index$macro$53 = 0; index$macro$53 < layoutRows; ++index$macro$53) {
            for (int index$macro$52 = 0; index$macro$52 < layoutCols; ++index$macro$52) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$52, index$macro$53);
                for (int index$macro$51 = 0; index$macro$51 < tileRows; ++index$macro$51) {
                    for (int index$macro$50 = 0; index$macro$50 < tileCols; ++index$macro$50) {
                        int acol = tileCols * index$macro$52 + index$macro$50;
                        int arow = tileRows * index$macro$53 + index$macro$51;
                        arr[arow * totalCols + acol] = tile.get(index$macro$50, index$macro$51);
                    }
                }
            }
        }
        return arr;
    }

    @Override
    public double[] toArrayDouble() {
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        double[] arr = (double[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Double());
        this.cols();
        this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        int totalCols = layoutCols * tileCols;
        for (int index$macro$57 = 0; index$macro$57 < layoutRows; ++index$macro$57) {
            for (int index$macro$56 = 0; index$macro$56 < layoutCols; ++index$macro$56) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$56, index$macro$57);
                for (int index$macro$55 = 0; index$macro$55 < tileRows; ++index$macro$55) {
                    for (int index$macro$54 = 0; index$macro$54 < tileCols; ++index$macro$54) {
                        int acol = tileCols * index$macro$56 + index$macro$54;
                        int arow = tileRows * index$macro$57 + index$macro$55;
                        arr[arow * totalCols + acol] = tile.getDouble(index$macro$54, index$macro$55);
                    }
                }
            }
        }
        return arr;
    }

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    @Override
    public int get(int col, int row) {
        int tcol = col / this.tileLayout().tileCols();
        int trow = row / this.tileLayout().tileRows();
        int pcol = col % this.tileLayout().tileCols();
        int prow = row % this.tileLayout().tileRows();
        return this.geotrellis$raster$CompositeTile$$getTile(tcol, trow).get(pcol, prow);
    }

    @Override
    public double getDouble(int col, int row) {
        int tcol = col / this.tileLayout().tileCols();
        int trow = row / this.tileLayout().tileRows();
        int pcol = col % this.tileLayout().tileCols();
        int prow = row % this.tileLayout().tileRows();
        return this.geotrellis$raster$CompositeTile$$getTile(tcol, trow).getDouble(pcol, prow);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$61 = 0; index$macro$61 < layoutRows; ++index$macro$61) {
            for (int index$macro$60 = 0; index$macro$60 < layoutCols; ++index$macro$60) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$60, index$macro$61);
                for (int index$macro$59 = 0; index$macro$59 < tileRows; ++index$macro$59) {
                    for (int index$macro$58 = 0; index$macro$58 < tileCols; ++index$macro$58) {
                        f.apply$mcVI$sp(tile.get(index$macro$58, index$macro$59));
                    }
                }
            }
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$65 = 0; index$macro$65 < layoutRows; ++index$macro$65) {
            for (int index$macro$64 = 0; index$macro$64 < layoutCols; ++index$macro$64) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$64, index$macro$65);
                for (int index$macro$63 = 0; index$macro$63 < tileRows; ++index$macro$63) {
                    for (int index$macro$62 = 0; index$macro$62 < tileCols; ++index$macro$62) {
                        f.apply$mcVD$sp(tile.getDouble(index$macro$62, index$macro$63));
                    }
                }
            }
        }
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$69 = 0; index$macro$69 < layoutRows; ++index$macro$69) {
            for (int index$macro$68 = 0; index$macro$68 < layoutCols; ++index$macro$68) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$68, index$macro$69);
                for (int index$macro$67 = 0; index$macro$67 < tileRows; ++index$macro$67) {
                    for (int index$macro$66 = 0; index$macro$66 < tileCols; ++index$macro$66) {
                        int acol = tileCols * index$macro$68 + index$macro$66;
                        int arow = tileRows * index$macro$69 + index$macro$67;
                        visitor.apply(acol, arow, tile.get(index$macro$66, index$macro$67));
                    }
                }
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$73 = 0; index$macro$73 < layoutRows; ++index$macro$73) {
            for (int index$macro$72 = 0; index$macro$72 < layoutCols; ++index$macro$72) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$72, index$macro$73);
                for (int index$macro$71 = 0; index$macro$71 < tileRows; ++index$macro$71) {
                    for (int index$macro$70 = 0; index$macro$70 < tileCols; ++index$macro$70) {
                        int acol = tileCols * index$macro$72 + index$macro$70;
                        int arow = tileRows * index$macro$73 + index$macro$71;
                        visitor.apply(acol, arow, tile.getDouble(index$macro$70, index$macro$71));
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$77 = 0; index$macro$77 < layoutRows; ++index$macro$77) {
            for (int index$macro$76 = 0; index$macro$76 < layoutCols; ++index$macro$76) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$76, index$macro$77);
                for (int index$macro$75 = 0; index$macro$75 < tileRows; ++index$macro$75) {
                    for (int index$macro$74 = 0; index$macro$74 < tileCols; ++index$macro$74) {
                        int acol = tileCols * index$macro$76 + index$macro$74;
                        int arow = tileRows * index$macro$77 + index$macro$75;
                        result.set(acol, arow, f.apply$mcII$sp(tile.get(index$macro$74, index$macro$75)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$81 = 0; index$macro$81 < layoutRows; ++index$macro$81) {
            for (int index$macro$80 = 0; index$macro$80 < layoutCols; ++index$macro$80) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$80, index$macro$81);
                for (int index$macro$79 = 0; index$macro$79 < tileRows; ++index$macro$79) {
                    for (int index$macro$78 = 0; index$macro$78 < tileCols; ++index$macro$78) {
                        int acol = tileCols * index$macro$80 + index$macro$78;
                        int arow = tileRows * index$macro$81 + index$macro$79;
                        result.setDouble(acol, arow, f.apply$mcDD$sp(tile.getDouble(index$macro$78, index$macro$79)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$85 = 0; index$macro$85 < layoutRows; ++index$macro$85) {
            for (int index$macro$84 = 0; index$macro$84 < layoutCols; ++index$macro$84) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$84, index$macro$85);
                for (int index$macro$83 = 0; index$macro$83 < tileRows; ++index$macro$83) {
                    for (int index$macro$82 = 0; index$macro$82 < tileCols; ++index$macro$82) {
                        int acol = tileCols * index$macro$84 + index$macro$82;
                        int arow = tileRows * index$macro$85 + index$macro$83;
                        result.set(acol, arow, mapper.apply(acol, arow, tile.get(index$macro$82, index$macro$83)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$89 = 0; index$macro$89 < layoutRows; ++index$macro$89) {
            for (int index$macro$88 = 0; index$macro$88 < layoutCols; ++index$macro$88) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$88, index$macro$89);
                for (int index$macro$87 = 0; index$macro$87 < tileRows; ++index$macro$87) {
                    for (int index$macro$86 = 0; index$macro$86 < tileCols; ++index$macro$86) {
                        int acol = tileCols * index$macro$88 + index$macro$86;
                        int arow = tileRows * index$macro$89 + index$macro$87;
                        result.setDouble(acol, arow, mapper.apply(acol, arow, tile.getDouble(index$macro$86, index$macro$87)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$93 = 0; index$macro$93 < layoutRows; ++index$macro$93) {
            for (int index$macro$92 = 0; index$macro$92 < layoutCols; ++index$macro$92) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$92, index$macro$93);
                for (int index$macro$91 = 0; index$macro$91 < tileRows; ++index$macro$91) {
                    for (int index$macro$90 = 0; index$macro$90 < tileCols; ++index$macro$90) {
                        int acol = tileCols * index$macro$92 + index$macro$90;
                        int arow = tileRows * index$macro$93 + index$macro$91;
                        result.set(acol, arow, f.apply$mcIII$sp(tile.get(index$macro$90, index$macro$91), other.get(acol, arow)));
                    }
                }
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$97 = 0; index$macro$97 < layoutRows; ++index$macro$97) {
            for (int index$macro$96 = 0; index$macro$96 < layoutCols; ++index$macro$96) {
                Tile tile = this.geotrellis$raster$CompositeTile$$getTile(index$macro$96, index$macro$97);
                for (int index$macro$95 = 0; index$macro$95 < tileRows; ++index$macro$95) {
                    for (int index$macro$94 = 0; index$macro$94 < tileCols; ++index$macro$94) {
                        int acol = tileCols * index$macro$96 + index$macro$94;
                        int arow = tileRows * index$macro$97 + index$macro$95;
                        result.setDouble(acol, arow, f.apply$mcDDD$sp(tile.getDouble(index$macro$94, index$macro$95), other.getDouble(acol, arow)));
                    }
                }
            }
        }
        return var3_3;
    }

    @Override
    public String asciiDraw() {
        StringBuilder sb = new StringBuilder();
        Predef$ predef$ = Predef$.MODULE$;
        int n = this.tileLayout().layoutRows();
        Serializable serializable = new Serializable(this, sb){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ CompositeTile $outer;
            public final StringBuilder sb$1;

            public final Object apply(int layoutRow) {
                BoxedUnit boxedUnit;
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, layoutRow){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$asciiDraw$1 $outer;
                    public final int layoutRow$1;

                    public final StringBuilder apply(int row) {
                        Predef$ predef$ = Predef$.MODULE$;
                        Serializable serializable = new Serializable(this, row){
                            public static final long serialVersionUID = 0L;
                            public final /* synthetic */ $anonfun$asciiDraw$1$$anonfun$apply$1 $outer;
                            public final int row$1;

                            public final Object apply(int layoutCol) {
                                BoxedUnit boxedUnit;
                                Tile tile = this.$outer.$outer.$outer.geotrellis$raster$CompositeTile$$getTile(layoutCol, this.$outer.layoutRow$1);
                                Predef$ predef$ = Predef$.MODULE$;
                                Serializable serializable = new Serializable(this, tile){
                                    public static final long serialVersionUID = 0L;
                                    public final /* synthetic */ $anonfun$asciiDraw$1$$anonfun$apply$1$$anonfun$apply$2 $outer;
                                    public final Tile tile$1;

                                    public final StringBuilder apply(int col) {
                                        int v = this.tile$1.get(col, this.$outer.row$1);
                                        String s = v == Integer.MIN_VALUE ? "ND" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)v)}));
                                        Predef$ predef$ = Predef$.MODULE$;
                                        Predef$ predef$2 = Predef$.MODULE$;
                                        String pad = new StringOps(" ").$times(scala.math.package$.MODULE$.max(6 - new StringOps(s).size(), 0));
                                        return this.$outer.$outer.$outer.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pad, s})));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.tile$1 = tile$1;
                                    }
                                };
                                Range range = RichInt$.MODULE$.until$extension0(0, this.$outer.$outer.$outer.tileLayout().tileCols());
                                if (!range.isEmpty()) {
                                    int n = range.start();
                                    while (true) {
                                        serializable.apply(n);
                                        if (n == range.lastElement()) break;
                                        n += range.step();
                                    }
                                }
                                if (layoutCol != this.$outer.geotrellis$raster$CompositeTile$$anonfun$$anonfun$$$outer().$outer.tileLayout().layoutCols() - 1) {
                                    Predef$ predef$2 = Predef$.MODULE$;
                                    String pad = new StringOps(" ").$times(5);
                                    boxedUnit = this.$outer.$outer.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "| "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pad}))).r();
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                return boxedUnit;
                            }

                            public /* synthetic */ $anonfun$asciiDraw$1$$anonfun$apply$1 geotrellis$raster$CompositeTile$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.row$1 = row$1;
                            }
                        };
                        Range range = RichInt$.MODULE$.until$extension0(0, this.$outer.$outer.tileLayout().layoutCols());
                        if (!range.isEmpty()) {
                            int n = range.start();
                            while (true) {
                                serializable.apply(n);
                                if (n == range.lastElement()) break;
                                n += range.step();
                            }
                        }
                        return this.$outer.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n"})).s((Seq)Nil$.MODULE$));
                    }

                    public /* synthetic */ $anonfun$asciiDraw$1 geotrellis$raster$CompositeTile$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.layoutRow$1 = layoutRow$1;
                    }
                };
                Range range = RichInt$.MODULE$.until$extension0(0, this.$outer.tileLayout().tileRows());
                if (!range.isEmpty()) {
                    int n = range.start();
                    while (true) {
                        serializable.apply(n);
                        if (n == range.lastElement()) break;
                        n += range.step();
                    }
                }
                if (layoutRow != this.$outer.tileLayout().layoutRows() - 1) {
                    Predef$ predef$2 = Predef$.MODULE$;
                    Predef$ predef$3 = Predef$.MODULE$;
                    String rowDiv = new StringBuilder().append((Object)new StringOps("-").$times(6 * this.$outer.tileLayout().tileCols() * this.$outer.tileLayout().layoutCols() - 2)).append((Object)new StringOps("-").$times(6 * this.$outer.tileLayout().layoutCols())).toString();
                    boxedUnit = this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowDiv})));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }

            public /* synthetic */ CompositeTile geotrellis$raster$CompositeTile$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sb$1 = sb$1;
            }
        };
        Range range = Range$.MODULE$.apply(0, n);
        if (!range.isEmpty()) {
            int n2 = range.start();
            while (true) {
                BoxedUnit boxedUnit;
                int n3 = n2;
                Predef$ predef$2 = Predef$.MODULE$;
                int n4 = this.tileLayout().tileRows();
                Serializable serializable2 = new /* invalid duplicate definition of identical inner class */;
                Range range2 = Range$.MODULE$.apply(0, n4);
                if (!range2.isEmpty()) {
                    int n5 = range2.start();
                    while (true) {
                        int n6 = n5;
                        Predef$ predef$3 = Predef$.MODULE$;
                        int n7 = serializable.$outer.tileLayout().layoutCols();
                        Serializable serializable3 = new /* invalid duplicate definition of identical inner class */;
                        Range range3 = Range$.MODULE$.apply(0, n7);
                        if (!range3.isEmpty()) {
                            int n8 = range3.start();
                            while (true) {
                                BoxedUnit boxedUnit2;
                                int n9 = n8;
                                Tile tile1 = serializable2.$outer.$outer.geotrellis$raster$CompositeTile$$getTile(n9, n3);
                                Predef$ predef$4 = Predef$.MODULE$;
                                Range range4 = RichInt$.MODULE$.until$extension0(0, serializable2.$outer.$outer.tileLayout().tileCols());
                                if (!range4.isEmpty()) {
                                    int n10 = range4.start();
                                    while (true) {
                                        int n11;
                                        int v1;
                                        String s1 = (v1 = tile1.get(n11 = n10, n6)) == Integer.MIN_VALUE ? "ND" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)v1)}));
                                        Predef$ predef$5 = Predef$.MODULE$;
                                        Predef$ predef$6 = Predef$.MODULE$;
                                        String pad2 = new StringOps(" ").$times(scala.math.package$.MODULE$.max(6 - new StringOps(s1).size(), 0));
                                        serializable3.$outer.$outer.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pad2, s1})));
                                        if (n10 == range4.lastElement()) break;
                                        n10 += range4.step();
                                    }
                                }
                                if (n9 != serializable2.$outer.$outer.tileLayout().layoutCols() - 1) {
                                    Predef$ predef$7 = Predef$.MODULE$;
                                    String pad1 = new StringOps(" ").$times(5);
                                    boxedUnit2 = serializable2.$outer.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "| "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pad1}))).r();
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                if (n8 == range3.lastElement()) break;
                                n8 += range3.step();
                            }
                        }
                        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n"})).s((Seq)Nil$.MODULE$));
                        if (n5 == range2.lastElement()) break;
                        n5 += range2.step();
                    }
                }
                if (n3 != this.tileLayout().layoutRows() - 1) {
                    Predef$ predef$8 = Predef$.MODULE$;
                    Predef$ predef$9 = Predef$.MODULE$;
                    String rowDiv1 = new StringBuilder().append((Object)new StringOps("-").$times(6 * this.tileLayout().tileCols() * this.tileLayout().layoutCols() - 2)).append((Object)new StringOps("-").$times(6 * this.tileLayout().layoutCols())).toString();
                    boxedUnit = sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowDiv1})));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (n2 == range.lastElement()) break;
                n2 += range.step();
            }
        }
        return sb.toString();
    }

    public CompositeTile copy(Seq<Tile> tiles, TileLayout tileLayout) {
        return new CompositeTile(tiles, tileLayout);
    }

    public Seq<Tile> copy$default$1() {
        return this.tiles();
    }

    public TileLayout copy$default$2() {
        return this.tileLayout();
    }

    public String productPrefix() {
        return "CompositeTile";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<Tile> seq;
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                seq = this.tileLayout();
                break;
            }
            case 0: {
                seq = this.tiles();
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompositeTile;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof CompositeTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompositeTile compositeTile = (CompositeTile)x$1;
        Seq<Tile> seq = this.tiles();
        Seq<Tile> seq2 = compositeTile.tiles();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        TileLayout tileLayout = this.tileLayout();
        TileLayout tileLayout2 = compositeTile.tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return false;
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return false;
        if (!compositeTile.canEqual(this)) return false;
        return true;
    }

    public CompositeTile(Seq<Tile> tiles, TileLayout tileLayout) {
        this.tiles = tiles;
        this.tileLayout = tileLayout;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        Product.class.$init$((Product)this);
        long l = tileLayout.totalCols();
        Predef$ predef$ = Predef$.MODULE$;
        boolean bl = RichLong$.MODULE$.isValidInt$extension(l);
        Predef$ predef$2 = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Total cols is not integer, cannot create such a large composite tile.").toString());
        }
        long l2 = tileLayout.totalRows();
        Predef$ predef$3 = Predef$.MODULE$;
        boolean bl2 = RichLong$.MODULE$.isValidInt$extension(l2);
        Predef$ predef$4 = Predef$.MODULE$;
        if (!bl2) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Total rows is not integer, cannot create such a large composite tile.").toString());
        }
        this.cols = (int)tileLayout.totalCols();
        this.rows = (int)tileLayout.totalRows();
        this.tileList = tiles.toList();
        this.tileCols = tileLayout.layoutCols();
        this.cellType = ((CellGrid)tiles.apply(0)).cellType();
    }
}

