/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CompositeTile;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.package$;
import geotrellis.raster.split.Split;
import geotrellis.raster.split.Split$Options$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class CompositeTile$
implements Serializable {
    public static final CompositeTile$ MODULE$;

    static {
        new CompositeTile$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompositeTile apply(Tile tile, TileLayout tileLayout) {
        if (!(tile instanceof CompositeTile)) return this.wrap(tile, tileLayout);
        CompositeTile compositeTile = (CompositeTile)tile;
        TileLayout tileLayout2 = tileLayout;
        TileLayout tileLayout3 = compositeTile.tileLayout();
        if (tileLayout2 == null) {
            if (tileLayout3 == null) return compositeTile;
            throw new GeoAttrsError(new StringBuilder().append((Object)"This tile is a composite tile with a different layout than the argument tile layout.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " does not match ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tileLayout, compositeTile.tileLayout()}))).toString());
        } else {
            if (!((Object)tileLayout2).equals(tileLayout3)) throw new GeoAttrsError(new StringBuilder().append((Object)"This tile is a composite tile with a different layout than the argument tile layout.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " does not match ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tileLayout, compositeTile.tileLayout()}))).toString());
            return compositeTile;
        }
    }

    public CompositeTile wrap(Tile tile, int tileCols, int tileRows) {
        TileLayout tileLayout = new TileLayout(tileCols, tileRows, (tile.cols() - 1) / tileCols + 1, (tile.rows() - 1) / tileRows + 1);
        return this.wrap(tile, tileLayout, true);
    }

    public CompositeTile wrap(Tile tile, int tileCols, int tileRows, boolean cropped) {
        TileLayout tileLayout = new TileLayout(tileCols, tileRows, (tile.cols() - 1) / tileCols + 1, (tile.rows() - 1) / tileRows + 1);
        return this.wrap(tile, tileLayout, cropped);
    }

    public CompositeTile wrap(Tile tile, TileLayout tileLayout) {
        return new CompositeTile((Seq<Tile>)Predef$.MODULE$.wrapRefArray((Object[])package$.MODULE$.withTileMethods(tile).split(tileLayout, new Split.Options(true, Split$Options$.MODULE$.apply$default$2()))), tileLayout);
    }

    public CompositeTile wrap(Tile tile, TileLayout tileLayout, boolean cropped) {
        return new CompositeTile((Seq<Tile>)Predef$.MODULE$.wrapRefArray((Object[])package$.MODULE$.withTileMethods(tile).split(tileLayout, new Split.Options(cropped, Split$Options$.MODULE$.apply$default$2()))), tileLayout);
    }

    public CompositeTile apply(Seq<Tile> tiles, TileLayout tileLayout) {
        return new CompositeTile(tiles, tileLayout);
    }

    public Option<Tuple2<Seq<Tile>, TileLayout>> unapply(CompositeTile x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.tiles(), (Object)x$0.tileLayout()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CompositeTile$() {
        MODULE$ = this;
    }
}

