/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.ArrayTile$class;
import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteCells;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.MutableArrayTile$class;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import geotrellis.raster.UByteArrayTile$;
import geotrellis.raster.UByteCells;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\u0001\u0003\u0003\u00039!!\u0004\"zi\u0016\f%O]1z)&dWM\u0003\u0002\u0004\t\u00051!/Y:uKJT\u0011!B\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005)\u0011M\u001d:bsV\tQ\u0003E\u0002\n-aI!a\u0006\u0006\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%I\u0012B\u0001\u000e\u000b\u0005\u0011\u0011\u0015\u0010^3\t\u0011q\u0001!\u0011!Q\u0001\nU\ta!\u0019:sCf\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\t\r|Gn\u001d\t\u0003\u0013\u0001J!!\t\u0006\u0003\u0007%sG\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003 \u0003\u0011\u0011xn^:\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00119\u0003&\u000b\u0016\u0011\u0005=\u0001\u0001\"B\n%\u0001\u0004)\u0002\"\u0002\u0010%\u0001\u0004y\u0002\"B\u0012%\u0001\u0004y\u0002b\u0002\u0017\u0001\u0005\u00045\t!L\u0001\tG\u0016dG\u000eV=qKV\taFE\u00020cQ2A\u0001\r\u0001\u0001]\taAH]3gS:,W.\u001a8u}A\u0011qBM\u0005\u0003g\t\u0011\u0011BQ=uK\u000e+G\u000e\\:\u0011\u0005=)\u0014B\u0001\u001c\u0003\u00059qu\u000eR1uC\"\u000bg\u000e\u001a7j]\u001eDQ\u0001\u000f\u0001\u0005\u0002e\nq\u0001^8CsR,7\u000fF\u0001\u0016\u0011\u0015Y\u0004\u0001\"\u0001=\u0003\u0011\u0019w\u000e]=\u0016\u0003\u001dBQA\u0010\u0001\u0005\u0002}\n!b^5uQ:{G)\u0019;b)\t\u00015\t\u0005\u0002\u0010\u0003&\u0011!I\u0001\u0002\u0005)&dW\rC\u0003E{\u0001\u0007Q)A\u0006o_\u0012\u000bG/\u0019,bYV,\u0007cA\u0005G\u0011&\u0011qI\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005%I\u0015B\u0001&\u000b\u0005\u0019!u.\u001e2mK\")A\n\u0001C\u0001\u001b\u0006Y\u0011N\u001c;feB\u0014X\r^!t)\t\u0001e\nC\u0003P\u0017\u0002\u0007\u0001+A\u0006oK^\u001cU\r\u001c7UsB,\u0007CA)U\u001d\ty!+\u0003\u0002T\u0005\u00059\u0001/Y2lC\u001e,\u0017BA+W\u0005!\u0019U\r\u001c7UsB,'BA*\u0003\u000f\u0015A&\u0001#\u0001Z\u00035\u0011\u0015\u0010^3BeJ\f\u0017\u0010V5mKB\u0011qB\u0017\u0004\u0006\u0003\tA\taW\n\u00045\"a\u0006CA\u0005^\u0013\tq&B\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003&5\u0012\u0005\u0001\rF\u0001Z\u0011\u0015\u0011'\f\"\u0001d\u0003\u0015\t\u0007\u000f\u001d7z)\u00119CMZ4\t\u000b\u0015\f\u0007\u0019A\u000b\u0002\u0007\u0005\u0014(\u000fC\u0003\u001fC\u0002\u0007q\u0004C\u0003$C\u0002\u0007q\u0004C\u0003c5\u0012\u0005\u0011\u000eF\u0003(U.dW\u000eC\u0003fQ\u0002\u0007Q\u0003C\u0003\u001fQ\u0002\u0007q\u0004C\u0003$Q\u0002\u0007q\u0004C\u0003-Q\u0002\u0007aNE\u0002pcQ2A\u0001\r.\u0001]\")!M\u0017C\u0001cR)qE]:uk\")Q\r\u001da\u0001+!)a\u0004\u001da\u0001?!)1\u0005\u001da\u0001?!)A\t\u001da\u0001mB\u0019\u0011B\u0012\r\t\u000b\tTF\u0011\u0001=\u0015\u000b\u001dJ(p\u001f?\t\u000b\u0015<\b\u0019A\u000b\t\u000by9\b\u0019A\u0010\t\u000b\r:\b\u0019A\u0010\t\u000b\u0011;\b\u0019\u0001\r\t\u000byTF\u0011A@\u0002\u000b=4G)[7\u0015\u000b\u001d\n\t!a\u0001\t\u000byi\b\u0019A\u0010\t\u000b\rj\b\u0019A\u0010\t\ryTF\u0011AA\u0004)\u001d9\u0013\u0011BA\u0006\u0003\u001bAaAHA\u0003\u0001\u0004y\u0002BB\u0012\u0002\u0006\u0001\u0007q\u0004C\u0004-\u0003\u000b\u0001\r!a\u0004\u0013\t\u0005E\u0011\u0007\u000e\u0004\u0006ai\u0003\u0011q\u0002\u0005\b\u0003+QF\u0011AA\f\u0003\u0015)W\u000e\u001d;z)\u00159\u0013\u0011DA\u000e\u0011\u0019q\u00121\u0003a\u0001?!11%a\u0005A\u0002}Aq!!\u0006[\t\u0003\ty\u0002F\u0004(\u0003C\t\u0019#!\n\t\ry\ti\u00021\u0001 \u0011\u0019\u0019\u0013Q\u0004a\u0001?!9A&!\bA\u0002\u0005\u001d\"\u0003BA\u0015cQ2Q\u0001\r.\u0001\u0003OAq!!\f[\t\u0003\ty#\u0001\u0003gS2dGcB\u0014\u00022\u0005U\u0012q\u0007\u0005\b\u0003g\tY\u00031\u0001\u0019\u0003\u00051\bB\u0002\u0010\u0002,\u0001\u0007q\u0004\u0003\u0004$\u0003W\u0001\ra\b\u0005\b\u0003[QF\u0011AA\u001e)%9\u0013QHA \u0003\u0003\n\u0019\u0005C\u0004\u00024\u0005e\u0002\u0019\u0001\r\t\ry\tI\u00041\u0001 \u0011\u0019\u0019\u0013\u0011\ba\u0001?!9A&!\u000fA\u0002\u0005\u0015#\u0003BA$cQ2Q\u0001\r.\u0001\u0003\u000bBq!a\u0013[\t\u0003\ti%A\u0005ge>l')\u001f;fgR9q%a\u0014\u0002T\u0005U\u0003bBA)\u0003\u0013\u0002\r!F\u0001\u0006Ef$Xm\u001d\u0005\u0007=\u0005%\u0003\u0019A\u0010\t\r\r\nI\u00051\u0001 \u0011\u001d\tYE\u0017C\u0001\u00033\"\u0012bJA.\u0003;\ny&!\u0019\t\u000f\u0005E\u0013q\u000ba\u0001+!1a$a\u0016A\u0002}AaaIA,\u0001\u0004y\u0002b\u0002\u0017\u0002X\u0001\u0007\u00111\r\n\u0005\u0003K\nDGB\u000315\u0002\t\u0019\u0007C\u0005\u0002ji\u000b\t\u0011\"\u0003\u0002l\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0003o\nAA[1wC&!\u00111PA9\u0005\u0019y%M[3di\u0002")
public abstract class ByteArrayTile
implements MutableArrayTile {
    private final byte[] array;
    private final int cols;
    private final int rows;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static ByteArrayTile fromBytes(byte[] byArray, int n, int n2, ByteCells byteCells) {
        return ByteArrayTile$.MODULE$.fromBytes(byArray, n, n2, byteCells);
    }

    public static ByteArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return ByteArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static ByteArrayTile fill(byte by, int n, int n2, ByteCells byteCells) {
        return ByteArrayTile$.MODULE$.fill(by, n, n2, byteCells);
    }

    public static ByteArrayTile fill(byte by, int n, int n2) {
        return ByteArrayTile$.MODULE$.fill(by, n, n2);
    }

    public static ByteArrayTile empty(int n, int n2, ByteCells byteCells) {
        return ByteArrayTile$.MODULE$.empty(n, n2, byteCells);
    }

    public static ByteArrayTile empty(int n, int n2) {
        return ByteArrayTile$.MODULE$.empty(n, n2);
    }

    public static ByteArrayTile ofDim(int n, int n2, ByteCells byteCells) {
        return ByteArrayTile$.MODULE$.ofDim(n, n2, byteCells);
    }

    public static ByteArrayTile ofDim(int n, int n2) {
        return ByteArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile$class.mutable(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile$class.set(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile$class.setDouble(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update2) {
        MutableArrayTile$class.update(this, colOffset, rowOffset, update2);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile$class.toArrayTile(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile$class.convert(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreach(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile$class.foreachDouble(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile$class.foreachIntVisitor(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile$class.foreachDoubleVisitor(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile$class.map(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile$class.mapDouble(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile$class.mapIntMapper(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile$class.mapDoubleMapper(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combine((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile$class.combineDouble((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile$class.equals(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile$class.get(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile$class.getDouble(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile$class.toList(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile$class.toListDouble(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile$class.toArray(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile$class.toArrayDouble(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDraw() {
        return Tile$class.asciiDraw(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        ByteArrayTile byteArrayTile = this;
        synchronized (byteArrayTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    public byte[] array() {
        return this.array;
    }

    public abstract ByteCells cellType();

    @Override
    public byte[] toBytes() {
        return (byte[])this.array().clone();
    }

    @Override
    public ByteArrayTile copy() {
        return ArrayTile$.MODULE$.apply((byte[])this.array().clone(), this.cols, this.rows);
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return ByteArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        if (newCellType instanceof ByteCells) {
            ByteCells byteCells = (ByteCells)((Object)newCellType);
            tile = ByteArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, byteCells);
        } else if (newCellType instanceof UByteCells) {
            UByteCells uByteCells = (UByteCells)((Object)newCellType);
            tile = UByteArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, uByteCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public ByteArrayTile(byte[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        ArrayTile$class.$init$(this);
        MutableArrayTile$class.$init$(this);
    }
}

