/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.ConstantTile$class;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile$class;
import geotrellis.raster.MappableTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.Tile$class;
import java.lang.constant.Constable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005]u!B\u0001\u0003\u0011\u00039\u0011a\u0004\"ji\u000e{gn\u001d;b]R$\u0016\u000e\\3\u000b\u0005\r!\u0011A\u0002:bgR,'OC\u0001\u0006\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u0005=\u0011\u0015\u000e^\"p]N$\u0018M\u001c;US2,7cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\f\n\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u0015I\u0012\u0002\"\u0001\u001b\u0003\u0015\t\u0007\u000f\u001d7z)\u001dY\u0012qMA6\u0003[\u0002\"\u0001\u0003\u000f\u0007\t)\u0011\u0001)H\n\u000691q\u0012E\u0005\t\u0003\u0011}I!\u0001\t\u0002\u0003\u0019\r{gn\u001d;b]R$\u0016\u000e\\3\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\u001d\u0001&o\u001c3vGRD\u0001\"\n\u000f\u0003\u0016\u0004%\tAJ\u0001\u0002mV\tq\u0005\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\b\u0005>|G.Z1o\u0011!YCD!E!\u0002\u00139\u0013A\u0001<!\u0011!iCD!f\u0001\n\u0003q\u0013\u0001B2pYN,\u0012a\f\t\u0003\u001bAJ!!\r\b\u0003\u0007%sG\u000f\u0003\u000549\tE\t\u0015!\u00030\u0003\u0015\u0019w\u000e\\:!\u0011!)DD!f\u0001\n\u0003q\u0013\u0001\u0002:poND\u0001b\u000e\u000f\u0003\u0012\u0003\u0006IaL\u0001\u0006e><8\u000f\t\u0005\u0006-q!\t!\u000f\u000b\u00057iZD\bC\u0003&q\u0001\u0007q\u0005C\u0003.q\u0001\u0007q\u0006C\u00036q\u0001\u0007q\u0006C\u0004?9\t\u0007I\u0011\u0003\u0018\u0002\t%4\u0016\r\u001c\u0005\u0007\u0001r\u0001\u000b\u0011B\u0018\u0002\u000b%4\u0016\r\u001c\u0011\t\u000f\tc\"\u0019!C\t\u0007\u0006!AMV1m+\u0005!\u0005CA\u0007F\u0013\t1eB\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0011r\u0001\u000b\u0011\u0002#\u0002\u000b\u00114\u0016\r\u001c\u0011\t\u000f)c\"\u0019!C\u0001\u0017\u0006A1-\u001a7m)f\u0004X-F\u0001M\u001d\tAQ*\u0003\u0002O\u0005\u0005Y!)\u001b;DK2dG+\u001f9f\u0011\u0019\u0001F\u0004)A\u0005\u0019\u0006I1-\u001a7m)f\u0004X\r\t\u0005\u0006%r!\taU\u0001\fi>\f%O]1z)&dW\rF\u0001U!\tAQ+\u0003\u0002W\u0005\tI\u0011I\u001d:bsRKG.\u001a\u0005\u00061r!\t!W\u0001\b[V$\u0018M\u00197f)\u0005Q\u0006C\u0001\u0005\\\u0013\ta&A\u0001\tNkR\f'\r\\3BeJ\f\u0017\u0010V5mK\")a\f\bC\u0001?\u00069Ao\u001c\"zi\u0016\u001cH#\u00011\u0011\u00075\t7-\u0003\u0002c\u001d\t)\u0011I\u001d:bsB\u0011Q\u0002Z\u0005\u0003K:\u0011AAQ=uK\")q\r\bC\u0001Q\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005yI\u0007\"\u00026g\u0001\u0004Y\u0017a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!\u00047E\u0013\tigB\u0001\u0004PaRLwN\u001c\u0005\b_r\t\t\u0011\"\u0001q\u0003\u0011\u0019w\u000e]=\u0015\tm\t(o\u001d\u0005\bK9\u0004\n\u00111\u0001(\u0011\u001dic\u000e%AA\u0002=Bq!\u000e8\u0011\u0002\u0003\u0007q\u0006C\u0004v9E\u0005I\u0011\u0001<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tqO\u000b\u0002(q.\n\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003}:\t!\"\u00198o_R\fG/[8o\u0013\r\t\ta\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u00039E\u0005I\u0011AA\u0004\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0003+\u0005=B\b\"CA\u00079E\u0005I\u0011AA\u0004\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!\u0005\u001d\u0003\u0003%\t%a\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\t1\fgn\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0019\u0019FO]5oO\"A\u0011q\u0005\u000f\u0002\u0002\u0013\u0005a&\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002,q\t\t\u0011\"\u0001\u0002.\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0018\u0003k\u00012!DA\u0019\u0013\r\t\u0019D\u0004\u0002\u0004\u0003:L\b\"CA\u001c\u0003S\t\t\u00111\u00010\u0003\rAH%\r\u0005\n\u0003wa\u0012\u0011!C!\u0003{\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0001b!!\u0011\u0002H\u0005=RBAA\"\u0015\r\t)ED\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u001bb\u0012\u0011!C\u0001\u0003\u001f\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004O\u0005E\u0003BCA\u001c\u0003\u0017\n\t\u00111\u0001\u00020!I\u0011Q\u000b\u000f\u0002\u0002\u0013\u0005\u0013qK\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0006C\u0005\u0002\\q\t\t\u0011\"\u0011\u0002^\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0016!I\u0011\u0011\r\u000f\u0002\u0002\u0013\u0005\u00131M\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u001d\n)\u0007\u0003\u0006\u00028\u0005}\u0013\u0011!a\u0001\u0003_Aa!!\u001b\u0019\u0001\u0004y\u0013!A5\t\u000b5B\u0002\u0019A\u0018\t\u000bUB\u0002\u0019A\u0018\t\u0011eI\u0011\u0011!CA\u0003c\"raGA:\u0003k\n9\b\u0003\u0004&\u0003_\u0002\ra\n\u0005\u0007[\u0005=\u0004\u0019A\u0018\t\rU\ny\u00071\u00010\u0011%\tY(CA\u0001\n\u0003\u000bi(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u0014q\u0011\t\u0005\u001b1\f\t\t\u0005\u0004\u000e\u0003\u0007;sfL\u0005\u0004\u0003\u000bs!A\u0002+va2,7\u0007C\u0005\u0002\n\u0006e\u0014\u0011!a\u00017\u0005\u0019\u0001\u0010\n\u0019\t\u0013\u00055\u0015\"!A\u0005\n\u0005=\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!%\u0011\t\u0005]\u00111S\u0005\u0005\u0003+\u000bIB\u0001\u0004PE*,7\r\u001e")
public class BitConstantTile
implements ConstantTile,
Product {
    private final boolean v;
    private final int cols;
    private final int rows;
    private final int iVal;
    private final double dVal;
    private final BitCellType$ cellType;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Object, Object, Object>> unapply(BitConstantTile bitConstantTile) {
        return BitConstantTile$.MODULE$.unapply(bitConstantTile);
    }

    public static BitConstantTile apply(boolean bl, int n, int n2) {
        return BitConstantTile$.MODULE$.apply(bl, n, n2);
    }

    public static BitConstantTile apply(int n, int n2, int n3) {
        return BitConstantTile$.MODULE$.apply(n, n2, n3);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile$class.get(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile$class.getDouble(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile$class.toArray(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile$class.toArrayDouble(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile$class.convert(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile$class.interpretAs(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile$class.foreach(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile$class.foreachDouble(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile$class.foreachIntVisitor(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile$class.foreachDoubleVisitor(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ConstantTile$class.map(this, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile$class.combine(this, other, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ConstantTile$class.mapDouble(this, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile$class.combineDouble(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile$class.mapIntMapper(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile$class.mapDoubleMapper(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile$class.dualForeach(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile$class.mapIfSet(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile$class.mapIfSetDouble(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMap(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile$class.dualMapIfSet(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile$class.dualCombine(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile$class.isNoDataTile(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile$class.normalize((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile$class.rescale((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile$class.downsample(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile$class.findMinMax(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile$class.findMinMaxDouble(this);
    }

    @Override
    public String asciiDraw() {
        return Tile$class.asciiDraw(this);
    }

    @Override
    public String asciiDrawDouble(int significantDigits) {
        return Tile$class.asciiDrawDouble(this, significantDigits);
    }

    @Override
    public String asciiDrawRange(int colMin, int colMax, int rowMin, int rowMax) {
        return Tile$class.asciiDrawRange(this, colMin, colMax, rowMin, rowMax);
    }

    @Override
    public int asciiDrawDouble$default$1() {
        return Tile$class.asciiDrawDouble$default$1(this);
    }

    private Logger logger$lzycompute() {
        BitConstantTile bitConstantTile = this;
        synchronized (bitConstantTile) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    public boolean v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public BitCellType$ cellType() {
        return this.cellType;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return BitArrayTile$.MODULE$.fill(this.v(), this.cols(), this.rows());
    }

    @Override
    public byte[] toBytes() {
        return new byte[]{(byte)this.iVal()};
    }

    @Override
    public ConstantTile withNoData(Option<Object> noDataValue) {
        return this;
    }

    public BitConstantTile copy(boolean v, int cols, int rows) {
        return new BitConstantTile(v, cols, rows);
    }

    public boolean copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public String productPrefix() {
        return "BitConstantTile";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Constable constable;
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                constable = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            case 1: {
                constable = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 0: {
                constable = BoxesRunTime.boxToBoolean((boolean)this.v());
            }
        }
        return constable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitConstantTile;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)(this.v() ? 1231 : 1237)), (int)this.cols()), (int)this.rows()), (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof BitConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitConstantTile bitConstantTile = (BitConstantTile)x$1;
        if (this.v() != bitConstantTile.v()) return false;
        if (this.cols() != bitConstantTile.cols()) return false;
        if (this.rows() != bitConstantTile.rows()) return false;
        if (!bitConstantTile.canEqual(this)) return false;
        return true;
    }

    public BitConstantTile(boolean v, int cols, int rows) {
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        Grid$class.$init$(this);
        IterableTile$class.$init$(this);
        MappableTile$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Tile$class.$init$(this);
        ConstantTile$class.$init$(this);
        Product.class.$init$((Product)this);
        this.iVal = v ? 1 : 0;
        this.dVal = v ? 1.0 : 0.0;
        this.cellType = BitCellType$.MODULE$;
    }
}

