/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CompositeTile;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.CroppedTile;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public abstract class ArrayTile$class {
    public static ArrayTile toArrayTile(ArrayTile $this) {
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayTile convert(ArrayTile $this, DataType targetCellType) {
        void var2_2;
        BoxedUnit boxedUnit;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, $this.cols(), $this.rows());
        if (targetCellType.isFloatingPoint() != $this.cellType().isFloatingPoint()) {
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion from ", " to ", " may lead to data loss."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.cellType(), targetCellType})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if ($this.cellType().isFloatingPoint()) {
            for (int index$macro$33 = 0; index$macro$33 < $this.rows(); ++index$macro$33) {
                for (int index$macro$32 = 0; index$macro$32 < $this.cols(); ++index$macro$32) {
                    tile.setDouble(index$macro$32, index$macro$33, $this.getDouble(index$macro$32, index$macro$33));
                }
            }
        } else {
            for (int index$macro$31 = 0; index$macro$31 < $this.rows(); ++index$macro$31) {
                for (int index$macro$30 = 0; index$macro$30 < $this.cols(); ++index$macro$30) {
                    tile.set(index$macro$30, index$macro$31, $this.get(index$macro$30, index$macro$31));
                }
            }
        }
        return var2_2;
    }

    public static void foreach(ArrayTile $this, Function1 f) {
        int len = $this.size();
        for (int i = 0; i < len; ++i) {
            f.apply$mcVI$sp($this.apply(i));
        }
    }

    public static void foreachDouble(ArrayTile $this, Function1 f) {
        int len = $this.size();
        for (int i = 0; i < len; ++i) {
            f.apply$mcVD$sp($this.applyDouble(i));
        }
    }

    public static void foreachIntVisitor(ArrayTile $this, IntTileVisitor visitor) {
        for (int index$macro$35 = 0; index$macro$35 < $this.rows(); ++index$macro$35) {
            for (int index$macro$34 = 0; index$macro$34 < $this.cols(); ++index$macro$34) {
                visitor.apply(index$macro$34, index$macro$35, $this.get(index$macro$34, index$macro$35));
            }
        }
    }

    public static void foreachDoubleVisitor(ArrayTile $this, DoubleTileVisitor visitor) {
        for (int index$macro$37 = 0; index$macro$37 < $this.rows(); ++index$macro$37) {
            for (int index$macro$36 = 0; index$macro$36 < $this.cols(); ++index$macro$36) {
                visitor.apply(index$macro$36, index$macro$37, $this.getDouble(index$macro$36, index$macro$37));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Tile map(ArrayTile $this, Function1 f) {
        void var2_2;
        MutableArrayTile output = ArrayTile$.MODULE$.alloc($this.cellType(), $this.cols(), $this.rows());
        int len = $this.size();
        for (int i = 0; i < len; ++i) {
            output.update(i, f.apply$mcII$sp($this.apply(i)));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Tile mapDouble(ArrayTile $this, Function1 f) {
        void var3_3;
        int len = $this.size();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc($this.cellType(), $this.cols(), $this.rows());
        for (int i = 0; i < len; ++i) {
            tile.updateDouble(i, f.apply$mcDD$sp($this.applyDouble(i)));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Tile mapIntMapper(ArrayTile $this, IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc($this.cellType(), $this.cols(), $this.rows());
        for (int index$macro$39 = 0; index$macro$39 < $this.rows(); ++index$macro$39) {
            for (int index$macro$38 = 0; index$macro$38 < $this.cols(); ++index$macro$38) {
                tile.set(index$macro$38, index$macro$39, mapper.apply(index$macro$38, index$macro$39, $this.get(index$macro$38, index$macro$39)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Tile mapDoubleMapper(ArrayTile $this, DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc($this.cellType(), $this.cols(), $this.rows());
        for (int index$macro$41 = 0; index$macro$41 < $this.rows(); ++index$macro$41) {
            for (int index$macro$40 = 0; index$macro$40 < $this.cols(); ++index$macro$40) {
                tile.setDouble(index$macro$40, index$macro$41, mapper.apply(index$macro$40, index$macro$41, $this.getDouble(index$macro$40, index$macro$41)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayTile combine(ArrayTile $this, ArrayTile other, Function2 f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)$this, (Object)other)).assertEqualDimensions();
        MutableArrayTile output = ArrayTile$.MODULE$.alloc($this.cellType().union(other.cellType()), $this.cols(), $this.rows());
        int len = $this.size();
        for (int i = 0; i < len; ++i) {
            output.update(i, f.apply$mcIII$sp($this.apply(i), other.apply(i)));
        }
        return var3_3;
    }

    public static Tile combine(ArrayTile $this, Tile other, Function2 f) {
        block6: {
            Tile tile;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!(other instanceof ArrayTile)) break block2;
                            ArrayTile arrayTile = (ArrayTile)other;
                            tile = $this.combine(arrayTile, (Function2<Object, Object, Object>)f);
                            break block3;
                        }
                        if (!(other instanceof ConstantTile)) break block4;
                        ConstantTile constantTile = (ConstantTile)other;
                        tile = constantTile.combine($this, (Function2<Object, Object, Object>)f);
                        break block3;
                    }
                    if (!(other instanceof CompositeTile)) break block5;
                    CompositeTile compositeTile = (CompositeTile)other;
                    tile = compositeTile.combine($this, (Function2<Object, Object, Object>)new Serializable($this, f){
                        public static final long serialVersionUID = 0L;
                        public final Function2 f$1;

                        public final int apply(int z1, int z2) {
                            return this.f$1.apply$mcIII$sp(z2, z1);
                        }

                        public int apply$mcIII$sp(int z1, int z2) {
                            return this.f$1.apply$mcIII$sp(z2, z1);
                        }
                        {
                            this.f$1 = f$1;
                        }
                    });
                    break block3;
                }
                if (!(other instanceof CroppedTile)) break block6;
                CroppedTile croppedTile = (CroppedTile)other;
                tile = croppedTile.combine($this, (Function2<Object, Object, Object>)new Serializable($this, f){
                    public static final long serialVersionUID = 0L;
                    public final Function2 f$1;

                    public final int apply(int z1, int z2) {
                        return this.f$1.apply$mcIII$sp(z2, z1);
                    }

                    public int apply$mcIII$sp(int z1, int z2) {
                        return this.f$1.apply$mcIII$sp(z2, z1);
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }
            return tile;
        }
        throw new MatchError((Object)other);
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayTile combineDouble(ArrayTile $this, ArrayTile other, Function2 f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)$this, (Object)other)).assertEqualDimensions();
        MutableArrayTile output = ArrayTile$.MODULE$.alloc($this.cellType().union(other.cellType()), $this.cols(), $this.rows());
        int len = $this.size();
        for (int i = 0; i < len; ++i) {
            output.updateDouble(i, f.apply$mcDDD$sp($this.applyDouble(i), other.applyDouble(i)));
        }
        return var3_3;
    }

    public static Tile combineDouble(ArrayTile $this, Tile other, Function2 f) {
        block5: {
            Tile tile;
            block3: {
                block4: {
                    block2: {
                        if (!(other instanceof ArrayTile)) break block2;
                        ArrayTile arrayTile = (ArrayTile)other;
                        tile = $this.combineDouble(arrayTile, (Function2<Object, Object, Object>)f);
                        break block3;
                    }
                    if (!(other instanceof ConstantTile)) break block4;
                    ConstantTile constantTile = (ConstantTile)other;
                    tile = constantTile.combineDouble($this, (Function2<Object, Object, Object>)f);
                    break block3;
                }
                if (!(other instanceof CompositeTile)) break block5;
                CompositeTile compositeTile = (CompositeTile)other;
                tile = compositeTile.combineDouble($this, (Function2<Object, Object, Object>)new Serializable($this, f){
                    public static final long serialVersionUID = 0L;
                    public final Function2 f$2;

                    public final double apply(double z1, double z2) {
                        return this.f$2.apply$mcDDD$sp(z2, z1);
                    }

                    public double apply$mcDDD$sp(double z1, double z2) {
                        return this.f$2.apply$mcDDD$sp(z2, z1);
                    }
                    {
                        this.f$2 = f$2;
                    }
                });
            }
            return tile;
        }
        throw new MatchError((Object)other);
    }

    public static boolean equals(ArrayTile $this, Object other) {
        boolean bl;
        if (other instanceof ArrayTile) {
            ArrayTile arrayTile = (ArrayTile)other;
            if (arrayTile == null) {
                return false;
            }
            int len = $this.size();
            if (len != arrayTile.size()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if ($this.apply(i) == arrayTile.apply(i)) continue;
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static int get(ArrayTile $this, int col, int row) {
        return $this.apply(row * $this.cols() + col);
    }

    public static double getDouble(ArrayTile $this, int col, int row) {
        return $this.applyDouble(row * $this.cols() + col);
    }

    public static List toList(ArrayTile $this) {
        return Predef$.MODULE$.intArrayOps($this.toArray()).toList();
    }

    public static List toListDouble(ArrayTile $this) {
        return Predef$.MODULE$.doubleArrayOps($this.toArrayDouble()).toList();
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toArray(ArrayTile $this) {
        void var2_2;
        int len = $this.size();
        int[] arr = (int[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Int());
        for (int i = 0; i < len; ++i) {
            arr[i] = $this.apply(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toArrayDouble(ArrayTile $this) {
        void var2_2;
        int len = $this.size();
        double[] arr = (double[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Double());
        for (int i = 0; i < len; ++i) {
            arr[i] = $this.applyDouble(i);
        }
        return var2_2;
    }

    public static void $init$(ArrayTile $this) {
    }
}

