/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileCombiner10;
import geotrellis.macros.DoubleTileCombiner3;
import geotrellis.macros.DoubleTileCombiner4;
import geotrellis.macros.DoubleTileCombiner5;
import geotrellis.macros.DoubleTileCombiner6;
import geotrellis.macros.DoubleTileCombiner7;
import geotrellis.macros.DoubleTileCombiner8;
import geotrellis.macros.DoubleTileCombiner9;
import geotrellis.macros.IntTileCombiner10;
import geotrellis.macros.IntTileCombiner3;
import geotrellis.macros.IntTileCombiner4;
import geotrellis.macros.IntTileCombiner5;
import geotrellis.macros.IntTileCombiner6;
import geotrellis.macros.IntTileCombiner7;
import geotrellis.macros.IntTileCombiner8;
import geotrellis.macros.IntTileCombiner9;
import geotrellis.macros.MacroCombineFunctions;
import geotrellis.raster.ArrayMultibandTile$;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid$class;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MacroMultibandCombiners;
import geotrellis.raster.MacroMultibandCombiners$class;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$class;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\t%s!B\u0001\u0003\u0011\u00039\u0011AE!se\u0006LX*\u001e7uS\n\fg\u000e\u001a+jY\u0016T!a\u0001\u0003\u0002\rI\f7\u000f^3s\u0015\u0005)\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!AE!se\u0006LX*\u001e7uS\n\fg\u000e\u001a+jY\u0016\u001c2!\u0003\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u0011QbE\u0005\u0003)9\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAF\u0005\u0005\u0002]\ta\u0001P5oSRtD#A\u0004\t\u000beIA\u0011\u0001\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007m\tY\u0010\u0005\u0002\t9\u0019!!B\u0001\u0001\u001e'\u0011aBBH\u0011\u0011\u0005!y\u0012B\u0001\u0011\u0003\u00055iU\u000f\u001c;jE\u0006tG\rV5mKB\u0011\u0001BI\u0005\u0003G\t\u0011q#T1de>lU\u000f\u001c;jE\u0006tGmQ8nE&tWM]:\t\u0011\u0015b\"\u0011!Q\u0001\n\u0019\naa\u00182b]\u0012\u001c\bcA\u0007(S%\u0011\u0001F\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0011)J!a\u000b\u0002\u0003\tQKG.\u001a\u0005\u0006-q!\t!\f\u000b\u000379BQ!\n\u0017A\u0002\u0019Bq\u0001\r\u000fC\u0002\u0013\u0005\u0011'A\u0005cC:$7i\\;oiV\t!\u0007\u0005\u0002\u000eg%\u0011AG\u0004\u0002\u0004\u0013:$\bB\u0002\u001c\u001dA\u0003%!'\u0001\u0006cC:$7i\\;oi\u0002BQ\u0001\u000f\u000f\u0005\ne\nAB^1mS\u0012\fG/\u001a\"b]\u0012$\"AO\u001f\u0011\u00055Y\u0014B\u0001\u001f\u000f\u0005\u0011)f.\u001b;\t\u000by:\u0004\u0019\u0001\u001a\u0002\u0003%Dq\u0001\u0011\u000fC\u0002\u0013\u0005\u0011)\u0001\u0005dK2dG+\u001f9f+\u0005\u0011\u0005CA\"G\u001d\tAA)\u0003\u0002F\u0005\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005!\u0019U\r\u001c7UsB,'BA#\u0003\u0011\u0019QE\u0004)A\u0005\u0005\u0006I1-\u001a7m)f\u0004X\r\t\u0005\b\u0019r\u0011\r\u0011\"\u00012\u0003\u0011\u0019w\u000e\\:\t\r9c\u0002\u0015!\u00033\u0003\u0015\u0019w\u000e\\:!\u0011\u001d\u0001FD1A\u0005\u0002E\nAA]8xg\"1!\u000b\bQ\u0001\nI\nQA]8xg\u0002BQ\u0001\u0016\u000f\u0005\u0002U\u000bAAY1oIR\u0011\u0011F\u0016\u0005\u0006/N\u0003\rAM\u0001\nE\u0006tG-\u00138eKbDQ!\u0017\u000f\u0005\u0002i\u000bQAY1oIN,\u0012a\u0017\t\u00049zKcBA\u0007^\u0013\t)e\"\u0003\u0002`A\n1a+Z2u_JT!!\u0012\b\t\u000b\tdB\u0011A2\u0002\u000f\r|gN^3siR\u0011a\u0004\u001a\u0005\u0006K\u0006\u0004\rAQ\u0001\f]\u0016<8)\u001a7m)f\u0004X\rC\u0003h9\u0011\u0005\u0001.\u0001\u0006xSRDgj\u001c#bi\u0006$\"AH5\t\u000b)4\u0007\u0019A6\u0002\u00179|G)\u0019;b-\u0006dW/\u001a\t\u0004\u001b1t\u0017BA7\u000f\u0005\u0019y\u0005\u000f^5p]B\u0011Qb\\\u0005\u0003a:\u0011a\u0001R8vE2,\u0007\"\u0002:\u001d\t\u0003\u0019\u0018aC5oi\u0016\u0014\bO]3u\u0003N$\"A\b;\t\u000b\u0015\f\b\u0019\u0001\"\t\u000bYdB\u0011A<\u0002\u00075\f\u0007\u000f\u0006\u0002y}R\u0011a$\u001f\u0005\u0006uV\u0004\ra_\u0001\u0002MB)Q\u0002 \u001a3e%\u0011QP\u0004\u0002\n\rVt7\r^5p]JBaa`;A\u0002\u0005\u0005\u0011AB:vEN,G\u000fE\u0003\u0002\u0004\u0005=!GD\u0002\u0002\u0006usA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\t\t\u0002\u0019\u0002\u0004'\u0016\f\bbBA\u000b9\u0011\u0005\u0011qC\u0001\n[\u0006\u0004Hi\\;cY\u0016$B!!\u0007\u0002 Q\u0019a$a\u0007\t\u000fi\f\u0019\u00021\u0001\u0002\u001eA)Q\u0002 \u001ao]\"9q0a\u0005A\u0002\u0005\u0005\u0001B\u0002<\u001d\t\u0003\t\u0019\u0003F\u0002\u001f\u0003KAaA_A\u0011\u0001\u0004Y\bbBA\u000b9\u0011\u0005\u0011\u0011\u0006\u000b\u0004=\u0005-\u0002b\u0002>\u0002(\u0001\u0007\u0011Q\u0004\u0005\u0007mr!\t!a\f\u0015\t\u0005E\u00121\b\u000b\u0004=\u0005M\u0002b\u0002>\u0002.\u0001\u0007\u0011Q\u0007\t\u0006\u001b\u0005]\"GM\u0005\u0004\u0003sq!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\ti$!\fA\u0002I\n!A\u0019\u0019\t\u000f\u0005UA\u0004\"\u0001\u0002BQ!\u00111IA%)\rq\u0012Q\t\u0005\bu\u0006}\u0002\u0019AA$!\u0015i\u0011q\u00078o\u0011\u001d\ti$a\u0010A\u0002IBq!!\u0014\u001d\t\u0003\ty%A\u0004g_J,\u0017m\u00195\u0015\u0007i\n\t\u0006C\u0004{\u0003\u0017\u0002\r!a\u0015\u0011\u000b5a(G\r\u001e\t\u000f\u0005]C\u0004\"\u0001\u0002Z\u0005iam\u001c:fC\u000eDGi\\;cY\u0016$2AOA.\u0011\u001dQ\u0018Q\u000ba\u0001\u0003;\u0002R!\u0004?3]jBq!!\u0014\u001d\t\u0003\t\t\u0007\u0006\u0003\u0002d\u0005%Dc\u0001\u001e\u0002f!9!0a\u0018A\u0002\u0005\u001d\u0004#B\u0007\u00028IR\u0004bBA\u001f\u0003?\u0002\rA\r\u0005\b\u0003/bB\u0011AA7)\u0011\ty'!\u001e\u0015\u0007i\n\t\bC\u0004{\u0003W\u0002\r!a\u001d\u0011\u000b5\t9D\u001c\u001e\t\u000f\u0005u\u00121\u000ea\u0001e!9\u0011Q\n\u000f\u0005\u0002\u0005eDc\u0001\u001e\u0002|!9!0a\u001eA\u0002\u0005u\u0004CB\u0007\u00028\u0005}$\bE\u0002\u000eOIBq!a\u0016\u001d\t\u0003\t\u0019\tF\u0002;\u0003\u000bCqA_AA\u0001\u0004\t9\t\u0005\u0004\u000e\u0003o\tII\u000f\t\u0004\u001b\u001dr\u0007bBAG9\u0011\u0005\u0011qR\u0001\bG>l'-\u001b8f)\u0011\t\t*a&\u0015\u0007%\n\u0019\nC\u0004{\u0003\u0017\u0003\r!!&\u0011\r5\t9$!\u00013\u0011\u001dy\u00181\u0012a\u0001\u0003\u0003Aq!a'\u001d\t\u0003\ti*A\u0007d_6\u0014\u0017N\\3E_V\u0014G.\u001a\u000b\u0005\u0003?\u000b9\u000bF\u0002*\u0003CCqA_AM\u0001\u0004\t\u0019\u000b\u0005\u0004\u000e\u0003o\t)K\u001c\t\u0006\u0003\u0007\tyA\u001c\u0005\b\u007f\u0006e\u0005\u0019AA\u0001\u0011\u001d\ti\t\bC\u0001\u0003W#2!KAW\u0011\u001dQ\u0018\u0011\u0016a\u0001\u0003_\u0003b!DA\u001c\u0003\u007f\u0012\u0004bBAG9\u0011\u0005\u00111\u0017\u000b\u0007\u0003k\u000bI,a/\u0015\u0007%\n9\f\u0003\u0004{\u0003c\u0003\ra\u001f\u0005\b\u0003{\t\t\f1\u00013\u0011\u001d\ti,!-A\u0002I\n!AY\u0019\t\u000f\u0005mE\u0004\"\u0001\u0002BR!\u00111YAe!\rA\u0011QY\u0005\u0004\u0003\u000f\u0014!\u0001E'vi\u0006\u0014G.Z!se\u0006LH+\u001b7f\u0011\u001dQ\u0018q\u0018a\u0001\u0003\u0017\u0004b!DA\u001c\u0003\u0013s\u0007bBAN9\u0011\u0005\u0011q\u001a\u000b\u0007\u0003#\f9.!7\u0015\u0007%\n\u0019\u000eC\u0004{\u0003\u001b\u0004\r!!6\u0011\u000b5ahN\u001c8\t\u000f\u0005u\u0012Q\u001aa\u0001e!9\u0011QXAg\u0001\u0004\u0011\u0004bBAo9\u0011\u0005\u0011q\\\u0001\fgV\u00147/\u001a;CC:$7\u000fF\u0002\u001c\u0003CD\u0001\"a9\u0002\\\u0002\u0007\u0011\u0011A\u0001\rE\u0006tGmU3rk\u0016t7-\u001a\u0005\b\u0003OdB\u0011IAu\u0003\u0019)\u0017/^1mgR!\u00111^Ay!\ri\u0011Q^\u0005\u0004\u0003_t!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003g\f)\u000f1\u0001\u0002v\u0006)q\u000e\u001e5feB\u0019Q\"a>\n\u0007\u0005ehBA\u0002B]fDa!\u0017\rA\u0002\u0005u\b\u0003B\u0007\u0002\u0000&J1A!\u0001\u000f\u0005)a$/\u001a9fCR,GM\u0010\u0005\u00073%!\tA!\u0002\u0015\u0007m\u00119\u0001C\u0004Z\u0005\u0007\u0001\rA!\u0003\u0011\u000b\u0005\r!1B\u0015\n\u0007\t5\u0001MA\u0006Ue\u00064XM]:bE2,\u0007BB\r\n\t\u0003\u0011\t\u0002F\u0002\u001c\u0005'Aa!\u0017B\b\u0001\u00041\u0003b\u0002B\f\u0013\u0011\u0005!\u0011D\u0001\u0006C2dwn\u0019\u000b\n7\tm!q\u0004B\u0011\u0005GAqA!\b\u0003\u0016\u0001\u0007!)A\u0001u\u0011\u0019I&Q\u0003a\u0001e!1AJ!\u0006A\u0002IBa\u0001\u0015B\u000b\u0001\u0004\u0011\u0004b\u0002B\u0014\u0013\u0011\u0005!\u0011F\u0001\u0006K6\u0004H/\u001f\u000b\n7\t-\"Q\u0006B\u0018\u0005cAqA!\b\u0003&\u0001\u0007!\t\u0003\u0004Z\u0005K\u0001\rA\r\u0005\u0007\u0019\n\u0015\u0002\u0019\u0001\u001a\t\rA\u0013)\u00031\u00013\u0011%\u0011)$CA\u0001\n\u0013\u00119$A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u001d!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\nA\u0001\\1oO*\u0011!1I\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003H\tu\"AB(cU\u0016\u001cG\u000f")
public class ArrayMultibandTile
implements MultibandTile,
MacroMultibandCombiners {
    public final Tile[] geotrellis$raster$ArrayMultibandTile$$_bands;
    private final int bandCount;
    private final DataType cellType;
    private final int cols;
    private final int rows;

    public static ArrayMultibandTile empty(DataType dataType, int n, int n2, int n3) {
        return ArrayMultibandTile$.MODULE$.empty(dataType, n, n2, n3);
    }

    public static ArrayMultibandTile alloc(DataType dataType, int n, int n2, int n3) {
        return ArrayMultibandTile$.MODULE$.alloc(dataType, n, n2, n3);
    }

    public static ArrayMultibandTile apply(Tile[] tileArray) {
        return ArrayMultibandTile$.MODULE$.apply(tileArray);
    }

    public static ArrayMultibandTile apply(Traversable<Tile> traversable) {
        return ArrayMultibandTile$.MODULE$.apply(traversable);
    }

    public static ArrayMultibandTile apply(Seq<Tile> seq) {
        return ArrayMultibandTile$.MODULE$.apply(seq);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner3 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner3 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner4 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner4 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner5 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner5 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner6 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner6 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner7 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner7 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner8 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner8 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner9 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner9 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner10 combiner) {
        return MacroMultibandCombiners$class.combineIntTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner10 combiner) {
        return MacroMultibandCombiners$class.combineDoubleTileCombiner((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public DataType targetCellType() {
        return MultibandTile$class.targetCellType(this);
    }

    @Override
    public MultibandTile subsetBands(Seq<Object> bandSequence, Predef.DummyImplicit d) {
        return MultibandTile$class.subsetBands(this, bandSequence, d);
    }

    @Override
    public MultibandTile mapBands(Function2<Object, Tile, Tile> f) {
        return MultibandTile$class.mapBands(this, f);
    }

    @Override
    public int size() {
        return Grid$class.size(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid$class.dimensions(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid$class.gridBounds(this);
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    private void validateBand(int i) {
        boolean bl = i < this.bandCount();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Band index out of bounds. Band Count: ", " Requested Band Index: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.bandCount()), BoxesRunTime.boxToInteger((int)i)}))).toString());
        }
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public Tile band(int bandIndex) {
        if (bandIndex >= this.bandCount()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Band ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bandIndex)})));
        }
        return this.geotrellis$raster$ArrayMultibandTile$$_bands[bandIndex];
    }

    @Override
    public Vector<Tile> bands() {
        return Predef$.MODULE$.refArrayOps((Object[])this.geotrellis$raster$ArrayMultibandTile$$_bands).toVector();
    }

    @Override
    public MultibandTile convert(DataType newCellType) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        for (int index$macro$2 = 0; index$macro$2 < this.bandCount(); ++index$macro$2) {
            newBands[index$macro$2] = this.band(index$macro$2).convert(newCellType);
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile withNoData(Option<Object> noDataValue) {
        return new ArrayMultibandTile((Tile[])Predef$.MODULE$.refArrayOps((Object[])this.geotrellis$raster$ArrayMultibandTile$$_bands).map((Function1)new Serializable(this, noDataValue){
            public static final long serialVersionUID = 0L;
            private final Option noDataValue$1;

            public final Tile apply(Tile x$5) {
                return x$5.withNoData((Option<Object>)this.noDataValue$1);
            }
            {
                this.noDataValue$1 = noDataValue$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class))));
    }

    @Override
    public MultibandTile interpretAs(DataType newCellType) {
        return new ArrayMultibandTile((Tile[])Predef$.MODULE$.refArrayOps((Object[])this.geotrellis$raster$ArrayMultibandTile$$_bands).map((Function1)new Serializable(this, newCellType){
            public static final long serialVersionUID = 0L;
            private final DataType newCellType$1;

            public final Tile apply(Tile x$6) {
                return x$6.interpretAs(this.newCellType$1);
            }
            {
                this.newCellType$1 = newCellType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class))));
    }

    @Override
    public MultibandTile map(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        Set set2 = subset.toSet();
        subset.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayMultibandTile $outer;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                boolean bl = 0 <= b && b < this.$outer.bandCount();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"All elements of subset must be present").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$ predef$ = Predef$.MODULE$;
        int n = this.bandCount();
        Serializable serializable = new Serializable(this, f, newBands, set2){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ArrayMultibandTile $outer;
            public final Function2 f$1;
            public final Tile[] newBands$1;
            public final Set set$1;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                this.newBands$1[b] = this.set$1.contains((Object)BoxesRunTime.boxToInteger((int)b)) ? this.$outer.band(b).map((Function1<Object, Object>)new Serializable(this, b){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$map$2 $outer;
                    public final int b$1;

                    public final int apply(int z) {
                        return this.$outer.f$1.apply$mcIII$sp(this.b$1, z);
                    }

                    public int apply$mcII$sp(int z) {
                        return this.$outer.f$1.apply$mcIII$sp(this.b$1, z);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.b$1 = b$1;
                    }
                }) : this.$outer.band(b);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
                this.newBands$1 = newBands$1;
                this.set$1 = set$1;
            }
        };
        Range range = Range$.MODULE$.apply(0, n);
        if (!range.isEmpty()) {
            int n2 = range.start();
            while (true) {
                newBands[n2] = set2.contains((Object)BoxesRunTime.boxToInteger((int)n2)) ? this.band(n2).map((Function1<Object, Object>)new /* invalid duplicate definition of identical inner class */) : this.band(n2);
                if (n2 == range.lastElement()) break;
                n2 += range.step();
            }
        }
        ArrayMultibandTile$ arrayMultibandTile$ = ArrayMultibandTile$.MODULE$;
        return new ArrayMultibandTile(newBands);
    }

    @Override
    public MultibandTile mapDouble(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        Set set2 = subset.toSet();
        subset.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayMultibandTile $outer;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                boolean bl = 0 <= b && b < this.$outer.bandCount();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"All elements of subset must be present").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$ predef$ = Predef$.MODULE$;
        int n = this.bandCount();
        Serializable serializable = new Serializable(this, f, newBands, set2){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ArrayMultibandTile $outer;
            public final Function2 f$2;
            public final Tile[] newBands$2;
            public final Set set$2;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                this.newBands$2[b] = this.set$2.contains((Object)BoxesRunTime.boxToInteger((int)b)) ? this.$outer.band(b).mapDouble((Function1<Object, Object>)new Serializable(this, b){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$mapDouble$2 $outer;
                    public final int b$2;

                    public final double apply(double z) {
                        return this.$outer.f$2.apply$mcDID$sp(this.b$2, z);
                    }

                    public double apply$mcDD$sp(double z) {
                        return this.$outer.f$2.apply$mcDID$sp(this.b$2, z);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.b$2 = b$2;
                    }
                }) : this.$outer.band(b);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$2 = f$2;
                this.newBands$2 = newBands$2;
                this.set$2 = set$2;
            }
        };
        Range range = Range$.MODULE$.apply(0, n);
        if (!range.isEmpty()) {
            int n2 = range.start();
            while (true) {
                newBands[n2] = set2.contains((Object)BoxesRunTime.boxToInteger((int)n2)) ? this.band(n2).mapDouble((Function1<Object, Object>)new /* invalid duplicate definition of identical inner class */) : this.band(n2);
                if (n2 == range.lastElement()) break;
                n2 += range.step();
            }
        }
        ArrayMultibandTile$ arrayMultibandTile$ = ArrayMultibandTile$.MODULE$;
        return new ArrayMultibandTile(newBands);
    }

    @Override
    public MultibandTile map(Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef index$macro$3 = IntRef.create((int)0);
        while (index$macro$3.elem < this.bandCount()) {
            newBands[index$macro$3.elem] = this.band(index$macro$3.elem).map((Function1<Object, Object>)new Serializable(this, f, index$macro$3){
                public static final long serialVersionUID = 0L;
                public final Function2 f$3;
                public final IntRef index$macro$3$1;

                public final int apply(int z) {
                    return this.f$3.apply$mcIII$sp(this.index$macro$3$1.elem, z);
                }

                public int apply$mcII$sp(int z) {
                    return this.f$3.apply$mcIII$sp(this.index$macro$3$1.elem, z);
                }
                {
                    this.f$3 = f$3;
                    this.index$macro$3$1 = index$macro$3$1;
                }
            });
            ++index$macro$3.elem;
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef index$macro$4 = IntRef.create((int)0);
        while (index$macro$4.elem < this.bandCount()) {
            newBands[index$macro$4.elem] = this.band(index$macro$4.elem).mapDouble((Function1<Object, Object>)new Serializable(this, f, index$macro$4){
                public static final long serialVersionUID = 0L;
                public final Function2 f$4;
                public final IntRef index$macro$4$1;

                public final double apply(double z) {
                    return this.f$4.apply$mcDID$sp(this.index$macro$4$1.elem, z);
                }

                public double apply$mcDD$sp(double z) {
                    return this.f$4.apply$mcDID$sp(this.index$macro$4$1.elem, z);
                }
                {
                    this.f$4 = f$4;
                    this.index$macro$4$1 = index$macro$4$1;
                }
            });
            ++index$macro$4.elem;
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile map(int b0, Function1<Object, Object> f) {
        this.validateBand(b0);
        Tile[] newBands = (Tile[])this.geotrellis$raster$ArrayMultibandTile$$_bands.clone();
        newBands[b0] = this.band(b0).map(f);
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(int b0, Function1<Object, Object> f) {
        this.validateBand(b0);
        Tile[] newBands = (Tile[])this.geotrellis$raster$ArrayMultibandTile$$_bands.clone();
        newBands[b0] = this.band(b0).mapDouble(f);
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        IntRef index$macro$5 = IntRef.create((int)0);
        while (index$macro$5.elem < this.bandCount()) {
            this.band(index$macro$5.elem).foreach((Function1<Object, BoxedUnit>)new Serializable(this, f, index$macro$5){
                public static final long serialVersionUID = 0L;
                public final Function2 f$5;
                public final IntRef index$macro$5$1;

                public final void apply(int z) {
                    this.f$5.apply$mcVII$sp(this.index$macro$5$1.elem, z);
                }

                public void apply$mcVI$sp(int z) {
                    this.f$5.apply$mcVII$sp(this.index$macro$5$1.elem, z);
                }
                {
                    this.f$5 = f$5;
                    this.index$macro$5$1 = index$macro$5$1;
                }
            });
            ++index$macro$5.elem;
        }
    }

    @Override
    public void foreachDouble(Function2<Object, Object, BoxedUnit> f) {
        IntRef index$macro$6 = IntRef.create((int)0);
        while (index$macro$6.elem < this.bandCount()) {
            this.band(index$macro$6.elem).foreachDouble((Function1<Object, BoxedUnit>)new Serializable(this, f, index$macro$6){
                public static final long serialVersionUID = 0L;
                public final Function2 f$6;
                public final IntRef index$macro$6$1;

                public final void apply(double z) {
                    this.f$6.apply$mcVID$sp(this.index$macro$6$1.elem, z);
                }

                public void apply$mcVD$sp(double z) {
                    this.f$6.apply$mcVID$sp(this.index$macro$6$1.elem, z);
                }
                {
                    this.f$6 = f$6;
                    this.index$macro$6$1 = index$macro$6$1;
                }
            });
            ++index$macro$6.elem;
        }
    }

    @Override
    public void foreach(int b0, Function1<Object, BoxedUnit> f) {
        this.validateBand(b0);
        this.band(b0).foreach(f);
    }

    @Override
    public void foreachDouble(int b0, Function1<Object, BoxedUnit> f) {
        this.validateBand(b0);
        this.band(b0).foreachDouble(f);
    }

    @Override
    public void foreach(Function1<int[], BoxedUnit> f) {
        for (int index$macro$9 = 0; index$macro$9 < this.cols(); ++index$macro$9) {
            for (int index$macro$8 = 0; index$macro$8 < this.rows(); ++index$macro$8) {
                int[] bandValues = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
                for (int index$macro$7 = 0; index$macro$7 < this.bandCount(); ++index$macro$7) {
                    bandValues[index$macro$7] = ((Tile)this.bands().apply(index$macro$7)).get(index$macro$9, index$macro$8);
                }
                f.apply((Object)bandValues);
            }
        }
    }

    @Override
    public void foreachDouble(Function1<double[], BoxedUnit> f) {
        for (int index$macro$12 = 0; index$macro$12 < this.cols(); ++index$macro$12) {
            for (int index$macro$11 = 0; index$macro$11 < this.rows(); ++index$macro$11) {
                double[] bandValues = (double[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Double());
                for (int index$macro$10 = 0; index$macro$10 < this.bandCount(); ++index$macro$10) {
                    bandValues[index$macro$10] = ((Tile)this.bands().apply(index$macro$10)).getDouble(index$macro$12, index$macro$11);
                }
                f.apply((Object)bandValues);
            }
        }
    }

    @Override
    public Tile combine(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayMultibandTile $outer;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                boolean bl = 0 <= b && b < this.$outer.bandCount();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"All elements of subset must be present").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int subsetSize = subset.size();
        int[] subsetArray = (int[])subset.toArray(ClassTag$.MODULE$.Int());
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] values2 = (int[])Array$.MODULE$.ofDim(subsetSize, ClassTag$.MODULE$.Int());
        for (int index$macro$15 = 0; index$macro$15 < this.rows(); ++index$macro$15) {
            for (int index$macro$14 = 0; index$macro$14 < this.cols(); ++index$macro$14) {
                for (int index$macro$13 = 0; index$macro$13 < subsetSize; ++index$macro$13) {
                    values2[index$macro$13] = this.geotrellis$raster$ArrayMultibandTile$$_bands[subsetArray[index$macro$13]].get(index$macro$14, index$macro$15);
                }
                result.set(index$macro$14, index$macro$15, BoxesRunTime.unboxToInt((Object)f.apply((Object)Predef$.MODULE$.wrapIntArray(values2))));
            }
        }
        return result;
    }

    @Override
    public Tile combineDouble(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayMultibandTile $outer;

            public final void apply(int b) {
                this.apply$mcVI$sp(b);
            }

            public void apply$mcVI$sp(int b) {
                boolean bl = 0 <= b && b < this.$outer.bandCount();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"All elements of subset must be present").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int subsetSize = subset.size();
        int[] subsetArray = (int[])subset.toArray(ClassTag$.MODULE$.Int());
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        double[] values2 = (double[])Array$.MODULE$.ofDim(subsetSize, ClassTag$.MODULE$.Double());
        for (int index$macro$18 = 0; index$macro$18 < this.rows(); ++index$macro$18) {
            for (int index$macro$17 = 0; index$macro$17 < this.cols(); ++index$macro$17) {
                for (int index$macro$16 = 0; index$macro$16 < subsetSize; ++index$macro$16) {
                    values2[index$macro$16] = this.geotrellis$raster$ArrayMultibandTile$$_bands[subsetArray[index$macro$16]].getDouble(index$macro$17, index$macro$18);
                }
                result.setDouble(index$macro$17, index$macro$18, BoxesRunTime.unboxToDouble((Object)f.apply((Object)Predef$.MODULE$.wrapDoubleArray(values2))));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Function1<int[], Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] arr = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
        for (int index$macro$21 = 0; index$macro$21 < this.rows(); ++index$macro$21) {
            for (int index$macro$20 = 0; index$macro$20 < this.cols(); ++index$macro$20) {
                for (int index$macro$19 = 0; index$macro$19 < this.bandCount(); ++index$macro$19) {
                    arr[index$macro$19] = this.band(index$macro$19).get(index$macro$20, index$macro$21);
                }
                result.set(index$macro$20, index$macro$21, BoxesRunTime.unboxToInt((Object)f.apply((Object)arr)));
            }
        }
        return var2_2;
    }

    @Override
    public Tile combine(int b0, int b1, Function2<Object, Object, Object> f) {
        Tile band1 = this.band(b0);
        Tile band2 = this.band(b1);
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        for (int index$macro$23 = 0; index$macro$23 < this.rows(); ++index$macro$23) {
            for (int index$macro$22 = 0; index$macro$22 < this.cols(); ++index$macro$22) {
                result.set(index$macro$22, index$macro$23, f.apply$mcIII$sp(band1.get(index$macro$22, index$macro$23), band2.get(index$macro$22, index$macro$23)));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableArrayTile combineDouble(Function1<double[], Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        double[] arr = (double[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Double());
        for (int index$macro$26 = 0; index$macro$26 < this.rows(); ++index$macro$26) {
            for (int index$macro$25 = 0; index$macro$25 < this.cols(); ++index$macro$25) {
                for (int index$macro$24 = 0; index$macro$24 < this.bandCount(); ++index$macro$24) {
                    arr[index$macro$24] = this.band(index$macro$24).getDouble(index$macro$25, index$macro$26);
                }
                result.setDouble(index$macro$25, index$macro$26, BoxesRunTime.unboxToDouble((Object)f.apply((Object)arr)));
            }
        }
        return var2_2;
    }

    @Override
    public Tile combineDouble(int b0, int b1, Function2<Object, Object, Object> f) {
        Tile band1 = this.band(b0);
        Tile band2 = this.band(b1);
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] cfr_ignored_0 = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
        for (int index$macro$28 = 0; index$macro$28 < this.rows(); ++index$macro$28) {
            for (int index$macro$27 = 0; index$macro$27 < this.cols(); ++index$macro$27) {
                result.setDouble(index$macro$27, index$macro$28, f.apply$mcDDD$sp(band1.getDouble(index$macro$27, index$macro$28), band2.getDouble(index$macro$27, index$macro$28)));
            }
        }
        return result;
    }

    @Override
    public ArrayMultibandTile subsetBands(Seq<Object> bandSequence) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(bandSequence.size(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef i = IntRef.create((int)0);
        Predef$.MODULE$.require(bandSequence.size() <= this.bandCount());
        bandSequence.foreach((Function1)new Serializable(this, newBands, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayMultibandTile $outer;
            private final Tile[] newBands$3;
            private final IntRef i$2;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                this.newBands$3[this.i$2.elem] = this.$outer.band(j);
                ++this.i$2.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newBands$3 = newBands$3;
                this.i$2 = i$2;
            }
        });
        return new ArrayMultibandTile(newBands);
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof ArrayMultibandTile) {
            ArrayMultibandTile arrayMultibandTile = (ArrayMultibandTile)other;
            boolean result = this.bandCount() == arrayMultibandTile.bandCount();
            for (int index$macro$29 = 0; result && index$macro$29 < this.bandCount(); ++index$macro$29) {
                Tile tile = this.band(index$macro$29);
                Tile tile2 = arrayMultibandTile.band(index$macro$29);
                if (!(tile == null ? tile2 != null : !tile.equals(tile2))) continue;
                result = false;
            }
            bl = result;
        } else {
            bl = false;
        }
        return bl;
    }

    public ArrayMultibandTile(Tile[] _bands) {
        this.geotrellis$raster$ArrayMultibandTile$$_bands = _bands;
        Grid$class.$init$(this);
        MacroCombineFunctions.class.$init$((MacroCombineFunctions)this);
        MultibandTile$class.$init$(this);
        MacroMultibandCombiners$class.$init$(this);
        Object[] objectArray = _bands;
        Predef$ predef$ = Predef$.MODULE$;
        this.bandCount = new ArrayOps.ofRef(objectArray).size();
        boolean bl = this.bandCount() > 0;
        Predef$ predef$2 = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Band count must be greater than 0").toString());
        }
        this.cellType = _bands[0].cellType();
        this.cols = _bands[0].cols();
        this.rows = _bands[0].rows();
        IntRef index$macro$1 = IntRef.create((int)0);
        while (index$macro$1.elem < this.bandCount()) {
            DataType dataType = _bands[index$macro$1.elem].cellType();
            DataType dataType2 = this.cellType();
            boolean bl2 = !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null);
            Predef$ predef$3 = Predef$.MODULE$;
            if (!bl2) {
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Band ", " cell type does not match, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index$macro$1.elem), this.geotrellis$raster$ArrayMultibandTile$$_bands[index$macro$1.elem].cellType(), this.cellType()}))).toString());
            }
            boolean bl3 = _bands[index$macro$1.elem].cols() == this.cols();
            Predef$ predef$4 = Predef$.MODULE$;
            if (!bl3) {
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Band ", " cols does not match, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index$macro$1.elem), BoxesRunTime.boxToInteger((int)this.geotrellis$raster$ArrayMultibandTile$$_bands[index$macro$1.elem].cols()), BoxesRunTime.boxToInteger((int)this.cols())}))).toString());
            }
            boolean bl4 = _bands[index$macro$1.elem].rows() == this.rows();
            Predef$ predef$5 = Predef$.MODULE$;
            if (!bl4) {
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Band ", " rows does not match, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index$macro$1.elem), BoxesRunTime.boxToInteger((int)this.geotrellis$raster$ArrayMultibandTile$$_bands[index$macro$1.elem].rows()), BoxesRunTime.boxToInteger((int)this.rows())}))).toString());
            }
            ++index$macro$1.elem;
        }
    }
}

