/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro.serde;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.avro.io.Decoder;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils$;
import org.locationtech.geomesa.features.avro.serde.ASFDeserializer;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class ASFDeserializer$class {
    public static void setString(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        Tuple2 tuple2 = (Tuple2)$this.buffers().getOrElseUpdate((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ByteBuffer, byte[]> apply() {
                return new Tuple2((Object)ByteBuffer.allocate(16), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        });
        if (tuple2 != null) {
            int length;
            Tuple2 tuple22;
            ByteBuffer bb = (ByteBuffer)tuple2._1();
            byte[] bytes = (byte[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)bb, (Object)bytes);
            ByteBuffer bb2 = (ByteBuffer)tuple23._1();
            byte[] bytes2 = (byte[])tuple23._2();
            if (bytes2.length < (length = (bb2 = in.readBytes(bb2)).remaining())) {
                bytes2 = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
            }
            $this.buffers().put((Object)new Tuple2((Object)bb2, (Object)bytes2));
            bb2.get(bytes2, 0, length);
            sf.setAttributeNoConvert(field, (Object)new String(bytes2, 0, length, StandardCharsets.UTF_8));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void consumeString(ASFDeserializer $this, Decoder in) {
        in.skipBytes();
    }

    public static void setInt(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        sf.setAttributeNoConvert(field, (Object)BoxesRunTime.boxToInteger((int)in.readInt()));
    }

    public static void consumeInt(ASFDeserializer $this, Decoder in) {
        in.readInt();
    }

    public static void setDouble(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        sf.setAttributeNoConvert(field, (Object)BoxesRunTime.boxToDouble((double)in.readDouble()));
    }

    public static void consumeDouble(ASFDeserializer $this, Decoder in) {
        in.readDouble();
    }

    public static void setLong(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        sf.setAttributeNoConvert(field, (Object)BoxesRunTime.boxToLong((long)in.readLong()));
    }

    public static void consumeLong(ASFDeserializer $this, Decoder in) {
        in.readLong();
    }

    public static void setFloat(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        sf.setAttributeNoConvert(field, (Object)BoxesRunTime.boxToFloat((float)in.readFloat()));
    }

    public static void consumeFloat(ASFDeserializer $this, Decoder in) {
        in.readFloat();
    }

    public static void setBool(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        sf.setAttributeNoConvert(field, (Object)BoxesRunTime.boxToBoolean((boolean)in.readBoolean()));
    }

    public static void consumeBool(ASFDeserializer $this, Decoder in) {
        in.readBoolean();
    }

    public static void setUUID(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        Tuple2 tuple2 = (Tuple2)$this.buffers().getOrElseUpdate((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ByteBuffer, byte[]> apply() {
                return new Tuple2((Object)ByteBuffer.allocate(16), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            ByteBuffer bb = (ByteBuffer)tuple2._1();
            byte[] bytes = (byte[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)bb, (Object)bytes);
            ByteBuffer bb2 = (ByteBuffer)tuple23._1();
            byte[] bytes2 = (byte[])tuple23._2();
            bb2 = in.readBytes(bb2);
            $this.buffers().put((Object)new Tuple2((Object)bb2, (Object)bytes2));
            sf.setAttributeNoConvert(field, (Object)AvroSimpleFeatureUtils$.MODULE$.decodeUUID(bb2));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void consumeUUID(ASFDeserializer $this, Decoder in) {
        in.skipBytes();
    }

    public static void setDate(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        sf.setAttributeNoConvert(field, (Object)new Date(in.readLong()));
    }

    public static void consumeDate(ASFDeserializer $this, Decoder in) {
        in.readLong();
    }

    public static void setList(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        Tuple2 tuple2 = (Tuple2)$this.buffers().getOrElseUpdate((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ByteBuffer, byte[]> apply() {
                return new Tuple2((Object)ByteBuffer.allocate(16), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            ByteBuffer bb = (ByteBuffer)tuple2._1();
            byte[] bytes = (byte[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)bb, (Object)bytes);
            ByteBuffer bb2 = (ByteBuffer)tuple23._1();
            byte[] bytes2 = (byte[])tuple23._2();
            bb2 = in.readBytes(bb2);
            $this.buffers().put((Object)new Tuple2((Object)bb2, (Object)bytes2));
            sf.setAttributeNoConvert(field, AvroSimpleFeatureUtils$.MODULE$.decodeList(bb2));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void consumeList(ASFDeserializer $this, Decoder in) {
        in.skipBytes();
    }

    public static void setMap(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        Tuple2 tuple2 = (Tuple2)$this.buffers().getOrElseUpdate((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ByteBuffer, byte[]> apply() {
                return new Tuple2((Object)ByteBuffer.allocate(16), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            ByteBuffer bb = (ByteBuffer)tuple2._1();
            byte[] bytes = (byte[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)bb, (Object)bytes);
            ByteBuffer bb2 = (ByteBuffer)tuple23._1();
            byte[] bytes2 = (byte[])tuple23._2();
            bb2 = in.readBytes(bb2);
            $this.buffers().put((Object)new Tuple2((Object)bb2, (Object)bytes2));
            sf.setAttributeNoConvert(field, AvroSimpleFeatureUtils$.MODULE$.decodeMap(bb2));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void consumeMap(ASFDeserializer $this, Decoder in) {
        in.skipBytes();
    }

    public static void setBytes(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        Tuple2 tuple2 = (Tuple2)$this.buffers().getOrElseUpdate((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ByteBuffer, byte[]> apply() {
                return new Tuple2((Object)ByteBuffer.allocate(16), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            ByteBuffer bb = (ByteBuffer)tuple2._1();
            byte[] bytes = (byte[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)bb, (Object)bytes);
            ByteBuffer bb2 = (ByteBuffer)tuple23._1();
            byte[] bytes2 = (byte[])tuple23._2();
            bb2 = in.readBytes(bb2);
            $this.buffers().put((Object)new Tuple2((Object)bb2, (Object)bytes2));
            byte[] value = (byte[])Array$.MODULE$.ofDim(bb2.remaining(), ClassTag$.MODULE$.Byte());
            bb2.get(value);
            sf.setAttributeNoConvert(field, (Object)value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void consumeBytes(ASFDeserializer $this, Decoder in) {
        in.skipBytes();
    }

    public static void setGeometry(ASFDeserializer $this, ScalaSimpleFeature sf, int field, Decoder in) {
        Tuple2 tuple2 = (Tuple2)$this.buffers().getOrElseUpdate((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ByteBuffer, byte[]> apply() {
                return new Tuple2((Object)ByteBuffer.allocate(16), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        });
        if (tuple2 != null) {
            int length;
            Tuple2 tuple22;
            ByteBuffer bb = (ByteBuffer)tuple2._1();
            byte[] bytes = (byte[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)bb, (Object)bytes);
            ByteBuffer bb2 = (ByteBuffer)tuple23._1();
            byte[] bytes2 = (byte[])tuple23._2();
            if (bytes2.length < (length = (bb2 = in.readBytes(bb2)).remaining())) {
                bytes2 = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
            }
            $this.buffers().put((Object)new Tuple2((Object)bb2, (Object)bytes2));
            bb2.get(bytes2, 0, length);
            sf.setAttributeNoConvert(field, (Object)WKBUtils$.MODULE$.read(bytes2));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void consumeGeometry(ASFDeserializer $this, Decoder in) {
        in.skipBytes();
    }

    public static void $init$(ASFDeserializer $this) {
        $this.org$locationtech$geomesa$features$avro$serde$ASFDeserializer$_setter_$buffers_$eq(new SoftThreadLocal());
    }
}

