/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.memory.cqengine.index;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.AbstractAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.geomesa.memory.cqengine.query.Intersects;
import org.locationtech.geomesa.utils.index.BucketIndex;
import org.locationtech.geomesa.utils.index.SizeSeparatedBucketIndex;
import org.locationtech.geomesa.utils.index.SizeSeparatedBucketIndex$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.runtime.AbstractFunction1;

public class GeoIndex<A extends Geometry, O extends SimpleFeature>
extends AbstractAttributeIndex<A, O>
implements OnHeapTypeIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoIndex.class);
    private static final int INDEX_RETRIEVAL_COST = 40;
    SpatialIndex<SimpleFeature> index;
    int geomAttributeIndex;
    static Set<Class<? extends Query>> supportedQueries = new HashSet<Class<? extends Query>>(){
        {
            this.add(Intersects.class);
        }
    };

    public GeoIndex(SimpleFeatureType sft, Attribute<O, A> attribute, int xBuckets, int yBuckets) {
        super(attribute, supportedQueries);
        this.geomAttributeIndex = sft.indexOf(attribute.getAttributeName());
        this.index = sft.getDescriptor(this.geomAttributeIndex).getType().getBinding() == Point.class ? new BucketIndex(xBuckets, yBuckets, new Envelope(-180.0, 180.0, -90.0, 90.0)) : new SizeSeparatedBucketIndex(SizeSeparatedBucketIndex$.MODULE$.DefaultTiers(), (double)xBuckets / 360.0, (double)yBuckets / 180.0, new Envelope(-180.0, 180.0, -90.0, 90.0));
    }

    public static <A extends Geometry, O extends SimpleFeature> GeoIndex<A, O> onAttribute(SimpleFeatureType sft, Attribute<O, A> attribute) {
        return new GeoIndex<A, O>(sft, attribute, 360, 180);
    }

    public static <A extends Geometry, O extends SimpleFeature> GeoIndex<A, O> onAttribute(SimpleFeatureType sft, Attribute<O, A> attribute, int xBuckets, int yBuckets) {
        return new GeoIndex<A, O>(sft, attribute, xBuckets, yBuckets);
    }

    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.addAll(ObjectSet.fromObjectStore(objectStore, (QueryOptions)queryOptions), queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (SimpleFeature object : objectSet) {
                Envelope env = ((Geometry)object.getDefaultGeometry()).getEnvelopeInternal();
                this.index.insert(env, object.getID(), (Object)object);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (SimpleFeature object : objectSet) {
                Envelope env = ((Geometry)object.getDefaultGeometry()).getEnvelopeInternal();
                this.index.remove(env, object.getID());
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    public void clear(QueryOptions queryOptions) {
        this.index.clear();
    }

    public ResultSet<O> retrieve(final Query<O> query2, final QueryOptions queryOptions) {
        return new ResultSet<O>(){

            public java.util.Iterator<O> iterator() {
                Iterator iter = GeoIndex.this.getSimpleFeatureIteratorInternal((Intersects)query2, queryOptions);
                return JavaConversions.asJavaIterator((Iterator)iter);
            }

            public boolean contains(O object) {
                Intersects intersects = (Intersects)query2;
                Geometry geom = (Geometry)object.getAttribute(GeoIndex.this.geomAttributeIndex);
                return intersects.matchesValue(geom, queryOptions);
            }

            public boolean matches(O object) {
                return query2.matches(object, queryOptions);
            }

            public Query<O> getQuery() {
                return query2;
            }

            public QueryOptions getQueryOptions() {
                return queryOptions;
            }

            public int getRetrievalCost() {
                return 40;
            }

            public int getMergeCost() {
                return this.size();
            }

            public int size() {
                return GeoIndex.this.getSimpleFeatureIteratorInternal((Intersects)query2, queryOptions).size();
            }

            public void close() {
            }
        };
    }

    private Iterator<SimpleFeature> getSimpleFeatureIteratorInternal(Intersects query2, final QueryOptions queryOptions) {
        final Intersects intersects = query2;
        Envelope queryEnvelope = intersects.getEnvelope();
        return this.index.query(queryEnvelope).filter((Function1)new AbstractFunction1<SimpleFeature, Object>(){

            public Object apply(SimpleFeature feature) {
                try {
                    Geometry geom = (Geometry)feature.getAttribute(GeoIndex.this.geomAttributeIndex);
                    return intersects.matchesValue(geom, queryOptions);
                }
                catch (Exception e) {
                    LOGGER.warn("Caught exception while trying to look up geometry", (Throwable)e);
                    return false;
                }
            }
        });
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isQuantized() {
        return false;
    }

    public Index<O> getEffectiveIndex() {
        return this;
    }
}

