/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.util.List;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.SynonymsEntry;
import org.lionsoul.jcseg.util.ArrayUtil;

public class Word
implements IWord,
Cloneable {
    private String value;
    private int fre = 0;
    private int type;
    private int position;
    private int length = -1;
    private int h = -1;
    private String[] entity = null;
    private String pinyin = null;
    private String[] partspeech = null;
    private volatile SynonymsEntry syn = null;
    private String parameter = null;

    public Word(String value, int fre, int type, String[] entity) {
        this.value = value;
        this.fre = fre;
        this.type = type;
        this.entity = entity;
    }

    public Word(String value, int fre, int type) {
        this(value, fre, type, null);
    }

    public Word(String value, int type) {
        this(value, 0, type, null);
    }

    public Word(String value, int type, String[] entity) {
        this(value, 0, type, entity);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getLength() {
        return this.length == -1 ? this.value.length() : this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getFrequency() {
        return this.fre;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setPosition(int pos) {
        this.position = pos;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public synchronized String[] getEntity() {
        return this.entity;
    }

    @Override
    public synchronized String getEntity(int idx) {
        if (this.entity == null) {
            return null;
        }
        if (idx < 0 || idx > this.entity.length) {
            return null;
        }
        return this.entity[idx];
    }

    @Override
    public synchronized void setEntity(String[] entity) {
        this.entity = entity;
    }

    @Override
    public synchronized void addEntity(String e) {
        if (e != null) {
            if (this.entity == null) {
                this.entity = new String[]{e};
            } else if (ArrayUtil.indexOf(e, this.entity) == -1) {
                String[] dest = new String[this.entity.length + 1];
                System.arraycopy(this.entity, 0, dest, 0, this.entity.length);
                dest[this.entity.length] = e;
                this.entity = dest;
            }
        }
    }

    @Override
    public String getPinyin() {
        return this.pinyin;
    }

    @Override
    public void setPinyin(String py) {
        this.pinyin = py;
    }

    @Override
    public SynonymsEntry getSyn() {
        return this.syn;
    }

    @Override
    public void setSyn(SynonymsEntry syn) {
        this.syn = syn;
    }

    @Override
    public synchronized String[] getPartSpeech() {
        return this.partspeech;
    }

    @Override
    public synchronized void setPartSpeech(String[] partspeech) {
        this.partspeech = partspeech;
    }

    @Override
    public synchronized void addPartSpeech(String ps) {
        if (this.partspeech == null) {
            this.partspeech = new String[]{ps};
        } else {
            String[] dest = new String[this.partspeech.length + 1];
            System.arraycopy(this.partspeech, 0, dest, 0, this.partspeech.length);
            dest[this.partspeech.length] = ps;
            this.partspeech = dest;
        }
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    @Override
    public void setParameter(String param) {
        this.parameter = param;
    }

    @Override
    public synchronized IWord clone() {
        IWord w = null;
        try {
            w = (IWord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return w;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IWord) {
            IWord word = (IWord)o;
            boolean bool = word.getValue().equalsIgnoreCase(this.getValue());
            return bool && word.getType() == this.getType();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String __toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        sb.append('/');
        if (this.partspeech != null) {
            for (int j = 0; j < this.partspeech.length; ++j) {
                if (j == 0) {
                    sb.append(this.partspeech[j]);
                    continue;
                }
                sb.append(',');
                sb.append(this.partspeech[j]);
            }
        } else {
            sb.append("null");
        }
        sb.append('/');
        sb.append(this.pinyin);
        sb.append('/');
        if (this.syn != null) {
            List<IWord> synsList;
            List<IWord> list = synsList = this.syn.getList();
            synchronized (list) {
                for (int i = 0; i < synsList.size(); ++i) {
                    if (i == 0) {
                        sb.append(synsList.get(i));
                        continue;
                    }
                    sb.append(',');
                    sb.append(synsList.get(i));
                }
            }
        } else {
            sb.append("null");
        }
        if (this.value.length() == 1) {
            sb.append('/');
            sb.append(this.fre);
        }
        if (this.entity != null) {
            sb.append('/');
            sb.append(ArrayUtil.implode("|", this.entity));
        }
        if (this.parameter != null) {
            sb.append('/');
            sb.append(this.parameter);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (this.value.length() == 1 && (this.value.charAt(0) == '\"' || this.value.charAt(0) == '\\')) {
            sb.append("\"word\":\"\\").append(this.value).append('\"');
        } else {
            sb.append("\"word\":\"").append(this.value).append('\"');
        }
        sb.append(",\"type\":").append(this.type);
        sb.append(",\"position\":").append(this.position);
        sb.append(",\"length\":").append(this.getLength());
        if (this.pinyin != null) {
            sb.append(",\"pinyin\":\"").append(this.pinyin).append('\"');
        } else {
            sb.append(",\"pinyin\":null");
        }
        if (this.partspeech != null) {
            sb.append(",\"pos\":\"").append(this.partspeech[0]).append('\"');
        } else {
            sb.append(",\"pos\":null");
        }
        if (this.entity != null) {
            sb.append(",\"entity\":").append(ArrayUtil.toJsonObject(this.entity));
        } else {
            sb.append(",\"entity\":null");
        }
        SynonymsEntry synEntry = this.getSyn();
        if (synEntry != null) {
            IWord rootWord = synEntry.getRootWord();
            sb.append(",\"root\":{").append("\"word\":\"").append(rootWord.getValue()).append("\",\"length\":").append(rootWord.getLength()).append(",\"pinyin\":");
            if (rootWord.getPinyin() == null) {
                sb.append("null");
            } else {
                sb.append('\"').append(rootWord.getPinyin()).append('\"');
            }
            sb.append('}');
        } else {
            sb.append(",\"root\":null");
        }
        if (this.parameter != null) {
            sb.append(",\"parameter\":\"");
            sb.append(this.parameter.replaceAll("\"", "\\\\\"")).append('\"');
        } else {
            sb.append(",\"parameter\":null");
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        if (this.h == -1) {
            this.h = 5381;
            for (int j = 0; j < this.value.length(); ++j) {
                this.h = this.h * 33 ^ this.value.charAt(j);
            }
            this.h &= Integer.MAX_VALUE;
        }
        return this.h;
    }
}

