/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.util.IPushbackReader;
import org.lionsoul.jcseg.util.StringUtil;

public class UnigramSeg
implements ISegment {
    protected int idx;
    protected IPushbackReader reader = null;
    protected ADictionary dic = null;

    public UnigramSeg(Reader input, ADictionary dic) throws IOException {
        this.dic = dic;
        this.reset(input);
    }

    @Override
    public void reset(Reader input) throws IOException {
        if (input != null) {
            this.reader = new IPushbackReader(new BufferedReader(input));
        }
        this.idx = -1;
    }

    @Override
    public int getStreamPosition() {
        return this.idx + 1;
    }

    protected int readNext() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.idx;
        }
        return c;
    }

    protected void pushBack(int data) throws IOException {
        this.reader.unread(data);
        --this.idx;
    }

    @Override
    public IWord next() throws IOException {
        int c;
        while ((c = this.readNext()) != -1) {
            if (StringUtil.isWhitespace(c) || StringUtil.isCJKChar(c) || StringUtil.isEnChar(c) || StringUtil.isLetterNumber(c) || !StringUtil.isOtherNumber(c)) continue;
        }
        return null;
    }
}

