/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.lionsoul.jcseg.tokenizer.ASegment;
import org.lionsoul.jcseg.tokenizer.Chunk;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.IChunk;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.tokenizer.core.MMSegFilter;

public class ComplexSeg
extends ASegment {
    public ComplexSeg(JcsegTaskConfig config, ADictionary dic) throws IOException {
        super(config, dic);
    }

    public ComplexSeg(Reader input, JcsegTaskConfig config, ADictionary dic) throws IOException {
        super(input, config, dic);
    }

    @Override
    public IChunk getBestCJKChunk(char[] chars, int index) throws IOException {
        IWord[] mword3;
        IWord[] mword2;
        IWord[] mwords = this.getNextMatch(chars, index);
        if (mwords.length == 1 && mwords[0].getType() == 17) {
            return new Chunk(new IWord[]{mwords[0]});
        }
        ArrayList<Chunk> chunkArr = new ArrayList<Chunk>();
        for (int x = 0; x < mwords.length; ++x) {
            int idx_2 = index + mwords[x].getLength();
            if (idx_2 < chars.length) {
                mword2 = this.getNextMatch(chars, idx_2);
                if (mword2.length == 1 && mword2[0].getType() == 17) {
                    return new Chunk(new IWord[]{mwords[mwords.length - 1]});
                }
                for (int y = 0; y < mword2.length; ++y) {
                    int idx_3 = idx_2 + mword2[y].getLength();
                    if (idx_3 < chars.length) {
                        mword3 = this.getNextMatch(chars, idx_3);
                        for (int z = 0; z < mword3.length; ++z) {
                            ArrayList<IWord> wArr = new ArrayList<IWord>(3);
                            wArr.add(mwords[x]);
                            wArr.add(mword2[y]);
                            if (mword3[z].getType() != 17) {
                                wArr.add(mword3[z]);
                            }
                            IWord[] words = new IWord[wArr.size()];
                            wArr.toArray(words);
                            wArr.clear();
                            chunkArr.add(new Chunk(words));
                        }
                        continue;
                    }
                    chunkArr.add(new Chunk(new IWord[]{mwords[x], mword2[y]}));
                }
                continue;
            }
            chunkArr.add(new Chunk(new IWord[]{mwords[x]}));
        }
        if (chunkArr.size() == 1) {
            return (IChunk)chunkArr.get(0);
        }
        IChunk[] chunks = new IChunk[chunkArr.size()];
        chunkArr.toArray(chunks);
        chunkArr.clear();
        mwords = null;
        mword2 = null;
        mword3 = null;
        IChunk[] afterChunks = MMSegFilter.getMaximumMatchChunks(chunks);
        if (afterChunks.length == 1) {
            return afterChunks[0];
        }
        if ((afterChunks = MMSegFilter.getLargestAverageWordLengthChunks(afterChunks)).length == 1) {
            return afterChunks[0];
        }
        if ((afterChunks = MMSegFilter.getSmallestVarianceWordLengthChunks(afterChunks)).length == 1) {
            return afterChunks[0];
        }
        if ((afterChunks = MMSegFilter.getLargestSingleMorphemicFreedomChunks(afterChunks)).length == 1) {
            return afterChunks[0];
        }
        return afterChunks[afterChunks.length - 1];
    }
}

