/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.extractor;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;

public abstract class KeywordsExtractor {
    protected ISegment seg;

    public KeywordsExtractor(ISegment seg) {
        this.seg = seg;
    }

    protected boolean filter(IWord word) {
        if (word.getValue().length() < 2) {
            return false;
        }
        switch (word.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                return false;
            }
        }
        String[] poss = word.getPartSpeech();
        if (poss == null) {
            return true;
        }
        char pos = poss[0].charAt(0);
        switch (pos) {
            case 'e': {
                return poss[0].equals("en");
            }
            case 'm': {
                return poss[0].equals("mix");
            }
            case 'b': 
            case 'c': 
            case 'd': 
            case 'g': 
            case 'h': 
            case 'k': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 'u': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return false;
            }
        }
        return true;
    }

    public List<String> getKeywordsFromString(String doc) throws IOException {
        return this.getKeywords(new StringReader(doc));
    }

    public List<String> getKeywordsFromFile(String file) throws IOException {
        return this.getKeywords(new FileReader(file));
    }

    public abstract List<String> getKeywords(Reader var1) throws IOException;

    public ISegment getSeg() {
        return this.seg;
    }

    public void setSeg(ISegment seg) {
        this.seg = seg;
    }
}

