/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapURL;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.unboundid.UnboundIDConnectionFactory;
import org.ldaptive.provider.unboundid.UnboundIDProviderConfig;
import org.ldaptive.provider.unboundid.UnboundIDStartTLSConnectionFactory;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.DefaultSSLContextInitializer;
import org.ldaptive.ssl.HostnameVerifyingTrustManager;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.TLSSocketFactory;

public class UnboundIDProvider
implements Provider<UnboundIDProviderConfig> {
    private UnboundIDProviderConfig config = new UnboundIDProviderConfig();

    public ProviderConnectionFactory<UnboundIDProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        SocketFactory factory = this.config.getSocketFactory();
        SSLContext sslContext = null;
        if (cc.getUseStartTLS()) {
            sslContext = this.getHostnameVerifierSSLContext(cc);
        } else if (cc.getUseSSL() && factory == null) {
            factory = this.getHostnameVerifierSocketFactory(cc);
        }
        if (cc.getSslConfig() != null && cc.getSslConfig().getEnabledCipherSuites() != null) {
            throw new UnsupportedOperationException("UnboundID provider does not support the cipher suites property");
        }
        if (cc.getSslConfig() != null && cc.getSslConfig().getEnabledProtocols() != null) {
            throw new UnsupportedOperationException("UnboundID provider does not support the protocols property");
        }
        LDAPConnectionOptions options = this.config.getConnectionOptions();
        if (options == null) {
            options = this.getDefaultLDAPConnectionOptions(cc);
        }
        AbstractProviderConnectionFactory cf = cc.getUseStartTLS() ? new UnboundIDStartTLSConnectionFactory(cc.getLdapUrl(), this.config, factory, sslContext, options) : new UnboundIDConnectionFactory(cc.getLdapUrl(), this.config, factory, options);
        return cf;
    }

    protected SSLContext getHostnameVerifierSSLContext(ConnectionConfig cc) {
        SSLContext sslContext;
        DefaultSSLContextInitializer contextInit;
        if (cc.getSslConfig() != null && cc.getSslConfig().getCredentialConfig() != null) {
            try {
                CredentialConfig credConfig = cc.getSslConfig().getCredentialConfig();
                contextInit = credConfig.createSSLContextInitializer();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            contextInit = new DefaultSSLContextInitializer();
        }
        if (cc.getSslConfig() != null && cc.getSslConfig().getTrustManagers() != null) {
            contextInit.setTrustManagers(cc.getSslConfig().getTrustManagers());
        } else {
            LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
            contextInit.setTrustManagers(new TrustManager[]{new HostnameVerifyingTrustManager((CertificateHostnameVerifier)new DefaultHostnameVerifier(), ldapUrl.getEntriesAsString())});
        }
        try {
            sslContext = contextInit.initSSLContext("TLS");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return sslContext;
    }

    protected SocketFactory getHostnameVerifierSocketFactory(ConnectionConfig cc) {
        LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
        return TLSSocketFactory.getHostnameVerifierFactory((SslConfig)cc.getSslConfig(), (String[])ldapUrl.getEntriesAsString());
    }

    protected LDAPConnectionOptions getDefaultLDAPConnectionOptions(ConnectionConfig cc) {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setConnectTimeoutMillis(cc.getConnectTimeout() > 0L ? (int)cc.getConnectTimeout() : 0);
        options.setResponseTimeoutMillis(cc.getResponseTimeout());
        return options;
    }

    public UnboundIDProviderConfig getProviderConfig() {
        return this.config;
    }

    public void setProviderConfig(UnboundIDProviderConfig pc) {
        this.config = pc;
    }

    public UnboundIDProvider newInstance() {
        return new UnboundIDProvider();
    }
}

