/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.Date;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JILocalCoClass;
import org.jinterop.dcom.core.JILocalInterfaceDefinition;
import org.jinterop.dcom.core.JILocalMethodDescriptor;
import org.jinterop.dcom.core.JILocalParamsDescriptor;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIUnsignedInteger;
import org.jinterop.dcom.core.JIUnsignedShort;
import org.jinterop.dcom.impls.JIObjectFactory;

public class SampleTestServerCallback {
    static JILocalCoClass StaticSinkJavaCoClass;

    private static void append(String fileName, String data) {
        try {
            PrintWriter pWriter = new PrintWriter(new FileWriter(fileName, true));
            pWriter.print(data);
            pWriter.flush();
            pWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void UpdateMe(JIUnsignedShort size, JIArray array) {
        SampleTestServerCallback.append("C:\\Test\\callback_j.log", "SampleTestServerCallback::UpdateMe entered with array size=" + size + "\n");
        System.out.println("SampleTestServerCallback::UpdateMe entered with array size=" + size + "\n");
        JIStruct[] structArray = (JIStruct[])array.getArrayInstance();
        for (int i = 0; i < size.getValue().intValue(); ++i) {
            SampleTestServerCallback.append("C:\\Test\\callback_j.log", "Member 0= " + structArray[i].getMember(0).toString() + "\n");
            System.out.println("Array elt=" + i + ",Member 0= " + structArray[i].getMember(0).toString() + "\n");
        }
    }

    private static JILocalInterfaceDefinition registerInterface() throws JIException {
        JILocalInterfaceDefinition interfaceDefinition = new JILocalInterfaceDefinition("D3F9CE10-686C-11d2-97BF-006008BD50B1", false);
        JIStruct VarData = new JIStruct();
        VarData.addMember(JIUnsignedInteger.class);
        VarData.addMember(Float.class);
        VarData.addMember(Float.class);
        VarData.addMember(JIUnsignedShort.class);
        VarData.addMember(Float.class);
        VarData.addMember(Date.class);
        VarData.addMember(JIUnsignedShort.class);
        JIStruct NonVariableData = new JIStruct();
        NonVariableData.addMember(JIUnsignedInteger.class);
        NonVariableData.addMember(JIUnsignedInteger.class);
        NonVariableData.addMember(JIUnsignedByte.class);
        NonVariableData.addMember(new JIPointer(new JIArray(VarData, null, 1, true), true));
        JIArray NonVariableDataArray = new JIArray(NonVariableData, null, 1, true);
        JILocalParamsDescriptor updateParamObj = new JILocalParamsDescriptor();
        updateParamObj.addInParamAsType(JIUnsignedShort.class, 0);
        updateParamObj.addInParamAsObject(NonVariableDataArray, 0);
        JILocalMethodDescriptor methodDescriptor = new JILocalMethodDescriptor("UpdateMe", updateParamObj);
        interfaceDefinition.addMethodDescriptor(methodDescriptor);
        return interfaceDefinition;
    }

    public static void testStaticUpdateMeSink(String[] args) throws JIException, InterruptedException, UnknownHostException {
        JISession session = JISession.createSession(args[1], args[2], args[3]);
        JIComServer comStub = new JIComServer(JIProgId.valueOf("TstMarsh.Test"), args[0], session);
        IJIComObject unknown = comStub.createInstance();
        IJIComObject ITest = unknown.queryInterface("89D8C8BE-1E91-11D3-910F-00C04F9403C2");
        JILocalInterfaceDefinition interfaceDefinition = SampleTestServerCallback.registerInterface();
        if (StaticSinkJavaCoClass == null) {
            StaticSinkJavaCoClass = new JILocalCoClass(interfaceDefinition, new SampleTestServerCallback());
        }
        IJIComObject iStaticSink = JIObjectFactory.buildObject(session, StaticSinkJavaCoClass);
        Object[] results = new Object[1];
        JICallBuilder javaCallback = new JICallBuilder(true);
        javaCallback.setOpnum(0);
        javaCallback.addInParamAsComObject(iStaticSink, 0);
        javaCallback.addOutParamAsType(Integer.class, 0);
        System.out.println("ITest.DoSomethingAndGetSomethingBack about to call this...");
        results = ITest.call(javaCallback);
        System.out.println("ITest.DoSomethingAndGetSomethingBack succeeded, session out =" + results[0]);
        int staticSession = (Integer)results[0];
        int rate = 4000;
        javaCallback.reInit();
        javaCallback.setOpnum(4);
        javaCallback.addInParamAsInt(staticSession, 1024);
        javaCallback.addInParamAsInt(rate, 1024);
        System.out.println("ITest.SetSomethingInSomethingsRate about to be called");
        results = ITest.call(javaCallback);
        System.out.println("ITest.SetSomethingInSomethingsRate succeeded");
        javaCallback.reInit();
        javaCallback.setOpnum(6);
        javaCallback.addInParamAsInt(staticSession, 1024);
        System.out.println("ITest.StartSomething about to be called");
        results = ITest.call(javaCallback);
        System.out.println("ITest.StartSomething succeeded");
        Thread.sleep(10000L);
        javaCallback.reInit();
        javaCallback.setOpnum(7);
        javaCallback.addInParamAsInt(staticSession, 1024);
        System.out.println("ITest.StopSomething about to be called");
        results = ITest.call(javaCallback);
        System.out.println("ITest.StopSomething succeeded");
        Thread.sleep(1000L);
        javaCallback.reInit();
        javaCallback.setOpnum(1);
        javaCallback.addInParamAsInt(staticSession, 1024);
        System.out.println("ITest.DestroySomething about to be called");
        results = ITest.call(javaCallback);
        System.out.println("ITest.DestroySomething succeeded");
        JISession.destroySession(session);
    }

    public static void testSinkDebug(String[] args) throws JIException, InterruptedException, UnknownHostException {
        JISession session = JISession.createSession(args[1], args[2], args[3]);
        JIComServer comStub = new JIComServer(JIProgId.valueOf("TstMarsh.Test"), args[0], session);
        IJIComObject unknown = comStub.createInstance();
        IJIComObject ITest = unknown.queryInterface("89D8C8BE-1E91-11D3-910F-00C04F9403C2");
        JILocalInterfaceDefinition interfaceDefinition = SampleTestServerCallback.registerInterface();
        if (StaticSinkJavaCoClass != null) {
            StaticSinkJavaCoClass = new JILocalCoClass(interfaceDefinition, new SampleTestServerCallback());
        }
        IJIComObject iStaticSink = JIObjectFactory.buildObject(session, StaticSinkJavaCoClass);
        Object[] results = new Object[1];
        JICallBuilder javaCallback = new JICallBuilder(true);
        javaCallback.setOpnum(8);
        javaCallback.addInParamAsComObject(iStaticSink, 0);
        javaCallback.addOutParamAsType(Integer.class, 0);
        results = ITest.call(javaCallback);
        System.out.println("ITest.DoSomethingAndGetSomethingBack succeeded, session out =" + results[0]);
        int staticSession = (Integer)results[0];
        Thread.sleep(30000L);
        javaCallback.reInit();
        javaCallback.setOpnum(1);
        javaCallback.addInParamAsInt(staticSession, 1024);
        System.out.println("ITest.UnDoSomething about to be called");
        results = ITest.call(javaCallback);
        System.out.println("ITest.UnDoSomething succeeded");
        JISession.destroySession(session);
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Please provide address domain username password");
                return;
            }
            JISystem.setInBuiltLogHandler(false);
            JISystem.setAutoRegisteration(true);
            for (int i = 0; i < 100; ++i) {
                System.out.println("**********************Invoking callback sequence....\n");
                SampleTestServerCallback.testStaticUpdateMeSink(args);
                Thread.sleep(12000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

