/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.SimpleArgumentConverter;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
public class DefaultArgumentConverter
extends SimpleArgumentConverter {
    public static final DefaultArgumentConverter INSTANCE = new DefaultArgumentConverter();
    private static final List<StringToObjectConverter> stringToObjectConverters = Collections.unmodifiableList(Arrays.asList(new StringToPrimitiveConverter(), new StringToEnumConverter(), new StringToJavaTimeConverter()));

    private DefaultArgumentConverter() {
    }

    @Override
    protected Object convert(Object source, Class<?> targetType) {
        if (source == null) {
            if (targetType.isPrimitive()) {
                throw new ArgumentConversionException("Cannot convert null to primitive value of type " + targetType.getName());
            }
            return null;
        }
        return this.convertToTargetType(source, this.toWrapperType(targetType));
    }

    private Class<?> toWrapperType(Class<?> targetType) {
        Class<?> wrapperType = ReflectionUtils.getWrapperType(targetType);
        return wrapperType != null ? wrapperType : targetType;
    }

    private Object convertToTargetType(Object source, Class<?> targetType) {
        Optional<StringToObjectConverter> converter;
        if (targetType.isInstance(source)) {
            return source;
        }
        if (source instanceof String && (converter = stringToObjectConverters.stream().filter(candidate -> candidate.canConvert(targetType)).findFirst()).isPresent()) {
            try {
                return converter.get().convert((String)source, targetType);
            }
            catch (Exception ex) {
                throw new ArgumentConversionException("Failed to convert String [" + source + "] to type " + targetType.getName(), ex);
            }
        }
        throw new ArgumentConversionException("No implicit conversion to convert object of type " + source.getClass().getName() + " to type " + targetType.getName());
    }

    static class StringToJavaTimeConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<CharSequence, ?>> CONVERTERS;

        StringToJavaTimeConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source, Class<?> targetType) throws Exception {
            return CONVERTERS.get(targetType).apply(source);
        }

        static {
            HashMap<Class<ZonedDateTime>, Function<CharSequence, Object>> converters = new HashMap<Class<ZonedDateTime>, Function<CharSequence, Object>>();
            converters.put(Instant.class, Instant::parse);
            converters.put(LocalDate.class, LocalDate::parse);
            converters.put(LocalDateTime.class, LocalDateTime::parse);
            converters.put(LocalTime.class, LocalTime::parse);
            converters.put(OffsetDateTime.class, OffsetDateTime::parse);
            converters.put(OffsetTime.class, OffsetTime::parse);
            converters.put(Year.class, Year::parse);
            converters.put(YearMonth.class, YearMonth::parse);
            converters.put(ZonedDateTime.class, ZonedDateTime::parse);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    static class StringToEnumConverter
    implements StringToObjectConverter {
        StringToEnumConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return targetType.isEnum();
        }

        @Override
        public Object convert(String source, Class<?> targetType) throws Exception {
            return this.valueOf(targetType, source);
        }

        private Object valueOf(Class targetType, String source) {
            return Enum.valueOf(targetType, source);
        }
    }

    static class StringToPrimitiveConverter
    implements StringToObjectConverter {
        private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

        StringToPrimitiveConverter() {
        }

        @Override
        public boolean canConvert(Class<?> targetType) {
            return CONVERTERS.containsKey(targetType);
        }

        @Override
        public Object convert(String source, Class<?> targetType) {
            return CONVERTERS.get(targetType).apply(source);
        }

        static {
            HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
            converters.put(Boolean.class, Boolean::valueOf);
            converters.put(Character.class, source -> {
                Preconditions.condition((source.length() == 1 ? 1 : 0) != 0, () -> "String must have length of 1: " + source);
                return Character.valueOf(source.charAt(0));
            });
            converters.put(Byte.class, Byte::valueOf);
            converters.put(Short.class, Short::valueOf);
            converters.put(Integer.class, Integer::valueOf);
            converters.put(Long.class, Long::valueOf);
            converters.put(Float.class, Float::valueOf);
            converters.put(Double.class, Double::valueOf);
            CONVERTERS = Collections.unmodifiableMap(converters);
        }
    }

    static interface StringToObjectConverter {
        public boolean canConvert(Class<?> var1);

        public Object convert(String var1, Class<?> var2) throws Exception;
    }
}

